/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.Scope;
import liquibase.SingletonObject;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandExecutionException;
import liquibase.command.CommandResult;
import liquibase.command.CommandStep;
import liquibase.command.LiquibaseCommand;
import liquibase.command.LiquibaseCommandFactory;
import liquibase.servicelocator.ServiceLocator;
import liquibase.util.StringUtil;

public class CommandFactory
implements SingletonObject {
    private Collection<CommandStep> allInstances;
    private final Map<String, Set<CommandArgumentDefinition<?>>> commandArgumentDefinitions = new HashMap();

    public static CommandFactory getInstance() {
        return Scope.getCurrentScope().getSingleton(CommandFactory.class);
    }

    protected CommandFactory() {
    }

    public CommandDefinition getCommandDefinition(String ... commandName) throws IllegalArgumentException {
        CommandDefinition commandDefinition = new CommandDefinition(commandName);
        for (CommandStep step : this.findAllInstances()) {
            if (step.getOrder(commandDefinition) <= 0) continue;
            commandDefinition.add(step);
        }
        List<CommandStep> pipeline = commandDefinition.getPipeline();
        if (pipeline.size() == 0) {
            throw new IllegalArgumentException("Unknown command '" + StringUtil.join(commandName, " ") + "'");
        }
        Set<CommandArgumentDefinition<?>> stepArguments = this.commandArgumentDefinitions.get(StringUtil.join(commandDefinition.getName(), " "));
        if (stepArguments != null) {
            for (CommandArgumentDefinition commandArgumentDefinition : stepArguments) {
                commandDefinition.add(commandArgumentDefinition);
            }
        }
        for (CommandStep commandStep : pipeline) {
            commandStep.adjustCommandDefinition(commandDefinition);
        }
        return commandDefinition;
    }

    public SortedSet<CommandDefinition> getCommands(boolean includeInternal) {
        HashMap<String, String[]> commandNames = new HashMap<String, String[]>();
        for (CommandStep step : this.findAllInstances()) {
            for (String[] name : step.defineCommandNames()) {
                commandNames.put(StringUtil.join(name, " "), name);
            }
        }
        TreeSet<CommandDefinition> commands = new TreeSet<CommandDefinition>();
        for (String[] commandName : commandNames.values()) {
            try {
                CommandDefinition definition = this.getCommandDefinition(commandName);
                if (!includeInternal && definition.getInternal()) continue;
                commands.add(definition);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return Collections.unmodifiableSortedSet(commands);
    }

    protected void register(String[] commandName, CommandArgumentDefinition<?> definition) {
        String commandNameKey = StringUtil.join(commandName, " ");
        if (!this.commandArgumentDefinitions.containsKey(commandNameKey)) {
            this.commandArgumentDefinitions.put(commandNameKey, new TreeSet());
        }
        if (this.commandArgumentDefinitions.get(commandNameKey).contains(definition)) {
            throw new IllegalArgumentException("Duplicate argument '" + definition.getName() + "' found for command '" + commandNameKey + "'");
        }
        this.commandArgumentDefinitions.get(commandNameKey).add(definition);
    }

    protected void unregister(String[] commandName) {
        this.commandArgumentDefinitions.remove(StringUtil.join(commandName, " "));
    }

    public LiquibaseCommand getCommand(String commandName) {
        return Scope.getCurrentScope().getSingleton(LiquibaseCommandFactory.class).getCommand(commandName);
    }

    public <T extends CommandResult> T execute(LiquibaseCommand<T> command) throws CommandExecutionException {
        command.validate();
        try {
            return command.run();
        }
        catch (Exception e) {
            if (e instanceof CommandExecutionException) {
                throw (CommandExecutionException)e;
            }
            throw new CommandExecutionException(e);
        }
    }

    private synchronized Collection<CommandStep> findAllInstances() {
        if (this.allInstances == null) {
            this.allInstances = new ArrayList<CommandStep>();
            ServiceLocator serviceLocator = Scope.getCurrentScope().getServiceLocator();
            this.allInstances.addAll(serviceLocator.findInstances(CommandStep.class));
        }
        return this.allInstances;
    }
}

