/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.utility;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.util.Logger;

public class InputStreamProgressWrapper
extends FilterInputStream {
    protected volatile TransferTaskProgressMonitor progressMonitor;
    private int mark;

    public InputStreamProgressWrapper(InputStream in, TransferTaskProgressMonitor aProgressMonitor, long max) {
        super(in);
        assert (aProgressMonitor != null);
        this.progressMonitor = aProgressMonitor;
        this.progressMonitor.init(0, null, null, max);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.progressMonitor.end();
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        return b;
    }

    @Override
    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        int b = super.read(arg0, arg1, arg2);
        this.progressMonitor.count(b);
        return b;
    }

    @Override
    public int read(byte[] arg0) throws IOException {
        int b = super.read(arg0);
        return b;
    }

    @Override
    public long skip(long arg0) throws IOException {
        long b = super.skip(arg0);
        this.progressMonitor.count(b);
        return b;
    }

    @Override
    public synchronized void mark(int arg0) {
        this.mark = arg0;
        Logger.info(this.getClass(), (String)("" + arg0));
        super.mark(arg0);
    }

    @Override
    public boolean markSupported() {
        Logger.info(this.getClass(), (String)("=" + super.markSupported()));
        return super.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        long diff = this.progressMonitor.getCount() - (long)this.mark;
        this.progressMonitor.count(-diff);
        Logger.info(this.getClass(), (String)("" + -diff), (Throwable)new Throwable());
        super.reset();
    }
}

