/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.commands.CSCommon;
import oracle.dbtools.commands.CommandMessages;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.oci.OCIProfiles;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class OCICommand
extends CommandListener
implements IHelp {
    private static final String OCI_CMD = "oci";
    private static final String OCI_CMDU = "OCI";
    private static final String OCI_PROFILE_NAME = "oci.profile.name";
    private static final String DELETE = "delete";
    private static final String GET = "get";
    private static final String PUT = "put";
    private static final String CLEAR = "clear";
    private static final String NL = "\n";

    public String getCommand() {
        return OCI_CMDU;
    }

    public String getHelp() {
        return CommandMessages.getString("OCI_CMD_HELP");
    }

    public boolean isSqlPlus() {
        return false;
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (OCICommand.matches((String)OCI_CMD, (String)cmd.getSql())) {
            block55: {
                String[] parts = cmd.getSql().replace(NL, "").split("\\s+");
                if (parts.length == 2 && parts[1].equalsIgnoreCase(CLEAR)) {
                    ctx.write(CommandMessages.getString("OCI_PROFILE_CLEARED") + NL);
                    ctx.removeProperty(OCI_PROFILE_NAME);
                    Map csProps = (Map)ctx.getProperty("cloud.storage");
                    if (csProps != null) {
                        csProps.remove(OCI_PROFILE_NAME);
                    }
                    return true;
                }
                if (parts.length > 1 && parts[1].equalsIgnoreCase("profile") && parts.length != 3) {
                    try {
                        OCIProfiles p = new OCIProfiles();
                        ctx.write(CommandMessages.getString("OCI_PROFILES"));
                        for (String profile : p.getProfiles()) {
                            ctx.write("\t" + profile + NL);
                        }
                    }
                    catch (IOException e) {
                        ctx.write(e.getLocalizedMessage() + NL);
                    }
                } else if (parts.length == 3 && parts[1].equalsIgnoreCase("profile")) {
                    try {
                        OCIProfiles p = new OCIProfiles();
                        if (p.getProfiles().contains(parts[2])) {
                            ctx.putProperty(OCI_PROFILE_NAME, (Object)parts[2]);
                            HashMap csProps = (HashMap)ctx.getProperty("cloud.storage");
                            if (csProps == null) {
                                csProps = new HashMap();
                                ctx.putProperty("cloud.storage", csProps);
                            }
                            CSCommon.setProfileAndWarn(ctx, parts[2], true);
                            break block55;
                        }
                        ctx.write(CommandMessages.getString("OCI_PROFILE_INVALID"));
                    }
                    catch (IOException e) {
                        ctx.write(e.getLocalizedMessage() + NL);
                    }
                } else if (ctx.getProperty(OCI_PROFILE_NAME) != null && parts.length > 1 && parts.length < 6) {
                    String host = null;
                    String method = null;
                    String bodyFile = null;
                    String qualifier = null;
                    String target = null;
                    try {
                        String ct;
                        if (parts[1].equalsIgnoreCase(DELETE) || parts[1].equalsIgnoreCase(GET) || parts[1].equalsIgnoreCase(PUT)) {
                            method = parts[1].toLowerCase();
                            Map props = (Map)ctx.getProperty("cloud.storage");
                            if (props == null || (CloudStorageUrl)props.get("cloud_url") == null) {
                                ctx.write(CommandMessages.getString("OCI_HOST") + NL);
                                return true;
                            }
                            if (!method.equals(PUT) && parts.length == 3) {
                                qualifier = parts[2];
                            } else if (method.equals(PUT) && parts.length == 3) {
                                bodyFile = parts[2];
                            } else if (method.equals(PUT) && parts.length == 4) {
                                bodyFile = parts[2];
                                qualifier = parts[3];
                            }
                            CloudStorageUrl csUrl = new CloudStorageUrl(((CloudStorageUrl)props.get("cloud_url")).getFinalUrl());
                            if (qualifier != null) {
                                csUrl.qualifiedUrl(qualifier);
                            }
                            URL url = csUrl.getFinalUrlAsOCI();
                            if (method.equalsIgnoreCase(DELETE) || method.equalsIgnoreCase(GET) || method.equalsIgnoreCase(PUT)) {
                                csUrl.validateUrlAsObject();
                            }
                            host = url.getHost();
                            target = url.getPath();
                            csUrl.dropQualifiedUrl();
                        } else if (parts.length == 4) {
                            host = parts[1];
                            method = parts[2];
                            target = parts[3];
                        } else if (parts.length == 5) {
                            host = parts[1];
                            method = parts[2];
                            bodyFile = parts[3];
                            target = parts[4];
                        } else {
                            ctx.write(CommandMessages.getString("OCI_CMD_HELP") + NL);
                            return true;
                        }
                        OCIProfiles p = new OCIProfiles();
                        OCIRESTClient client = p.getOciClient((String)ctx.getProperty(OCI_PROFILE_NAME));
                        OCIRequest req = null;
                        if (bodyFile == null) {
                            req = new OCIRequest.Builder().host(host).method(method).target(target).build();
                        } else if (bodyFile != null && !bodyFile.isEmpty()) {
                            File srcFile = new File(bodyFile = ctx.prependCD(bodyFile));
                            if (!srcFile.isFile()) {
                                throw new IOException(bodyFile + " is not a file");
                            }
                            req = new OCIRequest.Builder().host(host).method(method).bodyFile(new File(bodyFile)).target(target).build();
                        }
                        CloseableHttpResponse response = client.getResponse(req);
                        ctx.write("Status:" + response.getCode() + " " + response.getReasonPhrase() + NL);
                        HttpEntity ent = response.getEntity();
                        String string = ct = ent != null && ent.getContentType() != null ? ent.getContentType() : "application/octect";
                        if (ct.equals("application/json")) {
                            String ret = response != null && response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8") : "";
                            ctx.write(ret + NL);
                            break block55;
                        }
                        if (ent == null || ent.getContentLength() == 0L) break block55;
                        String responseFileName = req.getFinalPath() == null || req.getFinalPath().trim().equals("") ? "response.oci" : req.getFinalPath();
                        Path responsePath = FileUtils.getNewOrExistingPath((ScriptRunnerContext)ctx, (String)responseFileName);
                        ctx.write(CommandMessages.format("OCI_FILE_SAVED", responsePath.toAbsolutePath()));
                        try (InputStream inputStream = ent.getContent();){
                            Files.copy(inputStream, responsePath, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (MalformedURLException e) {
                        ctx.write(NL + e.getLocalizedMessage() + NL);
                    }
                    catch (InvalidKeyException e) {
                        ctx.write(NL + e.getLocalizedMessage() + NL);
                    }
                    catch (SignatureException e) {
                        ctx.write(NL + e.getLocalizedMessage() + NL);
                    }
                    catch (UnsupportedEncodingException e) {
                        ctx.write(NL + e.getLocalizedMessage() + NL);
                    }
                    catch (GeneralSecurityException e) {
                        ctx.write(NL + e.getLocalizedMessage() + NL);
                    }
                    catch (IOException e) {
                        ctx.write(NL + e.getLocalizedMessage() + NL);
                    }
                    catch (ParseException e) {
                        ctx.write(NL + e.getLocalizedMessage() + NL);
                    }
                } else {
                    ctx.write(CommandMessages.getString("OCI_CMD_HELP") + NL);
                }
            }
            return true;
        }
        return false;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

