/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;

public class HTMLReportSingleFileWeb {
    private StringBuffer buffer = new StringBuffer();
    private static final Logger LOGGER = new Logger(HTMLReportSingleFileWeb.class);

    public static StringBuffer createHTML(TreeMap objectNames, ByteArrayOutputStream htmlStream, String diagram, String tocIdSuffix, List diagramsNamesList) {
        StringBuffer buffer = new StringBuffer();
        HTMLReportSingleFileWeb.createHEAD(buffer);
        HTMLReportSingleFileWeb.createBODY(buffer, objectNames, htmlStream, diagram, tocIdSuffix, diagramsNamesList);
        return buffer;
    }

    private static void createHEAD(StringBuffer buffer) {
        buffer.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        buffer.append("\n");
        buffer.append("\t").append("<head>");
        buffer.append("\n");
        buffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>");
        buffer.append("\n");
        buffer.append("<style>");
        buffer.append("\n");
        buffer.append("html * {");
        buffer.append("\n");
        buffer.append("\t").append("font-size:xx-small;");
        buffer.append("\n");
        buffer.append("\t").append("font-family: Tahoma;");
        buffer.append("\n");
        buffer.append("\t").append("text-align:left;");
        buffer.append("\n");
        buffer.append("\t").append("vertical-align:top;");
        buffer.append("\n");
        buffer.append("\t").append("word-wrap:break-word;");
        buffer.append("\n");
        buffer.append("\t").append("empty-cells:show;");
        buffer.append("\n");
        buffer.append("}");
        buffer.append("\n");
        buffer.append(".flex {\n\t/* basic styling */\n\twidth: 100%;\n\theight: 100%;\n\tborder: none;\n\tflex-wrap: nowrap;\n\t/* flexbox setup */\n\tdisplay: -webkit-box;      /* OLD - iOS 6-, Safari 3.1-6 */\n\tdisplay: -moz-box;         /* OLD - Firefox 19- (buggy but mostly works) */\n\tdisplay: -ms-flexbox;      /* TWEENER - IE 10 */\n\tdisplay: -webkit-flex;     /* NEW - Chrome */\n\tdisplay: flex;             /* NEW, Spec - Opera 12.1, Firefox 20+ */\n\t-webkit-flex-direction: row;\n\tflex-direction: row;\n}\n.toc {\n\t-webkit-box-ordinal-group: 1;  /* OLD - iOS 6-, Safari 3.1-6 */\n\t-moz-box-ordinal-group: 1;     /* OLD - Firefox 19- */\n\t-ms-flex-order: 1;             /* TWEENER - IE 10 */\n\t-webkit-order: 1;              /* NEW - Chrome */\n\torder: 1;                      /* NEW, Spec - Opera 12.1, Firefox 20+ */\n\t-webkit-flex: auto; \n\tflex: auto;\n\tmin-width: 200px;\n\tmax-width: 200px;\n\tpadding-left: 5px;\n\tpadding-right: 5px;\n\toverflow: auto;\n\tword-wrap: break-word;\n\tborder-radius: 10px;\n\tborder-style: solid;\n\tborder-width: 1px;\n\tfont-family: Tahoma;\n\tfont-size:10pt;\n\theight:100%;                   /* Safari */\n}\n.details {\n\t-webkit-box-ordinal-group: 2;   /* OLD - iOS 6-, Safari 3.1-6 */\n\t-moz-box-ordinal-group: 2;      /* OLD - Firefox 19- */\n\t-ms-flex-order: 2;              /* TWEENER - IE 10 */\n\t-webkit-order: 2;               /* NEW - Chrome */\n\torder: 2;                       /* NEW, Spec - Opera 12.1, Firefox 20+ */\n\t-webkit-flex: auto; \n\tflex: auto;\n margin-left: 5px;\n\toverflow: auto;\n\toverflow-y: scroll;            /* Safari */\n\tword-wrap: break-word;\n\twidth:100%;\n}\na:link, a:visited {\n\tcolor: black;\n\ttext-decoration: none;\n}\na:hover {\n\tcolor: red;\n\tfont-weight: bold;\n}\n.t_item{\n  margin-left: 5px;\n}");
        buffer.append("\n");
        buffer.append("</style>");
        buffer.append("\n");
        buffer.append("<script>");
        buffer.append("function $x(pNd){\n\tvar lThis;\n\tswitch(typeof (pNd)){\n\t\tcase 'string':lThis = document.getElementById(pNd);break;\n\t\tcase 'object':lThis = pNd;break;\n\t\tdefault:return false;break;\n\t}\n\treturn (lThis.nodeType == 1)?lThis:false;\n}\nvar gRegex=false;\nvar gHeight=0;\nfunction $d_Find(pThis,pString,pTags,pClass){\n       if(!pTags){pTags = 'DIV';}\n       pThis = $x(pThis);\n       if(pThis){\n           var d=pThis.getElementsByTagName(pTags);\n           pThis.style.display=\"none\";\n           if(!gRegex){gRegex =new RegExp(\"test\");}\n           gRegex.compile(pString,\"i\");\n           for(var i=0,len=d.length ;i<len;i++){\n               if(gRegex.test(d[i].innerHTML)){\n                   d[i].style.display=\"table-row\";\n                   d[i].style.visiblilty=\"visible\";\n                   d[i].style.height=gHeight;\n               } else{\n                   if ( gHeight==0)  gHeight=d[i].style.height;\n                   d[i].style.height='0';\n                   d[i].style.display=\"none\";\n                   d[i].style.visiblilty=\"hidden\";\n               }\n           }\n       pThis.style.display=\"block\";\n   }\n   return;\n}");
        buffer.append("\n");
        buffer.append("</script>");
        buffer.append("\n");
        buffer.append("\t").append("</head>");
    }

    private static void createBODY(StringBuffer buffer, TreeMap objectNames, ByteArrayOutputStream htmlStream, String diagram, String tocIdSuffix, List diagramsNamesList) {
        buffer.append("\n");
        buffer.append("\t").append("<body>");
        buffer.append("\n");
        buffer.append("\t\t").append("<div class=\"flex\">");
        buffer.append("\n");
        if (objectNames != null && objectNames.size() > 0) {
            buffer.append("\t\t\t").append("<div class=\"toc\" id=\"toc_list\">");
            buffer.append("\n");
            buffer.append("\t\t\t\t").append("<table id=\"toc_table\" width=\"100%\" style=\"empty-cells:show; font-family:Tahoma; font-size:small; text-align:left; vertical-align:top; word-wrap:break-word;\">");
            buffer.append("\n");
            buffer.append("\t\t\t\t\t").append("<tr><td style=\"font-style:italic; font-weight:bold;\"><input type=\"text\" style=\"width: 180px; margin-top: 5px;\" onkeyup=\"$d_Find('toc_list',this.value,'a')\"/></td></tr>");
            buffer.append("\n");
            buffer.append("\t\t\t\t\t").append("<tr><td>&nbsp;</td></tr>");
            buffer.append("\n");
            buffer.append("\t\t\t\t").append("</table>");
            buffer.append("\n");
            buffer.append("\t\t\t\t").append("<div class=\"t_item\">");
            if (diagramsNamesList != null) {
                buffer.append("\n");
                buffer.append("\t\t\t\t<div>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t<ol class=\"tree\">");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t<li>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t\t<label for=\"objects\">Objects</label>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t\t<input type=\"checkbox\" id=\"objects\"/>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t\t<ol>");
                for (Map.Entry entry : objectNames.entrySet()) {
                    buffer.append("\n");
                    try {
                        buffer.append("\t\t\t\t\t\t\t\t").append("<li class=\"obj\"><a href=\"#" + URLEncoder.encode(((ModelIDObject)entry.getValue()).getShortObjectID(), "UTF-8").replace("+", "%20") + tocIdSuffix + "\" target=\"_self\">" + StringUtilities.encodeAttributeValue(((ModelIDObject)entry.getValue()).getLongName()) + "</a></li>");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t\t</ol>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t</li>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t</ol>");
                buffer.append("\n");
                buffer.append("\t\t\t\t</div>");
                buffer.append("\n");
                buffer.append("\n");
                buffer.append("\t\t\t\t<div>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t<ol class=\"tree\">");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t<li>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t\t<label for=\"diagrams\">Diagrams</label>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t\t<input type=\"checkbox\" id=\"diagrams\"/>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t\t<ol>");
                for (String diagramName : diagramsNamesList) {
                    buffer.append("\n");
                    try {
                        buffer.append("\t\t\t\t\t\t\t\t<li class=\"obj\"><a href=\"#" + URLEncoder.encode(diagramName, "UTF-8").replace("+", "%20") + "\" target=\"_self\">" + StringUtilities.encodeAttributeValue(diagramName) + "</a></li>");
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.error("HTMLSingleFileReport.createBODY(): ", e);
                    }
                }
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t\t</ol>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t\t</li>");
                buffer.append("\n");
                buffer.append("\t\t\t\t\t</ol>");
                buffer.append("\n");
                buffer.append("\t\t\t\t</div>");
                buffer.append("\n");
            } else {
                for (Map.Entry entry : objectNames.entrySet()) {
                    buffer.append("\n");
                    try {
                        buffer.append("\t\t\t\t\t").append("<div><a href=\"#" + URLEncoder.encode(((ModelIDObject)entry.getValue()).getShortObjectID(), "UTF-8").replace("+", "%20") + tocIdSuffix + "\" target=\"_self\">" + StringUtilities.encodeAttributeValue(((ModelIDObject)entry.getValue()).getLongName()) + "</a></div>");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            }
            buffer.append("\t\t\t\t").append("</div>");
            buffer.append("\n");
            buffer.append("\t\t\t").append("</div>");
            buffer.append("\n");
        }
        buffer.append("\t\t\t").append("<div class=\"details\">");
        if (htmlStream != null) {
            buffer.append("\n");
            buffer.append(new String(htmlStream.toByteArray(), Charset.forName("UTF-8")));
            buffer.append("\n");
        }
        if (diagram != null && !diagram.isEmpty()) {
            buffer.append("</br></br></br></br>");
            buffer.append(diagram);
            buffer.append("\n");
        }
        buffer.append("\t\t\t").append("</div>");
        buffer.append("\n");
        buffer.append("\t\t").append("</div>");
        buffer.append("\n");
        buffer.append("\t").append("</body>");
        buffer.append("\n");
        buffer.append("</html>");
    }

    public StringBuffer getContents() {
        return this.buffer;
    }
}

