/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.logical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.InheritanceRelationSet;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.logical.TVArc;

public class TVEntity
extends ContainerView {
    private Collection conns = new ArrayList();

    public TVEntity(DesignPartView dpv) {
        super(dpv);
    }

    @Override
    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    protected Entity getEntityModel() {
        return (Entity)this.getModel();
    }

    protected Relation.Connection[] getConnections() {
        return this.getEntityModel().getRelationConnections();
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
    }

    public Collection getAllConnections() {
        return this.conns;
    }

    @Override
    protected void doPrivateActions() {
        this.reassignRelations();
    }

    public void reassignRelations() {
        TVEntity newtvt = (TVEntity)((ContainerWithKeyObject)this.getModel()).getAnotherView(this);
        if (newtvt != null) {
            Entity entity = (Entity)this.getModel();
            List col = ((LogicalDesign)this.getModel().getDesignPart()).getRelationSet().getRelationsTo(entity);
            for (Relation fk : col) {
                if (fk.getSourceTV(this.getDesignPartView()) == this) {
                    fk.setSourceTV(newtvt);
                }
                if (!fk.matchTargetTV(this.getDesignPartView(), this)) continue;
                fk.setTargetTV(newtvt);
            }
            this.addArc(entity);
        } else {
            Entity tab = (Entity)this.getModel();
            List col = ((LogicalDesign)this.getModel().getDesignPart()).getRelationSet().getRelationsTo(tab);
            for (Relation fk : col) {
                if (fk.getSourceTV(this.getDesignPartView()) == this) {
                    fk.removeViewFor(this.dpv);
                    this.removeArcs(fk.getTargetEntity());
                }
                if (fk.getTargetTV(this.getDesignPartView()) != this) continue;
                fk.removeViewFor(this.dpv);
                this.removeArcs(fk.getSourceEntity());
            }
            this.fireChange(ObjectChangeEvent.TOPVIEW_REMOVED);
        }
    }

    private void removeArcs(Entity entity) {
        for (Arc arc : entity.getArcs()) {
            TVArc tv = (TVArc)arc.getFirstViewForDPV(this.getDesignPartView());
            if (tv == null) continue;
            int relCount = 0;
            for (Relation relation : arc.getRelations()) {
                if (relation.getFirstViewForDPV(this.getDesignPartView()) == null) continue;
                ++relCount;
            }
            if (relCount >= 2) continue;
            tv.remove(false);
        }
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    protected ContainerView createViewSynonim(DesignPartView dpv) {
        return new TVEntity(dpv);
    }

    public void addTVRelations() {
        Relation rel2;
        Entity ent = (Entity)this.getModel();
        DesignPartView dpv = this.getDesignPartView();
        Collection col = this.getDesign().getLogicalDesign().getRelationSet().getRelationsToSource(ent);
        for (Relation rel2 : col) {
            rel2.getSourceTV(dpv);
            rel2.getTargetTV(dpv);
        }
        col = this.getDesign().getLogicalDesign().getRelationSet().getRelationsToTarget(ent);
        for (Relation rel2 : col) {
            rel2.getSourceTV(dpv);
            rel2.getTargetTV(dpv);
        }
        if (ent.getHierarchicalParent() != null && (rel2 = ((InheritanceRelationSet)this.getDesign().getLogicalDesign().getInheritanceRelationSet()).getInheritanceRelation(ent.getHierarchicalParent(), ent)) != null) {
            if (rel2.getTargetTV(dpv) == null) {
                rel2.setTargetTV(this);
            }
            if ((col = ent.getHierarchicalParent().getViewsForDPV(dpv)).size() > 0) {
                Iterator it2 = col.iterator();
                TopView tv = (TopView)it2.next();
                if (rel2.getSourceTV(dpv) == null) {
                    rel2.setSourceTV((TVEntity)tv);
                }
            }
        }
        List list = ((InheritanceRelationSet)this.getDesign().getLogicalDesign().getInheritanceRelationSet()).getSubtypesOf(ent);
        for (InheritanceRelation rel3 : list) {
            Entity tent;
            if (rel3.getSourceTV(dpv) == null) {
                rel3.setSourceTV(this);
            }
            if ((col = (tent = rel3.getTargetEntity()).getViewsForDPV(dpv)).size() <= 0) continue;
            Iterator it2 = col.iterator();
            TopView tv = (TopView)it2.next();
            if (rel3.getTargetTV(dpv) != null) continue;
            rel3.setTargetTV((TVEntity)tv);
        }
    }

    public void addTVRelations(DesignPartView dpv) {
        Relation rel2;
        Entity ent = (Entity)this.getModel();
        Collection col = this.getDesign().getLogicalDesign().getRelationSet().getRelationsToSource(ent);
        for (Relation rel2 : col) {
            if (rel2.getSourceTV(dpv) != null) continue;
            rel2.setSourceTV(this);
        }
        col = this.getDesign().getLogicalDesign().getRelationSet().getRelationsToTarget(ent);
        for (Relation rel2 : col) {
            if (rel2.getTargetTV(dpv) != null) continue;
            rel2.setTargetTV(this);
        }
        if (ent.getHierarchicalParent() != null && (rel2 = ((InheritanceRelationSet)this.getDesign().getLogicalDesign().getInheritanceRelationSet()).getInheritanceRelation(ent.getHierarchicalParent(), ent)) != null) {
            if (rel2.getTargetTV(dpv) == null) {
                rel2.setTargetTV(this);
            }
            if ((col = ent.getHierarchicalParent().getViewsForDPV(dpv)).size() > 0) {
                Iterator it2 = col.iterator();
                TopView tv = (TopView)it2.next();
                if (rel2.getSourceTV(dpv) == null) {
                    rel2.setSourceTV((TVEntity)tv);
                }
            }
        }
        List list = ((InheritanceRelationSet)this.getDesign().getLogicalDesign().getInheritanceRelationSet()).getSubtypesOf(ent);
        for (InheritanceRelation rel3 : list) {
            Entity tent;
            if (rel3.getSourceTV(dpv) == null) {
                rel3.setSourceTV(this);
            }
            if ((col = (tent = rel3.getTargetEntity()).getViewsForDPV(dpv)).size() <= 0) continue;
            Iterator it2 = col.iterator();
            TopView tv = (TopView)it2.next();
            if (rel3.getTargetTV(dpv) != null) continue;
            rel3.setTargetTV((TVEntity)tv);
        }
    }

    public void addArcs() {
        Entity entity = (Entity)this.getModel();
        for (Arc arc : entity.getArcs()) {
            if (arc.getFirstViewForDPV(this.getDesignPartView()) != null) continue;
            Iterator rit = arc.getRelations().iterator();
            int relCount = 0;
            while (rit.hasNext()) {
                Relation relation = (Relation)rit.next();
                TopView tv = relation.getFirstViewForDPV(this.getDesignPartView());
                if (tv == null) continue;
                ++relCount;
            }
            if (relCount <= true) continue;
            this.getDesignPartView().addViewFor(arc);
        }
        for (Relation rel : this.getDesign().getLogicalDesign().getRelationSet().getRelationsTo(entity)) {
            Entity sourceEntity = rel.getOtherEntity(entity);
            if (sourceEntity.getFirstViewForDPV(this.getDesignPartView()) == null) continue;
            this.addArc(sourceEntity);
        }
    }

    private void addArc(Entity entity) {
        for (Arc arc : entity.getArcs()) {
            if (arc.getFirstViewForDPV(this.getDesignPartView()) != null) continue;
            Iterator rit = arc.getRelations().iterator();
            int relCount = 0;
            while (rit.hasNext()) {
                Relation relation = (Relation)rit.next();
                TopView tv = relation.getFirstViewForDPV(this.getDesignPartView());
                if (tv == null) continue;
                ++relCount;
            }
            if (relCount <= true) continue;
            this.getDesignPartView().addViewFor(arc);
        }
    }

    public void addArc(Arc arc) {
        if (arc.getFirstViewForDPV(this.getDesignPartView()) == null) {
            Iterator rit = arc.getRelations().iterator();
            int relCount = 0;
            while (rit.hasNext()) {
                Relation relation = (Relation)rit.next();
                TopView tv = relation.getFirstViewForDPV(this.getDesignPartView());
                if (tv == null) continue;
                ++relCount;
            }
            if (relCount > 1) {
                this.getDesignPartView().addViewFor(arc);
            }
        }
    }

    @Override
    public String toString() {
        int i = this.getViewNumber();
        String s = i == 0 ? "" : ":" + i;
        String tname = this.getModel().getName();
        String syn = ((Entity)this.getModel()).getSynonymToDisplay();
        if (syn != null && !"".equals(syn)) {
            tname = syn;
        }
        return tname + s;
    }

    @Override
    protected void hideRelations() {
    }

    private void removeArc() {
        Entity entity = (Entity)this.getModel();
        for (Arc arc : entity.getArcs()) {
            TVArc tv = (TVArc)arc.getFirstViewForDPV(this.getDesignPartView());
            if (tv == null) continue;
            tv.remove(false);
        }
    }

    @Override
    public void remove() {
        this.removeArc();
        super.remove();
    }

    @Override
    public void remove(boolean removeModel) {
        if (removeModel) {
            this.removeArc();
            ((Entity)this.getModel()).remove(true);
        } else {
            this.doPrivateActions();
            this.getDesignPartView().removeView(this);
        }
    }
}

