/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;

public class IndexProxySetOraclev10g
extends IndexProxySet
implements Constants {
    public IndexProxySetOraclev10g(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject object) {
        return new IndexProxyOraclev10g((Index)object, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        return new IndexProxyOraclev10g(design, id, longName, this.getStorageDesign());
    }

    @Override
    public void add(DesignObject object) {
        String id = object.getObjectID();
        RelationalObjectProxy proxy = this.getProxy(id);
        if (proxy == null && (proxy = this.restoreProxyFromRecycleMap(object)) != null) {
            this.add(proxy);
            this.fireUpdate();
            return;
        }
        if (proxy != null) {
            if (!this.getProxy(id).isLoaded()) {
                this.getProxy(id).loadDesignObject();
            }
        } else if (object instanceof KeyObject && !((KeyObject)object).isPK() && !((KeyObject)object).isFK() && !((Index)object).getIndexState().equalsIgnoreCase("Unique Constraint")) {
            proxy = this.createProxy(object);
            try {
                this.add(proxy);
                if (!this.getStorageDesign().isLoading()) {
                    IndexProxyOracle indexProxy = (IndexProxyOracle)proxy;
                    TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
                    if (tableProxy != null) {
                        indexProxy.setUser(tableProxy.getUser());
                        indexProxy.setTableSpace(tableProxy.getTableSpace());
                    }
                    this.applyTemplate(indexProxy);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.fireUpdate();
        }
    }

    protected void applyTemplate(IndexProxyOracle proxy) {
        if (this.getDesign().getSettings().useOracleIndexTemplate()) {
            // empty if block
        }
    }

    @Override
    protected void add(Index[] array) {
        for (int i = 0; i < array.length; ++i) {
            Index ind = array[i];
            if (ind.isPK() || ind.isFK() || ind.isUnique()) continue;
            this.add(ind);
        }
    }
}

