/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.exports.ddl.SQLAnalyzer;
import oracle.dbtools.crest.exports.ddl.SSBDropFK;
import oracle.dbtools.crest.exports.ddl.SSBDropIndex;
import oracle.dbtools.crest.exports.ddl.SSBDropTable;
import oracle.dbtools.crest.exports.ddl.SSBDropView;
import oracle.dbtools.crest.exports.ddl.SSBEndScript;
import oracle.dbtools.crest.exports.ddl.SSBErrorHandler;
import oracle.dbtools.crest.model.AbstractDesign;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.NameValidator;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignEvent;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DesignPartListener;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxySet;
import oracle.dbtools.crest.model.design.storage.ColumnProxySet;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.MethodParamProxySet;
import oracle.dbtools.crest.model.design.storage.MethodProxySet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectPropertyTranslator;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageObjectSetEvent;
import oracle.dbtools.crest.model.design.storage.StorageObjectSetListener;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxySet;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableProxySet;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxySet;
import oracle.dbtools.crest.model.design.storage.TypeElementProxySet;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.MaterializedViewLogOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.db.RepDeleteDescr;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;
import oracle.dbtools.crest.swingui.ddl.DDLConfig;
import oracle.dbtools.crest.swingui.search.Searchable;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyTranslator;

public abstract class StorageDesign
extends AbstractDesign
implements DesignPartListener,
StorageObjectSetListener,
DesignListener,
NameValidator,
Searchable {
    public static final String RDBMS_DB2_V7_0 = "db2v7.0";
    public static String TYPE_NAME = "StorageDesign";
    public static final StorageDesign[] PROTOTYPE_ARRAY = new StorageDesign[0];
    protected List<ElementSet> ddlSelectionSetsList;
    private RDBMSSite rdbmsSite = null;
    private Map physicalProxyMap = new TreeMap();
    private Map storageObjectMap = new TreeMap();
    private DDLGenerator generator;
    private DDLGenerator dropGenerator;
    private DDLGenerator incompleteTypeGenerator;
    private DDLGenerator typeGenerator;
    private DDLGenerator scopeGenerator;
    private DDLGenerator physicalTriggerGenerator;
    private DDLGenerator triggerGenerator;
    private DDLGenerator ordsGenerator;
    private DDLGenerator autoIncrementColumnGenerator;
    private DDLGenerator redactionPolicyGenerator;
    private DDLGenerator tsdpGenerator;
    private DDLGenerator userGenerator;
    private List endGenerators;
    private boolean initialReadBackDone = false;
    private MDDataTypeFactory dataTypeFactory = null;
    private boolean isLoading = true;
    private boolean initialize = true;
    protected List elements = new ArrayList();
    private boolean open = false;
    private RelationalDesign physicalDesign;
    private boolean closing = false;
    private boolean storageObjectsOnly = false;
    private TreeMap repositoryMap = new TreeMap();
    private float loadedVersion = 2.2f;
    private float version = 2.2f;
    private boolean cloneOperation = false;
    private RDBMSSite clonedSite = null;
    private boolean objectListChanged = false;
    protected Map f2tMap = null;
    private boolean tempModel = true;
    private static File lastFolder = null;
    private List lastSearchResult;
    private Map notLoadedObjectHelpersMap = new HashMap();
    private boolean importing = false;
    private boolean includeSchemaInDDL = true;
    private static final Logger LOGGER = new Logger(StorageDesign.class);
    private TreeMap filesMap = new TreeMap();
    private Map substitutionMap = new TreeMap();
    private PropertyTranslator[] translators;
    private List substitutionList;
    protected Map correspondenceMap;
    protected Map reverseMap;
    private Map cachedSchemaMap = new HashMap();
    private static GetHelper getHelper = new GetHelper();

    public StorageDesign(RelationalDesign physicalDesign, RDBMSSite site, Design design) {
        this.id = new GUID().toString();
        this.physicalDesign = physicalDesign;
        this.setRDBMSSite(site);
        this.setDesign(design);
        this.setDirty(true);
    }

    public MDDataTypeFactory getDataTypeFactory() {
        if (this.dataTypeFactory == null) {
            this.dataTypeFactory = this.createDataTypeFactory();
        }
        return this.dataTypeFactory;
    }

    public MDDataTypeFactory createDataTypeFactory() {
        return this.getDesign().getDTFactoryInstance(this.getRDBMSType());
    }

    protected void initialize() {
        this.getDataTypeFactory();
        this.initializeImportedDesigns();
    }

    public boolean hasSpaceCalculation() {
        return false;
    }

    public void showSpaceCalculation() {
    }

    public boolean hasDistinctTypes() {
        return false;
    }

    public void showDistinctTypes() {
    }

    public boolean hasUserDefinedTypes() {
        return false;
    }

    public void showUserDefinedTypes() {
    }

    public List getDropableSets() {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    public String getFileName() {
        return this.getDesign().getFileName();
    }

    @Override
    public Collection getAllTopLevelObjects() {
        LinkedList<Object> list = new LinkedList<Object>();
        for (ElementSet objectSet : this.getAllSetsList()) {
            list.addAll(Arrays.asList(objectSet.toArray()));
        }
        return list;
    }

    public static StorageDesign createStorageDesign(RelationalDesign physicalDesign, RDBMSSite site, Design design) {
        if (physicalDesign == null || site == null || site.getType() == null || site.getType().getStorageDesignClassName() == null) {
            return StorageDesign.createNullInstanceWith(site, design);
        }
        RDBMSType type = site.getType();
        String className = type.getStorageDesignClassName();
        StorageDesign stoDes = null;
        ArrayList<String> msg = null;
        try {
            Class<?> stoDesClass = Class.forName(className);
            Constructor<?> constructor = stoDesClass.getDeclaredConstructor(RelationalDesign.class, RDBMSSite.class, Design.class);
            stoDes = (StorageDesign)constructor.newInstance(physicalDesign, site, design);
            design.addDesignListener(stoDes);
            stoDes.initialize();
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Can not find class " + className, e);
            msg = new ArrayList();
            msg.add("Can not find class (cnfe)");
            msg.add(className);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.error("Can not find class (ncdfe)" + className);
            msg = new ArrayList();
            msg.add("Can not find class (ncdfe)");
            msg.add(className);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("There is no appropriate constructor Xxx(PhysicalDesign, RDBMSSite, design).", e);
            msg = new ArrayList<String>();
            msg.add("There is no appropriate constructor Xxx(PhysicalDesign, RDBMSSite, design)");
            msg.add(className);
        }
        catch (Exception e) {
            LOGGER.error("Can not instantiate StorageDesign:", e);
            msg = new ArrayList();
            msg.add("Can not instantiate StorageDesign");
            msg.add(className);
        }
        if (stoDes == null) {
            stoDes = new NullStorageDesign(null, "No Storage Design loaded", msg, site, design);
        }
        return stoDes;
    }

    private static StorageDesign createNullInstanceWith(RDBMSSite site, Design design) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add("Storage Design can not be instantiated due to: ");
        if (site == null) {
            msg.add("No RDBMSSite information (null)");
        } else if (site.getType() == null) {
            msg.add("No RDBMSType information (null)");
        } else if (site.getType().getStorageDesignClassName() == null) {
            msg.add("No StorageDesignClassName information (null)");
        }
        if (design == null) {
            msg.add("Design (null).");
        }
        return new NullStorageDesign(null, Messages.getString("StorageDesign.NoStorageDesignLoaded"), msg, site, design);
    }

    public void setRDBMSSite(RDBMSSite site) {
        this.rdbmsSite = site;
    }

    public RDBMSSite getRDBMSSite() {
        return this.rdbmsSite;
    }

    public boolean isRDBMSSite(RDBMSSite site) {
        return this.getRDBMSSite().equals(site);
    }

    public abstract RDBMSType getRDBMSType();

    public abstract PropertyHolder getPropertyHolder();

    @Override
    public String getIDPrefix() {
        return "STODES";
    }

    public void addStorageObject(StorageObject object) {
        Object obj = this.storageObjectMap.remove(object.getObjectID());
        this.storageObjectMap.put(object.getObjectID(), object);
    }

    public void removeStorageObject(StorageObject object) {
        this.storageObjectMap.remove(object.getObjectID());
    }

    public ModelIDObject getModelIDObject(String objectId) {
        if (objectId == null || objectId.isEmpty()) {
            return null;
        }
        ModelIDObject obj = (ModelIDObject)this.storageObjectMap.get(objectId);
        if (obj != null) {
            return obj;
        }
        if (this.physicalProxyMap.containsKey(objectId)) {
            LOGGER.error("StorageDesign.getModelIDObject(String): should not return PhysicalObjectProxy");
        }
        return null;
    }

    public StorageObject getStorageObject(String id) {
        return (StorageObject)this.getModelIDObject(id);
    }

    public abstract TableSpaceSetOracle getTableSpaceSet();

    public TableSpaceOracle getOrCreateTablespaceByName(String name) {
        TableSpaceOracle ts = (TableSpaceOracle)this.getTableSpaceSet().getByName(name);
        if (ts == null) {
            ts = this.getTableSpaceSet().createTableSpace();
            ts.setName(name);
        }
        return ts;
    }

    protected void registerModelIDObject(ModelIDObject object) {
        String id = object.getObjectID();
        if (object != null && id != null) {
            this.storageObjectMap.put(object.getObjectID(), object);
            this.setObjectListChanged(true);
        }
    }

    public void updateObjectID(String oldID, ModelIDObject object) {
        String id = object.getObjectID();
        if (id != null && !id.isEmpty()) {
            if (oldID != null && !oldID.isEmpty()) {
                this.storageObjectMap.remove(oldID);
                this.storageObjectMap.put(id, object);
            } else {
                this.registerModelIDObject(object);
            }
        }
    }

    protected void unregisterModelIDObject(ModelIDObject object) {
        if (object != null && object.getObjectID() != null) {
            this.storageObjectMap.remove(object.getObjectID());
            this.setObjectListChanged(true);
        }
    }

    public void unregisterAll() {
        this.storageObjectMap.clear();
    }

    public boolean hasModelIDObject(ModelIDObject object) {
        return this.hasModelIDObject(object.getObjectID());
    }

    public boolean hasModelIDObject(String id) {
        return this.storageObjectMap.containsKey(id);
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject object) {
        if (object instanceof Table || object instanceof Index) {
            // empty if block
        }
    }

    @Override
    public void objectRemoved(DesignPart designPart, DesignObject object) {
    }

    public boolean isNullInstance() {
        return false;
    }

    public Map getFunctionalities() {
        return Collections.EMPTY_MAP;
    }

    public abstract TableProxySet getTableProxySet();

    public abstract IndexProxySet getIndexProxySet();

    public abstract ColumnProxySet getColumnProxySet();

    public abstract TableViewProxySet getTableViewProxySet();

    public abstract StructuredTypeProxySet getStructuredTypeProxySet();

    public abstract TypeElementProxySet getTypeElementProxySet();

    public abstract MethodProxySet getMethodProxySet();

    public abstract MethodParamProxySet getMethodParamProxySet();

    public abstract StorageObjectSet getStorageObjectSetForType(String var1);

    public abstract CollectionTypeProxySet getCollectionTypeProxySet();

    public abstract void sortCollections();

    public List getAllSetsList() {
        ArrayList<RelationalObjectProxySet> list = new ArrayList<RelationalObjectProxySet>();
        list.add(this.getTableProxySet());
        list.add(this.getColumnProxySet());
        list.add(this.getIndexProxySet());
        list.add(this.getTableViewProxySet());
        list.add(this.getStructuredTypeProxySet());
        list.add(this.getTypeElementProxySet());
        list.add(this.getMethodProxySet());
        return list;
    }

    public RelationalObjectProxy getProxy(Object object) {
        String id = null;
        if (object instanceof ModelIDObject) {
            id = ((ModelIDObject)object).getObjectID();
        } else if (object instanceof String) {
            id = (String)object;
        }
        if (this.getTableProxySet().containsId(id)) {
            return this.getTableProxySet().getProxy(id);
        }
        if (this.getIndexProxySet().containsId(id)) {
            return this.getIndexProxySet().getProxy(id);
        }
        if (this.getColumnProxySet().containsId(id)) {
            return this.getColumnProxySet().getProxy(id);
        }
        if (this.getTableViewProxySet().containsId(id)) {
            return this.getTableViewProxySet().getProxy(id);
        }
        if (this.getStructuredTypeProxySet() != null && this.getStructuredTypeProxySet().containsId(id)) {
            return this.getStructuredTypeProxySet().getProxy(id);
        }
        if (this.getTypeElementProxySet() != null && this.getTypeElementProxySet().containsId(id)) {
            return this.getTypeElementProxySet().getProxy(id);
        }
        if (this.getMethodProxySet() != null && this.getMethodProxySet().containsId(id)) {
            return this.getMethodProxySet().getProxy(id);
        }
        if (this.getMethodParamProxySet() != null && this.getMethodParamProxySet().containsId(id)) {
            return this.getMethodParamProxySet().getProxy(id);
        }
        if (this.getCollectionTypeProxySet() != null && this.getCollectionTypeProxySet().containsId(id)) {
            return this.getCollectionTypeProxySet().getProxy(id);
        }
        return null;
    }

    public List getDDLEndScriptGenerators() {
        if (this.endGenerators == null) {
            this.endGenerators = this.createDDLEndScriptGenerators();
            for (DDLGenerator generator : this.endGenerators) {
                generator.setLabel(this.getRDBMSType().getLongName());
            }
        }
        return this.endGenerators;
    }

    protected List createDDLEndScriptGenerators() {
        ArrayList<DDLGeneratorSpecific> list = new ArrayList<DDLGeneratorSpecific>();
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        ddlGenerator.append(new SSBEndScript());
        list.add(ddlGenerator);
        return list;
    }

    public DDLGenerator getDDLGenerator() {
        if (this.generator == null) {
            this.generator = this.createDDLGenerator();
            this.generator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
            this.generator.setLabel(this.getRDBMSType().getLongName());
        }
        return this.generator;
    }

    protected DDLGenerator createDDLGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    public DDLGenerator getDDLDropGenerator() {
        if (this.dropGenerator == null) {
            this.dropGenerator = this.createDDLDropGenerator();
            this.dropGenerator.setLabel("DropGen");
            this.dropGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.dropGenerator;
    }

    protected DDLGenerator createDDLDropGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        ddlGenerator.append(new SSBDropFK());
        ddlGenerator.append(new SSBDropIndex());
        ddlGenerator.append(new SSBDropView());
        ddlGenerator.append(new SSBDropTable());
        return ddlGenerator;
    }

    public DDLGenerator getDDLIncompleteTypeGenerator() {
        if (this.incompleteTypeGenerator == null) {
            this.incompleteTypeGenerator = this.createDDLIncompleteTypeGenerator();
            this.incompleteTypeGenerator.setLabel("TypesGen");
            this.incompleteTypeGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.incompleteTypeGenerator;
    }

    public DDLGenerator getDDLUserGenerator() {
        if (this.userGenerator == null) {
            this.userGenerator = this.createDDLUserGenerator();
            this.userGenerator.setLabel("UserGen");
            this.userGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.userGenerator;
    }

    protected DDLGenerator createDDLIncompleteTypeGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    public DDLGenerator getDDLTypeGenerator() {
        if (this.typeGenerator == null) {
            this.typeGenerator = this.createDDLTypeGenerator();
            this.typeGenerator.setLabel("CompileTypesGen");
            this.typeGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.typeGenerator;
    }

    protected DDLGenerator createDDLTypeGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    public DDLGenerator getDDLScopeGenerator() {
        if (this.scopeGenerator == null) {
            this.scopeGenerator = this.createDDLScopeGenerator();
            this.scopeGenerator.setLabel("ScopeGenerator");
            this.scopeGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.scopeGenerator;
    }

    protected DDLGenerator createDDLScopeGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    public DDLGenerator getORDSGenerator() {
        if (this.ordsGenerator == null) {
            this.ordsGenerator = this.createORDSGenerator();
            this.ordsGenerator.setLabel("ORDSGenerator");
            this.ordsGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.ordsGenerator;
    }

    protected DDLGenerator createORDSGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    protected DDLGenerator createDDLUserGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    public DDLGenerator getDDLPhysicalTriggerGenerator() {
        if (this.physicalTriggerGenerator == null) {
            this.physicalTriggerGenerator = this.createDDLPhysicalTriggerGenerator();
            this.physicalTriggerGenerator.setLabel("PhysicalTriggerGenerator");
            this.physicalTriggerGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.physicalTriggerGenerator;
    }

    protected DDLGenerator createDDLPhysicalTriggerGenerator() {
        return new DDLGeneratorSpecific();
    }

    public DDLGenerator getDDLTriggerGenerator() {
        if (this.triggerGenerator == null) {
            this.triggerGenerator = this.createDDLTriggerGenerator();
            this.triggerGenerator.setLabel("TriggerGenerator");
            this.triggerGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.triggerGenerator;
    }

    public DDLGenerator getDDLAutoIncrementColumnGenerator() {
        if (this.autoIncrementColumnGenerator == null) {
            this.autoIncrementColumnGenerator = this.createDDLAutoIncrementColumnGenerator();
            this.autoIncrementColumnGenerator.setLabel("AutoIncrementColumnGenerator");
            this.autoIncrementColumnGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.autoIncrementColumnGenerator;
    }

    public DDLGenerator getRedactionPolicyGenerator() {
        if (this.redactionPolicyGenerator == null) {
            this.redactionPolicyGenerator = this.createRedactionPolicyGenerator();
            this.redactionPolicyGenerator.setLabel("RedactionPolicyGenerator");
            this.redactionPolicyGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.redactionPolicyGenerator;
    }

    public DDLGenerator getTSDPGenerator() {
        if (this.tsdpGenerator == null) {
            this.tsdpGenerator = this.createTSDPGenerator();
            this.tsdpGenerator.setLabel("TSDPGenerator");
            this.tsdpGenerator.append(SSBErrorHandler.createInstanceWithErrorLabel(this.getRDBMSSite().getName()));
        }
        return this.tsdpGenerator;
    }

    protected DDLGenerator createDDLTriggerGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    protected DDLGenerator createDDLAutoIncrementColumnGenerator() {
        return new DDLGeneratorSpecific();
    }

    protected DDLGenerator createRedactionPolicyGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    protected DDLGenerator createTSDPGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        return ddlGenerator;
    }

    public Iterator ddlObjects() {
        ArrayList list = new ArrayList();
        this.addDDLStorageObjects(list, this.getTableProxySet());
        this.addDDLStorageObjects(list, this.getIndexProxySet());
        this.addDDLStorageObjects(list, this.getTableViewProxySet());
        return list.iterator();
    }

    public abstract List getListOfDDLObjects();

    public Iterator ddlDropObjects() {
        ArrayList list = new ArrayList();
        this.addDDLStorageObjects(list, this.getIndexProxySet());
        this.addDDLStorageObjects(list, this.getTableViewProxySet());
        this.addDDLStorageObjects(list, this.getTableProxySet());
        return list.iterator();
    }

    public Iterator ddlIncompleteTypeObjects() {
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    public Iterator ddlTypeObjects() {
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    public Iterator ddlScopeObjects() {
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    public Iterator ddlORDSObjects() {
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    public Iterator ddlUserObjects() {
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    public Iterator ddlAutoIncrementColumnObjects() {
        ArrayList list = new ArrayList();
        this.addDDLStorageObjects(list, this.getTableProxySet());
        return list.iterator();
    }

    public Iterator ddlEndScriptObjects() {
        ArrayList list = new ArrayList();
        this.addDDLStorageObjects(list, this.getTableProxySet());
        this.addDDLStorageObjects(list, this.getTableViewProxySet());
        return list.iterator();
    }

    public Iterator ddlTriggersCausingObjects() {
        ArrayList<TableProxy> list = new ArrayList<TableProxy>();
        Iterator it = this.getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxy tp = (TableProxy)it.next();
            if (!((Table)tp.getObject()).hasNoneTransferableFK()) continue;
            list.add(tp);
        }
        this.getPhysicalDesign().getArcSet().addAllElementsTo(list);
        return list.iterator();
    }

    public Iterator ddlRedactionPolicyObjects() {
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    public Iterator ddlTSDPPolicyObjects() {
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    protected void addDDLStorageObjects(Collection collection, RelationalObjectProxySet set) {
        this.addDDLStorageObjects(collection, (StorageObject[])set.toArray());
    }

    protected void addDDLStorageObjectsNosort(Collection collection, RelationalObjectProxySet set) {
        this.addDDLStorageObjectsNoSort(collection, (StorageObject[])set.toArray());
    }

    protected void addDDLStorageObjects(Collection collection, StorageObjectSet set) {
        this.addDDLStorageObjects(collection, (StorageObject[])set.toArray());
    }

    protected void addDDLStorageObjects(Collection collection, StorageObject[] objects) {
        ArrayList<StorageObject> list = new ArrayList<StorageObject>();
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i].isNullInstance() || !objects[i].belongsToDesign()) continue;
            StorageObject object = objects[i];
            list.add(object);
        }
        Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
        collection.addAll(list);
    }

    protected void addDDLObjects(Collection collection, List objects) {
        ArrayList<DesignObject> list = new ArrayList<DesignObject>();
        for (DesignObject desObj : objects) {
            if (!desObj.belongsToDesign()) continue;
            list.add(desObj);
        }
        Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
        collection.addAll(list);
    }

    protected void addDDLStorageObjectsNoSort(Collection collection, StorageObject[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i].isNullInstance() || !objects[i].belongsToDesign()) continue;
            StorageObject object = objects[i];
            collection.add(object);
        }
    }

    protected void addDDLStorageObjectsNoSort(Collection collection, List list) {
        for (StorageObject sto : list) {
            if (sto.isNullInstance() || !sto.belongsToDesign()) continue;
            collection.add(sto);
        }
    }

    public Iterator siteObjects() {
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator designSpecificObjects() {
        ArrayList list = new ArrayList();
        this.addStorageObjects(list, this.getStructuredTypeProxySet());
        this.addStorageObjects(list, this.getTableProxySet());
        this.addStorageObjects(list, this.getIndexProxySet());
        this.addStorageObjects(list, this.getTableViewProxySet());
        return list.iterator();
    }

    protected void addStorageObjects(Collection collection, RelationalObjectProxySet set) {
        this.addStorageObjects(collection, (StorageObject[])set.toArray());
    }

    protected void addStorageObjects(Collection collection, StorageObjectSet set) {
        this.addDDLStorageObjects(collection, (StorageObject[])set.toArray());
    }

    protected void addStorageObjects(Collection collection, StorageObject[] objects) {
        collection.add(Arrays.asList(objects));
    }

    public PropertyTranslator[] getPropertyTranslators() {
        if (this.translators == null) {
            this.translators = new PropertyTranslator[]{new StorageObjectPropertyTranslator(this)};
        }
        return this.translators;
    }

    public void doTableSpaceCalculations() {
    }

    public void doIndexSpaceCalculations() {
    }

    public void copyCommentInRDBMS() {
        this.copyCommentInRDBMS(this.getTableProxySet());
        this.copyCommentInRDBMS(this.getTableViewProxySet());
        this.copyCommentInRDBMS(this.getColumnProxySet());
        this.copyCommentInRDBMS(this.getIndexProxySet());
    }

    public void copyCommentInRDBMS(RelationalObjectProxySet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            RelationalObjectProxy proxy = (RelationalObjectProxy)it.next();
            proxy.copyCommentInRDBMS();
        }
    }

    @Override
    public void changed(StorageObjectSet set, StorageObjectSetEvent event) {
        if (event.isAdded()) {
            this.addStorageObject(event.getAffectedStorageObject());
        } else if (event.isRemoved()) {
            this.removeStorageObject(event.getAffectedStorageObject());
        }
    }

    public boolean isInitialReadBackDone() {
        return this.initialReadBackDone;
    }

    public void setInitialReadBackDone(boolean value) {
        this.initialReadBackDone = value;
    }

    @Override
    public void designChanged(DesignEvent event) {
    }

    public void importDesign(Object name) {
    }

    protected void initializeImportedDesigns() {
        String[] names = this.getDesign().getImportedDesignNames();
        for (int i = 0; i < names.length; ++i) {
            this.importDesign(names[i]);
        }
    }

    @Override
    public String[] getImportedDesignNames() {
        return this.getDesign().getImportedDesignNames();
    }

    @Override
    public List getSearchableSets() {
        return Collections.EMPTY_LIST;
    }

    public void setLoading(boolean state) {
        this.isLoading = state;
        if (!state) {
            this.initialize = false;
        }
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void clearAll() {
        for (Object obj : this.getAllSetsList()) {
            if (obj instanceof StorageObjectSet) {
                ((StorageObjectSet)obj).removeAll();
                continue;
            }
            if (!(obj instanceof RelationalObjectProxySet)) continue;
            ((RelationalObjectProxySet)obj).clearAll();
        }
        this.unregisterAll();
        this.notLoadedObjectHelpersMap.clear();
    }

    public void close() {
        try {
            this.closing = true;
            this.setVisible(false);
            this.setOpen(false);
            this.clearAll();
            this.reloadAllProxies();
            this.reloadDefaults();
        }
        finally {
            this.closing = false;
        }
        System.gc();
    }

    public void reloadDefaults() {
    }

    public void delete() {
        this.delete(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(boolean confirm) {
        if (confirm) {
            // empty if block
        }
        try {
            String storagePath;
            this.closing = true;
            if (this.getDesign().isOldRepositoryType()) {
                // empty if block
            }
            this.setVisible(false);
            this.setOpen(false);
            this.getDesign().removeDesignListener(this);
            this.getPhysicalDesign().removeDesignPartListener(this);
            this.clearAll();
            if (this.getPhysicalDesign().getStorageDesignFactory() != null) {
                this.getPhysicalDesign().getStorageDesignFactory().removeStorageDesign(this);
            }
            if ((storagePath = this.getStoragePath()) != null) {
                File deleted = new File(storagePath);
                this.getDesign().deleteDirectory(deleted);
            }
            this.physicalDesign = null;
            this.setDesign(null);
        }
        finally {
            this.closing = false;
        }
        System.gc();
    }

    @Override
    public int getNumberOfChildren() {
        if (!this.isOpen()) {
            return 0;
        }
        return this.elements.size();
    }

    @Override
    public ModelObject getChild(int index) {
        return (ModelObject)this.elements.get(index);
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        return this.elements.indexOf(child);
    }

    @Override
    public int getIndexForChild(Object child) {
        return this.elements.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public RelationalDesign getPhysicalDesign() {
        return this.physicalDesign;
    }

    public void doAfterNew() {
    }

    public void doAfterLoad() {
        int pers = this.getDesign().getLoadedModelPersistence();
        if (pers != Design.PERS_MODEL_IN_ONE_FILE) {
            this.createFilesMap();
        }
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.setAllStorableObjectsDirty(false);
        this.sortCollections();
        DDLConfig.restoreDDLSelection(this);
    }

    public void load() {
        this.createFilesMap();
        this.setDirty(false);
        this.setObjectListChanged(false);
        this.setAllStorableObjectsDirty(false);
    }

    public void checkAndSetIDGenerator() {
    }

    private long getCounter(String id) {
        int ind = 9;
        int length = id.length();
        long counter = 0L;
        if (ind > length) {
            ind = length - 1;
        }
        while (true) {
            try {
                counter = Integer.parseInt(id.substring(length - ind));
                return counter;
            }
            catch (NumberFormatException e) {
                if (--ind >= 1) continue;
                return 0L;
            }
            break;
        }
    }

    public void createRepositoryMap() {
        this.repositoryMap.clear();
        List col = this.getStorableObjects();
        for (ModelIDObject dobj : col) {
            if (dobj.getRepositoryOID() == null) continue;
            RepDeleteDescr descr = new RepDeleteDescr();
            descr.objectType = dobj.getObjectTypeName();
            descr.repOID = dobj.getRepositoryOID();
            descr.repOVID = dobj.getRepositoryOVID();
            this.repositoryMap.put(dobj.getObjectID(), descr);
        }
    }

    public List getObjectsToDeleteFromRepository() {
        List col = this.getStorableObjects();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (ModelIDObject dobj : col) {
            if (dobj.getRepositoryOID() == null) continue;
            map.put(dobj.getObjectID(), dobj.getObjectID());
        }
        ArrayList deleted = new ArrayList();
        for (Map.Entry entry : this.repositoryMap.entrySet()) {
            Object obj = map.get(entry.getKey());
            if (obj != null) continue;
            deleted.add(entry.getValue());
        }
        return deleted;
    }

    public void doAfterSave() {
        if (this.getPhysicalDesign().getDesign().getCurrentOperation() != 5) {
            this.synchronizeFilesMap(true);
            this.setDirty(false);
            this.setAllStorableObjectsDirty(false);
        }
    }

    public void synchronizeFilesMap(boolean removeFromVCS) {
        this.removeDeletedObjects(removeFromVCS);
        this.createFilesMap();
    }

    public void save() {
        if (!this.isTempModel()) {
            int oper;
            if (this.getDesign().isOldRepositoryType()) {
                // empty if block
            }
            if ((oper = this.getDesign().getCurrentOperation()) != 5) {
                this.setDirty(false);
                this.setAllStorableObjectsDirty(false);
            }
        }
    }

    protected void createFilesMap() {
        this.filesMap.clear();
        List col = this.getStorableObjects();
        for (Object obj : col) {
            ModelIDObject dobj;
            if (!(obj instanceof ModelIDObject) || (dobj = (ModelIDObject)obj).getSegmentedStorageName() == null) continue;
            this.filesMap.put(dobj.getObjectID(), dobj.getSegmentedStorageName());
        }
    }

    public void addToFilesMap(String objectID, String segmentedStorageName) {
        this.filesMap.put(objectID, segmentedStorageName);
    }

    private void removeDeletedObjects(boolean removeFromVCS) {
        List col = this.getStorableObjects();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (ModelIDObject dobj : col) {
            map.put(dobj.getObjectID(), dobj.getObjectID());
        }
        ArrayList deleted = new ArrayList();
        for (Map.Entry entry : this.filesMap.entrySet()) {
            Object obj = map.get(entry.getKey());
            if (obj != null || entry.getValue() == null) continue;
            deleted.add(entry.getValue());
        }
        if (deleted.size() > 0) {
            this.getDesign().deleteFiles(deleted);
        }
    }

    public abstract String getFormatedName(String var1);

    public String getFormatedName(ModelIDObject obj) {
        boolean quoted = this.getDesign().getSettings().isUseQuotedIdentifiers();
        return obj.getFormatedName(this, quoted);
    }

    public String getFormatedLongNameDDL(ModelIDObject obj) {
        TableProxyOracle tp;
        if (obj instanceof SnapshotOracle) {
            TableProxyOracle prebuiltTable = ((SnapshotOracle)obj).getOnPrebuildTable();
            if (prebuiltTable != null) {
                obj = prebuiltTable;
            }
        } else if (obj instanceof MaterializedViewLogOracle && (tp = ((MaterializedViewLogOracle)obj).getTableProxy()) != null) {
            obj = tp;
        }
        if (this.getDesign().getSettings().isIncludeSchemaInDDL()) {
            return this.getFormatedLongName(obj);
        }
        return this.getFormatedName(obj);
    }

    public String getFormatedLongName(ModelIDObject obj) {
        boolean quoted = this.getDesign().getSettings().isUseQuotedIdentifiers();
        String fschema = null;
        String fname = obj.getFormatedName(this, quoted);
        ModelIDObject sch_impl = null;
        if (obj instanceof TableProxy) {
            sch_impl = ((TableProxy)obj).getSchemaImplementingObject();
        } else if (obj instanceof TableViewProxy) {
            sch_impl = ((TableViewProxy)obj).getSchemaImplementingObject();
        } else if (obj instanceof IndexProxyOracle) {
            sch_impl = ((IndexProxyOracle)obj).getSchemaImplementingObject();
        } else if (obj instanceof OwnedObjectOracle) {
            OwnedObjectOracle ob_ora = (OwnedObjectOracle)((Object)obj);
            StorageObject user = ob_ora.getUser();
            if (user != null) {
                fschema = user.getFormatedName(this, quoted);
            } else if (obj instanceof RelationalObjectProxy) {
                SchemaObject sch;
                DesignObject dobj = ((RelationalObjectProxy)obj).getObject();
                if (dobj != null && dobj instanceof ContainerObject && (sch = ((ContainerObject)dobj).getSchemaObject()) != null) {
                    user = this.getUserSchemaSet().getBySchemaObject(sch);
                    if (user != null) {
                        fschema = user.getFormatedName(this, quoted);
                    } else if (!this.isOpen()) {
                        fschema = sch.getFormatedName(this, quoted);
                    }
                }
            } else if (ob_ora.getSchemaObject() != null) {
                user = this.getUserSchemaSet().getBySchemaObject(ob_ora.getSchemaObject());
                if (user != null) {
                    fschema = user.getFormatedName(this, quoted);
                } else if (!this.isOpen()) {
                    fschema = ob_ora.getSchemaObject().getFormatedName(this, quoted);
                }
            }
        } else if (obj instanceof ContainerObject) {
            ContainerObject co = (ContainerObject)obj;
            if (co.getSchemaObject() != null) {
                fschema = this.getFormatedName(co.getSchemaObject());
            }
        } else {
            int ind;
            String name = obj.getName();
            String lname = obj.getLongName();
            if (lname.length() > name.length() && (ind = lname.lastIndexOf(name)) > 0) {
                String schema = lname.substring(0, ind - 1);
                fschema = this.getFormatedSimpleName(schema);
            }
        }
        if (sch_impl != null) {
            fschema = sch_impl.getFormatedName(this, quoted);
        }
        if (fschema == null) {
            return fname;
        }
        return fschema + "." + fname;
    }

    public String getFormatedSimpleName(String name) {
        boolean quoted = this.getDesign().getSettings().isUseQuotedIdentifiers();
        if (quoted || !this.isValidName(name)) {
            return "\"" + name + "\"";
        }
        return name;
    }

    public String getFormatedNameNoUseQIflag(ModelIDObject obj) {
        String name = obj.getName();
        if (obj.getNameHasQuotes() || !this.isValidName(name)) {
            return "\"" + name + "\"";
        }
        return name;
    }

    public String getFormatedNamesFromIDs(String idList, ElementSet elementSet) {
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(idList, ",");
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken().trim();
            ModelIDObject modelObject = elementSet.getObjectByID(id);
            if (modelObject == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(this.getFormatedName(modelObject));
        }
        return result.toString();
    }

    public String getFormatedNamesNoLogFromIDs(String idList, ElementSet elementSet) {
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(idList, ",");
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken().trim();
            ModelIDObject modelObject = elementSet.getObjectByID(id);
            if (modelObject == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(this.getFormatedName(modelObject)).append(" NO LOG");
        }
        return result.toString();
    }

    public boolean isNameShouildBeQuoted(ModelIDObject obj) {
        String name = obj.getName();
        return obj.getNameHasQuotes() || !this.isValidName(name);
    }

    public static boolean hasForbiddenCharsOracle(String name) {
        return name.indexOf(32) > -1 || name.indexOf(46) > -1 || name.indexOf(38) > -1 || name.indexOf(33) > -1 || name.indexOf(126) > -1 || name.indexOf(37) > -1 || name.indexOf(94) > -1 || name.indexOf(40) > -1 || name.indexOf(41) > -1 || name.indexOf(45) > -1 || name.indexOf(123) > -1 || name.indexOf(125) > -1 || name.indexOf(92) > -1 || name.indexOf(47) > -1 || name.indexOf(124) > -1 || name.indexOf(58) > -1 || name.indexOf(59) > -1 || name.indexOf(42) > -1 || name.indexOf(63) > -1 || name.indexOf(62) > -1 || name.indexOf(60) > -1 || name.indexOf(44) > -1 || name.indexOf(39) > -1 || name.indexOf(34) > -1 || name.indexOf(63) > -1 || name.indexOf(43) > -1 || name.indexOf(96) > -1;
    }

    public boolean startsWithNumber(String name) {
        String[] NUMBERS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        for (int i = 0; i < NUMBERS.length; ++i) {
            if (!name.startsWith(NUMBERS[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidName(String name) {
        return !StorageDesign.hasForbiddenCharsOracle(name) && !this.startsWithNumber(name);
    }

    public DDLAdvancedGenerator createDDLAdvancedGenerator() {
        return null;
    }

    public Map getNameSubstituionTypes() {
        if (this.substitutionMap.isEmpty()) {
            this.substitutionMap.put("Table", new ObjectType("Table"));
        }
        return this.substitutionMap;
    }

    public List getNameSubstitutionTypesList() {
        if (this.substitutionList == null) {
            this.substitutionList = Arrays.asList(this.getNameSubstituionTypes().values().toArray());
        }
        return this.substitutionList;
    }

    public boolean isNameSubstitutionTypeSelected(String name) {
        ObjectType obj = (ObjectType)this.getNameSubstituionTypes().get(name);
        if (obj != null) {
            return obj.isSelected();
        }
        return false;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void importStorageObjectsFromDDL() {
    }

    public boolean importStorageObjectsOnly() {
        return this.storageObjectsOnly;
    }

    public void setImportStorageObjectsOnly(boolean storageObjectsOnly) {
        this.storageObjectsOnly = storageObjectsOnly;
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public List getTypeOrder() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("TSpace");
        list.add("TmpTSpace");
        list.add("UTSpace");
        list.add("DB");
        list.add("DataFile");
        list.add("RLGrp");
        list.add("Segment");
        list.add("User");
        list.add("QuotaItem");
        list.add("Cluster");
        list.add("Snapshot");
        list.add("MVLog");
        list.add("PartList");
        list.add("Partition");
        list.add("Level");
        list.add("Hierarchy");
        list.add("DimenAttr");
        list.add("Dimension");
        list.add("SType");
        list.add("TypeElement");
        list.add("Method");
        list.add(MethodParam.TYPE_NAME);
        list.add("CollectionType");
        list.add("Table");
        list.add("Column");
        list.add("Index");
        return list;
    }

    public List getOrderedTypes(List types) {
        ArrayList temp = new ArrayList(types);
        List order = this.getTypeOrder();
        if (order.size() == 0) {
            return types;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String type : order) {
            String inp_type = null;
            for (int i = 0; i < types.size(); ++i) {
                String str = (String)types.get(i);
                if (!str.equalsIgnoreCase(type)) continue;
                inp_type = str;
                temp.remove(str);
                break;
            }
            if (inp_type == null) continue;
            result.add(inp_type);
        }
        result.addAll(temp);
        return result;
    }

    public float getLoadedVersion() {
        return this.loadedVersion;
    }

    public void setLoadedVersion(float loadedVersion) {
        this.loadedVersion = loadedVersion;
    }

    public float getVersion() {
        return this.version;
    }

    public List getStorableObjects() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ElementSet objectSet : this.getStorableSetsList()) {
            list.addAll(Arrays.asList(objectSet.toArray()));
        }
        return list;
    }

    public abstract List getStorableSetsList();

    public abstract List getUniqueList();

    public abstract List getFKProxyList();

    public abstract List getPKProxyList();

    public boolean hasDirtyStorableObjects() {
        for (ModelIDObject dobj : this.getStorableObjects()) {
            if (!dobj.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void setAllStorableObjectsDirty(boolean dirty) {
        for (ModelIDObject dobj : this.getStorableObjects()) {
            dobj.setDirty(dirty);
        }
        for (ModelIDObject dobj : this.getFKProxyList()) {
            dobj.setDirty(dirty);
        }
    }

    public List getDirtyObjects() {
        ArrayList<ModelIDObject> list = new ArrayList<ModelIDObject>();
        for (ModelIDObject dobj : this.getStorableObjects()) {
            if (!dobj.isDirty()) continue;
            list.add(dobj);
        }
        return list;
    }

    public boolean isCloneOperation() {
        return this.cloneOperation;
    }

    public void setCloneOperation(boolean cloneOperation) {
        this.cloneOperation = cloneOperation;
    }

    public RDBMSSite getClonedSite() {
        return this.clonedSite;
    }

    public void setClonedSite(RDBMSSite clonedSite) {
        this.clonedSite = clonedSite;
    }

    public abstract List getRDBMSTypesForClone();

    public void cloneFromMemoryToAnotherSD_MD(StorageDesign compatibleSD, Map correspondenceMap, Map comparatorsMap, boolean checkMerge) {
        this.cloneFromMemoryToAnotherSD_MD(compatibleSD, correspondenceMap, comparatorsMap, checkMerge, null);
    }

    public void cloneFromMemoryToAnotherSD_MD(StorageDesign compatibleSD, Map correspondenceMap, boolean checkMerge, String schema) {
        this.cloneFromMemoryToAnotherSD_MD(compatibleSD, correspondenceMap, null, checkMerge, schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneFromMemoryToAnotherSD_MD(StorageDesign compatibleSD, Map correspondenceMap, Map comparatorsMap, boolean checkMerge, String schema) {
        List list = this.getRDBMSTypesForClone();
        StorageDesign targetSD = compatibleSD;
        StorageDesign sourceSD = this;
        if (list.contains(targetSD.getRDBMSType())) {
            try {
                TreeMap<String, String> reverse;
                StorageObject sch;
                boolean dirty = false;
                this.correspondenceMap = correspondenceMap;
                targetSD.correspondenceMap = correspondenceMap;
                String userName = schema;
                if (schema != null && (sch = this.getUserSchemaSet().getBySchemaObjectName(schema)) != null) {
                    userName = sch.getName();
                }
                targetSD.reverseMap = reverse = new TreeMap<String, String>();
                targetSD.setLoading(true);
                ArrayList<StorageObject> proxys = new ArrayList<StorageObject>();
                ArrayList<StorageObject> stobjects = new ArrayList<StorageObject>();
                ArrayList<StorageObject> atEndObjects = new ArrayList<StorageObject>();
                this.processMatchByNameSets(sourceSD, targetSD);
                for (StorageObject so : sourceSD.getStorableObjects()) {
                    if (!StorageDesign.shouldMerge(so, checkMerge) || !sourceSD.isOwnedBy(userName, so) && sourceSD.hasOwner(so)) continue;
                    if (so instanceof RelationalObjectProxy) {
                        String id;
                        ModelIDObject obj;
                        proxys.add(so);
                        if (correspondenceMap == null || (obj = (ModelIDObject)correspondenceMap.get(id = so.getObjectID())) == null) continue;
                        String newID = obj.getObjectID();
                        if (reverse == null) continue;
                        reverse.put(newID, id);
                        continue;
                    }
                    stobjects.add(so);
                    if (!(so instanceof UserOracle)) continue;
                    atEndObjects.add(so);
                }
                stobjects.addAll(proxys);
                stobjects.addAll(atEndObjects);
                for (StorageObject so : stobjects) {
                    if (correspondenceMap == null || !so.isTopLevelObject()) continue;
                    Object to = correspondenceMap.get(so.getObjectID());
                    StorageObject target = null;
                    if (to == null) continue;
                    if (to instanceof DesignObject) {
                        DesignObject dob = (DesignObject)to;
                        if (to instanceof Table) {
                            target = targetSD.getTableProxySet().getProxy(dob.getObjectID());
                        } else if (to instanceof TableView) {
                            target = targetSD.getTableViewProxySet().getProxy(dob.getObjectID());
                        }
                    } else {
                        target = (StorageObject)to;
                    }
                    if (target == null) continue;
                    target.clearMergableStructure(reverse);
                }
                String designName = targetSD.getDesign().getName();
                for (StorageObject so : stobjects) {
                    GetHelper gh = this.getOrCreateTargetObject(so, targetSD);
                    StorageObject target = gh.object;
                    if (target == null) continue;
                    if (target instanceof SegmentOracle && gh.exists) {
                        target.setDirty(true);
                    } else {
                        String id = target.getObjectID();
                        String segment = target.getDirectorySegmentName();
                        String createdTime = so.getCreatedTime();
                        String createdBy = so.getCreatedBy();
                        String t_createdBy = target.getCreatedBy();
                        Object doc = null;
                        if (doc != null) {
                            target.setOwnerDesignName(designName);
                            if (!id.equals(target.getObjectID())) {
                                target.setObjectID(id);
                            }
                            target.setDirectorySegmentName(segment, true);
                            if (!gh.exists) {
                                target.setCreatedTime(createdTime);
                                target.setCreatedBy(createdBy);
                            } else {
                                target.setCreatedBy(t_createdBy);
                            }
                            if (target instanceof SegmentOracle && !gh.exists) {
                                SegmentSetOracle set = (SegmentSetOracle)target.getObjectSet();
                                String name = set.createUniqueName(so.getName());
                                target.setName(name);
                            }
                            target.setDirty(true);
                        }
                    }
                    if (!target.isDirty()) continue;
                    dirty = true;
                }
                if (dirty) {
                    targetSD.setDirty(dirty);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error during in memory clone of physical model " + this.getName() + "/n", e);
            }
            finally {
                targetSD.setOwnerDesignName(targetSD.getDesign().getName());
                this.correspondenceMap = null;
                targetSD.setLoading(false);
                targetSD.correspondenceMap = null;
            }
        }
    }

    public Map getCorrespondenceMap() {
        return this.correspondenceMap;
    }

    private GetHelper getOrCreateTargetObject(StorageObject sourceObject, StorageDesign targetSD) {
        if (sourceObject instanceof RelationalObjectProxy) {
            StorageDesign.getHelper.object = this.getTargetProxy(sourceObject, targetSD);
            StorageDesign.getHelper.exists = StorageDesign.getHelper.object != null;
            return getHelper;
        }
        StorageObject target = this.getMatchedTargetObject(sourceObject, targetSD);
        if (target == null) {
            String type = sourceObject.getObjectTypeName();
            StorageObjectSet set = targetSD.getStorageObjectSetForType(type);
            if (set != null) {
                String id = sourceObject.getObjectID();
                target = (StorageObject)set.createElement(id);
                if (target != null && targetSD.getCorrespondenceMap() != null) {
                    targetSD.getCorrespondenceMap().put(id, target);
                }
                if (target != null && targetSD.getReverseMap() != null) {
                    targetSD.getReverseMap().put(target.getObjectID(), id);
                }
            }
            StorageDesign.getHelper.exists = false;
        } else {
            StorageDesign.getHelper.exists = true;
        }
        StorageDesign.getHelper.object = target;
        return getHelper;
    }

    private StorageObject getTargetProxy(StorageObject sourceObject, StorageDesign targetSD) {
        ModelIDObject obj;
        String id = sourceObject.getObjectID();
        String newID = null;
        StorageObject target = null;
        Map map = targetSD.getCorrespondenceMap();
        Map revmap = targetSD.getReverseMap();
        if (map != null && (obj = (ModelIDObject)map.get(id)) != null) {
            newID = obj.getObjectID();
            if (revmap != null) {
                revmap.put(newID, id);
            }
        }
        target = newID != null ? targetSD.getStorageObject(newID) : targetSD.getStorageObject(id);
        return target;
    }

    private void createReadRequestForTargetObject(StorageObject sourceObject, StorageDesign storageDesign) {
    }

    public Map getReverseMap() {
        return this.reverseMap;
    }

    public static boolean shouldMerge(ModelIDObject object, boolean checkMerge) {
        DesignObject obj;
        if (object instanceof RelationalObjectProxy && (obj = ((RelationalObjectProxy)object).getObject()).isCopyForIncrementalDDL()) {
            return false;
        }
        if (checkMerge) {
            boolean includeInCompare;
            boolean inclstorProp = true;
            boolean inclPhysProp = true;
            boolean bl = includeInCompare = object instanceof SegmentOracle ? inclstorProp : inclPhysProp;
            if (!includeInCompare) {
                return false;
            }
            if (object instanceof RelationalObjectProxy) {
                DesignObject obj2 = ((RelationalObjectProxy)object).getObject();
                if (obj2 instanceof TypeElement) {
                    StructuredType st = ((TypeElement)obj2).getStructuredType();
                    return st.shouldBeMerge() && obj2.shouldBeMerge();
                }
                if (obj2 instanceof Method) {
                    StructuredType st = ((Method)obj2).getStructuredType();
                    return st.shouldBeMerge() && obj2.shouldBeMerge();
                }
                if (obj2 instanceof MethodParam && ((MethodParam)obj2).getMethod() != null) {
                    StructuredType st = ((MethodParam)obj2).getMethod().getStructuredType();
                    return st.shouldBeMerge() && ((MethodParam)obj2).getMethod().shouldBeMerge();
                }
                return obj2.shouldBeMerge();
            }
            return object.shouldBeMerge();
        }
        return true;
    }

    @Override
    public String getShortObjectID() {
        String siteID = this.getRDBMSSite().getShortObjectID();
        if (this.isCloneOperation() && this.getClonedSite() != null) {
            siteID = this.getClonedSite().getShortObjectID();
        }
        return siteID;
    }

    @Override
    public String getStoragePath() {
        String relPath = this.getPhysicalDesign().getStoragePath();
        if (relPath != null && relPath.length() > 0) {
            try {
                String siteID = this.getRDBMSSite().getShortObjectID();
                if (this.isCloneOperation() && this.getClonedSite() != null) {
                    siteID = this.getClonedSite().getShortObjectID();
                }
                return new File(relPath, "phys/" + siteID).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String relPath = this.getPhysicalDesign().getStoragePath();
        if (relPath != null && relPath.length() > 0) {
            try {
                String siteID = this.getRDBMSSite().getShortObjectID();
                if (this.isCloneOperation() && this.getClonedSite() != null) {
                    siteID = this.getClonedSite().getShortObjectID();
                }
                return new File(relPath, "phys/" + siteID + "/" + siteID + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setObjectListChanged(boolean objectListChanged) {
        this.objectListChanged = objectListChanged;
    }

    public boolean isObjectListChanged() {
        return this.objectListChanged;
    }

    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
        }
        return this.f2tMap;
    }

    public void dumpObjectTypes() {
        for (Object next : this.getStorableSetsList()) {
            try {
                ModelObject objectSet;
                if (next instanceof StorageObjectSet) {
                    objectSet = (StorageObjectSet)next;
                    ModelIDObject modelIDObject = objectSet.createElement(null);
                    continue;
                }
                if (!(next instanceof RelationalObjectProxySet)) continue;
                objectSet = (RelationalObjectProxySet)next;
            }
            catch (Exception e) {
                Logger.error(e);
            }
        }
    }

    public void reloadAllProxies() {
        if (this.getTableProxySet() != null) {
            this.getTableProxySet().setDesign(this.getDesign());
        }
        if (this.getTableViewProxySet() != null) {
            this.getTableViewProxySet().setDesign(this.getDesign());
        }
        if (this.getColumnProxySet() != null) {
            this.getColumnProxySet().setDesign(this.getDesign());
        }
        if (this.getIndexProxySet() != null) {
            this.getIndexProxySet().setDesign(this.getDesign());
        }
        if (this.getStructuredTypeProxySet() != null) {
            this.getStructuredTypeProxySet().setDesign(this.getDesign());
        }
        if (this.getTypeElementProxySet() != null) {
            this.getTypeElementProxySet().setDesign(this.getDesign());
        }
        if (this.getMethodProxySet() != null) {
            this.getMethodProxySet().setDesign(this.getDesign());
        }
        if (this.getMethodParamProxySet() != null) {
            this.getMethodParamProxySet().setDesign(this.getDesign());
        }
        if (this.getCollectionTypeProxySet() != null) {
            this.getCollectionTypeProxySet().setDesign(this.getDesign());
        }
    }

    public boolean isTempModel() {
        return this.tempModel;
    }

    public void setTempModel(boolean tempModel) {
        this.tempModel = tempModel;
        if (this.getPhysicalDesign() != null) {
            this.getPhysicalDesign().getStorageDesignFactory().sdTempStatusChanged(this);
        }
    }

    public List<ModelIDObject> getNotMarkedGenerateObjects() {
        ArrayList<ModelIDObject> notMarkedGenerateObjects = new ArrayList<ModelIDObject>();
        for (ElementSet objectSet : this.createDDLSelectionSetsList()) {
            this.addNotMarkedGenerateObjects(objectSet, notMarkedGenerateObjects);
        }
        return notMarkedGenerateObjects;
    }

    public List<ModelIDObject> getMarkedGenerateObjects() {
        ArrayList<ModelIDObject> markedGenerateObjects = new ArrayList<ModelIDObject>();
        for (ElementSet objectSet : this.createDDLSelectionSetsList()) {
            this.addMarkedGenerateObjects(objectSet, markedGenerateObjects);
        }
        return markedGenerateObjects;
    }

    public List<ModelIDObject> getAllMarkedAndNotMarkedGenerateObjects() {
        ArrayList<ModelIDObject> markedGenerateObjects = new ArrayList<ModelIDObject>();
        for (ElementSet objectSet : this.createDDLSelectionSetsList()) {
            this.addAllMarkedAndNotMarkedGenerateObjects(objectSet, markedGenerateObjects);
        }
        return markedGenerateObjects;
    }

    public List<ElementSet> getDDLSelectionSetsList() {
        if (this.ddlSelectionSetsList == null) {
            this.ddlSelectionSetsList = this.createDDLSelectionSetsList();
        }
        return this.ddlSelectionSetsList;
    }

    protected List<ElementSet> createDDLSelectionSetsList() {
        return new ArrayList<ElementSet>();
    }

    private void addNotMarkedGenerateObjects(ElementSet objectSet, List<ModelIDObject> notMarkedGenerateObjects) {
        Iterator setIterator = objectSet.iterator();
        while (setIterator.hasNext()) {
            ModelIDObject designObject = (ModelIDObject)setIterator.next();
            if (designObject.isMarkedGenerate()) continue;
            notMarkedGenerateObjects.add(designObject);
        }
    }

    private void addMarkedGenerateObjects(ElementSet objectSet, List<ModelIDObject> markedGenerateObjects) {
        Iterator setIterator = objectSet.iterator();
        while (setIterator.hasNext()) {
            ModelIDObject designObject = (ModelIDObject)setIterator.next();
            if (!designObject.isMarkedGenerate()) continue;
            markedGenerateObjects.add(designObject);
        }
    }

    private void addAllMarkedAndNotMarkedGenerateObjects(ElementSet objectSet, List<ModelIDObject> markedGenerateObjects) {
        Iterator setIterator = objectSet.iterator();
        while (setIterator.hasNext()) {
            ModelIDObject designObject = (ModelIDObject)setIterator.next();
            markedGenerateObjects.add(designObject);
        }
    }

    public List getStructuredTypesOrderedByParent() {
        ArrayList<StructuredTypeProxy> list = new ArrayList<StructuredTypeProxy>();
        for (StructuredType st : this.getDesign().getDataTypesDesign().getStructuredTypesOrderedByParent()) {
            StructuredTypeProxy pr = (StructuredTypeProxy)this.getStructuredTypeProxySet().getObjectGeneratedBy(st);
            if (pr == null) continue;
            list.add(pr);
        }
        return list;
    }

    public TableProxy getTableProxyBySchemaAndName(String schema, String name) {
        Table table = this.getPhysicalDesign().getTableSet().getBySchemaAndName(schema, name);
        if (table != null) {
            return (TableProxy)this.getTableProxySet().getObjectGeneratedBy(table);
        }
        return null;
    }

    public StorageObjectSet getUserSchemaSet() {
        return null;
    }

    public String getSchemaImplementationNane(SchemaObject schema) {
        StorageObject so;
        if (schema != null && (so = this.getUserSchemaSet().getBySchemaObject(schema)) != null) {
            return so.getName();
        }
        return "";
    }

    public String getSiteName() {
        if (this.rdbmsSite != null) {
            return this.rdbmsSite.getName();
        }
        return "";
    }

    public void setSiteName(String name) {
    }

    public String getSiteID() {
        if (this.rdbmsSite != null) {
            return this.rdbmsSite.getObjectID();
        }
        return "";
    }

    public void setSiteID(String oid) {
    }

    public int getSiteType() {
        if (this.rdbmsSite != null) {
            return this.rdbmsSite.getType().getType();
        }
        return -1;
    }

    public void setSiteType(int type) {
    }

    public void openStorageDesign() {
        if (!this.isOpen()) {
            this.setOpen(true);
        }
    }

    public List getMatchByNameSets() {
        return Collections.EMPTY_LIST;
    }

    private void processMatchByNameSets(StorageDesign sourceSD, StorageDesign targetSD) {
        for (Object obj : sourceSD.getMatchByNameSets()) {
            if (!(obj instanceof StorageObjectSet)) continue;
            StorageObjectSet set = (StorageObjectSet)obj;
            for (StorageObject sourceObject : set) {
                StorageObjectSet tset;
                StorageObject target = this.getMatchedTargetObject(sourceObject, targetSD);
                if (target != null || (tset = targetSD.getStorageObjectSetForType(sourceObject.getObjectTypeName())) == null) continue;
                target = (StorageObject)tset.createElement(sourceObject.getObjectID());
            }
        }
    }

    private StorageObject getMatchedTargetObject(StorageObject sourceObject, StorageDesign targetSD) {
        StorageObjectSet set;
        ModelIDObject obj;
        StorageObject target = null;
        String id = sourceObject.getObjectID();
        String type = sourceObject.getObjectTypeName();
        String newID = null;
        Map map = targetSD.getCorrespondenceMap();
        Map revmap = targetSD.getReverseMap();
        boolean foundInMap = false;
        if (map != null && (obj = (ModelIDObject)map.get(id)) != null) {
            foundInMap = true;
            newID = obj.getObjectID();
            if (revmap != null) {
                revmap.put(newID, id);
            }
            id = newID;
        }
        if ((set = targetSD.getStorageObjectSetForType(type)) != null) {
            if (set instanceof SegmentSetOracle && sourceObject instanceof SegmentOracle) {
                target = ((SegmentSetOracle)set).getEqual((SegmentOracle)sourceObject);
                if (target != null) {
                    targetSD.getCorrespondenceMap().put(id, target);
                }
            } else {
                target = (StorageObject)set.getObjectByID(id);
                if (target != null) {
                    if (!foundInMap) {
                        map.put(id, target);
                    }
                } else if (sourceObject.isTopLevelObject()) {
                    String dataBaseName = null;
                    String name = sourceObject.getName();
                    if (name != null && name.length() > 0) {
                        if (dataBaseName != null) {
                            target = set.getByNameAndDatabase(name, dataBaseName);
                        } else {
                            target = (StorageObject)set.getByName(name);
                            if (target != null && !sourceObject.getLongName().equalsIgnoreCase(target.getLongName())) {
                                target = null;
                            }
                        }
                        if (target != null) {
                            targetSD.getCorrespondenceMap().put(id, target);
                        }
                    }
                }
            }
            if (target != null && revmap != null) {
                revmap.put(target.getObjectID(), id);
            }
        }
        return target;
    }

    @Override
    public void setOwnerDesignName(String designName) {
        super.setOwnerDesignName(designName);
        for (Object obj : this.getAllSetsList()) {
            if (!(obj instanceof ElementSet)) continue;
            ElementSet set = (ElementSet)obj;
            Iterator its = set.iterator();
            while (its.hasNext()) {
                Object mo = its.next();
                if (!(mo instanceof ModelIDObject)) continue;
                ((ModelIDObject)mo).setOwnerDesignName(designName);
            }
        }
    }

    public List getLastSearchResult() {
        if (this.lastSearchResult == null) {
            this.lastSearchResult = new ArrayList();
        }
        return this.lastSearchResult;
    }

    public String[] getFKDeleteRules() {
        return FKIndexAssociation.DELETE_RULES;
    }

    public String[] getFKDeleteRulesMandatory() {
        return FKIndexAssociation.DELETE_RULES_WITHOUT_NULL;
    }

    public String[] getFKDeleteRulesNonTransferable() {
        return FKIndexAssociation.DELETE_RULES_RESTRICT_CASCADE;
    }

    public String getValidFKRule(String fkRule) {
        if ("SET DEFAULT".equals(fkRule)) {
            return "NO ACTION";
        }
        return fkRule;
    }

    public void parse(List<ModelIDObject> objects) {
        Iterator<ModelIDObject> it = objects.iterator();
        while (it.hasNext()) {
            this.processDependencies(it.next(), Collections.EMPTY_LIST, null);
        }
    }

    public void processDependencies(ModelIDObject obj, List<SQLAnalyzer.PDescriptor> dependencies, List<StructuredTypeProxy> refList) {
        TableView view;
        if (obj instanceof TableViewProxy && (view = (TableView)((TableViewProxy)obj).getObject()) != null) {
            List<ModelIDObject> list = obj.getParsedDependOnList();
            list.clear();
            for (TableView refView : view.getViews()) {
                TableViewProxy refViewProxy = (TableViewProxy)this.getProxy(refView.getObjectID());
                if (refViewProxy == null) continue;
                list.add(refViewProxy);
            }
        }
    }

    public boolean isOwnedBy(String user, StorageObject sto) {
        if (user != null && !"".equals(user)) {
            if (sto instanceof OwnedObjectOracle) {
                SchemaObject so;
                UserOracle owner = ((OwnedObjectOracle)((Object)sto)).getUser();
                if (owner != null && user.equalsIgnoreCase(owner.getName())) {
                    return true;
                }
                if (owner == null && (so = sto.getSchemaObject()) != null && user.equalsIgnoreCase(so.getName())) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean hasOwner(StorageObject sto) {
        if (sto instanceof OwnedObjectOracle) {
            UserOracle owner = ((OwnedObjectOracle)((Object)sto)).getUser();
            if (owner != null) {
                return true;
            }
            SchemaObject so = sto.getSchemaObject();
            if (so != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        if (id == null) {
            return null;
        }
        Object result = this.getStorageObject(id);
        if (result == null) {
            ModelIDObject obj;
            String newID = null;
            Map map = this.getCorrespondenceMap();
            if (map != null && (obj = (ModelIDObject)map.get(id)) != null) {
                newID = obj.getObjectID();
                result = this.getStorageObject(newID);
            }
        }
        if (result != null) {
            return result;
        }
        result = super.translateIdToObject(propertyName, id);
        return result;
    }

    public boolean isInitialize() {
        return this.initialize;
    }

    @Override
    public boolean isDirty() {
        return this.isOpen() && super.isDirty();
    }

    public boolean isImporting() {
        return this.importing;
    }

    public void setImporting(boolean importing) {
        this.importing = importing;
    }

    public boolean isIncludeSchemaInDDL() {
        return this.includeSchemaInDDL;
    }

    public void setIncludeSchemaInDDL(boolean includeSchemaInDDL) {
        this.includeSchemaInDDL = includeSchemaInDDL;
    }

    public Map<String, XMLTransformationManager.ObjectHelper> getNotLoadedObjectHelpersMap() {
        return this.notLoadedObjectHelpersMap;
    }

    public void clearMarkGenerateForIndexes() {
        Iterator it = this.getPhysicalDesign().getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            Iterator itk = table.getKeySet().iterator();
            while (itk.hasNext()) {
                StorageObject so;
                KeyObject ko = (KeyObject)itk.next();
                if (ko.isPK() || ko.isUnique() || ko.isFK() || (so = this.getStorageObject(ko.getObjectID())) == null) continue;
                so.setMarkedGenerate(false);
            }
        }
    }

    public void clearMarkGenerateForConstraintsAndIndexes() {
        Iterator it = this.getPhysicalDesign().getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            Iterator itk = table.getKeySet().iterator();
            while (itk.hasNext()) {
                KeyObject ko = (KeyObject)itk.next();
                ko.setMarkedGenerate(false);
                StorageObject so = this.getStorageObject(ko.getObjectID());
                if (so != null) {
                    so.setMarkedGenerate(false);
                }
                if (!ko.isFK()) continue;
                ko.getFKAssociation().setMarkedGenerate(false);
                so = this.getStorageObject(ko.getFKAssociation().getObjectID());
                if (so == null) continue;
                so.setMarkedGenerate(false);
            }
        }
        this.clearMarkGenerateForOthers();
    }

    public void clearMarkGenerateForOthers() {
    }

    public void clearMarkGenerateForTables() {
        Iterator it = this.getTableProxySet().iterator();
        while (it.hasNext()) {
            StorageObject mv = (StorageObject)it.next();
            mv.setMarkedGenerate(false);
        }
        this.clearMarkGenerateForConstraintsAndIndexes();
    }

    public String getSchemaImplementingName(ModelIDObject obj) {
        boolean quoted = this.getDesign().getSettings().isUseQuotedIdentifiers();
        ModelIDObject sch_impl = null;
        String schema = "";
        if (obj instanceof TableProxy) {
            sch_impl = ((TableProxy)obj).getSchemaImplementingObject();
        } else if (obj instanceof TableViewProxy) {
            sch_impl = ((TableViewProxy)obj).getSchemaImplementingObject();
        } else if (obj instanceof IndexProxyOracle) {
            sch_impl = ((IndexProxyOracle)obj).getSchemaImplementingObject();
        } else if (obj instanceof OwnedObjectOracle) {
            OwnedObjectOracle ob_ora = (OwnedObjectOracle)((Object)obj);
            StorageObject user = ob_ora.getUser();
            if (user != null) {
                schema = user.getName();
            } else if (obj instanceof RelationalObjectProxy) {
                SchemaObject sch;
                DesignObject dobj = ((RelationalObjectProxy)obj).getObject();
                if (dobj != null && dobj instanceof ContainerObject && (sch = ((ContainerObject)dobj).getSchemaObject()) != null) {
                    user = this.getUserSchemaSet().getBySchemaObject(sch);
                    if (user != null) {
                        schema = user.getName();
                    } else if (!this.isOpen()) {
                        schema = sch.getName();
                    }
                }
            } else if (ob_ora.getSchemaObject() != null) {
                user = this.getUserSchemaSet().getBySchemaObject(ob_ora.getSchemaObject());
                if (user != null) {
                    schema = user.getName();
                } else if (!this.isOpen()) {
                    schema = ob_ora.getSchemaObject().getName();
                }
            }
        } else if (obj instanceof ContainerObject) {
            ContainerObject co = (ContainerObject)obj;
            if (co.getSchemaObject() != null) {
                schema = co.getSchemaObject().getName();
            }
        } else {
            int ind;
            String name = obj.getName();
            String lname = obj.getLongName();
            if (lname.length() > name.length() && (ind = lname.lastIndexOf(name)) > 0) {
                schema = lname.substring(0, ind - 1);
                return schema;
            }
        }
        if (sch_impl != null) {
            return sch_impl.getName();
        }
        return schema;
    }

    public String getCachedSchemaImplementingName(ModelIDObject obj) {
        String schema = (String)this.cachedSchemaMap.get(obj);
        if (schema == null) {
            schema = this.getSchemaImplementingName(obj);
            this.cachedSchemaMap.put(obj, schema);
        }
        return schema;
    }

    public void clearCachedSchemaMap() {
        this.cachedSchemaMap.clear();
    }

    static class GetHelper {
        StorageObject object;
        boolean exists = true;

        GetHelper() {
        }
    }

    public class ObjectType {
        private boolean isSelected = false;
        private String typeName = "";

        public ObjectType(String name) {
            this.typeName = name;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String toString() {
            return this.typeName;
        }
    }

    public static class NullStorageDesign
    extends StorageDesign {
        private String label;
        private List msg;

        NullStorageDesign(RelationalDesign physicalDesign, String label, List msg, RDBMSSite site, Design design) {
            super(physicalDesign, site, design);
            this.label = label;
            this.msg = msg;
        }

        @Override
        public RDBMSType getRDBMSType() {
            return this.getRDBMSSite().getType();
        }

        public RDBMSSite getDefaultRDBMSSite() {
            return this.getRDBMSSite();
        }

        @Override
        public PropertyHolder getPropertyHolder() {
            return null;
        }

        @Override
        public void objectAdded(DesignPart designPart, DesignObject object) {
        }

        @Override
        public void objectRemoved(DesignPart designPart, DesignObject object) {
        }

        public void addPhysicalObject(DesignObject object) {
        }

        public void removePhysicalObject(DesignObject object) {
        }

        public void removePhysicalObject(String objectID) {
        }

        @Override
        public TableProxySet getTableProxySet() {
            return null;
        }

        @Override
        public IndexProxySet getIndexProxySet() {
            return null;
        }

        @Override
        public ColumnProxySet getColumnProxySet() {
            return null;
        }

        @Override
        public TableViewProxySet getTableViewProxySet() {
            return null;
        }

        @Override
        public StructuredTypeProxySet getStructuredTypeProxySet() {
            return null;
        }

        @Override
        public CollectionTypeProxySet getCollectionTypeProxySet() {
            return null;
        }

        @Override
        public MethodProxySet getMethodProxySet() {
            return null;
        }

        @Override
        public TypeElementProxySet getTypeElementProxySet() {
            return null;
        }

        @Override
        public MethodParamProxySet getMethodParamProxySet() {
            return null;
        }

        @Override
        public StorageObjectSet getStorageObjectSetForType(String objectType) {
            return null;
        }

        @Override
        public Collection getAllTopLevelObjects() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public String getIDPrefix() {
            return "NULLSTODES";
        }

        @Override
        public String getObjectID() {
            return this.getIDPrefix();
        }

        @Override
        public boolean isNullInstance() {
            return true;
        }

        public List getMessage() {
            return this.msg;
        }

        @Override
        public String getName() {
            return this.label;
        }

        @Override
        public MDDataTypeFactory createDataTypeFactory() {
            return null;
        }

        @Override
        public String getFormatedName(String name) {
            return name;
        }

        @Override
        public List getStorableSetsList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getUniqueList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getFKProxyList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getPKProxyList() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List getRDBMSTypesForClone() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public void sortCollections() {
        }

        public TableProxySet getSubViewTableProxySet() {
            return null;
        }

        public TableViewProxySet getSubViewTableViewProxySet() {
            return null;
        }

        @Override
        public List getListOfDDLObjects() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public TableSpaceSetOracle getTableSpaceSet() {
            return null;
        }
    }
}

