/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.OptimizerHint;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.ColumnViewSet;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.relational.ViewIndexSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.util.Service;

public class TableView
extends AbstractView
implements EditableFonts,
StatementsConstants {
    private String oidText;
    private List editableFonts = new ArrayList();
    private boolean readOnlyView = false;
    private boolean checkOption = false;
    private boolean force = false;
    private boolean createOnly = false;
    private static String saveClearCRInput = "";
    private static String saveClearCROutput = "";
    private static final String systemLineSeparator = System.getProperty("line.separator");
    static final int INITIAL = 0;
    static final int INSINGLELINECOMMENT = 1;
    static final int INMULTILINECOMMENT = 2;
    static final int INALIAS = 3;
    static final int INSINGLEQUOTE = 4;
    static final int INQUOTEDQUOTE = 5;
    private static String[][] m_startAndEnd = new String[][]{{"", "", "0"}, {"--", "\n", "1"}, {"/*", "*/", "2"}, {"\"", "\"", "3"}, {"'", "'", "4"}, {"q'", "'", "5"}};

    public TableView(DesignPart designPart) {
        super(designPart);
    }

    public String getOidText() {
        return this.oidText;
    }

    public void setOidText(String oidText) {
        this.oidText = oidText;
    }

    @Override
    public boolean hasValidHeader() {
        boolean result = false;
        Iterator it = this.getElementsCollection().iterator();
        if (it.hasNext()) {
            boolean allHaveHeaders = true;
            while (it.hasNext()) {
                ColumnView cv = (ColumnView)it.next();
                String ch = cv.getHeaderAlias();
                if (ch == null || ch.trim().length() == 0) {
                    allHaveHeaders = false;
                    continue;
                }
                if (ch.trim().equals(cv.getPresentationName(false))) continue;
                return true;
            }
            result = allHaveHeaders;
        }
        return result;
    }

    @Override
    public KeyObject createKeyObject(String id) {
        return this.createIndex(id);
    }

    public ContainedObject[] getColumns() {
        return this.getElements();
    }

    public ViewIndex createIndex() {
        ViewIndex key = this.createIndex(null);
        return key;
    }

    @Override
    public KeyObject[] getKeyArrayPrototype() {
        return Table.KEY_PROTOTYPE;
    }

    public ViewIndex createIndex(String id) {
        ViewIndex key = new ViewIndex(this.getDesignPart());
        key.setBackup(this.isBackup());
        key.setObjectID(id);
        this.add(key);
        return key;
    }

    public List getAllInds_FKeyInds() {
        ArrayList<ViewIndex> list = new ArrayList<ViewIndex>();
        ArrayList<ViewIndex> fk = new ArrayList<ViewIndex>();
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            ViewIndex index = (ViewIndex)it.next();
            if (index.isPK()) {
                list.add(0, index);
                continue;
            }
            if (index.isUnique()) {
                list.add(index);
                continue;
            }
            if (!index.isFK()) continue;
            fk.add(index);
        }
        list.addAll(fk);
        return list;
    }

    public ColumnView getColumnViewByName(String name) {
        for (ColumnView contained : this.getElementsCollection()) {
            if (!contained.getName().equalsIgnoreCase(name)) continue;
            return contained;
        }
        return null;
    }

    public ColumnView getColumnViewByLongName(String name) {
        for (ColumnView contained : this.getElementsCollection()) {
            if (!contained.getLongName().equalsIgnoreCase(name)) continue;
            return contained;
        }
        return null;
    }

    public ViewIndex getIndexByName(String indexName) {
        KeyObject[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            ViewIndex index = (ViewIndex)keys[i];
            if (!index.getName().equals(indexName)) continue;
            return index;
        }
        return null;
    }

    @Override
    protected KeyObjectSet createKeySet() {
        return new ViewIndexSet(this.getDesignPart(), this);
    }

    public ColumnViewSet getColumnViewSet() {
        return ((RelationalDesign)this.getDesignPart()).getColumnViewSet();
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getColumnViewSet();
    }

    @Override
    public void addToContainers(String objectID, String alias) {
        this.containerMap.put(alias, objectID);
        ContainerObject container = (ContainerObject)this.getTableSet().getObjectByID(objectID);
        if (container != null) {
            if (!this.tables.contains(container)) {
                this.tables.add(container);
            }
            this.usedContainers.add(new AbstractView.ContainerHolder(container, alias));
            container.addObjectListener(this);
            this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(objectID, alias));
        } else {
            TableView v = (TableView)((RelationalDesign)this.getDesignPart()).getTableViewSet().getObjectByID(objectID);
            if (v != null) {
                if (!this.views.contains(v)) {
                    this.views.add(v);
                }
                this.usedContainers.add(new AbstractView.ContainerHolder(v, alias));
                v.addObjectListener(this);
                this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(objectID, alias));
            } else {
                this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(objectID, alias));
            }
        }
    }

    @Override
    public void clearContainers() {
        this.containerMap.clear();
        this.tables.clear();
        this.views.clear();
        this.usedContainers.clear();
    }

    @Override
    public void addToContainers(ContainerObject container, String alias) {
        this.containerMap.put(alias, container.getObjectID());
        if (container instanceof Table) {
            if (!this.tables.contains(container)) {
                this.tables.add(container);
                this.usedContainers.add(new AbstractView.ContainerHolder(container, alias));
            }
        } else if (container instanceof TableView && !this.views.contains(container)) {
            this.views.add(container);
            this.usedContainers.add(new AbstractView.ContainerHolder(container, alias));
        }
        container.addObjectListener(this);
    }

    @Override
    public void clearElements(ContainerObject container) {
        block5: {
            block4: {
                if (!(container instanceof TableView)) break block4;
                ContainedObject[] cos = container.getElements();
                for (int i = 0; i < cos.length; ++i) {
                    if (!this.getElementsCollection().contains(cos[i])) continue;
                    this.remove(cos[i]);
                }
                break block5;
            }
            if (!(container instanceof Table)) break block5;
            ArrayList<ColumnView> forRemove = new ArrayList<ColumnView>();
            Iterator it = this.getElementsCollection().iterator();
            ContainedObject[] cos = container.getElements();
            block1: while (it.hasNext()) {
                ColumnView colView = (ColumnView)it.next();
                if (colView.getReferencedColumn() == null) continue;
                for (int i = 0; i < cos.length; ++i) {
                    if (colView.getReferencedColumn() != cos[i]) continue;
                    forRemove.add(colView);
                    continue block1;
                }
            }
            it = forRemove.iterator();
            while (it.hasNext()) {
                this.remove((ColumnView)it.next());
            }
        }
    }

    @Override
    public void clearOrderByElements(ContainerObject container) {
        block7: {
            block6: {
                if (!(container instanceof TableView)) break block6;
                ArrayList<ColumnView> forRemove = new ArrayList<ColumnView>();
                for (ColumnView col : container.getElementsCollection()) {
                    for (ColumnView column : this.orderByList) {
                        if (col.getReferencedColumn() != column.getReferencedColumn()) continue;
                        forRemove.add(column);
                    }
                }
                Iterator it = forRemove.iterator();
                while (it.hasNext()) {
                    this.removeFromOrderBy((ColumnView)it.next());
                }
                break block7;
            }
            if (!(container instanceof Table)) break block7;
            ArrayList<ColumnView> forRemove = new ArrayList<ColumnView>();
            block3: for (ColumnView colView : this.orderByList) {
                if (colView.getReferencedColumn() == null) continue;
                for (Column col : container.getElementsCollection()) {
                    if (colView.getReferencedColumn() != col) continue;
                    forRemove.add(colView);
                    continue block3;
                }
            }
            Iterator it = forRemove.iterator();
            while (it.hasNext()) {
                this.removeFromOrderBy((ColumnView)it.next());
            }
        }
    }

    @Override
    public void addToOrderBy(ContainedObject object, String sortOrder) {
        if (object.getObjectID() == null) {
            this.assignLocalID(object);
        }
        object.setContainer(this);
        this.getColumnViewSet().add(object);
        this.orderByMap.put(object.getObjectID(), sortOrder);
        this.orderByList.add(object);
        if (((AbstractViewElement)object).getReferencedColumn() != null) {
            ((AbstractViewElement)object).getReferencedColumn().addObjectListener(this);
        }
    }

    @Override
    public void updateElements(List telems) {
        for (int i = 0; i < telems.size(); ++i) {
            TypeElement te = (TypeElement)telems.get(i);
            ColumnView column = (ColumnView)this.getElementByStructAttributeID(te.getObjectID());
            if (column == null) {
                column = new ColumnView(this.getDesignPart());
                column.setName(te.getName());
                column.setNameHasQuotes(te.getNameHasQuotes());
                column.setStructAttributeID(te.getObjectID());
                column.setAlias(te.getName());
                this.addColumn(column);
            }
            this.copyTEtoColumn(te, column);
        }
    }

    private void copyTEtoColumn(TypeElement te, ColumnView column) {
        column.setName(te.getName());
        column.setNameHasQuotes(te.getNameHasQuotes());
        column.setDataType(te.getDataType(this.getDesignPart().getSelectedRDBMSSite().getName()));
        column.setReference(te.isReference());
        column.setTypeElement(te);
        if (te.getType() instanceof StructuredType) {
            column.setStructuredType((StructuredType)te.getType());
        } else {
            column.setStructuredType(null);
        }
    }

    public void addColumn(ColumnView column) {
        column.setDesign(this.getDesign());
        column.setContainer(this);
        this.add(column);
    }

    @Override
    public AbstractViewElement createViewElement(DesignPart designPart) {
        return new ColumnView(designPart);
    }

    @Override
    public DesignObjectSet getTableSet() {
        return ((RelationalDesign)this.getDesignPart()).getTableSet();
    }

    @Override
    public String getIDPrefix() {
        return MDPreferences.getDefaultInstance().get("tableview id prefix");
    }

    @Override
    public Class getContainedClass() {
        return ColumnView.class;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "view/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected boolean exposePhysicalProperties() {
        return true;
    }

    public String getUnderViewName() {
        ContainerObject parentView;
        TypeSubstitution typeSubstitution = this.getTypeSubstitution();
        if (typeSubstitution != null && (parentView = typeSubstitution.getParentContainerObject()) != null) {
            return parentView.getName();
        }
        return null;
    }

    public void setUnderViewName(String name) {
    }

    @Override
    public String getFCObjectType() {
        return "Relational View";
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    public DesignObjectCollection getUKeys() {
        return this.unSet;
    }

    public String getUserDefinedSQLAsDDL() {
        String sql = this.userDefinedSQL;
        if (!this.optimizerHints.isEmpty()) {
            String beforeSelect = Token.getStringBeforeToken(sql, "SELECT");
            String afterSelect = Token.getStringAfterToken(sql, "SELECT");
            if (!afterSelect.startsWith("/*+")) {
                for (int i = 0; i < this.optimizerHints.size(); ++i) {
                    OptimizerHint hint = (OptimizerHint)this.optimizerHints.get(i);
                    if (!hint.isOrderedHint()) continue;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(beforeSelect).append(" SELECT /*+ ");
                    buffer.append(hint.getHint()).append(" ");
                    buffer.append("*/ ").append(afterSelect);
                    sql = buffer.toString();
                    break;
                }
            }
        }
        if (!sql.toUpperCase().startsWith("CREATE ")) {
            sql = ((RelationalDesign)this.getDesignPart()).getStorageDesign() instanceof StorageDesignOracle ? "CREATE OR REPLACE VIEW " + this.getName() + "\nAS \n" + sql : "CREATE VIEW " + this.getName() + "\nAS \n" + sql;
        }
        return sql;
    }

    public List<String> getHeaderAliases() {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.isBST()) {
            ContainedObject[] elements = this.getElements();
            for (int i = 0; i < elements.length; ++i) {
                String headerAlias = ((AbstractViewElement)elements[i]).getPresentationName(true);
                result.add(headerAlias);
            }
        }
        return result;
    }

    public List<String> getUsedTablesAndViewsList() {
        String schema = this.getSchema();
        ArrayList<String> list = new ArrayList<String>();
        if (this.sqlNames != null) {
            for (SQLNameHelper helper : this.sqlNames) {
                if (!helper.isContainer()) continue;
                if (schema == null || schema.isEmpty()) {
                    String s = helper.getSchema();
                    if (s != null && !s.isEmpty()) {
                        list.add(s + "." + helper.getTableName());
                        continue;
                    }
                    list.add(helper.getTableName());
                    continue;
                }
                list.add(helper.getTableName());
            }
        }
        return list;
    }

    public boolean isReadOnlyView() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof TableViewProxyOracle) {
            return "YES".equalsIgnoreCase(((TableViewProxyOracle)pr).getViewReadOnly());
        }
        return this.readOnlyView;
    }

    public void setReadOnlyView(boolean readOnly) {
        this.readOnlyView = readOnly;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof TableViewProxyOracle) {
            ((TableViewProxyOracle)pr).setViewReadOnly(readOnly ? "YES" : "NO");
        }
    }

    public boolean isCheckOption() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof TableViewProxyOracle) {
            return ((TableViewProxyOracle)pr).getCheckOption();
        }
        return this.checkOption;
    }

    public void setCheckOption(boolean checkOption) {
        this.checkOption = checkOption;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof TableViewProxyOracle) {
            ((TableViewProxyOracle)pr).setCheckOption(checkOption);
        }
    }

    public boolean isForce() {
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof TableViewProxyOracle) {
            return "YES".equalsIgnoreCase(((TableViewProxyOracle)pr).getForce());
        }
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
        RelationalObjectProxy pr = (RelationalObjectProxy)this.getProxyObject();
        if (pr != null && pr instanceof TableViewProxyOracle) {
            ((TableViewProxyOracle)pr).setForce(force ? "YES" : "NO");
        }
    }

    @Override
    public String getQueryString() {
        if (this.userDefinedSQL != null) {
            return TableView.getQuery(this.userDefinedSQL);
        }
        return "";
    }

    public static String getQuery(String sql) {
        String vdef_up = sql.toUpperCase();
        int indw = vdef_up.indexOf("WITH READ ONLY");
        if (indw > -1) {
            sql = sql.substring(0, indw);
        } else {
            indw = vdef_up.indexOf("WITH CHECK OPTION");
            if (indw > -1) {
                sql = sql.substring(0, indw);
            }
        }
        sql = TableView.getSQL(sql);
        return sql;
    }

    public static String getSQL(String sqlIn) {
        String sql = sqlIn;
        String sqlu = sql.toUpperCase();
        if (sqlu.indexOf("CREATE") > -1) {
            int ind = sqlu.indexOf("SELECT");
            int ind2 = sqlu.indexOf("WITH");
            if (ind > 0) {
                if (ind2 > -1 && ind2 < ind) {
                    char ch = sqlu.charAt(ind2 - 1);
                    if (ch != ' ' && (ch < '\t' || ch > '\r')) {
                        ind2 = sqlu.indexOf("WITH", ind2 + 1);
                    }
                    sql = sql.substring(ind2);
                } else {
                    char ch = sqlu.charAt(ind - 1);
                    if (ch != ' ' && (ch < '\t' || ch > '\r')) {
                        ind = sqlu.indexOf("SELECT", ind + 1);
                    }
                    sql = sql.substring(ind);
                }
            }
        }
        return sql;
    }

    private static String removeClosingBrackets(String statement) {
        int ind = statement.toLowerCase().indexOf(" as ");
        String stb = "";
        String stmt = statement;
        if (ind > -1) {
            stb = statement.substring(0, ind + 4);
            stmt = statement.substring(ind + 4).trim();
            if (stmt.charAt(0) == '(') {
                stmt = Token.getValBetweenBrackets(stmt);
            }
            stmt = stb + stmt;
        }
        return stmt;
    }

    public static void initCols(TableView view, String statement) {
        String statementAs;
        String stmt;
        String cols;
        Design design = view.getDesign();
        ArrayList<String> columnList = null;
        String beforeSelect = Token.getStringBefore(statement = TableView.removeClosingBrackets(statement), "AS SELECT ");
        if (!Token.hasToken(beforeSelect, "OF") && Token.hasCloseAndOpenBrackets(beforeSelect) && !"".equalsIgnoreCase(cols = Token.getValBetweenBrackets(beforeSelect, 1))) {
            columnList = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(cols, ",");
            while (tokenizer.hasMoreTokens()) {
                String entry = tokenizer.nextToken().trim();
                String entryUC = entry.toUpperCase();
                if (entryUC.startsWith("CONSTRAINT ") || entryUC.startsWith("UNIQUE ") || entryUC.startsWith("PRIMARY ") || entryUC.startsWith("FOREIGN ") || entryUC.startsWith("CHECK ")) continue;
                columnList.add(Token.getFirstName(entry, '\"', '\"'));
            }
        }
        if ((stmt = Token.getStringAfter(statementAs = TableView.removeClosingBrackets(statement), "AS SELECT").trim()).equalsIgnoreCase("")) {
            stmt = Token.getStringAfter(statementAs, "SELECT").trim();
        }
        if (!stmt.equals("")) {
            String afterFrom = "";
            if (Token.hasToken(stmt, "FROM")) {
                int fromInd = stmt.toUpperCase().indexOf(" FROM ");
                String beforeFrom = stmt.substring(0, fromInd);
                afterFrom = stmt.substring(fromInd + 6);
                while (Token.tokenNumber(beforeFrom, "(") > Token.tokenNumber(beforeFrom, ")") && (fromInd = stmt.toUpperCase().indexOf(" FROM ", fromInd + 1)) > -1) {
                    beforeFrom = stmt.substring(0, fromInd);
                    afterFrom = stmt.substring(fromInd + 6);
                }
                stmt = beforeFrom;
            }
            if (Token.hasToken(afterFrom, "WHERE")) {
                afterFrom = Token.getStringBeforeToken(afterFrom, "WHERE");
            }
            String[] match = new String[]{"CONNECT", "START", "GROUP", "HAVING", "MODEL", "UNION", "INTERSECT", "MINUS", "ORDER"};
            afterFrom = Token.getStringToFirstMatch2(afterFrom, match);
            afterFrom = Token.replaceAll(Token.replaceAll(afterFrom, " INNER ", " "), " inner ", " ");
            afterFrom = Token.replaceAll(Token.replaceAll(afterFrom, " OUTER ", " "), " outer ", " ");
            afterFrom = Token.replaceAll(Token.replaceAll(afterFrom, " JOIN ", ","), " join ", ",");
            StringTokenizer fromTokenizer = new StringTokenizer(afterFrom, ",");
            while (fromTokenizer.hasMoreTokens()) {
                FKContainer tableOrView = null;
                String fromEntry = fromTokenizer.nextToken();
                String objectName = Token.getFirstName(fromEntry, '\"', '\"');
                String userName = "";
                int dotIndex = objectName.indexOf(46);
                if (dotIndex > -1) {
                    userName = objectName.substring(0, dotIndex);
                    userName = Token.removeQuotes(userName);
                    objectName = objectName.substring(dotIndex + 1);
                }
                objectName = Token.removeQuotes(objectName);
                if (!"".equals(userName) && (tableOrView = design.getRelationalDesign().getTableSet().getBySchemaAndName(userName, objectName)) == null) {
                    tableOrView = (TableView)design.getRelationalDesign().getTableViewSet().getBySchemaAndName(userName, objectName);
                }
                if (tableOrView == null && (tableOrView = (Table)design.getRelationalDesign().getTableSet().getByName(objectName)) == null) {
                    tableOrView = (TableView)design.getRelationalDesign().getTableViewSet().getByName(objectName);
                }
                if (tableOrView == null) continue;
                String aliasName = "";
                int objectNameIndex = fromEntry.indexOf(objectName);
                if (objectNameIndex > -1) {
                    String afterObject = fromEntry.substring(objectNameIndex + objectName.length());
                    if (afterObject.startsWith("\"")) {
                        afterObject = afterObject.substring(1);
                    }
                    aliasName = Token.getFirstName(afterObject, '\"', '\"');
                }
                if (aliasName.equals("")) {
                    aliasName = objectName;
                }
                view.addToContainers(tableOrView, aliasName);
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("ALL")) {
                stmt = Token.getStringAfterToken(stmt, "ALL").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("DISTINCT")) {
                stmt = Token.getStringAfterToken(stmt, "DISTINCT").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("UNIQUE")) {
                stmt = Token.getStringAfterToken(stmt, "UNIQUE").trim();
            }
            StringTokenizer tokenizer = new StringTokenizer(stmt, ",");
            String column = null;
            String columnAlias = null;
            int columnNumber = 0;
            while (tokenizer.hasMoreTokens()) {
                int dotIndex;
                column = tokenizer.nextToken().trim();
                columnAlias = null;
                StringBuffer oneColumnPast = new StringBuffer(column);
                while (tokenizer.hasMoreTokens() && Token.tokenNumber(column, "(") > Token.tokenNumber(column, ")")) {
                    oneColumnPast.append(",").append(tokenizer.nextToken().trim());
                    column = oneColumnPast.toString().trim();
                }
                boolean isExpression = false;
                if (!column.endsWith("*") && (Token.hasCloseAndOpenBrackets(column) || column.indexOf(43) > -1 || column.indexOf(45) > -1 || column.indexOf(42) > -1 || column.indexOf(47) > -1 || column.indexOf("||") > -1 || Token.hasToken(column, "PRIOR"))) {
                    isExpression = true;
                }
                if (Token.hasToken(column, "AS")) {
                    String tt = Token.getStringAfter(column, "AS");
                    columnAlias = Token.getNameAfterToken(column, "AS", '\"', '\"');
                    columnAlias = tt;
                    column = Token.getStringBeforeToken(column, "AS");
                    column = Token.encodeQuotedString(column);
                } else if (!((column = Token.encodeQuotedString(column)).indexOf(32) <= -1 || columnList != null && isExpression)) {
                    if (column.charAt(column.length() - 1) == '\"') {
                        columnAlias = column.substring(0, column.length() - 1);
                        int lastIndex = columnAlias.lastIndexOf(34);
                        columnAlias = columnAlias.substring(lastIndex) + "\"";
                        column = column.substring(0, lastIndex - 1);
                    } else {
                        String last = Token.getLastToken(column);
                        if (last.indexOf(41) == -1 && !last.equalsIgnoreCase("END")) {
                            columnAlias = last;
                            column = column.substring(0, column.lastIndexOf(last)).trim();
                        }
                    }
                }
                String columnQualifier = "";
                if (!isExpression && (dotIndex = column.lastIndexOf(46)) > -1) {
                    columnQualifier = column.substring(0, dotIndex);
                    int anotherDotIndex = columnQualifier.lastIndexOf(46);
                    if (anotherDotIndex > -1) {
                        columnQualifier = columnQualifier.substring(anotherDotIndex + 1);
                    }
                    columnQualifier = Token.removeQuotes(Token.decodeQuotedString(columnQualifier)).trim();
                    column = column.substring(dotIndex + 1);
                }
                if ((column = Token.removeQuotes(Token.decodeQuotedString(column))).equalsIgnoreCase("*")) {
                    for (AbstractView.ContainerHolder refContainerHolder : view.getUsedContainers()) {
                        String containerAlias = refContainerHolder.getAlias();
                        if (!columnQualifier.equals("") && !columnQualifier.equalsIgnoreCase(containerAlias)) continue;
                        ContainerObject containerObject = refContainerHolder.getContainer();
                        if (containerObject instanceof Table) {
                            for (Column tableColumn : containerObject.getElementsCollection()) {
                                ColumnView viewCol = new ColumnView(view.getDesignPart());
                                viewCol.setReferencedColumn(tableColumn);
                                viewCol.setName(tableColumn.getName());
                                viewCol.setNameHasQuotes(tableColumn.getNameHasQuotes());
                                viewCol.setDesign(design);
                                viewCol.setTable((Table)containerObject);
                                viewCol.setTableAlias(containerAlias);
                                viewCol.setDataType(tableColumn.getDataType().toString());
                                viewCol.setContainer(view);
                                view.add(viewCol);
                                ++columnNumber;
                            }
                            continue;
                        }
                        if (!(containerObject instanceof TableView)) continue;
                        ContainedObject[] refViewCols = ((TableView)containerObject).getColumns();
                        for (int i = 0; i < refViewCols.length; ++i) {
                            ColumnView refColumn = (ColumnView)refViewCols[i];
                            ColumnView viewCol = new ColumnView(view.getDesignPart());
                            viewCol.setReferencedColumnView(refColumn);
                            viewCol.setName(refColumn.getName());
                            viewCol.setNameHasQuotes(refColumn.getNameHasQuotes());
                            viewCol.setDesign(design);
                            viewCol.setView((TableView)containerObject);
                            viewCol.setTableAlias(containerAlias);
                            viewCol.setDataType(refColumn.getDataTypeString());
                            viewCol.setContainer(view);
                            view.add(viewCol);
                            ++columnNumber;
                        }
                    }
                    continue;
                }
                if (column.equalsIgnoreCase("")) continue;
                AbstractViewElement cvExp = view.createViewElement(view.getDesignPart());
                cvExp.setDesign(design);
                cvExp.setExpression(column);
                cvExp.setContainer(view);
                view.add(cvExp);
                if (!isExpression) {
                    for (AbstractView.ContainerHolder refContainerHolder : view.getUsedContainers()) {
                        ContainerObject container;
                        ContainedObject refObject;
                        String containerAlias = refContainerHolder.getAlias();
                        if (!columnQualifier.equals("") && !columnQualifier.equalsIgnoreCase(containerAlias) || (refObject = (container = refContainerHolder.getContainer()).getElementByName(column)) == null) continue;
                        if (refObject instanceof Column) {
                            cvExp.setReferencedColumn((Column)refObject);
                            cvExp.setTable((Table)container);
                            break;
                        }
                        if (!(refObject instanceof ColumnView)) break;
                        cvExp.setReferencedColumnView((FKElement)refObject);
                        cvExp.setView((TableView)container);
                        break;
                    }
                }
                if (columnList != null && columnNumber < columnList.size()) {
                    columnAlias = (String)columnList.get(columnNumber);
                }
                if (columnAlias != null) {
                    String tt = columnAlias;
                    columnAlias = Token.removeQuotes(Token.decodeQuotedString(columnAlias));
                    cvExp.setName(columnAlias);
                    cvExp.setAlias(columnAlias);
                    cvExp.setHeaderAlias(columnAlias);
                    if (!tt.equals(columnAlias)) {
                        cvExp.setNameHasQuotes(true);
                    }
                } else {
                    cvExp.setName(column);
                    cvExp.setAlias(column);
                    cvExp.setTableAlias(columnQualifier);
                }
                ++columnNumber;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Design design = new Design();
        String sql = Service.readFile((String)"D:/test_view.sql");
        sql = TableView.clearCR(sql);
        RelationalDesign rd = design.getRelationalDesign();
        TableView tv = rd.createTableView();
        TableView.initCols(tv, sql);
        for (DesignObject dob : tv.getElementsCollection()) {
            System.out.println(rd.getStorageDesign().getFormatedName(dob));
        }
    }

    @Override
    public boolean setName(String name) {
        return super.setName(name);
    }

    public static String clearCR(String line) {
        if (line != saveClearCRInput) {
            saveClearCRInput = line;
            int quoteIndex = (line = TableView.removeComments(line)).indexOf("'");
            if (quoteIndex > -1) {
                int startIndex = 0;
                StringBuffer buffer = new StringBuffer();
                while (quoteIndex > -1) {
                    String beforeLit = line.substring(startIndex, quoteIndex);
                    int endQuoteIndex = line.indexOf("'", quoteIndex + 1);
                    if (endQuoteIndex == -1 || beforeLit.endsWith("Q") || beforeLit.endsWith("q")) {
                        saveClearCROutput = line.replaceAll("[ \t\n\f\r\u000b]+", " ");
                        return saveClearCROutput;
                    }
                    buffer.append(beforeLit.replaceAll("[ \t\n\f\r\u000b]+", " "));
                    buffer.append(line.substring(quoteIndex, endQuoteIndex + 1));
                    startIndex = endQuoteIndex + 1;
                    quoteIndex = line.indexOf("'", startIndex);
                }
                buffer.append(line.substring(startIndex).replaceAll("[ \t\n\f\r\u000b]+", " "));
                saveClearCROutput = buffer.toString();
            } else {
                saveClearCROutput = line.replaceAll("[ \t\n\f\r\u000b]+", " ");
            }
        }
        return saveClearCROutput;
    }

    public static String removeComments(String currstmt) {
        currstmt = TableView.checkInLineComments(currstmt);
        int position = 0;
        int knownInitialStatePosition = 0;
        int nextPosition = currstmt.indexOf("/*", position);
        while (nextPosition > -1) {
            if (TableView.amIInitial(currstmt.substring(knownInitialStatePosition, nextPosition))) {
                knownInitialStatePosition = nextPosition;
                int nextPos = currstmt.indexOf("*/", nextPosition);
                if (nextPos == -1) {
                    currstmt = currstmt.substring(0, nextPosition);
                    nextPosition = -1;
                    continue;
                }
                currstmt = currstmt.substring(0, nextPosition) + " " + currstmt.substring(nextPos + 2);
                nextPosition = currstmt.indexOf("/*", nextPosition);
                continue;
            }
            ++nextPosition;
            nextPosition = currstmt.indexOf("/*", nextPosition);
        }
        return currstmt;
    }

    private static String checkInLineComments(String currstmt) {
        int position = 0;
        int knownInitialStatePosition = 0;
        int nextPosition = currstmt.indexOf("--", position);
        while (nextPosition > -1) {
            if (TableView.amIInitial(currstmt.substring(knownInitialStatePosition, nextPosition))) {
                knownInitialStatePosition = nextPosition;
                int nextPos = currstmt.indexOf("\n", nextPosition);
                if (nextPos == -1) {
                    currstmt = currstmt.substring(0, nextPosition);
                    nextPosition = -1;
                    continue;
                }
                currstmt = currstmt.substring(0, nextPosition) + systemLineSeparator + currstmt.substring(nextPos + 1);
                nextPosition = currstmt.indexOf("--", nextPosition);
                continue;
            }
            ++nextPosition;
            nextPosition = currstmt.indexOf("--", nextPosition);
        }
        return currstmt;
    }

    private static boolean amIInitial(String inString) {
        int state = 0;
        int position = 0;
        String quoteString = "";
        boolean[] needToCheckThisType = new boolean[m_startAndEnd.length];
        for (int i = 1; i < m_startAndEnd.length; ++i) {
            needToCheckThisType[i] = true;
        }
        boolean needToCheckUppercaseQ = true;
        while (true) {
            int newPos;
            if (state == 0) {
                int nextMatch;
                int lowestMatch = 100000;
                int matchVal = 0;
                int i = 1;
                for (i = 1; i < m_startAndEnd.length; ++i) {
                    if (!needToCheckThisType[i]) continue;
                    nextMatch = inString.indexOf(m_startAndEnd[i][0], position);
                    if (nextMatch == -1) {
                        needToCheckThisType[i] = false;
                        continue;
                    }
                    if (nextMatch >= lowestMatch || i == 5 && nextMatch + 2 == inString.length()) continue;
                    lowestMatch = nextMatch;
                    matchVal = i;
                }
                i = 5;
                if (needToCheckUppercaseQ) {
                    nextMatch = inString.indexOf("Q'", position);
                    if (nextMatch == -1) {
                        needToCheckUppercaseQ = false;
                    } else if (nextMatch < lowestMatch && (i != 5 || nextMatch + 2 != inString.length())) {
                        lowestMatch = nextMatch;
                        matchVal = i;
                    }
                }
                if (matchVal == 5) {
                    quoteString = inString.substring(lowestMatch + 2, lowestMatch + 3);
                    quoteString = TableView.getEndQuoteString(quoteString);
                }
                if (matchVal == 5) {
                    state = 5;
                    position = lowestMatch + 3;
                    continue;
                }
                if (matchVal == 4) {
                    state = 4;
                    position = lowestMatch + 1;
                    continue;
                }
                if (matchVal == 0) {
                    return state == 0;
                }
                state = matchVal;
                position = lowestMatch + m_startAndEnd[matchVal][0].length();
                continue;
            }
            String endString = m_startAndEnd[state][1];
            if (state == 5) {
                endString = quoteString + endString;
            }
            if ((newPos = inString.indexOf(endString, position)) == -1) {
                return state == 0;
            }
            position = newPos + endString.length();
            if (state == 4 || state == 5) {
                quoteString = "";
            }
            state = 0;
        }
    }

    public List getAllInds_PK_UK_NoFKeys() {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (key.isFK()) continue;
            list.add(key);
        }
        return list;
    }

    public FKIndexAssociation createFK() {
        FKIndexAssociation fk = this.getRelationalModel().createForeignKey();
        fk.setContainerWithKeyObject(this);
        return fk;
    }

    static String getEndQuoteString(String inQuote) {
        String retVal = inQuote;
        if (retVal.equals("[")) {
            retVal = "]";
        } else if (retVal.equals("{")) {
            retVal = "}";
        } else if (retVal.equals("<")) {
            retVal = ">";
        } else if (retVal.equals("(")) {
            retVal = ")";
        }
        return retVal;
    }

    public boolean isCreateOnly() {
        return this.createOnly;
    }

    public void setCreateOnly(boolean createOnly) {
        this.createOnly = createOnly;
    }
}

