/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.Map;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.FKArc;

public class FKArcComparator
extends PropertiesComparator {
    private FKArc sourceArc;
    private FKArc targetArc;
    private Map objectsMap;

    public FKArcComparator(FKArc sourced, FKArc target, Map objectsMap) {
        super(sourced, target);
        this.sourceArc = sourced;
        this.targetArc = target;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initDynamicProperties();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        PropertyHolder ph = new PropertyHolder(MANDATORY);
        ph.setLeftValue(this.sourceArc != null ? String.valueOf(this.sourceArc.isMandatory()) : "");
        ph.setRightValue(this.targetArc != null ? String.valueOf(this.targetArc.isMandatory()) : "");
        if (this.isExcludedFromComparison(MANDATORY)) {
            ph.setExcluded(true);
        } else if (this.targetArc != null && this.sourceArc != null && this.targetArc.isMandatory() != this.sourceArc.isMandatory()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        if (!DDL_ONLY) {
            ph = new PropertyHolder(FOREIGN_KEYS);
            ph.setLeftValue(this.sourceArc != null ? String.valueOf(this.sourceArc.getFkeys().size()) : "");
            ph.setRightValue(this.targetArc != null ? String.valueOf(this.targetArc.getFkeys().size()) : "");
            if (this.isExcludedFromComparison(FOREIGN_KEYS)) {
                ph.setExcluded(true);
            } else if (this.targetArc != null && this.sourceArc != null && !FKArc.isMatchingForeignKeys(this.sourceArc, this.targetArc, this.objectsMap)) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setRightValue(CHANGED);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder("Discriminator Column");
            ph.setLeftValue(this.sourceArc != null && this.sourceArc.getDiscriminatorColumn() != null ? this.sourceArc.getDiscriminatorColumn().getName() : "");
            ph.setRightValue(this.targetArc != null && this.targetArc.getDiscriminatorColumn() != null ? this.targetArc.getDiscriminatorColumn().getName() : "");
            if (this.isExcludedFromComparison("Discriminator Column")) {
                ph.setExcluded(true);
            } else if (this.targetArc != null && this.sourceArc != null && !FKArc.isMatchingDiscriminatorColumn(this.sourceArc, this.targetArc, this.objectsMap)) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromArc();
        this.copyPropertiesFromLeftToRight();
    }

    private void copyPropertiesFromArc() {
        if (this.targetArc != null && this.sourceArc != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(MANDATORY)) {
                    this.targetArc.setMandatory(this.sourceArc.isMandatory());
                    continue;
                }
                if (ph.getName().equals(FOREIGN_KEYS)) {
                    FKArc.synchronizeForeignKeys(this.sourceArc, this.targetArc, this.objectsMap, false);
                    continue;
                }
                if (!ph.getName().equals("Discriminator Column")) continue;
                FKArc.synchronizeDiscriminatorColumn(this.sourceArc, this.targetArc, this.objectsMap);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceArc != null ? this.sourceArc.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.targetArc != null ? this.targetArc.getLongName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceArc == null) {
            return true;
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceArc == null && this.targetArc != null) {
            return true;
        }
        return super.hasToBeDrop();
    }
}

