/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.crest.imports.domains.DomainPropertiesComparator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.datatype.DataTypeListener;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;

public class Domain
extends DesignObject
implements DataTypeListener,
ObjectListener,
ConstrainedObject {
    public static final ObjectChangeEvent CONSTRAINT_CHANGED = new ObjectChangeEvent(Messages.getString("Domain.ConstraintChanged"));
    public static final ObjectChangeEvent DATATYPE_CHANGED = new ObjectChangeEvent(Messages.getString("Domain.DatatypeChanged"));
    public static final ObjectChangeEvent LOGICALTYPE_CHANGED = new ObjectChangeEvent(Messages.getString("Domain.LogicalDatatypeChanged"));
    public static final ObjectChangeEvent DATATYPE_SIZEINFO_CHANGED = new ObjectChangeEvent(Messages.getString("Domain.DatatypeSizePrecisionScaleChanged"));
    public static final ObjectChangeEvent FILENAME_CHANGED = new ObjectChangeEvent(Messages.getString("Domain.DomainFilenameChanged"));
    public static final String TYPE_NAME = "Domain";
    public static final String DEFAULT_FILE = "defaultdomains";
    private String fileName;
    private LogicalDatatype logicalType;
    private Map parameters = new TreeMap();
    private Map dataTypes = new TreeMap();
    private CheckConstraint check;
    private ConstraintEnumeration valueList;
    private String defaultValue;
    private String unitOfMeasure;
    private Set avts;
    private int avtSortOrder = 0;
    private String synonym;
    private String dimension = "";
    private boolean readonly = false;
    private boolean persisted;
    private SensitiveType sensitiveType;
    private String sensitiveTypeDesc;

    public Domain(DesignPart designPart) {
        super(designPart);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.synonym = "";
        this.fileName = DEFAULT_FILE;
        this.logicalType = null;
        this.check = null;
        this.avts = new TreeSet();
        this.valueList = null;
        this.setComment("");
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public MDDataType getDataType() {
        return this.getDataType(this.getSelectedRDBMSType().toString());
    }

    public MDDataType getDataType(String rdbmsName) {
        if (!this.dataTypes.containsKey(rdbmsName)) {
            MDDataType type = ContainedObjectWithDomain.getDataTypeWithDefaults(this.getLogicalDatatype(), this.parameters, rdbmsName);
            this.dataTypes.put(rdbmsName, type);
        }
        if (this.dataTypes.get(rdbmsName) == null && this.getDesign() != null) {
            this.dataTypes.put(rdbmsName, this.getDesign().getDTFactoryInstance(rdbmsName).createStringEncodedType("UNKNOWN"));
        }
        return (MDDataType)this.dataTypes.get(rdbmsName);
    }

    public void setDataType(MDDataType physicalType) {
        this.setDataType(this.getSelectedRDBMSType().toString(), physicalType);
    }

    public void setDataType(String rdbmsName, MDDataType physicalType) {
        if (this.dataTypes.containsKey(rdbmsName)) {
            if (this.dataTypes.get(rdbmsName) == physicalType) {
                return;
            }
            ((MDDataType)this.dataTypes.get(rdbmsName)).removeDataTypeListener(this);
        }
        this.dataTypes.put(rdbmsName, physicalType);
        physicalType.addDataTypeListener(this);
        this.fireChange(DATATYPE_CHANGED);
    }

    public void setDataTypeParameter(String key, String value) {
        if (value == null || "".equals(value)) {
            this.parameters.remove(key);
            this.dataTypes.clear();
        } else {
            String old = (String)this.parameters.get(key);
            if (old == null || old != null && !old.equals(value)) {
                this.parameters.put(key, value);
                this.dataTypes.clear();
            }
        }
    }

    public String getDataTypeParameter(String key) {
        Object value = this.parameters.get(key);
        if (value == null) {
            value = "";
        }
        return (String)value;
    }

    public String getSize() {
        return this.getDataTypeParameter("size");
    }

    public String getPrecision() {
        return this.getDataTypeParameter("precision");
    }

    public String getScale() {
        return this.getDataTypeParameter("scale");
    }

    public Iterator getDataTypeParameterNames() {
        return this.parameters.keySet().iterator();
    }

    public void setLogicalDatatype(LogicalDatatype logicalType) {
        if (this.logicalType != logicalType) {
            this.dataTypes.clear();
            if (this.logicalType != null) {
                this.logicalType.removeObjectListener(this);
            }
            this.logicalType = logicalType;
            if (logicalType != null) {
                logicalType.addObjectListener(this);
                this.fireChange(LOGICALTYPE_CHANGED);
            }
        }
    }

    public LogicalDatatype getLogicalDatatype() {
        if (this.logicalType == null) {
            this.logicalType = this.getDesign().getLogicalDatatypeSet().getDefaultType();
        }
        return this.logicalType;
    }

    public LogicalDatatype[] getAvailableLogicalDatatypes() {
        return (LogicalDatatype[])this.getDesign().getLogicalDatatypeSet().toArray();
    }

    public String[] getRequiredParametersNames() {
        return this.getLogicalDatatype().getRequiredParameters();
    }

    public String getRequiredParametersRepresentation() {
        StringBuffer buffer = new StringBuffer();
        String[] array = this.getRequiredParametersNames();
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                buffer.append("; ");
            }
            buffer.append(array[i]);
        }
        return buffer.toString();
    }

    public String getUnits() {
        String size = this.getSize();
        String[] parts_n = size.split(" ");
        if (parts_n.length == 2) {
            return parts_n[1];
        }
        return "";
    }

    public void setFileName(String fileNameNoExtension) {
        if (!this.fileName.equals(fileNameNoExtension)) {
            this.fileName = fileNameNoExtension;
            if (DEFAULT_FILE.equals(fileNameNoExtension)) {
                this.setOwnerDesignName(Design.getSystemDesignName());
            }
            this.fireChange(FILENAME_CHANGED);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getOwnerDesignName() {
        if (DEFAULT_FILE.equals(this.getFileName())) {
            return Design.getSystemDesignName();
        }
        return super.getOwnerDesignName();
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
    }

    @Override
    public void changed(MDDataType type) {
        this.fireChange(DATATYPE_SIZEINFO_CHANGED);
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("domain id prefix");
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public int getNumberOfChildren() {
        return 0;
    }

    @Override
    public ModelObject getChild(int index) {
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Object getParent() {
        return this.getDesign().getDomainSet();
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String synonym) {
        if (!this.synonym.equals(synonym)) {
            this.synonym = synonym;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        if (dimension != null && dimension.equals(this.dimension)) {
            return;
        }
        this.dimension = dimension;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public void addAVT(AVT avt) {
        if (!this.avts.contains(avt)) {
            this.avts.add(avt);
        }
    }

    @Override
    public Set getAVTs() {
        LogicalDatatype logicalDatatype;
        if (this.avts.size() > 1 && (logicalDatatype = this.getLogicalDatatype()) != null && logicalDatatype.isNumeric()) {
            TreeSet sortedSet = new TreeSet(new AVTNumberComparator());
            sortedSet.addAll(this.avts);
            return sortedSet;
        }
        return this.avts;
    }

    @Override
    public void removeAVT(AVT avt) {
        if (this.avts.contains(avt)) {
            this.avts.remove(avt);
        }
    }

    @Override
    public void clearAVTs() {
        this.avts.clear();
    }

    public String getAVTString() {
        return "View";
    }

    @Override
    public ConstraintEnumeration getValueList() {
        return this.valueList;
    }

    @Override
    public void setValueList(ConstraintEnumeration valueList) {
        this.valueList = valueList;
    }

    public Iterator getValueIterator() {
        return this.getValues().iterator();
    }

    public Set getValues() {
        ConstraintEnumeration constraintEnumeration = this.getValueList();
        if (constraintEnumeration != null) {
            LogicalDatatype logicalDatatype;
            Set valueSet = constraintEnumeration.getValues();
            if (valueSet.size() > 1 && (logicalDatatype = this.getLogicalDatatype()) != null && logicalDatatype.isNumeric()) {
                TreeSet sortedSet = new TreeSet(new ValueComparator());
                sortedSet.addAll(valueSet);
                return sortedSet;
            }
            return valueSet;
        }
        return new TreeSet();
    }

    @Override
    public CheckConstraint getCheck() {
        return this.check;
    }

    @Override
    public void setCheck(CheckConstraint check) {
        if (this.check != check) {
            this.check = check;
            this.fireChange(CONSTRAINT_CHANGED);
        }
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public String getDefaultValue() {
        String result = this.defaultValue;
        if (result == null) {
            return "";
        }
        return this.defaultValue;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public String getUnitOfMeasure() {
        if (this.unitOfMeasure == null) {
            return "";
        }
        return this.unitOfMeasure;
    }

    public DesignObject getTempObject() {
        Domain newDomain = new Domain(this.getDesign().getLogicalDesign());
        newDomain.setRemoteObjectID(this.getRemoteObjectID());
        return newDomain;
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public void copy(DesignObject desObject, Map copyMap, boolean remoteObject) {
        if (remoteObject) {
            Domain domain = (Domain)desObject;
            domain.setName(this.getName());
            domain.setSynonym(this.getSynonym());
            domain.setLogicalDatatype(this.getLogicalDatatype());
            domain.setComment(this.getComment());
            domain.setDataTypeParameter("precision", this.getDataTypeParameter("precision"));
            domain.setDataTypeParameter("scale", this.getDataTypeParameter("scale"));
            domain.setDataTypeParameter("size", this.getDataTypeParameter("size"));
            DomainPropertiesComparator.copyCheckConstrant(this, domain);
            DomainPropertiesComparator.copyLOVConstrant(this, domain);
            DomainPropertiesComparator.copyRangeConstrant(this, domain);
            domain.setSensitiveType(this.getSensitiveType());
        } else {
            this.copyTo((Domain)desObject);
        }
    }

    public void copyTo(Domain domain) {
        domain.setName(this.getName());
        domain.setSynonym(this.getSynonym());
        domain.setLogicalDatatype(this.getLogicalDatatype());
        domain.setComment(this.getComment());
        domain.setFileName(this.getFileName());
        domain.setDataTypeParameter("precision", this.getDataTypeParameter("precision"));
        domain.setDataTypeParameter("scale", this.getDataTypeParameter("scale"));
        domain.setDataTypeParameter("size", this.getDataTypeParameter("size"));
        DomainPropertiesComparator.copyCheckConstrant(this, domain);
        DomainPropertiesComparator.copyLOVConstrant(this, domain);
        DomainPropertiesComparator.copyRangeConstrant(this, domain);
        domain.setSensitiveType(this.getSensitiveType());
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (dirty) {
            this.getChange().setTimeNow();
        }
        if (dirty) {
            this.getDesign().setDirty(dirty);
        }
    }

    public String getLogicalRepresentationName(boolean useLogicaltype) {
        String name = this.getName();
        if (useLogicaltype && this.getLogicalDatatype() != null) {
            name = this.getLogicalDatatype().getName();
            String size = this.getDataTypeParameter("size");
            if (size != null && !"".equals(size) && !"0".equals(size)) {
                return name + "(" + size + ")";
            }
            String precision = this.getDataTypeParameter("precision");
            if (precision != null && !"".equals(precision) && !"0".equals(precision)) {
                String scale = this.getDataTypeParameter("scale");
                if (scale != null && !"".equals(scale) && !"0".equals(scale)) {
                    return name + "(" + precision + "," + scale + ")";
                }
                return name + "(" + precision + ")";
            }
        }
        return name;
    }

    @Override
    public int getAVTSortOrder() {
        return this.avtSortOrder;
    }

    @Override
    public void setAVTSortOrder(int sortOrder) {
        this.avtSortOrder = sortOrder;
    }

    public boolean isDefault() {
        return DEFAULT_FILE.equalsIgnoreCase(this.fileName);
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public void setReadOnly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @Override
    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public void setDataTypeSize(String value) {
        this.setDataTypeParameter("size", value);
    }

    public String getDataTypeSize() {
        return this.getDataTypeParameter("size");
    }

    public void setDataTypePrecision(String value) {
        this.setDataTypeParameter("precision", value);
    }

    public String getDataTypePrecision() {
        return this.getDataTypeParameter("precision");
    }

    public void setDataTypeScale(String value) {
        this.setDataTypeParameter("scale", value);
    }

    public String getDataTypeScale() {
        return this.getDataTypeParameter("scale");
    }

    public ConstraintEnumeration createConstraintEnumeration() {
        ConstraintEnumeration ce = new ConstraintEnumeration();
        ce.setDesign(this.getDesign());
        return ce;
    }

    public CheckConstraint createCheckConstraint() {
        CheckConstraint cc = new CheckConstraint();
        cc.setDesign(this.getDesign());
        return cc;
    }

    public void clearCheckConstraint() {
        this.check = null;
    }

    public void clearValueList() {
        this.valueList = null;
    }

    public AVT createAVT() {
        return new AVT();
    }

    public List getAVTList() {
        ArrayList<AVT> list = new ArrayList<AVT>();
        for (AVT avt : this.getAVTs()) {
            list.add(avt);
        }
        return list;
    }

    public void applyAVTList(List avtList) {
        this.avts.clear();
        this.avts.addAll(avtList);
    }

    public static void clearEvents() {
        CONSTRAINT_CHANGED.setAffected(null);
        DATATYPE_CHANGED.setAffected(null);
        LOGICALTYPE_CHANGED.setAffected(null);
        DATATYPE_SIZEINFO_CHANGED.setAffected(null);
        FILENAME_CHANGED.setAffected(null);
    }

    public SensitiveType getSensitiveType() {
        return this.sensitiveType;
    }

    public void setSensitiveType(SensitiveType sensitiveType) {
        this.sensitiveType = sensitiveType;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        ModelIDObject object = null;
        object = this.getDesign().getDesignObject(id);
        if (object != null) {
            return object;
        }
        if ("sensitiveType".equalsIgnoreCase(propertyName)) {
            object = this.getDesign().getSensitiveTypeSet().getObjectByID(id);
        }
        if (object != null) {
            return object;
        }
        return super.translateIdToObject(propertyName, id);
    }

    public String getSensitiveTypeDescription() {
        return this.sensitiveTypeDesc;
    }

    public void setSensitiveTypeDescription(String sensitiveTypeDesc) {
        this.sensitiveTypeDesc = sensitiveTypeDesc;
    }

    public void clearDataTypesMap() {
        this.dataTypes.clear();
    }

    public Map getParametersMap() {
        return this.parameters;
    }

    @Override
    public String getStorageName() {
        try {
            if (this.getFileName().equalsIgnoreCase(DEFAULT_FILE)) {
                String domainsFile = new File(this.getDesign().getDefaultSystemTypesPath(), "/" + this.getFileName() + ".xml").getCanonicalPath();
                return domainsFile;
            }
            String domainsFile = new File(this.getDesign().getStoragePath(), "/domains/" + this.getFileName() + ".xml").getCanonicalPath();
            return domainsFile;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private class ValueComparator
    implements Comparator {
        private ValueComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                double d1 = Double.parseDouble((String)o1);
                double d2 = Double.parseDouble((String)o2);
                if (d1 > d2) {
                    return 1;
                }
                if (d1 < d2) {
                    return -1;
                }
                return 0;
            }
            catch (Exception e) {
                return ((String)o1).compareTo((String)o2);
            }
        }
    }

    private class AVTNumberComparator
    implements Comparator {
        private AVTNumberComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                double d1 = Double.parseDouble(((AVT)o1).getBeginValue());
                double d2 = Double.parseDouble(((AVT)o2).getBeginValue());
                if (d1 > d2) {
                    return 1;
                }
                if (d1 < d2) {
                    return -1;
                }
                return 0;
            }
            catch (Exception e) {
                return ((AVT)o1).getBeginValue().compareTo(((AVT)o2).getBeginValue());
            }
        }
    }
}

