/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.UpdatableStatus;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public abstract class AbstractDBMExtractionHandler {
    protected String dbProductName = "";
    protected String dbProductVersion = "";
    protected int dbMajorVersion = -1;
    protected int dbMinorVersion = -1;
    private List showList = null;
    private static boolean allSelected = false;
    private boolean schemaBased = true;
    protected Design design;
    private int offset = 0;
    private int limit = 0;
    private UpdatableStatus updatableStatus;
    private boolean parseQueriesAfterImport = true;
    long allProcessed = 0L;
    long allObjects = 0L;
    private static final Logger LOGGER = new Logger(AbstractDBMExtractionHandler.class);

    public AbstractDBMExtractionHandler(Design design) {
        this.design = design;
    }

    public abstract RDBMSSite getRDBMSSite();

    public abstract List getMOHObjects();

    public String getDBProductVersion() {
        return this.dbProductVersion;
    }

    public String getDBProductName() {
        return this.dbProductName;
    }

    public int getDBMajorVersion() {
        return this.dbMajorVersion;
    }

    public static boolean isAllSelected() {
        return allSelected;
    }

    public static void setAllSelected(boolean allSel) {
        allSelected = allSel;
    }

    public boolean isSchemaBased() {
        return this.schemaBased;
    }

    public void setSchemaBased(boolean schemaBase) {
        this.schemaBased = schemaBase;
    }

    protected void dumpResultSet(ResultSet rs) {
        try {
            while (rs.next()) {
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                }
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSchemas(Connection conn) throws Exception {
        ArrayList<DBObject> list;
        block27: {
            list = new ArrayList<DBObject>();
            if (conn == null) break block27;
            boolean mvSet = false;
            DatabaseMetaData dbmd = conn.getMetaData();
            try {
                block26: {
                    block28: {
                        ResultSet rs;
                        Statement st;
                        block25: {
                            this.dbProductName = dbmd.getDatabaseProductName();
                            if (this.dbProductName.toUpperCase().indexOf("ORACLE") <= -1) break block28;
                            st = conn.createStatement();
                            rs = null;
                            try {
                                rs = st.executeQuery("select product, version from product_component_version where product like 'Oracle%'");
                                if (rs == null) break block25;
                                if (rs.next()) {
                                    this.dbProductVersion = rs.getString(1);
                                    String mv = rs.getString(2);
                                    if (mv != null && mv.length() > 0) {
                                        try {
                                            String kv = mv.substring(0, mv.indexOf("."));
                                            this.dbMajorVersion = Integer.parseInt(kv);
                                            if (this.dbMajorVersion == 12 && (kv = mv.substring(mv.indexOf(".") + 1)).startsWith("2")) {
                                                this.dbMinorVersion = 2;
                                            }
                                            mvSet = true;
                                        }
                                        catch (Exception kv) {
                                            // empty catch block
                                        }
                                    }
                                }
                                rs.close();
                            }
                            catch (Exception e) {
                                try {
                                    this.dbProductVersion = dbmd.getDatabaseProductVersion();
                                }
                                catch (Throwable throwable) {
                                    Closeables.close((Object[])new AutoCloseable[]{rs, st});
                                    throw throwable;
                                }
                                Closeables.close((Object[])new AutoCloseable[]{rs, st});
                                break block26;
                            }
                        }
                        Closeables.close((Object[])new AutoCloseable[]{rs, st});
                        break block26;
                    }
                    this.dbProductVersion = dbmd.getDatabaseProductVersion();
                }
                if (!mvSet) {
                    this.dbMajorVersion = dbmd.getDatabaseMajorVersion();
                }
            }
            catch (Throwable e) {
                Logger.error(e);
            }
            try (ResultSet resultSet = dbmd.getSchemas();){
                while (resultSet.next()) {
                    String schema = resultSet.getString(1);
                    DBObject dbo = new DBObject(false, schema);
                    list.add(dbo);
                }
                resultSet.close();
            }
        }
        return list;
    }

    public static int getOracleVersionInt(Connection conn) {
        int ver = 11;
        String version = AbstractDBMExtractionHandler.getOracleVersion(conn);
        if (version.startsWith("12")) {
            ver = 12;
            if (version.startsWith("12.2")) {
                ver = 13;
            }
        } else {
            try {
                int tv = Integer.valueOf(version.substring(0, 2));
                if (tv > 12) {
                    ver = tv;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getOracleVersion(Connection conn) {
        int dbMajorVersion = -1;
        int dbMinorVersion = -1;
        String res = "";
        if (conn == null) return res;
        boolean mvSet = false;
        try {
            Statement st = conn.createStatement();
            ResultSet rs = null;
            try {
                rs = st.executeQuery("select product, version from product_component_version where product like 'Oracle%'");
                if (rs != null) {
                    String mv;
                    if (rs.next() && (mv = rs.getString(2)) != null && mv.length() > 0) {
                        String string = mv;
                        return string;
                    }
                    rs.close();
                }
            }
            catch (Exception mv) {
            }
            finally {
                Closeables.close((Object)rs);
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (mvSet) return res;
            DatabaseMetaData dbmd = conn.getMetaData();
            dbMajorVersion = dbmd.getDatabaseMajorVersion();
            dbMinorVersion = dbmd.getDatabaseMinorVersion();
            return dbMajorVersion + "." + dbMinorVersion;
        }
        catch (Throwable e) {
            Logger.error(e);
        }
        return res;
    }

    public List getDBObjects(Connection conn, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        List mhoList = this.getMOHObjects();
        if (mhoList.size() > 0 && conn != null) {
            for (AbstractMOHandler moHandler : mhoList) {
                if (!moHandler.showObjects()) continue;
                moHandler.reset();
                List extracted = moHandler.extract(conn, schemas);
                for (Object obj : extracted) {
                    if (!(obj instanceof DBObject)) continue;
                    list.add((DBObject)obj);
                }
            }
        }
        return list;
    }

    public List getDBObjects(Connection conn, List schemas, String type) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        List mhoList = this.getMOHObjects();
        if (mhoList.size() > 0 && conn != null) {
            for (AbstractMOHandler moHandler : mhoList) {
                if (!type.equalsIgnoreCase(moHandler.getType())) continue;
                moHandler.reset();
                List extracted = moHandler.extract(conn, schemas);
                for (Object obj : extracted) {
                    if (!(obj instanceof DBObject)) continue;
                    ((DBObject)obj).setSelected(true);
                    list.add((DBObject)obj);
                }
            }
        }
        return list;
    }

    protected boolean isNullStorageDesign(StorageDesign sd) {
        if (sd instanceof StorageDesign.NullStorageDesign) {
            StorageDesign.NullStorageDesign nsd = (StorageDesign.NullStorageDesign)sd;
            LOGGER.error(nsd.getName());
            Iterator it = nsd.getMessage().iterator();
            while (it.hasNext()) {
                LOGGER.error((String)it.next());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateDesign(Connection conn, List selectedObjects, ImportLogger importLog) throws Exception {
        List mhoList = this.getMOHObjects();
        if (selectedObjects.size() <= 0) return;
        if (mhoList.size() <= 0) return;
        if (conn == null) return;
        UpdatableStatus upst = this.getUpdatableStatus();
        try {
            int counter = 0;
            double step = 10.0;
            int size = mhoList.size();
            long allProcessed = 0L;
            long allObjects = selectedObjects.size();
            for (AbstractMOHandler moHandler : mhoList) {
                moHandler.preGenerateProcessing(conn, selectedObjects);
            }
            Iterator it = mhoList.iterator();
            while (it.hasNext()) {
                AbstractMOHandler moHandler;
                this.setAllProcessed(allProcessed);
                this.setAllObjects(allObjects);
                moHandler = (AbstractMOHandler)it.next();
                int prcount = moHandler.getCountOfObjectsToProcess(selectedObjects);
                if (upst != null && prcount > 0 && upst.isCancelled()) {
                    return;
                }
                moHandler.setSupportInformation_Schema(true);
                moHandler.generate(conn, selectedObjects, importLog);
                int hobjects = moHandler.getHandledObjects().size();
                prcount = Math.max(prcount, hobjects);
                moHandler.clearHandledObjects(selectedObjects);
                ++counter;
                step += 75.0 / (double)size;
                if (upst == null || prcount <= 0) continue;
                int count = moHandler.getCountOfProcessedObjedcts();
                int cc = count - prcount;
                if (cc > 0) {
                    prcount += cc;
                    allObjects += (long)cc;
                }
                upst.updateStatus(allProcessed += (long)prcount, allObjects, "Import of " + moHandler.getType());
            }
            for (AbstractMOHandler moHandler : mhoList) {
                moHandler.postGenerateProcessing(conn);
            }
        }
        catch (Exception e) {
            Logger.error_("Error in database import:", e);
        }
        finally {
            try {
                if (conn.isClosed()) {
                    // empty if block
                }
            }
            catch (Exception ec) {
                ec.printStackTrace();
                LOGGER.error(ec.toString());
            }
        }
        if (upst == null) return;
    }

    public boolean isSecondaryTables() {
        return this.getDesign().getSettings().isImportSecondaryTables();
    }

    public void setSecondaryTables(boolean secondaryTables) {
        this.getDesign().getSettings().setImportSecondaryTables(secondaryTables);
    }

    public boolean isSpatialProperties() {
        return this.getDesign().getSettings().isImportSpatialProperties();
    }

    public void setSpatialProperties(boolean spatialProperties) {
        this.getDesign().getSettings().setImportSpatialProperties(spatialProperties);
    }

    public boolean isImportColumnDetails() {
        return this.getDesign().getSettings().isImportColumnDetails();
    }

    public void setImportColumnDetails(boolean importColumnDetails) {
        this.getDesign().getSettings().setImportColumnDetails(importColumnDetails);
    }

    public List getShowList() {
        return this.showList;
    }

    public void setShowList(List showList) {
        this.showList = showList;
    }

    public void init(Connection connection) {
        try {
            DatabaseMetaData dbmd = connection.getMetaData();
            try {
                this.dbProductName = dbmd.getDatabaseProductName();
                this.dbProductVersion = dbmd.getDatabaseProductVersion();
                this.dbMajorVersion = dbmd.getDatabaseMajorVersion();
                this.dbMinorVersion = dbmd.getDatabaseMinorVersion();
            }
            catch (Throwable throwable) {}
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean isPartitions() {
        return this.getDesign().getSettings().isImportPartitions();
    }

    public void setPartitions(boolean partitions) {
        this.getDesign().getSettings().setImportPartitions(partitions);
    }

    public boolean isTriggers() {
        return this.getDesign().getSettings().isImportTriggers();
    }

    public void setTriggers(boolean triggers) {
        this.getDesign().getSettings().setImportTriggers(triggers);
    }

    public boolean isStructuredTypesScan() {
        return this.getDesign().getSettings().isScanForUsedStructuredTypes();
    }

    public void setStructuredTypesScan(boolean structuredTypesScan) {
        this.getDesign().getSettings().setScanForUsedStructuredTypes(structuredTypesScan);
    }

    public AbstractMOHandler getTableHandler() {
        return null;
    }

    public Design getDesign() {
        return this.design;
    }

    public void setDesign(Design design) {
        this.design = design;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getPaginatedQuery(String query) {
        int limit = this.getLimit();
        int offset = this.getOffset();
        if (limit >= 0) {
            return "select * from (select /*+ FIRST_ROWS(n) */ a.*, ROWNUM rnum from (" + query + ") a where rownum <= " + (offset + limit) + ") where rnum > " + offset;
        }
        return query;
    }

    public static String getPaginatedQuery(String query, int limit, int offset) {
        if (limit >= 0) {
            if (offset < 0) {
                offset = 0;
            }
            return "select * from (select /*+ FIRST_ROWS(n) */ a.*, ROWNUM rnum from (" + query + ") a where rownum <= " + (offset + limit) + ") where rnum > " + offset;
        }
        return query;
    }

    public int getDbMinorVersion() {
        return this.dbMinorVersion;
    }

    public void setDbMinorVersion(int dbMinorVersion) {
        this.dbMinorVersion = dbMinorVersion;
    }

    public UpdatableStatus getUpdatableStatus() {
        return this.updatableStatus;
    }

    public void setUpdatableStatus(UpdatableStatus updatableStatus) {
        this.updatableStatus = updatableStatus;
    }

    public boolean isParseQueriesAfterImport() {
        return this.parseQueriesAfterImport;
    }

    public void setParseQueriesAfterImport(boolean parseQueriesAfterImport) {
        this.parseQueriesAfterImport = parseQueriesAfterImport;
    }

    public long getAllProcessed() {
        return this.allProcessed;
    }

    public void setAllProcessed(long allProcessed) {
        this.allProcessed = allProcessed;
    }

    public long getAllObjects() {
        return this.allObjects;
    }

    public void setAllObjects(long allObjects) {
        this.allObjects = allObjects;
    }
}

