/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.BitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;

public class SSBCreateBitmapJoinIndexOraclev9i
extends AbstractSSBOracle {
    private StorageDesignOraclev9i storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        BitmapJoinIndexOraclev9i index = (BitmapJoinIndexOraclev9i)object;
        this.storageDesign = (StorageDesignOraclev9i)index.getStorageDesign();
        this.appendComment(oldbuffer, index);
        this.appendCreateBitmapJoinIndex(buffer, index);
        advancedComment = buffer.toString();
        this.appendIndexColumns(buffer, index, prettyPrint);
        this.appendFrom(buffer, index, prettyPrint);
        this.appendWhere(buffer, index, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        SSBCreateBitmapJoinIndexOraclev9i.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.incrementCreateIndex();
    }

    private void appendCreateBitmapJoinIndex(StringBuffer buffer, BitmapJoinIndexOraclev9i index) {
        this.appendCreate(buffer);
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "BITMAP");
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "INDEX");
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(index));
    }

    private void appendIndexColumns(StringBuffer buffer, BitmapJoinIndexOraclev9i index, boolean prettyPrint) {
        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "ON");
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(index.getTable()));
        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        Object[] cols = index.getIndexColumnSet().toArray();
        for (int i = 0; i < cols.length; ++i) {
            TableProxyOracle tableProxy;
            if (i > 0) {
                this.appendComma(buffer);
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            }
            String colID = (String)cols[i];
            ++i;
            ColumnProxyOracle column = (ColumnProxyOracle)index.getStorageDesign().getColumnProxySet().getProxy(colID);
            if (column == null || (tableProxy = column.getTableProxy()) == null) continue;
            String sortOrder = "ASC";
            if (i < cols.length) {
                sortOrder = (String)cols[i];
            }
            SSBCreateBitmapJoinIndexOraclev9i.appendString(buffer, ' ');
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy) + '.' + this.storageDesign.getFormatedName(column));
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, sortOrder);
        }
        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ')');
    }

    private void appendFrom(StringBuffer buffer, BitmapJoinIndexOraclev9i index, boolean prettyPrint) {
        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "FROM");
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(index.getTable()));
        for (int i = 0; i < index.getDimensionTables().length; ++i) {
            TableProxyOracle table = (TableProxyOracle)index.getStorageDesign().getTableProxySet().getProxy((String)index.getDimensionTables()[i]);
            if (table == null) continue;
            this.appendComma(buffer);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(table));
        }
    }

    private void appendWhere(StringBuffer buffer, BitmapJoinIndexOraclev9i index, boolean prettyPrint) {
        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "WHERE");
        Object[] cols = index.getJoinColumnSet().toArray();
        for (int i = 0; i < cols.length - 1; ++i) {
            if (i > 0) {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "AND");
            }
            String dimensionCol = (String)cols[i];
            String baseCol = (String)cols[++i];
            ColumnProxyOracle dimColumn = (ColumnProxyOracle)index.getStorageDesign().getColumnProxySet().getProxy(dimensionCol);
            ColumnProxyOracle baseColumn = (ColumnProxyOracle)index.getStorageDesign().getColumnProxySet().getProxy(baseCol);
            if (dimColumn == null || baseColumn == null) continue;
            TableProxyOracle dimTable = dimColumn.getTableProxy();
            TableProxyOracle baseTable = baseColumn.getTableProxy();
            if (dimTable == null || baseTable == null) continue;
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(dimTable) + '.' + this.storageDesign.getFormatedName(dimColumn));
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "=");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(baseTable) + '.' + this.storageDesign.getFormatedName(baseColumn));
        }
        if ("YES".equalsIgnoreCase(index.getLocalPartitioning()) && index.getTable().getPartitioned().equalsIgnoreCase("YES")) {
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "LOCAL");
            this.appendPartitionList(buffer, index, index.getTable(), prettyPrint);
        }
        this.appendIndexAttributes(buffer, index, prettyPrint);
    }

    private void appendPartitionList(StringBuffer buffer, BitmapJoinIndexOraclev9i index, TableProxyOracle tableProxy, boolean prettyPrint) {
        PartitionListOraclev9i partitionList = (PartitionListOraclev9i)tableProxy.getPartitionList();
        if (partitionList != null) {
            String subPartitionTableSpaceIDs;
            String partitionType = partitionList.getPartitionType();
            if (("HASH BY QUANTITY".equalsIgnoreCase(partitionType) || "COMPOSITE BY HASH".equalsIgnoreCase(partitionType)) && !"".equals((subPartitionTableSpaceIDs = index.getHashSubPartitionsTableSpaces()).trim())) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(subPartitionTableSpaceIDs));
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ')');
            }
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                this.appendPartitions(buffer, index, partitionList, false, prettyPrint);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(partitionType) || "COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                this.appendPartitions(buffer, index, partitionList, true, prettyPrint);
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                this.appendHashPartitions(buffer, partitionList, index, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                this.appendListPartitions(buffer, partitionList, index, prettyPrint);
            }
        }
    }

    private void appendListPartitions(StringBuffer buffer, PartitionListOraclev9i partitionList, BitmapJoinIndexOraclev9i index, boolean prettyPrint) {
        TableProxyOracle tableProxy = index.getTable();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String lipPName;
            ListPartitionOraclev9i partition = (ListPartitionOraclev9i)it.next();
            if (first) {
                buffer.append(NEWLINE).append("    ");
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ',');
            }
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(index, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_") || this.storageDesign.getDesign().getSettings().isIncludeSystemNames()) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null) continue;
            TableSpaceOraclev9i ts = (TableSpaceOraclev9i)lip.getTableSpace();
            String logging = lip.getLogging();
            SegmentOraclev9i indexSegment = (SegmentOraclev9i)lip.getSegment();
            if (indexSegment != null) {
                this.appendSegment(buffer, indexSegment, prettyPrint);
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                if (ts != null) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                }
            }
            if (!this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) continue;
            if ("YES".equalsIgnoreCase(logging)) {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(logging)) continue;
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
        }
        if (!first) {
            buffer.append(NEWLINE).append("    ");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendHashPartitions(StringBuffer buffer, PartitionListOraclev9i partitionList, BitmapJoinIndexOraclev9i index, boolean prettyPrint) {
        TableProxyOracle tableProxy = index.getTable();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            TableSpaceOraclev9i ts;
            String lipPName;
            HashPartitionOraclev9i partition = (HashPartitionOraclev9i)it.next();
            if (first) {
                buffer.append(NEWLINE).append("    ");
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ',');
            }
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(index, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_") || this.storageDesign.getDesign().getSettings().isIncludeSystemNames()) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null || (ts = (TableSpaceOraclev9i)lip.getTableSpace()) == null || !this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) continue;
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
        }
        if (!first) {
            buffer.append(NEWLINE).append("    ");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendPartitions(StringBuffer buffer, BitmapJoinIndexOraclev9i index, PartitionListOraclev9i partitionList, boolean composite, boolean prettyPrint) {
        TableProxyOracle tableProxy = index.getTable();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String lipPName;
            PartitionOraclev9i partition = (PartitionOraclev9i)it.next();
            if (first) {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(index, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_") || this.storageDesign.getDesign().getSettings().isIncludeSystemNames()) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip != null) {
                SegmentOraclev9i indexSegment = (SegmentOraclev9i)lip.getSegment();
                if (indexSegment != null) {
                    this.appendSegment(buffer, indexSegment, prettyPrint);
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                    TableSpaceOraclev9i ts = (TableSpaceOraclev9i)lip.getTableSpace();
                    if (ts != null) {
                        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                    } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                    }
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) {
                    String logging = lip.getLogging();
                    if ("YES".equalsIgnoreCase(logging)) {
                        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                    } else if ("NO".equalsIgnoreCase(logging)) {
                        SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
            }
            if (!composite) continue;
            String tablespaceIDs = "";
            if (lip != null) {
                tablespaceIDs = lip.getHashSubPartitionsTableSpaces();
            }
            this.appendIndexSubPartitions(buffer, index, partitionList, partition, tablespaceIDs, prettyPrint);
        }
        if (!first) {
            buffer.append(NEWLINE).append("    ").append(')');
        }
    }

    private LocalIndexProperties getPropsForIndex(BitmapJoinIndexOraclev9i indexProxy, StorageObject partition) {
        return this.storageDesign.getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(partition, indexProxy);
    }

    private void appendIndexSubPartitions(StringBuffer buffer, BitmapJoinIndexOraclev9i index, PartitionListOraclev9i partitionList, PartitionOraclev9i partition, String tablespaceIDs, boolean prettyPrint) {
        String partType = partitionList.getPartitionType();
        if (partType.equalsIgnoreCase("COMPOSITE BY HASH")) {
            if (!this.appendHashSubPartitions(buffer, index, partition.getPartitions(), prettyPrint) && !"".equalsIgnoreCase(tablespaceIDs.trim())) {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(tablespaceIDs));
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ')');
            }
        } else if (partType.equalsIgnoreCase("COMPOSITE BY LIST")) {
            this.appendListSubPartitions(buffer, index, partition.getListPartitions());
        }
    }

    private void appendListSubPartitions(StringBuffer buffer, BitmapJoinIndexOraclev9i index, StorageObjectCollection subpartitions) {
        boolean first = true;
        for (ListStorageTemplatePartitionOraclev9i listPartition : subpartitions) {
            TableSpaceOracle ts;
            String lipPName;
            if (first) {
                buffer.append(NEWLINE).append("    ");
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ',');
            }
            buffer.append(NEWLINE).append("    ");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
            String lpName = listPartition.getName();
            String formattedPName = this.storageDesign.getFormatedName(listPartition);
            LocalIndexProperties lip = this.getPropsForIndex(index, listPartition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !lpName.equals(lipPName)) {
                lpName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!lpName.toUpperCase().startsWith("SYS_") || this.storageDesign.getDesign().getSettings().isIncludeSystemNames()) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null || (ts = lip.getTableSpace()) == null || !this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) continue;
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
        }
        if (!first) {
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private boolean appendHashSubPartitions(StringBuffer buffer, BitmapJoinIndexOraclev9i index, StorageObjectCollection subpartitions, boolean prettyPrint) {
        boolean result = false;
        boolean first = true;
        for (HashPartitionOraclev9i hashPartition : subpartitions) {
            TableSpaceOraclev9i ts;
            String lipPName;
            if (first) {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, '(');
                first = false;
                result = true;
            } else {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, ',');
            }
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
            String hpName = hashPartition.getName();
            String formattedPName = this.storageDesign.getFormatedName(hashPartition);
            LocalIndexProperties lip = this.getPropsForIndex(index, hashPartition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !hpName.equals(lipPName)) {
                hpName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!hpName.toUpperCase().startsWith("SYS_") || this.storageDesign.getDesign().getSettings().isIncludeSystemNames()) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null || (ts = (TableSpaceOraclev9i)lip.getTableSpace()) == null || !this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) continue;
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
        }
        if (!first) {
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            buffer.append(')');
        }
        return result;
    }

    private void appendSegment(StringBuffer buffer, SegmentOracle segment, boolean prettyPrint) {
        if (segment != null && segment.isMarkedGenerate() && this.storageDesign.getDesign().getSettings().isIncludeStorageInDDL()) {
            if (this.storageDesign.getDesign().getSettings().isIncludePctFreeInDDL()) {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                buffer.append("PCTFREE ").append(segment.getPCTFree());
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeInitransInDDL()) {
                if (segment.getInitrans() > 2) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    buffer.append("INITRANS ").append(segment.getInitrans());
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "INITRANS");
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "2");
                }
                if (segment.getMaxTrans() > 2) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    buffer.append("MAXTRANS ").append(segment.getMaxTrans());
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    buffer.append("MAXTRANS 255").append(segment.getMaxTrans());
                }
            }
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            buffer.append(" STORAGE (");
            SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
            boolean props = false;
            if (segment.getSCInitialExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
                buffer.append("INITIAL ").append(segment.getSCInitialExtent());
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                buffer.append("NEXT ").append(segment.getSCNextExtent());
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                buffer.append("PCTINCREASE ").append(segment.getSCPctIncrease());
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                buffer.append("MINEXTENTS ").append(segment.getSCMinExtents());
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
                buffer.append("MAXEXTENTS ").append(segment.getSCMaxExtents());
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeFreeListsInDDL()) {
                buffer.append("FREELISTS ").append(segment.getSCFreeLists());
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeFreeListGroupsInDDL()) {
                buffer.append("FREELIST GROUPS ").append(segment.getSCFreelistGroups());
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                props = true;
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
                buffer.append("BUFFER_POOL ").append(segment.getSCBufferPool());
                props = true;
            }
            if (props) {
                buffer.append(')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf(" STORAGE ("), buffer.length(), "");
            }
        }
    }

    private void appendIndexAttributes(StringBuffer buffer, BitmapJoinIndexOraclev9i indexProxy, boolean prettyPrint) {
        String tablespace = indexProxy.getTablespace();
        if (tablespace != null && !tablespace.equals("") && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
            if ("DEFAULT".equalsIgnoreCase(tablespace)) {
                if ("YES".equalsIgnoreCase(indexProxy.getLocalPartitioning())) {
                    SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "DEFAULT");
                }
            } else {
                SSBCreateBitmapJoinIndexOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tablespace));
            }
        }
        this.appendSegment(buffer, indexProxy.getSegment(), prettyPrint);
        if (this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) {
            if ("YES".equalsIgnoreCase(indexProxy.getLogging())) {
                buffer.append(NEWLINE).append("    ");
                buffer.append("LOGGING");
            } else if ("NO".equalsIgnoreCase(indexProxy.getLogging())) {
                buffer.append(NEWLINE).append("    ");
                buffer.append("NOLOGGING");
            }
        }
        if ("YES".equalsIgnoreCase(indexProxy.getOnline())) {
            buffer.append(NEWLINE).append("    ");
            buffer.append("ONLINE");
        }
        if ("YES".equalsIgnoreCase(indexProxy.getComputeStatistics())) {
            buffer.append(NEWLINE).append("    ");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
        }
        buffer.append(NEWLINE).append("    ");
        if (indexProxy.getCompress() > 0) {
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "COMPRESS");
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, indexProxy.getCompress());
        } else {
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        buffer.append(NEWLINE).append("    ");
        if ("YES".equalsIgnoreCase(indexProxy.getParallel())) {
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "PARALLEL");
            if (!"".equalsIgnoreCase(indexProxy.getDegree())) {
                SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, indexProxy.getDegree());
            }
        } else {
            SSBCreateBitmapJoinIndexOraclev9i.appendStringWithSpace(buffer, "NOPARALLEL");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof BitmapJoinIndexOraclev9i && ((BitmapJoinIndexOraclev9i)object).isMarkedGenerate();
    }

    public void doAppendBJIndex(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        this.doAppend(oldbuffer, object, prettyPrint);
    }
}

