/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.compare;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.exports.ddl.DDLGenerationStatus;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;

public class CDDLFileMaker
extends ModelObject {
    private StorageDesign storageDesign;
    private StringBuffer contentBuffer;
    private String content;
    private CompareObjectSelection merger;
    private static DDLAdvancedGenerator ddlAdvancedGenenerator = null;
    private DDLGenerationStatus status = new DDLGenerationStatus();
    private static final char INTERVAL = ' ';

    public CDDLFileMaker() {
        this.status.resetCounters();
    }

    public void setStorageDesign(Object storageDesignOrSite) {
        if (storageDesignOrSite instanceof StorageDesign) {
            this.setStorageDesign((StorageDesign)storageDesignOrSite);
        } else if (storageDesignOrSite instanceof RDBMSSite) {
            StorageDesign storageDesign = this.getDesign().getStorageDesign((RDBMSSite)storageDesignOrSite);
            this.setStorageDesign(storageDesign);
        }
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public StringBuffer buffer() {
        if (this.contentBuffer == null) {
            this.contentBuffer = new StringBuffer();
        }
        return this.contentBuffer;
    }

    public int getTextSize() {
        return this.buffer().length();
    }

    public void generateDDLContent() {
        this.generateDDLContent(false, false);
    }

    public void generateDDLContent(boolean includeTitle, boolean includeSummary) {
        List listOfDDLObjects = this.getMerger().getListOfDDLObjects();
        int size = listOfDDLObjects.size();
        RDBMSSite defaultSite = this.getDesign().getSelectedRDBMSSite();
        this.getDesign().setSelectedRDBMSSite(this.getStorageDesign().getRDBMSSite());
        this.clearContent();
        if (includeTitle) {
            this.buffer().append("Generated at ").append(MDConfiguration.timeToString(System.currentTimeMillis())).append(this.newline());
        }
        if (this.getMerger() != null) {
            if (includeTitle) {
                // empty if block
            }
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            int p = 0;
            this.resetCounters();
            this.getStatus().setddlAdvancedGenenerator(null);
            DDLAdvancedGenerator ddlAdvancedGenerator = this.getStorageDesign().createDDLAdvancedGenerator();
            if (ddlAdvancedGenerator != null && DDLGenerationOptions.getDDLType() > 0) {
                this.getStatus().setddlAdvancedGenenerator(ddlAdvancedGenerator);
                ddlAdvancedGenerator.addAdvanceHeader(this.buffer());
            }
            DDLGenerator dropGenerator = this.getMerger().getDDLDropGenerator();
            dropGenerator.setStatus(this.getStatus());
            Iterator it = this.getMerger().ddlDropObjects();
            while (it.hasNext()) {
                ModelObject object = (ModelObject)it.next();
                this.appendStatementFor(object, dropGenerator);
            }
            DDLGenerator ddlGenerator = this.getMerger().getDDLGenerator();
            ddlGenerator.setStatus(this.getStatus());
            it = listOfDDLObjects.iterator();
            while (it.hasNext()) {
                ++p;
                ModelObject object = (ModelObject)it.next();
                this.appendStatementFor(object, ddlGenerator);
            }
            if (ddlAdvancedGenerator != null && DDLGenerationOptions.getDDLType() > 0) {
                ddlAdvancedGenerator.addStatementFinisher(this.buffer());
            }
            this.getMerger().removeDDLObjects();
            if (includeSummary) {
                this.buffer().append(this.newline());
                this.buffer().append(this.newline());
                this.appendCounters(this.buffer(), this.getStorageDesign().getRDBMSType());
            }
            SSBAutoIncrementColumnOracle.clearGenSequenceSet();
        }
        this.getDesign().setSelectedRDBMSSite(defaultSite);
    }

    private void appendStatementFor(Object object, DDLGenerator generator) {
        StringBuffer buffer = new StringBuffer();
        generator.appendDDLFor(buffer, object);
        String result = buffer.toString();
        if (!"".equalsIgnoreCase(result.trim())) {
            boolean formatStatement = false;
            if (formatStatement) {
                String formatted = this.formatSQL(result, this.getStorageDesign());
                if (!"".equalsIgnoreCase(result.trim())) {
                    result = formatted;
                }
            }
            this.buffer().append(this.newline());
            this.buffer().append(result);
        }
    }

    private String formatSQL(String sql, StorageDesign storageDesign) {
        return sql;
    }

    private void appendCounters(StringBuffer buffer, RDBMSType type) {
        buffer.append("Summary Report :");
        buffer.append(this.newline());
        buffer.append("-- ");
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE TABLE", this.getCreateTable());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE INDEX", this.getCreateIndex());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE VIEW", this.getCreateView());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER TABLE", this.getAlterTable());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER INDEX", this.status.alterIndex);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER VIEW", this.getAlterView());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- status. create TABLE", this.status.dropTable);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP INDEX", this.status.dropIndex);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP VIEW", this.status.dropTableView);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PACKAGE", this.status.createPackage);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PACKAGE BODY", this.status.createPackageBody);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PROCEDURE", this.status.createProc);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE FUNCTION", this.status.createFunction);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP PACKAGE", this.status.dropPackage);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP PACKAGE BODY", this.status.dropPackageBody);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP PROCEDURE", this.status.dropProc);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP FUNCTION", this.status.dropFunction);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE TRIGGER", this.getCreateTrigger());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER TRIGGER", this.getAlterTrigger());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP TRIGGER", this.status.dropTrigger);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE COLLECTION TYPE", this.status.getCreateCollectionType());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", this.status.getCreateStructuredType());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE BODY", this.status.getCreateStructuredTypeBody());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP TYPE", this.status.dropType);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE SEQUENCE", this.getCreateSequence());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER SEQUENCE", this.status.alterSequence);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP SEQUENCE", this.status.dropSequence);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE MATERIALIZED VIEW", this.getCreateSnapshot());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP MATERIALIZED VIEW", this.status.dropSnapshot);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE SYNONYM", this.status.getCreateSynonym());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP SYNONYM", this.status.dropSynonym);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE DIMENSION", this.status.getCreateDimension());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP DIMENSION", this.status.dropDimension);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE CONTEXT", this.status.getCreateContext());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP CONTEXT", this.status.dropContext);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE DIRECTORY", this.status.getCreateDirectory());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP DIRECTORY", this.status.dropDirectory);
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("-- ");
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ERRORS", this.getErrors());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- WARNINGS", this.getWarnings());
        buffer.append(this.newline());
    }

    private void appendFormattedString(StringBuffer buffer, String string, int number) {
        int n = new Integer(number).toString().length();
        buffer.append(string);
        for (int i = 0; i < 45 - string.length() - n; ++i) {
            buffer.append(' ');
        }
        buffer.append(number);
    }

    public void incrementCreateTable() {
        this.status.incrementCreateTable();
    }

    public int getCreateTable() {
        return this.status.getCreateTable();
    }

    public void incrementCreateIndex() {
        this.status.incrementCreateIndex();
    }

    public int getCreateIndex() {
        return this.status.getCreateIndex();
    }

    public void incrementCreateView() {
        this.status.incrementCreateView();
    }

    public int getCreateView() {
        return this.status.getCreateView();
    }

    public void incrementAlterTable() {
        this.status.incrementAlterTable();
    }

    public int getAlterTable() {
        return this.status.getAlterTable();
    }

    public void incrementAlterView() {
        this.status.incrementAlterView();
    }

    public int getAlterView() {
        return this.status.getAlterView();
    }

    public void incrementAlterIndex() {
        ++this.status.alterIndex;
    }

    public void incrementCreatePackage() {
        ++this.status.createPackage;
    }

    public void incrementCreatePackageBody() {
        ++this.status.createPackageBody;
    }

    public void incrementCreateProc() {
        ++this.status.createProc;
    }

    public void incrementCreateFunction() {
        ++this.status.createFunction;
    }

    public void incrementCreateTrigger() {
        this.status.incrementCreateTrigger();
    }

    public int getCreateTrigger() {
        return this.status.getCreateTrigger();
    }

    public int getRedactionPolicies() {
        return this.status.getRedactionPolicies();
    }

    public int getORDSDropSchema() {
        return this.status.getORDSDropSchema();
    }

    public int getORDSEnableSchema() {
        return this.status.getORDSEnableSchema();
    }

    public int getTSDPPolicies() {
        return this.status.getTSDPPolicies();
    }

    public void incrementAlterTrigger() {
        this.status.incrementAlterTrigger();
    }

    public int getAlterTrigger() {
        return this.status.getAlterTrigger();
    }

    public void incrementCreateSequence() {
        this.status.incrementCreateSequence();
    }

    public int getCreateSequence() {
        return this.status.getCreateSequence();
    }

    public void incrementCreateSnapshot() {
        this.status.incrementCreateSnapshot();
    }

    public int getCreateSnapshot() {
        return this.status.getCreateSnapshot();
    }

    public void incrementCreateMViewLog() {
        this.status.incrementCreateMViewLog();
    }

    public int getCreateMViewLog() {
        return this.status.getCreateMaterializedViewLog();
    }

    public void incrementAlterSequence() {
        ++this.status.alterSequence;
    }

    public void incrementDropSequence() {
        ++this.status.dropSequence;
    }

    public void incrementErrors() {
        this.status.incrementErrors();
    }

    public int getErrors() {
        return this.status.getErrors();
    }

    public void incrementWarnings() {
        this.status.incrementWarnings();
    }

    public int getWarnings() {
        return this.status.getWarnings();
    }

    private void resetCounters() {
        this.status.resetCounters();
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public void clearContent() {
        this.buffer().setLength(0);
        this.content = null;
    }

    public String getContent() {
        if (this.content == null) {
            this.content = this.buffer().toString();
        }
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public CompareObjectSelection getMerger() {
        return this.merger;
    }

    public void setMerger(CompareObjectSelection merger) {
        this.merger = merger;
    }

    public void incrementDropTable() {
        ++this.status.dropTable;
    }

    public void incrementDropIndex() {
        ++this.status.dropIndex;
    }

    public void incrementDropView() {
        ++this.status.dropTableView;
    }

    public void incrementDropSnapshot() {
        ++this.status.dropSnapshot;
    }

    public void incrementDropMViewLog() {
        ++this.status.dropMViewLog;
    }

    public void incrementDropPackage() {
        ++this.status.dropPackage;
    }

    public void incrementDropPackageBody() {
        ++this.status.dropPackageBody;
    }

    public void incrementDropProc() {
        ++this.status.dropProc;
    }

    public void incrementDropFunction() {
        ++this.status.dropFunction;
    }

    public void incrementDropTrigger() {
        ++this.status.dropTrigger;
    }

    public void incrementDropType() {
        ++this.status.dropType;
    }

    public void incrementDropContext() {
        ++this.status.dropContext;
    }

    public void incrementDropDimension() {
        ++this.status.dropDimension;
    }

    public void incrementDropDirectory() {
        ++this.status.dropDirectory;
    }

    public void incrementDropSynonym() {
        ++this.status.dropSynonym;
    }

    public void incrementAdvancedStep() {
        this.status.incrementAdvancedStep();
    }

    public int getAdvancedStep() {
        return this.status.advancedStep;
    }

    public DDLGenerationStatus getStatus() {
        return this.status;
    }
}

