/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.versions;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.common.utils.DateUtils;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.proxy.ProxySelectorImpl;
import oracle.dbtools.raptor.scriptrunner.cmdline.SqlCli;
import oracle.dbtools.util.Logger;
import oracle.dbtools.versions.SQLclVersion;
import oracle.dbtools.versions.Updates;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class CheckForUpdates {
    private static final String DEFAULT_CONFIGURATION = "META-INF/cfu.json";
    private static final String MIME_TYPE = ContentType.APPLICATION_JSON.getMimeType();
    public static final String BANNERFILE = File.separator + "banner.ser";
    private static JSON MAPPER = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
    private Updates _update;

    public static CheckForUpdates check() {
        CheckForUpdates cfu = new CheckForUpdates();
        Config config = cfu.loadConfig();
        if (config != null) {
            cfu.loadFromConfig(config);
        }
        return cfu;
    }

    private static CloseableHttpClient getHttpClient(int timeout) {
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)timeout)).build();
        PoolingHttpClientConnectionManager connMgr = PoolingHttpClientConnectionManagerBuilder.create().setDefaultSocketConfig(socketConfig).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).setConnectionTimeToLive(TimeValue.ofMinutes((long)1L)).build();
        HttpClientBuilder builder = HttpClients.custom();
        builder.setConnectionManager((HttpClientConnectionManager)connMgr);
        builder.setUserAgent(CheckForUpdates.getUserAgent());
        ProxySelectorImpl proxySelector = new ProxySelectorImpl(ProxySelector.getDefault());
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner((ProxySelector)proxySelector);
        builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        return builder.build();
    }

    private static String getUserAgent() {
        StringBuffer sb = new StringBuffer();
        sb.append(SqlCli.productName);
        sb.append("/");
        sb.append(SQLclVersion.getSQLclVersion());
        sb.append(" (");
        sb.append(System.getProperty("os.name"));
        sb.append(" ");
        sb.append(System.getProperty("os.version"));
        sb.append("; ");
        sb.append(System.getProperty("os.arch"));
        sb.append("; Java ");
        sb.append(System.getProperty("java.version"));
        sb.append(") ");
        sb.append(SQLclVersion.getFullVersion());
        return sb.toString();
    }

    private Config loadConfig() {
        Config config = null;
        ClassLoader cl = CheckForUpdates.class.getClassLoader();
        URL url = cl.getResource(DEFAULT_CONFIGURATION);
        if (url != null) {
            try (InputStream in = url.openStream();){
                config = (Config)MAPPER.beanFrom(Config.class, (Object)in);
            }
            catch (IOException e) {
                Logger.warn(CheckForUpdates.class, e);
            }
        }
        return config;
    }

    private void loadFromConfig(Config cfg) {
        block19: {
            try (CloseableHttpClient client = CheckForUpdates.getHttpClient(cfg.getTimeout());){
                List updates;
                HttpGet request = new HttpGet(new URI(cfg.getUrl()));
                if (client == null || (updates = (List)client.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)new ListResponseHandler())) == null) break block19;
                for (URI update : updates) {
                    try {
                        request = new HttpGet(update);
                        Updates result = (Updates)client.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)new UpdatesResponseHandler());
                        if (result == null) continue;
                        this._update = result;
                        break;
                    }
                    catch (UnknownHostException result) {
                    }
                    catch (IOException e) {
                        Logger.warn(CheckForUpdates.class, e);
                    }
                }
            }
            catch (IOException e) {
                Logger.warn(CheckForUpdates.class, e);
            }
            catch (URISyntaxException e) {
                Logger.warn(CheckForUpdates.class, e);
            }
        }
    }

    public boolean isLoaded() {
        return this._update != null;
    }

    public Version getLatestOracleVersion() {
        return new Version(this.getLatestVersion());
    }

    public static void main(String[] args) {
        CheckForUpdates cfu = CheckForUpdates.check();
        if (cfu.isLoaded()) {
            System.out.println("Number 5 is ALIVE!");
            System.out.println(cfu.getLatestVersion());
            System.out.println(cfu.getDatePublished());
            System.out.println(cfu.getBroadcastMessage());
            System.out.println(cfu.getBroadcastMessageDate());
        }
    }

    public String getBroadcastMessageDate() {
        if (this.isLoaded()) {
            return this._update.getMessage_date();
        }
        return "";
    }

    public String getBroadcastMessageEndDate() {
        if (this.isLoaded()) {
            return this._update.getMessage_end_date();
        }
        return "";
    }

    public String getBroadcastMessage() {
        if (this.isLoaded()) {
            return this._update.getMessage();
        }
        return "";
    }

    public String getDatePublished() {
        if (this.isLoaded()) {
            return this._update.getDate_published();
        }
        return "";
    }

    public String getLatestVersion() {
        if (this.isLoaded()) {
            return this._update.getVersion();
        }
        return "0.0.0.0.1";
    }

    public boolean isMessageShowable(Date today) {
        boolean show = true;
        Date messageStartDate = DateUtils.getDateFromOracleDateFormat(this.getBroadcastMessageDate());
        Date messageEndDate = DateUtils.getDateFromOracleDateFormat(this.getBroadcastMessageEndDate());
        if (messageEndDate != null && messageEndDate.before(today)) {
            show = false;
        }
        if (messageStartDate != null && messageStartDate.after(today)) {
            show = false;
        }
        return show;
    }

    public void save(String string) {
        try {
            String filename = FileUtils.getUserHome() + File.separator + BANNERFILE;
            if (string.trim().length() > 0) {
                if (FileUtils.getUserHome() != null) {
                    File dir = new File(FileUtils.getUserHome());
                    dir.mkdirs();
                }
                FileOutputStream fileOut = new FileOutputStream(filename);
                ObjectOutputStream out = new ObjectOutputStream(fileOut);
                out.writeObject(string);
                out.close();
                fileOut.close();
            } else {
                Files.deleteIfExists(Paths.get(FileUtils.getUserHome(), BANNERFILE));
            }
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), e);
        }
    }

    public static String getBanner() {
        try {
            String filename = FileUtils.getUserHome() + File.separator + BANNERFILE;
            FileInputStream fileIn = new FileInputStream(filename);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            String banner = (String)in.readObject();
            in.close();
            fileIn.close();
            return banner;
        }
        catch (Exception e) {
            Logger.info(CheckForUpdates.class, e);
            return null;
        }
    }

    public static final class Config {
        private String url;
        private int timeout = 60000;

        @JsonSetter(value="url")
        private void setUrl(String url) {
            this.url = url;
        }

        @JsonSetter(value="timeout")
        private void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public String getUrl() {
            return this.url;
        }

        public int getTimeout() {
            return this.timeout;
        }
    }

    static final class ListResponseHandler
    extends RH<List<URI>> {
        ListResponseHandler() {
        }

        @Override
        protected List<URI> build(Reader r) throws IOException {
            ArrayList<URI> result = new ArrayList<URI>();
            try {
                TreeNode cfu;
                TreeNode root = MAPPER.treeFrom((Object)r);
                TreeNode sqlcl = root.get("sqlcl");
                if (sqlcl != null && (cfu = sqlcl.get("cfu")) != null && cfu.isArray()) {
                    Iterator iter = ((JrsArray)cfu).elements();
                    while (iter.hasNext()) {
                        JrsValue entry = (JrsValue)iter.next();
                        String path = entry.asText();
                        if (!ModelUtil.hasLength(path)) continue;
                        try {
                            result.add(new URI(path));
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                    }
                }
                return result;
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
        }
    }

    static final class UpdatesResponseHandler
    extends RH<Updates> {
        UpdatesResponseHandler() {
        }

        @Override
        protected Updates build(Reader r) throws IOException {
            try {
                return (Updates)MAPPER.beanFrom(Updates.class, (Object)r);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
        }
    }

    static abstract class RH<T>
    implements HttpClientResponseHandler<T> {
        RH() {
        }

        public T handleResponse(ClassicHttpResponse response) throws ClientProtocolException, IOException {
            T result = null;
            int code = response.getCode();
            switch (code) {
                case 200: {
                    result = this.parseResponse(response);
                    break;
                }
                default: {
                    Logger.info(CheckForUpdates.class, "Error retrieving update" + new StatusLine((HttpResponse)response).toString());
                }
            }
            return result;
        }

        private T parseResponse(ClassicHttpResponse resp) throws IOException {
            ContentType type = ContentType.parse((CharSequence)resp.getEntity().getContentType());
            if (!MIME_TYPE.equalsIgnoreCase(type.getMimeType())) {
                throw new IOException("Unexpected Content-Type: " + type);
            }
            HttpEntity entity = resp.getEntity();
            Charset cs = type.getCharset();
            if (cs == null) {
                try {
                    cs = Charset.forName("UTF-8");
                }
                catch (UnsupportedCharsetException e) {
                    Logger.warn(CheckForUpdates.class, "Unsupported charset: UTF-8!");
                    cs = Charset.defaultCharset();
                }
            }
            try (BufferedReader r = new BufferedReader(new InputStreamReader(entity.getContent(), cs));){
                T t = this.build(r);
                return t;
            }
        }

        protected abstract T build(Reader var1) throws IOException;
    }
}

