/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline.handlers;

import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedConnectFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class SQLCliPromptedConnectFieldsProvider
implements IGetPromptedConnectFieldsProvider {
    boolean ctrld = false;

    @Override
    public ConnectionDetails get3Fields(ScriptRunnerContext scriptRunnerContext, ConnectionDetails inCd, boolean retry) {
        String promptDatabase;
        ConnectionDetails retCd = null;
        String connectName = inCd.getConnectName();
        String connectPassword = inCd.getConnectPassword();
        String connectDB = inCd.getConnectDB();
        if (scriptRunnerContext.getProperty("script.runner.jline") == null) {
            return null;
        }
        this.ctrld = false;
        if (!(retry || connectName == null || connectName.equals("") || connectPassword == null || connectPassword.equals("") || connectDB == null || connectDB.equals(""))) {
            return inCd;
        }
        String retrying = "";
        if (retry) {
            retrying = ScriptRunnerDbArb.getString("CONNECT_RETRYING") + " ";
        }
        String redacted = "";
        String name = inCd.getConnectName();
        String password = inCd.getConnectPassword();
        String db = inCd.getConnectDB();
        String role = inCd.getRole();
        if (name != null && !name.equals("")) {
            if (name.indexOf(" ") != -1 && !name.startsWith("\"")) {
                name = '\"' + name + '\"';
            }
            redacted = name;
        }
        if (password != null && !password.equals("")) {
            redacted = redacted + "/*********";
        } else if (inCd.getSlash() != -1) {
            redacted = redacted + "/";
        }
        if (db != null && !db.equals("")) {
            redacted = redacted + "@" + db;
        }
        if (role != null && !role.equals("")) {
            redacted = redacted + " " + role.trim();
        }
        String namePlus = this.getOneField(scriptRunnerContext, ScriptRunnerDbArb.getString("CONNECT_USERNAME") + " " + retrying, inCd.getFullString(), redacted, false, retry);
        ConnectionDetails cd = ScriptUtils.getConnectionDetails("connect " + namePlus);
        if (cd != null && cd.getCallUsage()) {
            return cd;
        }
        if (!(namePlus == null || namePlus.equals("") || cd.getSlash() == -1 && cd.getAt() == -1)) {
            connectName = cd.getConnectName();
            connectPassword = cd.getSlash() != -1 ? cd.getConnectPassword() : this.getOneField(scriptRunnerContext, ScriptRunnerDbArb.getString("CONNECT_PASSWORD") + " " + retrying, connectPassword, connectPassword, true, retry);
            connectDB = cd.getConnectDB();
            cd.setConnectPassword(connectPassword);
            retCd = cd;
        } else {
            cd.setConnectPassword(this.getOneField(scriptRunnerContext, ScriptRunnerDbArb.getString("CONNECT_PASSWORD") + " " + retrying, connectPassword, connectPassword, true, retry));
            retCd = cd;
        }
        if (System.getenv("SQLCLDBPROMPT") != null && !System.getenv("SQLCLDBPROMPT").equals("") && cd != null && cd.getAt() == -1 && (promptDatabase = this.getOneField(scriptRunnerContext, ScriptRunnerDbArb.getString("CONNECT_DATABASE") + " " + retrying, connectDB, connectDB, false, retry)) != null) {
            cd.setConnectDB(promptDatabase);
        }
        if (this.ctrld) {
            return null;
        }
        return retCd;
    }

    String getOneField(ScriptRunnerContext ctx, String prompt, String existing, String redacted, boolean hide, boolean retry) {
        ConsoleService reader;
        if (this.ctrld) {
            return "";
        }
        if ((retry || existing == null || existing.equals("")) && (reader = (ConsoleService)ctx.getProperty("script.runner.jline")) != null) {
            String haveASpace = "";
            if (ctx.getProperty("script.runner.sqlplus.silent") == null) {
                if (hide) {
                    haveASpace = prompt + "(**********?) ";
                } else {
                    if (redacted == null) {
                        redacted = "";
                    }
                    haveASpace = prompt + "('" + redacted + "'?) ";
                }
            }
            String fromConsole = null;
            try {
                fromConsole = ctx.getProperty("script.runner.sqlplus.silent") == null ? (hide ? reader.readInput(haveASpace, Character.valueOf('*')) : reader.readInput(haveASpace)) : reader.readInput(haveASpace, Character.valueOf(' '));
                if (retry && fromConsole != null && fromConsole.equals("")) {
                    fromConsole = existing;
                }
                if (fromConsole == null) {
                    this.ctrld = true;
                    fromConsole = "";
                }
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e);
            }
            return fromConsole;
        }
        return existing;
    }
}

