/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.console.StatusBarComponent;
import oracle.dbtools.raptor.console.StatusBarService;
import oracle.dbtools.raptor.console.impl.SqlclConsole;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.util.Logger;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.Log;
import org.jline.utils.Status;

public class SqlclStatusBar
implements StatusBarService {
    private final Status status;
    private final SqlclConsole console;
    private LineReaderImpl reader;
    private final Terminal terminal;
    private final ScriptRunnerContext scriptRunnerContext;
    private final SortedMap<String, StatusBarComponent> availableComponents = new TreeMap<String, StatusBarComponent>();
    private final LinkedList<StatusBarComponent> usedComponents = new LinkedList();
    private final List<StatusBarComponent> defaultComponents = new ArrayList<StatusBarComponent>();
    private boolean enabled = false;
    private static final Set<String> RESERVED_WORDS = new HashSet<String>();

    public SqlclStatusBar(SqlclConsole console, LineReaderImpl reader, ScriptRunnerContext scriptRunnerContext) {
        this.console = console;
        this.reader = reader;
        this.terminal = reader.getTerminal();
        this.scriptRunnerContext = scriptRunnerContext;
        this.status = Status.getStatus(this.terminal, true);
        if (scriptRunnerContext != null) {
            this.registerComponentServices();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setEnabled(boolean enabled) {
        if (enabled == this.enabled) return;
        if (enabled) {
            if (this.usedComponents.size() <= 0) throw new IllegalArgumentException("Cannot enable status bar when there are no configured components.");
            this.enabled = true;
            this.terminal.writer().write(10);
            this.terminal.writer().flush();
            this.refresh();
            return;
        } else {
            this.enabled = false;
            this.status.update(null);
        }
    }

    @Override
    public Collection<StatusBarComponent> getAvailableComponents() {
        return this.filter(this.availableComponents.values());
    }

    @Override
    public Collection<StatusBarComponent> getUsedComponents() {
        return this.usedComponents;
    }

    @Override
    public Collection<StatusBarComponent> getDefaultComponents() {
        return this.defaultComponents;
    }

    @Override
    public void setComponents(List<String> names) {
        if (names.size() > 99) {
            throw new IllegalArgumentException("Number of components must be less than 100.");
        }
        HashMap<String, StatusBarComponent> availables = new HashMap<String, StatusBarComponent>(this.availableComponents);
        ArrayList<StatusBarComponent> used = new ArrayList<StatusBarComponent>(this.usedComponents);
        this.removeAllUsed(availables, used);
        for (int c = 0; c < names.size(); ++c) {
            String name = names.get(c);
            if (this.addUsedComponent(availables, used, name)) continue;
            throw new IllegalArgumentException("'" + names.get(c) + "' not found.");
        }
        this.notifyComponents(this.usedComponents, used);
        boolean wasEmpty = this.usedComponents.isEmpty();
        this.usedComponents.clear();
        this.usedComponents.addAll(used);
        this.availableComponents.clear();
        this.availableComponents.putAll(availables);
        this.refresh(true);
        this.enabled = true;
        if (wasEmpty) {
            this.terminal.writer().write(10);
            this.terminal.writer().flush();
        }
    }

    @Override
    public void setDefaultComponents(List<String> names) {
        if (names.size() > 99) {
            throw new IllegalArgumentException("Number of components must be less than 100.");
        }
        if (names.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one default components.");
        }
        ArrayList<StatusBarComponent> components = new ArrayList<StatusBarComponent>();
        for (String name : names) {
            int position;
            StatusBarComponent component = (StatusBarComponent)this.availableComponents.get(name);
            if (component == null && (position = this.findUsedComponent(name)) >= 0) {
                component = this.usedComponents.get(position);
            }
            if (component != null) {
                components.add(component);
                continue;
            }
            throw new IllegalArgumentException("'" + name + "' not found");
        }
        this.defaultComponents.clear();
        this.defaultComponents.addAll(components);
    }

    @Override
    public void addComponent(String name) {
        boolean wasEmpty = this.usedComponents.isEmpty();
        ArrayList<StatusBarComponent> original = new ArrayList<StatusBarComponent>(this.usedComponents);
        this.removeUsedComponent(this.availableComponents, this.usedComponents, name);
        if (this.addUsedComponent(this.availableComponents, this.usedComponents, name)) {
            this.notifyComponents(original, this.usedComponents);
            this.refresh();
            this.enabled = true;
            if (wasEmpty) {
                this.terminal.writer().write(10);
                this.terminal.writer().flush();
            }
        } else {
            throw new IllegalArgumentException("'" + name + "' not found.");
        }
    }

    @Override
    public void removeComponent(String name) {
        ArrayList<StatusBarComponent> original = new ArrayList<StatusBarComponent>(this.usedComponents);
        if (this.removeUsedComponent(this.availableComponents, this.usedComponents, name)) {
            this.notifyComponents(original, this.usedComponents);
            if (this.usedComponents.isEmpty()) {
                this.enabled = false;
            }
            if (this.isEnabled()) {
                this.refresh();
            } else {
                this.status.update(null);
            }
        } else {
            throw new IllegalArgumentException("'" + name + "' not found.");
        }
    }

    @Override
    public void removeAllComponents() {
        ArrayList<StatusBarComponent> original = new ArrayList<StatusBarComponent>(this.usedComponents);
        this.removeAllUsed(this.availableComponents, this.usedComponents);
        this.notifyComponents(original, this.usedComponents);
        this.status.update(null);
        this.enabled = false;
    }

    @Override
    public void setToDefault() {
        this.setComponents(this.getNames(this.defaultComponents));
    }

    public void register(StatusBarComponent component) {
        String name = component.getName();
        String treatedName = name.replaceAll("\\s+", "").toLowerCase();
        if (!treatedName.equals(name)) {
            throw new IllegalArgumentException("Illegal status bar component name: " + component.getName() + ". Must be lower case and without whitespace.");
        }
        if (RESERVED_WORDS.contains(treatedName)) {
            throw new IllegalArgumentException("Illegal status bar component name. May not equal '" + component.getName() + "'.");
        }
        if (treatedName.length() > 16) {
            throw new IllegalArgumentException("Illegal status bar component name: " + component.getName() + ". Must be 16 characters or less.");
        }
        boolean alreadyRegistered = this.availableComponents.containsKey(name);
        if (!alreadyRegistered) {
            for (int c = 0; c < this.usedComponents.size(); ++c) {
                if (!name.equals(this.usedComponents.get(c).getName())) continue;
                alreadyRegistered = true;
                break;
            }
        }
        if (alreadyRegistered) {
            throw new IllegalArgumentException("Component with name '" + component.getName() + "' is already registered.");
        }
        this.availableComponents.put(name, component);
        if (this.defaultComponents.isEmpty()) {
            this.defaultComponents.add(component);
        }
    }

    public void refresh() {
        this.refresh(StatusBarComponent.Reason.OTHER, false);
    }

    public void refresh(boolean force) {
        this.refresh(StatusBarComponent.Reason.OTHER, force);
    }

    public void refresh(final StatusBarComponent.Reason reason, boolean force) {
        if (this.isEnabled()) {
            final String divider = " \u00a6 ";
            final AttributedStringBuilder attribStringBuilder = new AttributedStringBuilder();
            final boolean[] appendValid = new boolean[]{true};
            StatusBarComponent.Context context = new StatusBarComponent.Context(){

                @Override
                public StatusBarComponent.Reason getReason() {
                    return reason;
                }

                @Override
                public ConsoleService getConsole() {
                    return SqlclStatusBar.this.console;
                }

                @Override
                public LineReaderImpl getReader() {
                    return SqlclStatusBar.this.reader;
                }

                @Override
                public ScriptRunnerContext getScriptRunnerContext() {
                    return SqlclStatusBar.this.scriptRunnerContext;
                }

                @Override
                public void append(AttributedString attribString) {
                    if (!appendValid[0]) {
                        Log.warn("can only append text to status bar during update call");
                    } else {
                        if (attribStringBuilder.length() > 0) {
                            attribStringBuilder.append((CharSequence)divider);
                        }
                        attribStringBuilder.append(attribString);
                    }
                }
            };
            for (int c = 0; c < this.usedComponents.size(); ++c) {
                try {
                    this.usedComponents.get(c).update(context);
                    continue;
                }
                catch (RuntimeException ex) {
                    String message = ex.getMessage();
                    Log.warn("error updating statusbar component '" + this.usedComponents.get(c).getName() + "'\n-" + ex.getClass().getSimpleName() + (message != null ? "(" + message + ")" : ""));
                }
            }
            appendValid[0] = false;
            if (force) {
                this.status.reset();
            }
            this.status.update(Collections.singletonList(attribStringBuilder.toAttributedString()));
        }
    }

    private boolean addUsedComponent(Map<String, StatusBarComponent> availables, List<StatusBarComponent> used, String name) {
        StatusBarComponent component = availables.remove(name);
        if (component != null) {
            used.add(component);
            return true;
        }
        return false;
    }

    private void removeAllUsed(Map<String, StatusBarComponent> availables, List<StatusBarComponent> used) {
        for (StatusBarComponent component : used) {
            availables.put(component.getName(), component);
        }
        used.clear();
    }

    private boolean removeUsedComponent(Map<String, StatusBarComponent> availables, List<StatusBarComponent> used, String name) {
        int position = this.findUsedComponent(name);
        if (position >= 0) {
            StatusBarComponent component = used.remove(position);
            availables.put(component.getName(), component);
        }
        return position >= 0;
    }

    private int findUsedComponent(String name) {
        int position = -1;
        for (int c = 0; c < this.usedComponents.size(); ++c) {
            if (!this.usedComponents.get(c).getName().equals(name)) continue;
            position = c;
            break;
        }
        return position;
    }

    private void notifyComponents(List<StatusBarComponent> original, List<StatusBarComponent> updated) {
        for (StatusBarComponent component : original) {
            if (updated.contains(component)) continue;
            component.onRemove();
        }
        for (StatusBarComponent component : updated) {
            if (original.contains(component)) continue;
            component.onAdd();
        }
    }

    private List<String> getNames(Collection<StatusBarComponent> components) {
        ArrayList<String> names = new ArrayList<String>();
        for (StatusBarComponent component : components) {
            names.add(component.getName());
        }
        return names;
    }

    private Collection<StatusBarComponent> filter(Collection<StatusBarComponent> collection) {
        return collection.stream().filter((? super T component) -> !component.isHidden()).collect(Collectors.toList());
    }

    private void registerComponentServices() {
        ServiceLoader<StatusBarComponent> loader = ServiceLoader.load(StatusBarComponent.class);
        try {
            for (StatusBarComponent component : loader) {
                this.register(component);
            }
        }
        catch (IllegalArgumentException e) {
            Logger.fine(this.getClass(), e.getMessage());
        }
    }

    static {
        RESERVED_WORDS.add("on");
        RESERVED_WORDS.add("off");
        RESERVED_WORDS.add("default");
        RESERVED_WORDS.add("add");
        RESERVED_WORDS.add("remove");
    }
}

