/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.app.CompletionList;
import oracle.dbtools.app.SqlCompleter;
import oracle.dbtools.raptor.console.impl.ParseUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.DumbTerminal;

public class SqlclCompleter
extends SqlCompleter
implements Completer {
    private ScriptRunnerContext _ctx;

    public SqlclCompleter(ScriptRunnerContext ctx) {
        super(null);
        this._ctx = ctx;
    }

    public void complete(LineReader reader, ParsedLine parsedLine, List<Candidate> candidates) {
        String firstWord;
        List words = parsedLine.words();
        if (words.isEmpty()) {
            return;
        }
        switch (firstWord = ((String)words.get(0)).trim().toLowerCase()) {
            case "@": 
            case "!": 
            case "@@": 
            case "start": 
            case "host": 
            case "load": 
            case "cd": 
            case "get": 
            case "save": 
            case "store": {
                return;
            }
        }
        int numWords = words.size();
        if (parsedLine.wordIndex() == numWords - 1) {
            String lastWord;
            String string = lastWord = numWords > 0 ? (String)words.get(numWords - 1) : null;
            if (lastWord == null || lastWord.equals("\n/") || lastWord.equals("\n.")) {
                return;
            }
        }
        String lastLine = parsedLine.line();
        int cursor = parsedLine.cursor();
        String colCompleteKey = "coloredComplete";
        String colComplete = HiddenParameters.parameters.get("coloredComplete");
        if (colComplete == null && this._ctx != null) {
            if ("ON".equals(this._ctx.getProperty("script.runner.color.coding"))) {
                colComplete = "true";
                HiddenParameters.parameters.put("coloredComplete", colComplete);
            }
        }
        try {
            String secondWord;
            if ("true".equals(HiddenParameters.parameters.get("debugComplete"))) {
                System.out.println("\u001b[32m");
                System.out.println("lastLine=" + lastLine + "");
                System.out.println("cursor=" + cursor);
            }
            String line = "";
            int pos = cursor;
            if (this._ctx != null) {
                line = parsedLine.line();
                pos = parsedLine.cursor();
            } else {
                line = lastLine;
            }
            if ("true".equals(HiddenParameters.parameters.get("debugComplete"))) {
                System.out.println("line=" + line);
                System.out.println("pos=" + pos);
            }
            CompletionList insight = this.complete(this.stripContinuationChars(parsedLine), pos);
            String string = secondWord = numWords > 1 ? (String)words.get(1) : null;
            if (secondWord != null && firstWord.equals("connect") && secondWord.endsWith("@")) {
                for (CompletionItem item : insight.entries) {
                    candidates.add(new Candidate(secondWord + item.entry, item.entry, null, null, null, null, true));
                }
            } else {
                for (CompletionItem item : insight.entries) {
                    candidates.add(new Candidate(item.entry));
                }
            }
            if (candidates.size() == 1 && 0 < candidates.get(0).toString().indexOf(32)) {
                return;
            }
            if (candidates.size() == 1) {
                String cleaned = null;
                for (Candidate c : candidates) {
                    cleaned = c.value();
                    cleaned = SqlclCompleter.discolor(cleaned);
                }
                candidates.clear();
                candidates.add(new Candidate(cleaned));
            }
            int ret = cursor;
            if (insight.prefix != null) {
                ret -= insight.prefix.content.length();
            }
            if ("true".equals(HiddenParameters.parameters.get("debugComplete"))) {
                System.out.println("return=" + ret + "\u001b[0m");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static String discolor(String cleaned) {
        cleaned = cleaned.replace("\u001b[0m", "");
        cleaned = cleaned.replace("\u001b[1m", "");
        cleaned = cleaned.replace("\u001b[32m", "");
        return cleaned;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = null;
        conn = this._ctx != null ? this._ctx.getBaseConnection() : DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521/PDB1", "SODA_PLAN", "dbtools");
        return conn;
    }

    private String stripContinuationChars(ParsedLine parsedLine) {
        String treatedLine = parsedLine.line();
        ISQLCommand cmd = ParseUtil.parseLast(String.join((CharSequence)" ", parsedLine.words()));
        if (cmd != null && cmd.getStmtType() == SQLCommand.StmtType.G_C_SQLPLUS) {
            treatedLine = treatedLine.replace("-\n", "  ");
        }
        return treatedLine;
    }

    public static void main(String[] args) throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521/xe", "hr", "hr");
        ScriptRunnerContext ctx = new ScriptRunnerContext();
        ctx.setBaseConnection(conn);
        SqlclCompleter c = new SqlclCompleter(ctx);
        String text = "sel!";
        final int pos = text.indexOf("!");
        final String input = text.replace("!", "");
        System.out.println("pos=" + pos);
        CompletionList candidates = c.complete(input, pos);
        System.out.println(candidates.toString());
        ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes());
        ByteArrayOutputStream os = new ByteArrayOutputStream(1000);
        LinkedList<Candidate> candidates2 = new LinkedList<Candidate>();
        LineReaderImpl lineReader = new LineReaderImpl((Terminal)new DumbTerminal((InputStream)is, (OutputStream)os));
        ParsedLine parsedLine = new ParsedLine(){

            public int cursor() {
                return pos;
            }

            public String line() {
                return input;
            }

            public String word() {
                return null;
            }

            public int wordCursor() {
                return 0;
            }

            public int wordIndex() {
                return 0;
            }

            public List<String> words() {
                return null;
            }
        };
        c.complete(lineReader, parsedLine, candidates2);
        System.out.println(((Object)candidates2).toString());
    }
}

