/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extract.models;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.ddl.DDLGenerator;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.common.utils.DBURLUtil;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.extract.ExtractReconciler;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObjectSqlModel;
import oracle.dbtools.extract.models.ExtractScript;
import oracle.dbtools.extract.models.ExtractSqlHandler;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.writers.ImportGenFile;
import oracle.dbtools.importer.writers.ImportGenHelper;

public class ExtractObject {
    public static String COPY_DDL = "COPY";
    public static String SCRIPT_DDL = "SCRIPT";
    public static final int TYPE_DBO = 0;
    public static final int TYPE_QUERY = 1;
    public static final int TYPE_PRESCRIPT = 2;
    public static final int TYPE_POSTSCRIPT = 3;
    public static final int TYPE_DATA_FILE = 4;
    public static final String QUOTE_DELIMITER = "\"";
    private boolean _isExtractMeta = false;
    private boolean _isExtractData = false;
    private boolean _isPreSelected = false;
    private boolean _isSelectedMeta = false;
    private boolean _isSelectedData = false;
    private boolean _isSelectedFile = false;
    private boolean _isDataObject = false;
    private boolean _isDataPrepared = false;
    private boolean _isExistsSource = false;
    private boolean _isExistsDest = false;
    private boolean _isReconciledDest = false;
    private ExtractListModel _listModel;
    private ExtractObjectSqlModel _sqlModel;
    private int _type = 0;
    private BasicDBObject _dbo;
    private URL _url;
    private URL _configUrl;
    private String _sourceConnName = "";
    private String _destConnName = "";
    private String _sourceConnUser = "";
    private String _destConnUser = "";
    private boolean _isSourceConnOracle;
    private boolean _isSourceConnTimesTen;
    private boolean _isSourceConnHive;
    ExtractObjectSqlModel model;
    private ArrayList<String> _partitions;
    private Object _table;
    private String _tableName;
    private String _objectWhere = "";
    private HashMap<Integer, ExtractScript> _scriptList;
    private HashMap<String, Object> _extendedProperties = new HashMap();
    private ArrayList<String> _destConstraints;
    private DDLGenerator _gen = DDLGenerator.getInstance();
    private ImportProperties _iProps;
    private ImportGenFile _genFile;
    private ArrayList<String> _virtualColumns;

    public ExtractObject(URL url, ExtractListModel listModel) {
        this.init(listModel);
        this._url = url;
        if (url != null && !url.getProtocol().equals("file") && !url.getProtocol().equals("https")) {
            this._dbo = new BasicDBObject(url);
            this._sourceConnName = this._dbo.getConnectionName();
        } else {
            this._type = 4;
            if (url != null) {
                if (url.toString().endsWith(".sdimp")) {
                    try {
                        this._iProps = ImportGenHelper.getConfig(this._configUrl);
                        if (this._iProps != null) {
                            String dataFilePath = (String)this._iProps.get(ImportKeys.FILE_PATH);
                            this._url = new File(dataFilePath).toURI().toURL();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this._listModel != null) {
                    this._listModel.getReconciler();
                    this.isExistsSource(ExtractReconciler.reconcileExistence(this));
                }
            }
        }
    }

    public ExtractObject(BasicDBObject dbo, ExtractListModel listModel) {
        this.init(listModel);
        this._dbo = dbo;
        this._sourceConnName = this._dbo.getConnectionName();
        this._url = this._dbo.getURL();
    }

    public ExtractObject(Object table, ExtractListModel listModel) {
        this.init(listModel);
        this._table = table;
        this._tableName = this.getInternalTableName();
        this._type = 1;
    }

    public ExtractObject(int type, ExtractListModel listModel) {
        this.init(listModel);
        this._type = type;
    }

    private ExtractObject() {
    }

    public void setListModel(ExtractListModel listModel) {
        this._listModel = listModel;
        if (listModel != null) {
            this._gen.setFormating(this._listModel.getDDLFormat());
        }
    }

    public ExtractObjectSqlModel getSqlModel() {
        return this._sqlModel;
    }

    public void setSqlModel(ExtractObjectSqlModel sqlModel) {
        this._sqlModel = sqlModel;
    }

    public void setDBObjectForMetaData(BasicDBObject value) {
        this._dbo = value;
    }

    public String getObjectType() {
        if (this._dbo == null) {
            return "";
        }
        return this._dbo.getObjectType();
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
    }

    public boolean isTypeScript() {
        return this._type == 2 || this._type == 3;
    }

    public boolean isExistsSource() {
        return this._isExistsSource;
    }

    public void isExistsSource(boolean isExistsSource) {
        this._isExistsSource = isExistsSource;
        if (isExistsSource) {
            this.setSourceConnName(this._sourceConnName);
        } else {
            this._isDataPrepared = false;
        }
    }

    public boolean isExistsDest() {
        return this._isExistsDest;
    }

    public void isExistsDest(boolean isExistsDest) {
        this._isExistsDest = isExistsDest;
    }

    public boolean isReconciledDest() {
        return this._isReconciledDest;
    }

    public void isReconciledDest(boolean isReconciledDest) {
        this._isReconciledDest = isReconciledDest;
    }

    public String getDDL(int type) {
        return this.getDDL(type, SCRIPT_DDL);
    }

    public String getDDL(int type, String metaType) {
        switch (type) {
            case 0: {
                return this.getDDLCreate(metaType);
            }
            case 1: {
                return this.getDDLCreate(metaType);
            }
            case 2: {
                return this.getDDLCreate(metaType);
            }
            case 3: {
                return this.getDDLCreate(metaType);
            }
            case 4: {
                return this.getDDLDrop();
            }
            case 5: {
                return this.getDDLTruncate();
            }
            case 7: {
                return this.getDDLDisableConstraints();
            }
            case 6: {
                return this.getDDLEnableConstraints();
            }
        }
        return new String("");
    }

    public HashMap<Integer, ExtractScript> getScripts() {
        if (this._scriptList == null) {
            this._scriptList = new HashMap();
        }
        return this._scriptList;
    }

    public boolean isIncludeScripts() {
        return this._scriptList != null && !this._scriptList.isEmpty();
    }

    public void addScript(String path, String encoding, int executeWhen, boolean isSelectedFile) {
        this.getScripts().put(executeWhen, new ExtractScript(path, encoding, executeWhen, isSelectedFile));
    }

    public void addScript(String path, String encoding, String executeWhen, boolean isSelectedFile) {
        this.getScripts().put(ExtractScript.getExecuteWhen(executeWhen), new ExtractScript(path, encoding, ExtractScript.getExecuteWhen(executeWhen), isSelectedFile));
    }

    public void addScript(ExtractScript script) {
        this.getScripts().put(script.getExecuteWhen(), script);
    }

    public ExtractScript getScript(int executeWhen) {
        return this.getScripts().get(executeWhen);
    }

    public boolean isScriptError() {
        boolean isScriptError = false;
        ExtractScript script = this.getScripts().get(110);
        if (this._isExtractMeta && script != null && script.isSelectedFile() && !new File(script.getPath()).isFile()) {
            isScriptError = true;
        }
        script = this.getScripts().get(111);
        if (this._isExtractMeta && script != null && script.isSelectedFile() && !new File(script.getPath()).isFile()) {
            isScriptError = true;
        }
        script = this.getScripts().get(112);
        if (this._isExtractData && script != null && script.isSelectedFile() && !new File(script.getPath()).isFile()) {
            isScriptError = true;
        }
        script = this.getScripts().get(113);
        if (this._isExtractData && script != null && script.isSelectedFile() && !new File(script.getPath()).isFile()) {
            isScriptError = true;
        }
        script = this.getScripts().get(114);
        if (this._type == 2 && script != null && script.isSelectedFile() && !new File(script.getPath()).isFile()) {
            isScriptError = true;
        }
        script = this.getScripts().get(115);
        if (this._type == 3 && script != null && script.isSelectedFile() && !new File(script.getPath()).isFile()) {
            isScriptError = true;
        }
        return isScriptError;
    }

    public String getTip() {
        if (this.isTypeDBO()) {
            return this.getDBOTip();
        }
        if (this.isTypeScript()) {
            return this.getScriptTip();
        }
        if (this.isTypeDataFile()) {
            return this.getFileTip();
        }
        return "";
    }

    public String getScriptTip() {
        boolean isValid;
        StringBuffer ids = new StringBuffer();
        ExtractScript script = this.getScripts().get(110);
        String separator = "<html>";
        String err = " " + ExtractResources.getString("ERROR");
        Object[] valid = new Object[]{new String("")};
        if (this._isExtractMeta && script != null && script.isSelectedFile()) {
            isValid = new File(script.getPath()).isFile();
            ids.append(separator + ExtractResources.getString("BEFORE_CREATE") + (isValid ? "" : err) + ": " + script.getPath());
            separator = "<br>";
        }
        script = this.getScripts().get(111);
        if (this._isExtractMeta && script != null && script.isSelectedFile()) {
            isValid = new File(script.getPath()).isFile();
            ids.append(separator + ExtractResources.getString("AFTER_CREATE") + (isValid ? "" : err) + ": " + script.getPath());
            separator = "<br>";
        }
        script = this.getScripts().get(112);
        if (this._isExtractData && script != null && script.isSelectedFile()) {
            isValid = new File(script.getPath()).isFile();
            ids.append(separator + ExtractResources.getString("BEFORE_LOAD") + (isValid ? "" : err) + ": " + script.getPath());
            separator = "<br>";
        }
        script = this.getScripts().get(113);
        if (this._isExtractData && script != null && script.isSelectedFile()) {
            isValid = new File(script.getPath()).isFile();
            ids.append(separator + ExtractResources.getString("AFTER_LOAD") + (isValid ? "" : err) + ": " + script.getPath());
            separator = "<br>";
        }
        script = this.getScripts().get(114);
        if (this._type == 2 && script != null && script.isSelectedFile()) {
            isValid = new File(script.getPath()).isFile();
            ids.append(separator + ExtractResources.getString("INITIAL") + (isValid ? "" : err) + ": " + script.getPath());
            separator = "<br>";
        }
        script = this.getScripts().get(115);
        if (this._type == 3 && script != null && script.isSelectedFile()) {
            isValid = new File(script.getPath()).isFile();
            ids.append(separator + ExtractResources.getString("FINAL") + (isValid ? "" : err) + ": " + script.getPath());
            separator = "<br>";
        }
        if (ids.length() > 0) {
            ids.append("</html>");
        }
        return ids.toString().trim();
    }

    public int[][] getScriptErrorRanges() {
        Vector ranges = new Vector();
        int[][] rtn = new int[ranges.size()][2];
        return rtn;
    }

    public void clearScripts() {
        this.getScripts().clear();
    }

    public void dropScript(int executeWhen) {
        this.getScripts().remove(executeWhen);
    }

    public String getFileTip() {
        boolean isValid = true;
        String err = " " + ExtractResources.getString("ERROR");
        if (this.isTypeDataFileLocal()) {
            File file = new File(this._url.getPath());
            isValid = file.isFile();
        }
        return isValid ? this._url.toExternalForm() : err + ": " + this._url.toExternalForm();
    }

    public ImportGenFile getGenFile() {
        if (this._genFile == null) {
            this._genFile = new ImportGenFile();
            this._genFile.start(this);
        }
        return this._genFile;
    }

    public ImportProperties getImportProperties() {
        return this._iProps;
    }

    public void setImportProperties(ImportProperties iProps) {
        this._iProps = iProps;
    }

    public String getDBOTip() {
        if (this._sourceConnName != null) {
            Properties srcConnInfo = ConnectionResolver.getConnectionInfo((String)this._sourceConnName);
            return srcConnInfo == null ? "" : srcConnInfo.getProperty("customUrl");
        }
        return "";
    }

    public Object getPropertyValue(String propertyKey) {
        return this._extendedProperties.get(propertyKey);
    }

    public void setProperty(String propertyKey, Object propertyValue) {
        this._extendedProperties.put(propertyKey, propertyValue);
    }

    public Set<String> getPropertyKeySet() {
        return this._extendedProperties.keySet();
    }

    public void isExtractMetaData(boolean isExtractMeta) {
        this._isExtractMeta = isExtractMeta;
    }

    public boolean isExtractMetaData() {
        return this._isExtractMeta;
    }

    public void isExtractData(boolean isExtractData) {
        this._isExtractData = isExtractData;
    }

    public boolean isExtractData() {
        return this._isExtractData;
    }

    public void isPreSelected(boolean isPreSelected) {
        this._isPreSelected = isPreSelected;
    }

    public boolean isPreSelected() {
        return this._isPreSelected;
    }

    public void isSelectedMetaData(boolean isSelectedMeta) {
        this._isSelectedMeta = isSelectedMeta;
    }

    public boolean isSelectedMetaData() {
        return this._isSelectedMeta;
    }

    public void isSelectedData(boolean isSelectedData) {
        this._isSelectedData = isSelectedData;
    }

    public boolean isSelectedData() {
        return this._isSelectedData;
    }

    public void isSelectedFile(boolean isSelectedFile) {
        this._isSelectedFile = isSelectedFile;
    }

    public boolean isSelectedFile() {
        return this._isSelectedFile;
    }

    public void isDataObject(boolean isDataObject) {
        this._isDataObject = isDataObject;
    }

    public boolean isDataObject() {
        return this._isDataObject;
    }

    public boolean isTypeDBO() {
        return this._type == 0;
    }

    public boolean isTypeDataFile() {
        return this._type == 4;
    }

    public boolean isTypeDataFileLocal() {
        return this._type == 4 && this._url != null && this._url.getProtocol().equals("file");
    }

    public boolean isTypeDataFileExternalTable() {
        if (this._type == 4 && this._iProps != null) {
            return this._iProps.getValueInteger(ImportKeys.LOAD_METHOD) == 2;
        }
        return false;
    }

    public void isDataPrepared(boolean isDataPrepared) {
        this._isDataPrepared = isDataPrepared;
    }

    public boolean isDataPrepared() {
        return this._isDataPrepared;
    }

    public URL getUrl() {
        return this._url;
    }

    public void setUrl(URL value) {
        this._url = value;
    }

    public URL getConfigUrl() {
        return this._configUrl;
    }

    public void setConfigUrl(URL value) {
        this._configUrl = value;
    }

    public String getSourceConnName() {
        return this._sourceConnName;
    }

    private String getConnectionUser(String connName) {
        return this._listModel.getConnectionUser(connName);
    }

    public void setSourceConnName(String value) {
        this._sourceConnName = value;
        if (this._sourceConnName != null & this._sourceConnName.length() > 0) {
            Connection conn = this.getSourceConn();
            this._isSourceConnOracle = ConnectionResolver.isOracle((Connection)conn);
            this._isSourceConnTimesTen = ConnectionResolver.isTimesTen((Connection)conn);
            if (!ConnectionResolver.isOracle((Connection)conn)) {
                Properties connDetails = ConnectionResolver.getConnectionInfo((String)this._sourceConnName);
                String subType = connDetails.getProperty("subtype");
                this._isSourceConnHive = subType.equals("Hive");
            }
        }
    }

    public boolean isSourceConnOracle() {
        return this._isSourceConnOracle;
    }

    public boolean isSourceConnTimesTen() {
        return this._isSourceConnTimesTen;
    }

    public boolean isSourceConnHive() {
        return this._isSourceConnHive;
    }

    public void setSourceConnUserName() {
        if (this._sourceConnName != null & this._sourceConnName.length() > 0 && this.getSourceConn() != null) {
            try {
                this._sourceConnUser = this.getConnectionUser(this._sourceConnName);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    public void mapSourceConnection(String newConnName) {
        String dbName = newConnName;
        URL url = DBURLUtil.getURL((String)"sqldev.nav", (String)dbName, null, (String)this._dbo.getSchemaName(), (String)this._dbo.getObjectType(), (String)this._dbo.getObjectName());
        this._dbo = new BasicDBObject(url);
        this.setSourceConnName(newConnName);
        this.setSourceConnUserName();
        this._listModel.getReconciler();
        this.isExistsSource(ExtractReconciler.reconcileExistence(this));
        this._isDataPrepared = false;
    }

    public Connection getSourceConn() {
        try {
            return ConnectionResolver.getConnection((String)this._sourceConnName);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return null;
        }
    }

    public String getSourceConnUser(boolean quote) {
        if (this._sourceConnUser.length() == 0) {
            this.setSourceConnUserName();
        }
        return quote ? QUOTE_DELIMITER + this._sourceConnUser + QUOTE_DELIMITER : this._sourceConnUser;
    }

    public String getDestConnName() {
        return this._destConnName;
    }

    public void setDestConnName(String value) {
        this._destConnName = value;
    }

    public void setDestConnUserName() {
        if (this._destConnName != null & this._destConnName.length() > 0) {
            try {
                this._destConnUser = this.getConnectionUser(this._destConnName);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    public Connection getDestConn() {
        try {
            return ConnectionResolver.getConnection((String)this._destConnName);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return null;
        }
    }

    public String getDestConnUser(boolean quote) {
        if (this._destConnUser.length() == 0) {
            this.setDestConnUserName();
        }
        return quote ? QUOTE_DELIMITER + this._destConnUser + QUOTE_DELIMITER : this._destConnUser;
    }

    public boolean isOtherUser() {
        return !this._listModel.getSourceConnUser().equals(this._dbo.getSchemaName());
    }

    public ExtractListModel getListModel() {
        return this._listModel;
    }

    private void dataPrepare() {
        try {
            if (ConnectionResolver.getConnection((String)this._sourceConnName) == null) {
                return;
            }
            this._isDataPrepared = true;
            this.setSqlModel(new ExtractObjectSqlModel(this));
            ExtractSqlHandler.dataPrepare(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getColumns() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._sqlModel.getColumns();
    }

    public void setColumns(String value) {
        this._sqlModel.setColumns(value);
    }

    public ArrayList<String> getPartitions() {
        if (this._partitions == null) {
            this._partitions = new ArrayList();
        }
        return this._partitions;
    }

    public void setPartitions(ArrayList<String> value) {
        this._partitions = value;
    }

    public String getWhereString() {
        return this._objectWhere;
    }

    public String getWhere() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._objectWhere;
    }

    public void setWhere(String value) {
        int whereIdx = value.trim().toLowerCase().indexOf("where");
        this._objectWhere = whereIdx != 0 ? value : value.substring(whereIdx + 6);
    }

    public String getSql() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._sqlModel.getSql();
    }

    public String getFinalSQL() {
        String finalWhere = this.getFinalWhere();
        return finalWhere.length() > 0 ? this.getSql() + " " + this.getFinalWhere() : this.getSql();
    }

    public String getFinalWhere() {
        String ret = this._objectWhere;
        if (this._listModel.getGlobalWhere().length() != 0) {
            if (ret.length() != 0) {
                ret = ret + " and ";
            }
            ret = ret + this._listModel.getGlobalWhere();
        }
        return ret.length() > 0 ? " where " + ret : ret;
    }

    public void setSql(String value) {
        this._sqlModel.setSql(value);
    }

    public String getRawSql() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._sqlModel.getRawSql();
    }

    public void setRawSql(String value) {
        this._sqlModel.setRawSql(value);
    }

    public boolean isEmptySelect() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._listModel.isAllowLobs() ? this._sqlModel.isLobsEmptySelect() : this._sqlModel.isNoLobsEmptySelect();
    }

    public boolean isExcludedColumns() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._sqlModel.getColumns() != "*" ? true : (this._listModel.isAllowLobs() ? this._sqlModel.isLobsExcludedColumns() : this._sqlModel.isNoLobsExcludedColumns());
    }

    public boolean isSqlExtendable() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._sqlModel.isSqlExtendable();
    }

    public String getSqlForVisibleCols() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._sqlModel.getColumns() != "*" ? "select " + this._sqlModel.getColumns() + this.calculateFrom(this._sqlModel.getSql()) : this._sqlModel.getSql();
    }

    public List<?> getBindList() {
        return this._sqlModel.getBindList();
    }

    public void setBindList(List<?> value) {
        this._sqlModel.setBindList(value);
    }

    public Map<String, ?> getBindMap() {
        return this._sqlModel.getBindMap();
    }

    public void setBindMap(Map<String, ?> value) {
        this._sqlModel.setBindMap(value);
    }

    public Object getTable() {
        return this._table;
    }

    public void setTable(Object table) {
        this._table = table;
    }

    public boolean isTableDirty() {
        return ExtractSqlHandler.isTableDirty(this);
    }

    public String getTableName() {
        if (this._dbo != null) {
            ExtractDataFormat dataFormat = this._listModel.getDataFormat();
            if (dataFormat != null && dataFormat.getShowSchema()) {
                if (dataFormat.getSchema()) {
                    return DBUtil.addDoubleQuote((String)this._dbo.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)this._dbo.getObjectName());
                }
                return DBUtil.addDoubleQuote((String)this._dbo.getObjectName());
            }
            if (this._listModel.getDDLFormat() != null && this._listModel.getDDLFormat().getSchema()) {
                return DBUtil.addDoubleQuote((String)this._dbo.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)this._dbo.getObjectName());
            }
            return DBUtil.addDoubleQuote((String)this._dbo.getObjectName());
        }
        if (this._tableName != null && this._tableName.startsWith(QUOTE_DELIMITER) && this._tableName.endsWith(QUOTE_DELIMITER)) {
            return this._tableName;
        }
        return this._tableName != null ? this._tableName.toUpperCase() : this._tableName;
    }

    public String getExternalTableName() {
        String objectName = "";
        if (this.isTypeDataFile()) {
            objectName = this.getTableName();
            objectName = objectName != null && objectName.startsWith(QUOTE_DELIMITER) && objectName.endsWith(QUOTE_DELIMITER) ? objectName.substring(1, objectName.length() - 1) : objectName.toUpperCase();
        } else if (this._dbo != null) {
            objectName = this._dbo.getObjectName();
        }
        return objectName;
    }

    public void setTableName(String value) {
        this._tableName = value;
    }

    public boolean isInList(List<ExtractObject> eoList) {
        for (ExtractObject eo : eoList) {
            if (!this.equals(eo)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(ExtractObject eo) {
        return this._type == eo._type && this._url.equals(eo._url);
    }

    public BasicDBObject getDBObject() {
        return this._dbo;
    }

    public String getDisplayName(boolean qual) {
        if (this._dbo != null) {
            String name = this._dbo.getObjectName();
            if (this._dbo.isObjectFolderType()) {
                name = DDLTypes.getFolderName(this._dbo.getObjectFolderType()) + " " + ExtractResources.getString("FOLDER");
            }
            return qual ? ConnectionResolver.getDisplayName((String)this._dbo.getConnectionName()) + "." + this._dbo.getSchemaName() + "." + name : this._dbo.getSchemaName() + "." + name;
        }
        if (this._table != null && this._tableName != null) {
            return this._tableName;
        }
        return "";
    }

    public String calculateFrom(String inSql) {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        if (this._isSourceConnOracle || this._isSourceConnTimesTen || this._isSourceConnHive) {
            return " from (" + inSql + ")";
        }
        return " from (" + inSql + ") as t";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ArrayList<String> identifyVirtualColumns() {
        if (this._virtualColumns == null) {
            this._virtualColumns = new ArrayList();
            HashMap<String, String> binds = new HashMap<String, String>();
            ResultSet rset = null;
            binds.put("OWNER", this._dbo.getSchemaName());
            binds.put("TAB", this._dbo.getObjectName());
            String COLUMN_OBJECT = "select column_name from sys.all_tab_cols \nWHERE hidden_column = 'NO' and virtual_column='YES' \n and table_name = :TAB and owner = :OWNER";
            Connection conn = this._dbo.getConnection();
            if (LockManager.lock((Connection)conn)) {
                try {
                    rset = DBUtil.getInstance((Connection)conn).executeQuery(COLUMN_OBJECT, binds);
                    while (rset.next()) {
                        this._virtualColumns.add(rset.getString(1));
                    }
                }
                catch (Exception exception) {
                    DBUtil.closeResultSet(rset);
                    LockManager.unlock((Connection)conn);
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(rset);
                        LockManager.unlock((Connection)conn);
                        throw throwable;
                    }
                }
                DBUtil.closeResultSet((ResultSet)rset);
                LockManager.unlock((Connection)conn);
            }
        }
        return this._virtualColumns;
    }

    public boolean isColumnVirtual(String colName) {
        this.identifyVirtualColumns();
        return this._virtualColumns.contains(colName);
    }

    private String getInternalTableName() {
        return ExtractSqlHandler.getInternalTableName(this);
    }

    private String getDDLCreate(String metaType) {
        StringBuilder sb = new StringBuilder();
        this.setListModel(this._listModel);
        try {
            if (metaType.equals(COPY_DDL)) {
                this.addSql(sb, "set define off;" + this.getTerm(), false);
                boolean isQuoteSchemaDot = this._dbo.getObjectType().equals("QUEUE TABLE") || this._dbo.getObjectType().equals("QUEUE");
                String sql = this._gen.getCopyDDL(this._dbo);
                this.addSql(sb, sql, isQuoteSchemaDot);
            } else if (this.isTypeDataFile() && this._iProps != null && !this._iProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE).booleanValue()) {
                this.addSql(sb, ImportGenFile.getDDL(this), false);
            } else if (this._dbo.getObjectType().equals("TABLE") && this._listModel.getDDLTypes().getTableDeps()) {
                this.addSql(sb, this._gen.getDDL(this._dbo, "DEP"), false);
                if (this._listModel.getDDLFormat().getGrant()) {
                    this.addSql(sb, this._gen.getGrants(this._dbo), false);
                }
            } else {
                boolean isQuoteSchemaDot = this._dbo.getObjectType().equals("QUEUE TABLE") || this._dbo.getObjectType().equals("QUEUE");
                String sql = this._gen.getScriptDDL(this._dbo);
                sql = sql.trim();
                if (this._listModel.getDDLFormat().getTerminator()) {
                    if (sql != null && sql.length() > 0 && sql.lastIndexOf("/") == sql.length() - 1) {
                        String sql2 = sql.substring(0, sql.lastIndexOf("/"));
                        sql = sql2 + this.getTerm() + "/" + this.getTerm();
                    } else if (this._dbo.getObjectType().equals("QUEUE TABLE") || this._dbo.getObjectType().equals("QUEUE")) {
                        sql = sql + this.getTerm() + "/" + this.getTerm();
                    }
                }
                this.addSql(sb, sql, isQuoteSchemaDot);
                if (this._listModel.getDDLFormat().getGrant()) {
                    this.addSql(sb, this._gen.getGrants(this._dbo), isQuoteSchemaDot);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return sb.toString().trim();
    }

    private String getDDLDrop() {
        StringBuilder sb = new StringBuilder();
        if (this.isTypeDataFile() && this._listModel.getDDLFormat().getCascade()) {
            sb.append("  DROP TABLE " + this.getTableName() + " cascade constraints;" + this.getTerm());
            return sb.toString();
        }
        if (this.isTypeDataFile()) {
            sb.append("  DROP TABLE " + this.getTableName() + ";" + this.getTerm());
            return sb.toString();
        }
        String name = QUOTE_DELIMITER + this._dbo.getObjectName() + QUOTE_DELIMITER;
        if (this._listModel.getDDLFormat().getSchema()) {
            name = QUOTE_DELIMITER + this._dbo.getSchemaName() + "\".\"" + this._dbo.getObjectName() + QUOTE_DELIMITER;
        }
        if (this._dbo.getObjectType().equals("MATERIALIZED VIEW LOG")) {
            sb.append("  DROP " + this._dbo.getObjectType() + " on " + name + ";" + this.getTerm());
        } else if (this._dbo.getObjectType().equals("TABLE") && this._listModel.getDDLFormat().getCascade()) {
            sb.append("  DROP " + this._dbo.getObjectType() + " " + name + " cascade constraints;" + this.getTerm());
        } else if (this._dbo.getObjectType().equals("TABLE")) {
            sb.append("  DROP " + this._dbo.getObjectType() + " " + name + ";" + this.getTerm());
        } else if (this._dbo.getObjectType().equals("QUEUE")) {
            sb.append("begin" + this.getTerm() + "DBMS_AQADM.DROP_QUEUE(queue_name=>'" + this._dbo.getObjectName() + "', auto_commit=>TRUE);" + this.getTerm() + "end;" + this.getTerm() + "/" + this.getTerm());
        } else if (this._dbo.getObjectType().equals("QUEUE TABLE")) {
            sb.append("begin" + this.getTerm() + "DBMS_AQADM.DROP_QUEUE_TABLE(queue_table=>'" + this._dbo.getObjectName() + "', force=>TRUE);" + this.getTerm() + "end;" + this.getTerm() + "/" + this.getTerm());
        } else {
            sb.append("  DROP " + this._dbo.getObjectType() + " " + name + ";" + this.getTerm());
        }
        return sb.toString();
    }

    private String getDDLTruncate() {
        StringBuilder sb = new StringBuilder();
        if (this.isTypeDataFile()) {
            sb.append("  TRUNCATE TABLE " + this.getTableName() + ";" + this.getTerm());
            return sb.toString();
        }
        String name = QUOTE_DELIMITER + this._dbo.getObjectName() + QUOTE_DELIMITER;
        if (this._listModel.getDDLFormat().getSchema()) {
            name = QUOTE_DELIMITER + this._dbo.getSchemaName() + "\".\"" + this._dbo.getObjectName() + QUOTE_DELIMITER;
        }
        if (this._dbo.getObjectType().equals("TABLE")) {
            sb.append("  TRUNCATE " + this._dbo.getObjectType() + " " + name + ";" + this.getTerm());
        }
        return sb.toString();
    }

    private String getDDLDisableConstraints() {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.getConstraintSQL("DISABLE"));
        return sb.toString();
    }

    private String getDDLEnableConstraints() {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.getConstraintSQL("ENABLE"));
        return sb.toString();
    }

    private StringBuilder getConstraintSQL(String action) {
        StringBuilder sb = new StringBuilder();
        Connection conn = this._listModel.getDestConn();
        String user = "";
        if (conn != null) {
            user = this._listModel.getDestConnUser();
            if (this._destConstraints == null) {
                this._destConstraints = this.getObjectConstraints(conn);
            }
            String name = QUOTE_DELIMITER + this._dbo.getObjectName() + QUOTE_DELIMITER;
            if (this._listModel.getDDLFormat().getSchema()) {
                name = QUOTE_DELIMITER + user + "\".\"" + this._dbo.getObjectName() + QUOTE_DELIMITER;
            }
            for (String constraintName : this._destConstraints) {
                if (!this._dbo.getObjectType().equals("TABLE")) continue;
                sb.append("alter table " + name + " " + action + " constraint \"" + constraintName + "\";" + this.getTerm());
            }
            return sb;
        }
        String sql = "";
        String objectName = "";
        if (this._dbo != null) {
            user = this._dbo.getSchemaName();
            objectName = this._dbo.getObjectName();
        } else if (this._tableName != null) {
            objectName = this._tableName;
        }
        sql = this._listModel.getDDLFormat().getSchema() && user != null && !user.isEmpty() ? "begin" + this.getTerm() + "for cur in (select owner, constraint_name , table_name" + this.getTerm() + "from all_constraints" + this.getTerm() + "where owner = '" + user + "'" + this.getTerm() + "and constraint_type = 'R'" + this.getTerm() + "and TABLE_NAME = '" + objectName + "' )" + this.getTerm() + "loop" + this.getTerm() + "execute immediate 'ALTER TABLE '||cur.owner||'.'||cur.table_name||' MODIFY CONSTRAINT \"'||cur.constraint_name||'\" " + action + " ';" + this.getTerm() + "end loop;" + this.getTerm() + "end;" + this.getTerm() : "begin" + this.getTerm() + "for cur in (select constraint_name , table_name" + this.getTerm() + "from user_constraints" + this.getTerm() + "where constraint_type = 'R'" + this.getTerm() + "and TABLE_NAME = '" + objectName + "' )" + this.getTerm() + "loop" + this.getTerm() + "execute immediate 'ALTER TABLE '||cur.table_name||' MODIFY CONSTRAINT \"'||cur.constraint_name||'\" " + action + " ';" + this.getTerm() + "end loop;" + this.getTerm() + "end;" + this.getTerm();
        sb.append(sql);
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArrayList<String> getObjectConstraints(Connection conn) {
        ArrayList<String> constraints = new ArrayList<String>();
        HashMap<String, String> binds = new HashMap<String, String>();
        ResultSet rset = null;
        binds.put("NAME", this._dbo.getObjectName());
        String CONSTRAINT_OBJECT = "select constraint_name from user_constraints where constraint_type = 'R' and table_name =:NAME ";
        if (LockManager.lock((Connection)conn)) {
            try {
                rset = DBUtil.getInstance((Connection)conn).executeQuery(CONSTRAINT_OBJECT, binds);
                while (rset.next()) {
                    constraints.add(rset.getString(1));
                }
            }
            catch (Exception exception) {
                DBUtil.closeResultSet(rset);
                LockManager.unlock((Connection)conn);
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(rset);
                    LockManager.unlock((Connection)conn);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)rset);
            LockManager.unlock((Connection)conn);
        }
        return constraints;
    }

    private void addSql(StringBuilder sb, String sql, boolean isQuoteSchemaDot) {
        if (sql.length() < 1) {
            return;
        }
        if (this._dbo != null && !this._listModel.getDDLFormat().getSchema()) {
            sql = isQuoteSchemaDot ? sql.replaceAll("'" + this._dbo.getSchemaName() + ".", "'") : sql.replace(QUOTE_DELIMITER + this._dbo.getSchemaName() + "\".", "");
        }
        sb.append(sql);
    }

    private String getTerm() {
        return "\n";
    }

    private void init(ExtractListModel listModel) {
        this._listModel = listModel;
        if (listModel != null) {
            this._gen.setFormating(this._listModel.getDDLFormat());
            this.setSourceConnName(this._listModel.getSourceConnName());
            this.setDestConnName(this._listModel.getDestConnName());
        }
        this._sqlModel = new ExtractObjectSqlModel(this);
    }

    private void setDBObject(BasicDBObject value) {
        this._dbo = value;
        if (this._dbo != null) {
            this._url = this._dbo.getURL();
        }
    }

    private void isLobsEmptySelect(boolean value) {
        this._sqlModel.isLobsEmptySelect(value);
    }

    private void isNoLobsEmptySelect(boolean value) {
        this._sqlModel.isNoLobsEmptySelect(value);
    }

    private void isLobsExcludedColumns(boolean value) {
        this._sqlModel.isLobsExcludedColumns(value);
    }

    private void isNoLobsExcludedColumns(boolean value) {
        this._sqlModel.isNoLobsExcludedColumns(value);
    }

    private void setSqlLobs(String value) {
        this._sqlModel.setSqlLobs(value);
    }

    private void setSqlNoLobs(String value) {
        this._sqlModel.setSqlNoLobs(value);
    }

    private void isVertical(boolean value) {
        this._sqlModel.isVertical(value);
    }

    private void isSqlExtendable(boolean value) {
        this._sqlModel.isSqlExtendable(value);
    }

    private void setExtendedProperties(HashMap<String, Object> value) {
        this._extendedProperties = value;
    }

    private void setDestConstraints(ArrayList<String> value) {
        this._destConstraints = value;
    }

    public ExtractObject clone() {
        ExtractObject clone = new ExtractObject();
        clone.setSqlModel(new ExtractObjectSqlModel(clone));
        clone.isExtractMetaData(this._isExtractMeta);
        clone.isExtractData(this._isExtractData);
        clone.isPreSelected(this._isPreSelected);
        clone.isSelectedMetaData(this._isSelectedMeta);
        clone.isSelectedData(this._isSelectedData);
        clone.isDataObject(this._isDataObject);
        clone.isDataPrepared(this._isDataPrepared);
        clone.isExistsSource(this._isExistsSource);
        clone.isExistsDest(this._isExistsDest);
        clone.setListModel(this._listModel);
        clone.setType(this._type);
        clone.setDBObject(this._dbo);
        clone.setUrl(this._url);
        if (this._type == 0) {
            clone.setSourceConnName(this._sourceConnName);
            clone.setDestConnName(this._destConnName);
        } else if (this._type == 4) {
            clone.setConfigUrl(this._configUrl);
            clone.setImportProperties(this._iProps);
        }
        clone.setColumns(this._sqlModel.getColumns());
        clone.isLobsEmptySelect(this._sqlModel.isLobsEmptySelect());
        clone.isNoLobsEmptySelect(this._sqlModel.isNoLobsEmptySelect());
        clone.isLobsExcludedColumns(this._sqlModel.isLobsExcludedColumns());
        clone.isNoLobsExcludedColumns(this._sqlModel.isNoLobsExcludedColumns());
        clone.setWhere(this._objectWhere);
        clone.setTable(this._table);
        clone.setTableName(this._tableName);
        clone.setBindList(this._sqlModel.getBindList());
        clone.setBindMap(this._sqlModel.getBindMap());
        clone.setRawSql(this._sqlModel.getRawSql());
        clone.setSql(this._sqlModel.getSql());
        clone.setSqlLobs(this._sqlModel.getSqlLobs());
        clone.setSqlNoLobs(this._sqlModel.getSqlNoLobs());
        clone.isVertical(this._sqlModel.isVertical());
        clone.isSqlExtendable(this._sqlModel.isSqlExtendable());
        clone.setExtendedProperties(this._extendedProperties);
        clone.setDestConstraints(this._destConstraints);
        this.cloneScript(clone, 110);
        this.cloneScript(clone, 111);
        this.cloneScript(clone, 112);
        this.cloneScript(clone, 113);
        this.cloneScript(clone, 114);
        this.cloneScript(clone, 115);
        return clone;
    }

    private void cloneScript(ExtractObject clone, int executeWhen) {
        ExtractScript ES = this.getScript(executeWhen);
        if (ES != null) {
            clone.addScript(ES.clone());
        }
    }

    public void convertToDest() {
        this.isExistsSource(false);
        this.isExistsDest(true);
        this.setDestConnName(this._sourceConnName);
        this.setDestConnUserName();
        this.setSourceConnName("");
    }

    public String getIndent(int idx) {
        char[] indent = new char[idx];
        for (int i = 0; i < idx; ++i) {
            indent[i] = 9;
        }
        return new String(indent);
    }

    public String toXML(int indent) {
        return this.toXML(new StringBuffer(), indent).toString();
    }

    public StringBuffer toXML(StringBuffer sb, int indent) {
        if (this._type == 0) {
            sb.append(this.getIndent(indent) + "<dbobject");
            sb.append(">\n");
            sb.append(this.getIndent(indent + 1) + "<objectconnection><![CDATA[" + this._sourceConnName + "]]></objectconnection>\n");
            sb.append(this.getIndent(indent + 1) + "<objecttype><![CDATA[" + this._dbo.getObjectType() + "]]></objecttype>\n");
            sb.append(this.getIndent(indent + 1) + "<objectschema><![CDATA[" + this._dbo.getSchemaName() + "]]></objectschema>\n");
            sb.append(this.getIndent(indent + 1) + "<objectname><![CDATA[" + this._dbo.getObjectName() + "]]></objectname>\n");
            if (this._dbo.getObjectType().equals("APEX")) {
                sb.append(this.getIndent(indent + 1) + "<applicationname><![CDATA[" + this._dbo.getDictionary().get("APPLICATION_NAME").toString() + "]]></applicationname>\n");
                sb.append(this.getIndent(indent + 1) + "<workspacename><![CDATA[" + this._dbo.getDictionary().get("WORKSPACE").toString() + "]]></workspacename>\n");
            }
            if (this._isPreSelected) {
                sb.append(this.getIndent(indent + 1) + "<include><![CDATA[true]]></include>\n");
            } else {
                sb.append(this.getIndent(indent + 1) + "<include><![CDATA[false]]></include>\n");
            }
            if (this._isExtractMeta) {
                sb.append(this.getIndent(indent + 1) + "<meta><![CDATA[true]]></meta>\n");
            } else {
                sb.append(this.getIndent(indent + 1) + "<meta><![CDATA[false]]></meta>\n");
            }
            if (this._isExtractData) {
                sb.append(this.getIndent(indent + 1) + "<data><![CDATA[true]]></data>\n");
            } else {
                sb.append(this.getIndent(indent + 1) + "<data><![CDATA[false]]></data>\n");
            }
            if (this.getSql() != null && this.getSql().length() > 0) {
                sb.append(this.getIndent(indent + 1) + "<filter><![CDATA[" + this.getWhere() + "]]></filter>\n");
            }
            if (this.isIncludeScripts()) {
                sb.append(this.getIndent(indent + 1) + "<scripts");
                sb.append(">\n");
                Collection<ExtractScript> values = this.getScripts().values();
                for (ExtractScript ES : values) {
                    ES.toXML(sb, indent + 2);
                }
                sb.append(this.getIndent(indent + 1) + "</scripts>\n");
            }
            sb.append(this.getIndent(indent) + "</dbobject>\n");
        } else if (this._type == 2 || this._type == 3 || this._type == 4) {
            sb.append(this.getIndent(indent) + "<fileobject");
            sb.append(">\n");
            Integer type = this._type;
            sb.append(this.getIndent(indent + 1) + "<filetype><![CDATA[" + type.toString() + "]]></filetype>\n");
            sb.append(this.getIndent(indent + 1) + "<fileurl><![CDATA[" + this.getUrl() + "]]></fileurl>\n");
            if (this.isPreSelected()) {
                sb.append(this.getIndent(indent + 1) + "<includefile><![CDATA[true]]></includefile>\n");
            } else {
                sb.append(this.getIndent(indent + 1) + "<includefile><![CDATA[false]]></includefile>\n");
            }
            if (this._type == 4) {
                if (this.getConfigUrl() != null) {
                    sb.append(this.getIndent(indent + 1) + "<stateurl><![CDATA[" + this.getConfigUrl() + "]]></stateurl>\n");
                }
                if (this.getTableName() != null) {
                    sb.append(this.getIndent(indent + 1) + "<objectname><![CDATA[" + this.getTableName() + "]]></objectname>\n");
                }
                if (this._isExtractMeta) {
                    sb.append(this.getIndent(indent + 1) + "<meta><![CDATA[true]]></meta>\n");
                } else {
                    sb.append(this.getIndent(indent + 1) + "<meta><![CDATA[false]]></meta>\n");
                }
                if (this._isExtractData) {
                    sb.append(this.getIndent(indent + 1) + "<data><![CDATA[true]]></data>\n");
                } else {
                    sb.append(this.getIndent(indent + 1) + "<data><![CDATA[false]]></data>\n");
                }
            }
            if (this.isIncludeScripts()) {
                sb.append(this.getIndent(indent + 1) + "<scripts");
                sb.append(">\n");
                Collection<ExtractScript> values = this.getScripts().values();
                for (ExtractScript ES : values) {
                    ES.toXML(sb, indent + 2);
                }
                sb.append(this.getIndent(indent + 1) + "</scripts>\n");
            }
            sb.append(this.getIndent(indent) + "</fileobject>\n");
        }
        return sb;
    }
}

