/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.export.service;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.commands.CSCommon;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.export.ExportResources;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.importer.writers.IGenerationOutputStream;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.transfer.location.OracleOciStorageLocation;
import oracle.dbtools.transfer.location.StoreAndForwardStorageLocation;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Service;
import oracle.dbtools.util.ZipOutputHandler;

public class ExportGenerationOutputStream
implements IGenerationOutputStream {
    protected final int FLUSH_EVERY_N_WRITE = 20;
    protected int m_writeTracker = 0;
    private TargetFormat m_targetFormat;
    private ResultsFormatter m_formatter;
    private long m_linesWritten = 0L;
    private Writer m_currentWriter;
    private OutputStream m_fout;
    private OutputStream m_bout;
    private ZipOutputHandler m_zipper;
    private String m_currentObjectType = "";
    private String m_lastObjectType = "";
    private ArrayList<String> m_createdFiles;
    private String m_currentFileName;
    private String m_controllingScriptName;
    private String m_controllingHeader;
    private boolean m_isControllingFileExecutable = false;
    private String m_encoding;
    private String m_connName;
    private CloudStorageUrl m_cloudStorageUrl;
    private StoreAndForwardStorageLocation m_location;
    private StoreAndForwardStorageLocation.UserTaskListener m_listener;
    private static final TypeToFolderNameTuple[] FOLDER_NAME_MAP = new TypeToFolderNameTuple[]{new TypeToFolderNameTuple("DROP", ExportResources.getString("DROP_FOLDER")), new TypeToFolderNameTuple("VIEW", ExportResources.getString("VIEW_FOLDER")), new TypeToFolderNameTuple("TYPE", ExportResources.getString("TYPE_FOLDER")), new TypeToFolderNameTuple("TRIGGER", ExportResources.getString("TRIGGER_FOLDER")), new TypeToFolderNameTuple("TABLE", ExportResources.getString("TABLE_FOLDER")), new TypeToFolderNameTuple("SEQUENCE", ExportResources.getString("SEQUENCE_FOLDER")), new TypeToFolderNameTuple("PROCEDURE", ExportResources.getString("PROCEDURE_FOLDER")), new TypeToFolderNameTuple("PACKAGE BODY", ExportResources.getString("PACKBODY_FOLDER")), new TypeToFolderNameTuple("PACKAGE", ExportResources.getString("PACKSPEC_FOLDER")), new TypeToFolderNameTuple("MATERIALIZED VIEW", ExportResources.getString("MATVIEW_FOLDER")), new TypeToFolderNameTuple("INDEX", ExportResources.getString("INDEX_FOLDER")), new TypeToFolderNameTuple("FUNCTION", ExportResources.getString("FUNCTION_FOLDER")), new TypeToFolderNameTuple("DATABASE LINK", ExportResources.getString("DBLINK_FOLDER")), new TypeToFolderNameTuple("SYNONYM", ExportResources.getString("SYNONYM_FOLDER")), new TypeToFolderNameTuple("MATERIALIZED VIEW LOG", ExportResources.getString("MATVIEWLOG_FOLDER")), new TypeToFolderNameTuple("DIRECTORY", ExportResources.getString("DIRECTORY_FOLDER")), new TypeToFolderNameTuple("QUEUE", ExportResources.getString("QUEUE_FOLDER")), new TypeToFolderNameTuple("QUEUE TABLE", ExportResources.getString("QUEUETABLE_FOLDER")), new TypeToFolderNameTuple("CONSTRAINT", ExportResources.getString("CONSTRAINT_FOLDER")), new TypeToFolderNameTuple("REFCONSTRAINT", ExportResources.getString("REFCONSTRAINT_FOLDER")), new TypeToFolderNameTuple("BEFORE_CREATE", ExportResources.getString("SCRIPT_FOLDER")), new TypeToFolderNameTuple("AFTER_CREATE", ExportResources.getString("SCRIPT_FOLDER")), new TypeToFolderNameTuple("BEFORE_LOAD", ExportResources.getString("SCRIPT_FOLDER")), new TypeToFolderNameTuple("AFTER_LOAD", ExportResources.getString("SCRIPT_FOLDER")), new TypeToFolderNameTuple("INITIAL", ExportResources.getString("SCRIPT_FOLDER")), new TypeToFolderNameTuple("FINAL", ExportResources.getString("SCRIPT_FOLDER"))};

    public ExportGenerationOutputStream(TargetFormat targetFormat) {
        this.m_targetFormat = targetFormat;
        this.m_encoding = targetFormat.getEncoding();
    }

    public void setConnName(String connName) {
        this.m_connName = connName;
    }

    public void setControllingFileHeader(String hdrLines) {
        this.m_controllingHeader = hdrLines;
    }

    @Override
    public void startPreamble(String name) throws FileNotFoundException, UnsupportedEncodingException, MalformedURLException, IOException {
        this.m_createdFiles = new ArrayList();
        if (this.m_targetFormat.isCompressed()) {
            this.m_zipper = new ZipOutputHandler();
            this.m_zipper.setEncoding(this.m_targetFormat.getEncoding());
            String zipName = this.m_targetFormat.getSaveAs();
            File zipFile = new File(zipName);
            String zipDir = zipFile.getParent();
            this.m_zipper.openZip(zipName);
            this.m_targetFormat.setSaveAs(zipDir);
            if (this.m_targetFormat.isSingleFile()) {
                this.open(this.m_targetFormat.getControllingBaseName());
            } else {
                this.m_controllingScriptName = this.m_targetFormat.getControllingBaseName();
                this.m_targetFormat.setControllingBaseName(this.m_controllingScriptName);
            }
        } else if (this.m_targetFormat.isSingleFile() || this.m_targetFormat.isStringType() || this.m_targetFormat.isCompressed()) {
            this.open(this.m_targetFormat.getSaveAs());
        } else {
            this.m_controllingScriptName = name;
            this.m_targetFormat.setControllingBaseName(this.m_controllingScriptName);
        }
        try {
            if (this.m_targetFormat.isCloudStorage()) {
                this.m_cloudStorageUrl = new CloudStorageUrl(this.m_targetFormat.getSaveAs());
                this.m_location = this.m_targetFormat.getCloudStorageProps() != null ? (StoreAndForwardStorageLocation)CSCommon.getLocation(this.m_targetFormat.getCloudStorageProps(), (Connection)ConnectionResolver.getConnection((String)this.m_connName)) : new OracleOciStorageLocation(this.m_cloudStorageUrl, (String)this.m_targetFormat.getCloudStorageAuth());
                this.m_location.connect();
            }
        }
        catch (Throwable t) {
            Logger.warn(ExportGenerationOutputStream.class, (Throwable)t);
            throw ExportGenerationOutputStream.asIOException(t);
        }
    }

    @Override
    public void endPreamble() {
    }

    @Override
    public void startObject(String objectName, String objectType) throws IOException {
        this.startObject(objectName, objectType, null, null);
    }

    public void startObject(String objectName, String objectType, String scriptType, String scriptPath) throws IOException {
        block17: {
            boolean newObjectType = !this.m_currentObjectType.equals(objectType);
            this.m_lastObjectType = this.m_currentObjectType;
            this.m_currentObjectType = objectType;
            try {
                if (this.m_targetFormat.isCompressed()) {
                    if (this.m_targetFormat.isMultipleFiles() || this.m_targetFormat.isTypeFiles() && newObjectType || this.m_targetFormat.isTypeFiles() && this.isTypeData(objectType) || this.m_targetFormat.isSeparateDirs()) {
                        this.closeCurrentStream();
                        this.m_currentFileName = this.getFileName(Service.cleanScriptFileName((String)objectName), objectType);
                        if (!this.m_targetFormat.isTypeFiles() && scriptType != null) {
                            this.writeScript(objectName, scriptType, scriptPath);
                        }
                        this.m_zipper.openEntry(this.m_currentFileName);
                        if (this.m_targetFormat.isTypeFiles() && scriptType != null) {
                            this.writeScript(objectName, scriptType, scriptPath);
                        }
                    } else {
                        this.flushCurrentStream();
                        if (scriptType != null) {
                            this.writeScript(objectName, scriptType, scriptPath);
                        }
                    }
                    break block17;
                }
                if (this.m_targetFormat.isMultipleFiles() || this.m_targetFormat.isSeparateDirs()) {
                    this.closeCurrentStream();
                    this.m_currentFileName = this.getFileName(Service.cleanScriptFileName((String)objectName), objectType);
                    if (!this.m_targetFormat.isCloudStorage() && this.m_targetFormat.isSeparateDirs() && newObjectType) {
                        File f = new File(this.m_currentFileName).getParentFile();
                        try {
                            f.mkdir();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (scriptType != null) {
                        this.writeScript(objectName, scriptType, scriptPath);
                    }
                    this.open(this.m_currentFileName);
                    break block17;
                }
                if (this.m_targetFormat.isTypeFiles() && newObjectType || this.m_targetFormat.isTypeFiles() && this.isTypeData(objectType)) {
                    this.closeCurrentStream();
                    this.m_currentFileName = this.getFileName(Service.cleanScriptFileName((String)objectName), objectType);
                    this.open(this.m_currentFileName);
                    if (scriptType != null) {
                        this.writeScript(objectName, scriptType, scriptPath);
                    }
                } else {
                    this.m_currentFileName = this.m_targetFormat.getSaveAs();
                    this.flushCurrentStream();
                    if (scriptType != null) {
                        this.writeScript(objectName, scriptType, scriptPath);
                    }
                }
            }
            catch (Throwable t) {
                Logger.warn(ExportGenerationOutputStream.class, (Throwable)t);
                throw ExportGenerationOutputStream.asIOException(t);
            }
        }
    }

    @Override
    public void endObject() {
    }

    @Override
    public void println(String toPrint) {
        assert (this.m_currentWriter != null || this.m_zipper != null);
        int numLines = ExportGenerationOutputStream.countLines(toPrint);
        try {
            if (toPrint != null) {
                if (this.m_targetFormat.isCompressed()) {
                    this.m_zipper.writeEntryText(toPrint);
                } else {
                    this.m_currentWriter.write(toPrint);
                }
                if (this.m_writeTracker < 20) {
                    ++this.m_writeTracker;
                } else {
                    if (this.m_targetFormat.isCompressed()) {
                        this.m_zipper.flush();
                    } else {
                        this.m_currentWriter.flush();
                    }
                    this.m_writeTracker = 0;
                }
                this.m_linesWritten += (long)numLines;
            }
        }
        catch (IOException e) {
            Logger.warn(ExportGenerationOutputStream.class, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeScript(String objectName, String type, String path) {
        if (this.m_targetFormat.isSingleFile() || this.m_targetFormat.isStringType() || this.m_targetFormat.isTypeFiles() && !type.equals("INITIAL") && !type.equals("FINAL")) {
            InputStreamReader reader = null;
            try {
                FileInputStream fin = new FileInputStream(path);
                BufferedInputStream bin = new BufferedInputStream(fin);
                reader = this.m_encoding == null ? new InputStreamReader(bin) : new InputStreamReader((InputStream)bin, this.m_encoding);
                String msg = ExportResources.format("START_SCRIPT", type, path);
                if (this.m_targetFormat.isCompressed()) {
                    this.m_zipper.writeEntryText("--------------------------------------------------------\n");
                    this.m_zipper.writeEntryText("-- " + msg + "\n");
                    this.m_zipper.writeEntryText("--------------------------------------------------------\n");
                    this.m_zipper.writeEntryCharStream((Reader)reader);
                }
                this.m_currentWriter.write("\n");
                this.m_currentWriter.write("--------------------------------------------------------\n");
                this.m_currentWriter.write("-- " + msg + "\n");
                this.m_currentWriter.write("--------------------------------------------------------\n");
                int len = 0;
                char[] buf = new char[1024];
                while ((len = reader.read(buf, 0, 1024)) > 0) {
                    this.m_currentWriter.write(buf, 0, len);
                }
                this.m_currentWriter.write("\n");
            }
            catch (IOException e) {
                Logger.warn(ExportGenerationOutputStream.class, (Throwable)e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    Logger.warn(ExportGenerationOutputStream.class, (Throwable)e);
                }
            }
        } else {
            try {
                String fileName = this.getFileName(objectName, type);
                if (this.m_targetFormat.isCompressed()) {
                    this.writeFileEntry(path, fileName);
                } else {
                    Service.copy((String)path, null, (String)fileName, (String)this.m_encoding);
                    this.m_createdFiles.add(fileName);
                }
            }
            catch (Exception e) {
                Logger.warn(ExportGenerationOutputStream.class, (Throwable)e);
            }
        }
    }

    public void writeFileEntry(String path, String fileName) {
        try {
            this.m_zipper.writeFileEntry(path, fileName, true);
        }
        catch (IOException e) {
            Logger.warn(ExportGenerationOutputStream.class, (Throwable)e);
        }
    }

    public void writeFileEntry(URL url) {
        try {
            this.m_zipper.writeFileEntry(url);
        }
        catch (IOException e) {
            Logger.warn(ExportGenerationOutputStream.class, (Throwable)e);
        }
    }

    @Override
    public void finished() throws IOException {
        this.m_lastObjectType = this.m_currentObjectType;
        if (!this.m_targetFormat.isStringType()) {
            this.closeCurrentStream();
            if (this.m_targetFormat.isCompressed()) {
                try {
                    if (!this.m_targetFormat.isSingleFile() && this.m_targetFormat.isGenScript()) {
                        this.m_zipper.addSQLControllingFile(this.m_targetFormat.getControllingFile(), this.m_controllingHeader, this.m_targetFormat.isExcutableControlFile());
                    }
                    this.m_zipper.closeZip();
                }
                catch (IOException e) {
                    Logger.warn(ExportGenerationOutputStream.class, (Throwable)e);
                }
            } else if (!this.m_targetFormat.isCompressed() && this.m_targetFormat.isGenScript() && this.m_createdFiles != null && this.m_createdFiles.size() > 1 && (this.m_targetFormat.isMultipleFiles() || this.m_targetFormat.isSeparateDirs() || this.m_targetFormat.isTypeFiles())) {
                try {
                    for (String s : this.m_createdFiles) {
                        if (!s.endsWith(".sql")) continue;
                        this.m_isControllingFileExecutable = true;
                    }
                    if (this.m_isControllingFileExecutable) {
                        this.open(this.m_targetFormat.getControllingFile());
                        this.println(this.m_controllingHeader);
                        this.m_createdFiles.remove(this.m_createdFiles.size() - 1);
                        for (String s : this.m_createdFiles) {
                            if (new File(s).length() <= 0L) continue;
                            if (s.endsWith(".sql")) {
                                this.println("@" + s + "\n");
                                this.m_isControllingFileExecutable = true;
                                continue;
                            }
                            this.println("--@" + s + "\n");
                        }
                        this.m_lastObjectType = "CONTROL";
                        this.closeCurrentStream();
                    }
                }
                catch (Exception e) {
                    Logger.warn(ExportGenerationOutputStream.class, (Throwable)e);
                }
            }
        }
        if (this.m_location != null) {
            this.m_location.disconnect();
        }
    }

    public boolean isControlFileExecutable() {
        return this.m_isControllingFileExecutable;
    }

    private void closeCurrentStream() throws IOException {
        if (!this.m_targetFormat.isCompressed() && this.m_currentWriter != null) {
            if (this.isTypeData(this.m_lastObjectType) && this.m_formatter.isStreamHandler()) {
                this.m_formatter.closeStream();
            } else {
                this.m_currentWriter.flush();
                this.m_currentWriter.close();
                if (this.m_currentFileName != null) {
                    File file = new File(this.m_currentFileName);
                    if (!this.m_targetFormat.isCloudStorage()) {
                        if (file.length() == 0L) {
                            file.delete();
                        }
                    } else {
                        try {
                            this.m_listener.waitForDone();
                            if (this.m_listener.getThrowable() != null) {
                                throw ExportGenerationOutputStream.asIOException(this.m_listener.getThrowable());
                            }
                        }
                        catch (InterruptedException e) {
                            throw ExportGenerationOutputStream.asIOException(e);
                        }
                    }
                }
            }
            this.m_writeTracker = 0;
            this.m_currentWriter = null;
        }
    }

    private void flushCurrentStream() {
        try {
            if (!this.m_targetFormat.isCompressed() && this.m_currentWriter != null) {
                if (this.isTypeData(this.m_lastObjectType) && this.m_formatter.isStreamHandler()) {
                    this.m_formatter.flushStream();
                } else {
                    this.m_currentWriter.flush();
                }
                this.m_writeTracker = 0;
            }
        }
        catch (IOException e) {
            Logger.warn(ExportGenerationOutputStream.class, (Throwable)e);
        }
    }

    private static int countLines(String toCheck) {
        if (toCheck == null || toCheck.length() == 0) {
            return 0;
        }
        int count = 1;
        for (int i = 0; i < toCheck.length(); ++i) {
            if (toCheck.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    private void open(String fileName) throws FileNotFoundException, UnsupportedEncodingException, MalformedURLException, IOException {
        if (this.m_targetFormat.isCompressed()) {
            try {
                this.m_zipper.openEntry(fileName);
                this.m_createdFiles.add(fileName.toString());
            }
            catch (IOException e) {
                Logger.warn(ExportGenerationOutputStream.class, (Throwable)e);
            }
        } else if (this.m_targetFormat.isStringType()) {
            this.m_currentWriter = new StringWriter();
        } else if (this.m_targetFormat.isCloudStorage()) {
            Path filePath = Paths.get(this.m_cloudStorageUrl.getQualifierForFileName(fileName), new String[0]);
            this.m_listener = new StoreAndForwardStorageLocation.UserTaskListener();
            this.m_currentWriter = new OutputStreamWriter(this.m_location.asOutputStream(filePath, this.m_listener), this.m_encoding);
        } else {
            this.m_fout = new FileOutputStream(new File(fileName));
            this.m_bout = new BufferedOutputStream(this.m_fout);
            this.m_currentWriter = this.m_encoding == null ? new OutputStreamWriter(this.m_bout) : new OutputStreamWriter(this.m_bout, this.m_encoding);
            this.m_createdFiles.add(fileName.toString());
        }
    }

    public void addToControllingFile(String fileName) {
        this.m_createdFiles.add(fileName);
    }

    public Writer getWriter() {
        return this.m_currentWriter;
    }

    public OutputStream getOutputStream() {
        return this.m_bout;
    }

    public ZipOutputHandler getZipper() {
        return this.m_zipper;
    }

    public String toString() {
        if (this.m_currentWriter != null && this.m_currentWriter instanceof StringWriter) {
            return this.m_currentWriter.toString();
        }
        return null;
    }

    public TargetFormat getTargetFormat() {
        return this.m_targetFormat;
    }

    protected void setTargetFormat(TargetFormat targetFormat) {
        this.m_targetFormat = targetFormat;
    }

    public void setFormatter(ResultsFormatter formatter) {
        this.m_formatter = formatter;
    }

    public String getFileNameToOpen() {
        if (this.m_targetFormat.isSingleFile()) {
            return this.m_targetFormat.getSaveAs();
        }
        if (this.isControlFileExecutable()) {
            return this.m_targetFormat.getControllingFile();
        }
        if (this.m_createdFiles != null && this.m_createdFiles.size() > 0) {
            String singleSqlFile = null;
            for (String s : this.m_createdFiles) {
                if (!s.endsWith(".sql")) continue;
                if (singleSqlFile != null) {
                    return null;
                }
                singleSqlFile = s;
            }
            return singleSqlFile;
        }
        return null;
    }

    private String getFileName(String objectName, String objectType) throws IOException {
        String fileName;
        if (this.m_targetFormat.isCompressed()) {
            objectName = (objectName = Service.convertNonAsciiFileName((String)objectName)).startsWith("-") ? "X_" + objectName.substring(1) : objectName;
        }
        String string = fileName = this.m_targetFormat.isCompressed() ? "" : this.m_targetFormat.getSaveAs();
        if (this.m_targetFormat.isSingleFile() || this.m_targetFormat.isStringType()) {
            return fileName;
        }
        String typeID = "";
        if (this.isTypeData(objectType)) {
            typeID = "_" + objectType;
        } else if (objectType.equals("CONSTRAINT")) {
            typeID = "_CONSTRAINT";
        } else if (objectType.equals("REFCONSTRAINT")) {
            typeID = "_REFCONSTRAINT";
        } else if (this.isTypeScript(objectType)) {
            typeID = "_" + objectType;
        }
        String sepChar = Character.valueOf(File.separatorChar).toString();
        if (fileName.endsWith(sepChar) || this.m_targetFormat.isCompressed() && !this.m_targetFormat.isSeparateDirs()) {
            sepChar = "";
        }
        fileName = this.m_targetFormat.isMultipleFiles() ? (this.isTypeProcessScript(objectType) ? fileName + sepChar + objectName : (this.m_targetFormat.isCloudStorage() ? objectName + typeID : fileName + sepChar + objectName + typeID)) : (this.m_targetFormat.isTypeFiles() ? (this.isTypeData(objectType) ? fileName + sepChar + objectName + typeID : (this.isTypeScript(objectType) ? fileName + sepChar + objectName : fileName + sepChar + this.getFolderNameForType(objectType))) : (!this.m_targetFormat.isCompressed() ? (this.isTypeObjectScript(objectType) ? fileName + sepChar + this.getFolderNameForType(objectType) + sepChar + objectName + typeID : fileName + sepChar + this.getFolderNameForType(objectType) + sepChar + objectName) : (this.isTypeObjectScript(objectType) ? this.getFolderNameForType(objectType) + sepChar + objectName + typeID : this.getFolderNameForType(objectType) + sepChar + objectName)));
        fileName = this.m_targetFormat.isCompressed() ? this.m_zipper.getUniqueEntryName(fileName, this.getExtension(objectType)) : this.getUniqueFileName(fileName, this.getExtension(objectType));
        return fileName;
    }

    private boolean isTypeData(String type) {
        return type.startsWith("DATA") && !type.equals("DATABASE LINK");
    }

    private boolean isTypeScript(String type) {
        return type.startsWith("INITIAL") || type.startsWith("FINAL") || type.startsWith("BEFORE") || type.startsWith("AFTER");
    }

    private boolean isTypeObjectScript(String type) {
        return type.startsWith("BEFORE") || type.startsWith("AFTER");
    }

    private boolean isTypeProcessScript(String type) {
        return type.startsWith("INITIAL") || type.startsWith("FINAL");
    }

    private String getUniqueFileName(String candidateFileName, String extension) throws IOException {
        String fileName = candidateFileName + extension;
        int suffix = 0;
        if (!this.m_targetFormat.isCloudStorage()) {
            File candidateFile = new File(fileName);
            while (candidateFile.exists()) {
                fileName = candidateFileName + "_" + ++suffix + extension;
                candidateFile = new File(fileName);
            }
            return fileName;
        }
        List clist = null;
        try {
            clist = this.m_location.list("o", null);
        }
        catch (Throwable t) {
            Logger.warn(ExportGenerationOutputStream.class, (Throwable)t);
            throw ExportGenerationOutputStream.asIOException(t);
        }
        while (this.isCloudFile(clist, fileName)) {
            fileName = candidateFileName + "_" + ++suffix + extension;
        }
        return fileName;
    }

    private boolean isCloudFile(List<Map<?, ?>> clist, String fileName) {
        if (clist != null) {
            for (int i = 0; i < clist.size(); ++i) {
                Map<?, ?> entry = clist.get(i);
                if (!((String)entry.get("name")).equals(fileName)) continue;
                return true;
            }
        }
        return false;
    }

    public String getCurrentFileName() {
        return this.m_currentFileName;
    }

    private String getExtension(String objectType) {
        return !this.isTypeData(objectType) ? ".sql" : "." + this.m_targetFormat.getDataFormatExtension();
    }

    private String getFolderNameForType(String type) {
        for (TypeToFolderNameTuple tuple : FOLDER_NAME_MAP) {
            if (!tuple.getType().equals(type)) continue;
            return tuple.getFolderName();
        }
        return type;
    }

    protected static IOException asIOException(Throwable t) {
        if (t instanceof IOException) {
            return (IOException)t;
        }
        Throwable c = t.getCause();
        if (c instanceof IOException) {
            return (IOException)c;
        }
        return new IOException(t);
    }

    public void close() {
    }

    private static class TypeToFolderNameTuple {
        private String m_type;
        private String m_folderName;

        public TypeToFolderNameTuple(String type, String folderName) {
            this.setType(type);
            this.setFolderName(folderName);
        }

        public String getFolderName() {
            return this.m_folderName;
        }

        public String getType() {
            return this.m_type;
        }

        protected void setFolderName(String folderName) {
            this.m_folderName = folderName;
        }

        protected void setType(String type) {
            this.m_type = type;
        }
    }
}

