/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.test;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public abstract class Base {
    protected static Integer singleTest = null;
    private static int maxTestNo = 0;
    private static Set<Integer> failedTests = new TreeSet<Integer>();
    Set<RuleTuple> rules;
    Earley earley;
    private int assertion;
    private int comment;
    protected int dotted_name;
    protected int digits;
    protected int element;
    private int output;
    private int query;
    protected int result;
    private int identifier;
    protected int parameters;
    private String input;

    public Base(String testFile, String testGrammar) throws FileNotFoundException, IOException {
        this.input = Service.readFile(testFile);
        this.rules = Base.rules(testGrammar);
        this.earley = new Earley(this.rules){

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                LexerToken token = src.get(y);
                return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING || symbol == this.identifier && token.type == Token.BQUOTED_STRING;
            }
        };
        this.output = (Integer)this.earley.symbolIndexes.get("output");
        this.assertion = (Integer)this.earley.symbolIndexes.get("assertion");
        this.query = (Integer)this.earley.symbolIndexes.get("query");
        this.comment = (Integer)this.earley.symbolIndexes.get("comment");
        this.result = (Integer)this.earley.symbolIndexes.get("result");
        this.element = (Integer)this.earley.symbolIndexes.get("element");
        this.dotted_name = (Integer)this.earley.symbolIndexes.get("dotted_name");
        this.identifier = (Integer)this.earley.symbolIndexes.get("identifier");
        this.parameters = (Integer)this.earley.symbolIndexes.get("parameters");
        this.digits = (Integer)this.earley.symbolIndexes.get("digits");
    }

    public Base(String input) throws FileNotFoundException, IOException {
        this(input, Service.readFile("src/test/resources/oracle/dbtools/test/base.grammar"));
    }

    public void test() throws Exception {
        List<LexerToken> src = Lexer.parse(this.input, "`");
        Matrix matrix = new Matrix(this.earley);
        Visual visual = null;
        if (src.size() < 100) {
            visual = new Visual(src, this.earley);
        }
        this.earley.parse(src, matrix);
        SyntaxError s = SyntaxError.checkSyntax(this.input, new String[]{"atest"}, src, this.earley, matrix);
        if (s != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.err.println("Syntax Error");
            System.err.println("at line#" + s.line);
            System.err.println(s.code);
            System.err.println(s.marker);
            System.err.println("Expected:  ");
            for (String tmp : s.getSuggestions()) {
                System.err.print(tmp + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode root = this.earley.forest(src, matrix);
        long t1 = System.currentTimeMillis();
        this.atest(root, src, this.input);
        long t2 = System.currentTimeMillis();
        System.out.println("Total test time = " + (t2 - t1));
        if (failedTests.size() == 0) {
            System.out.println("*** ALL " + maxTestNo + " TESTS are OK *** ---> ");
        } else {
            System.err.println("*** TEST FAILED! *** ---> " + failedTests.toString());
            System.exit(2);
        }
    }

    private static Set<RuleTuple> rules(String input) {
        try {
            List<LexerToken> src = Lexer.parse(input, false, 1);
            ParseNode root = Grammar.parseGrammarFile(src, input);
            TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
            Grammar.grammar(root, src, ret);
            return ret;
        }
        catch (Exception e) {
            throw new AssertionError((Object)"VT: failed to init grammar for regression test");
        }
    }

    private void atest(ParseNode root, List<LexerToken> src, String input) throws Exception {
        if (root.contains(this.assertion)) {
            if (singleTest != null && singleTest != maxTestNo) {
                return;
            }
            System.out.print("TEST#" + maxTestNo + " -> ");
            if (this.assertion(root, src, input, maxTestNo)) {
                System.out.println("OK \n");
            } else {
                System.out.println("*** Failed ***\n");
            }
            return;
        }
        if (root.contains(this.output)) {
            if (singleTest != null && singleTest != maxTestNo) {
                return;
            }
            System.out.print("TEST#" + maxTestNo + " -> ");
            this.output(root, src, input, maxTestNo);
            return;
        }
        if (root.contains(this.comment)) {
            Base.comment(root, src, input);
            return;
        }
        for (ParseNode child : root.children()) {
            this.atest(child, src, input);
        }
    }

    protected void output(ParseNode root, List<LexerToken> src, String input, int testNum) throws SQLException {
        for (ParseNode child : root.children()) {
            if (child.contains(this.parameters)) {
                this.parameters(child, src, input);
                continue;
            }
            if (!child.contains(this.query)) continue;
            System.out.println("TEST#" + maxTestNo + " ->\n" + this.query(child, src, input));
        }
    }

    protected boolean assertion(ParseNode root, List<LexerToken> src, String input, int testNum) throws SQLException {
        List<String> output = null;
        Map<String, Boolean> cmp = null;
        for (ParseNode child : root.children()) {
            if (child.contains(this.parameters)) {
                this.parameters(child, src, input);
                continue;
            }
            if (child.contains(this.query)) {
                output = this.query(child, src, input);
                continue;
            }
            if (!child.contains(this.result)) continue;
            cmp = this.result(child, src, input);
        }
        for (String c : cmp.keySet()) {
            boolean isPositive = (Boolean)cmp.get(c);
            String cC = c.replace("\r", "");
            boolean isCaseSensitive = false;
            if (cC.charAt(0) == '\"') {
                isCaseSensitive = true;
            }
            if (cC.charAt(0) == '`') {
                cC = cC.substring(1, cC.length() - 1);
            }
            if (!isCaseSensitive) {
                cC = cC.toLowerCase();
            }
            boolean matched = false;
            String prefix = this.longestCommonPrefix(cC, "");
            String str1 = "";
            String str2 = "";
            for (String o : output) {
                String oO = o.replace("\r", "");
                if (isCaseSensitive && oO.charAt(0) != '\"') {
                    oO = this.quoteOutput(oO);
                }
                if (!isCaseSensitive) {
                    oO = oO.toLowerCase();
                }
                if (cC.equals(oO)) {
                    matched = true;
                    break;
                }
                String p = this.longestCommonPrefix(cC, oO);
                if (prefix.length() >= p.length()) continue;
                prefix = p;
                int index1 = prefix.length() + 3;
                if (oO.length() < index1) {
                    index1 = oO.length();
                }
                str1 = oO.substring(prefix.length(), index1);
                int index2 = prefix.length() + 3;
                if (cC.length() < index2) {
                    index2 = cC.length();
                }
                str2 = cC.substring(prefix.length(), index2);
            }
            if ((matched || !isPositive) && (!matched || isPositive)) continue;
            System.out.println((isPositive ? "no" : "unexpected") + " match for " + c);
            failedTests.add(testNum);
            if (cC.contains("\n")) {
                System.out.println(prefix + ">>>" + str1 + "!=" + str2);
            }
            return false;
        }
        return true;
    }

    protected String quoteOutput(String output) {
        return '\"' + output + '\"';
    }

    protected void parameters(ParseNode node, List<LexerToken> src, String input) {
    }

    private Map<String, Boolean> result(ParseNode node, List<LexerToken> src, String input) {
        if (node.contains(this.element)) {
            return this.element(node, src, input);
        }
        HashMap<String, Boolean> output = new HashMap<String, Boolean>();
        for (ParseNode child : node.children()) {
            output.putAll(this.result(child, src, input));
        }
        return output;
    }

    private Map<String, Boolean> element(ParseNode node, List<LexerToken> src, String input) {
        HashMap<String, Boolean> output = new HashMap<String, Boolean>();
        if (node.contains(this.dotted_name)) {
            String current = node.content(src);
            output.put(current, true);
            return output;
        }
        for (ParseNode child : node.children()) {
            if (!child.contains(this.dotted_name)) continue;
            String current = child.content(src);
            output.put(current, false);
            return output;
        }
        return output;
    }

    private List<String> query(ParseNode root, List<LexerToken> src, String input) throws SQLException {
        if (root.contains(this.identifier)) {
            return this.output(Base.sql_fragment(root, src, input), -1);
        }
        String lhs = "";
        String rhs = "";
        for (ParseNode child : root.children()) {
            if (!child.contains(this.identifier)) continue;
            if (lhs == "") {
                lhs = Base.sql_fragment(child, src, input);
                continue;
            }
            rhs = Base.sql_fragment(child, src, input);
        }
        return this.output(lhs + rhs, lhs.length());
    }

    public abstract List<String> output(String var1, int var2);

    private static String sql_fragment(ParseNode root, List<LexerToken> src, String input) {
        return input.substring(src.get((int)root.from).begin, src.get((int)(root.to - 1)).end).replace("`", "");
    }

    private static ParseNode comment(ParseNode root, List<LexerToken> src, String input) throws Exception {
        String txt = input.substring(src.get((int)(root.from + 1)).begin, src.get((int)(root.to - 1)).end - 1);
        int testNo = Integer.parseInt(txt);
        if (maxTestNo < testNo) {
            maxTestNo = testNo;
        }
        if (singleTest != null && singleTest != testNo) {
            return null;
        }
        return null;
    }

    private String longestCommonPrefix(String a, String b) {
        int minLength = Math.min(a.length(), b.length());
        for (int i = 0; i < minLength; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return a.substring(0, i);
        }
        return a.substring(0, minLength);
    }
}

