/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WindowsUtility {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static boolean jdk11Style = false;

    private WindowsUtility() {
    }

    public static Object[] toJdk11(Object[] inParams) {
        if (inParams == null) {
            return null;
        }
        if (!jdk11Style) {
            if (inParams[0] instanceof Long) {
                inParams[0] = new Integer(((Long)inParams[0]).intValue());
            }
            return inParams;
        }
        if (inParams[0] instanceof Integer) {
            inParams[0] = new Long(((Integer)inParams[0]).intValue());
        }
        return inParams;
    }

    public static Long[] longArrayToInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof int[]) {
            ArrayList<Long> allL = new ArrayList<Long>();
            int[] nArray = (int[])o;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                long l = nArray[i];
                allL.add(new Long(l));
            }
            return allL.toArray(new Long[allL.size()]);
        }
        if (o instanceof long[]) {
            ArrayList<Long> allL = new ArrayList<Long>();
            for (long l : (long[])o) {
                allL.add(new Long(l));
            }
            return allL.toArray(new Long[allL.size()]);
        }
        new Exception().printStackTrace();
        return null;
    }

    public static String readString(int hkey, String key, String valueName) throws Exception {
        return WindowsUtility.findValue(WindowsUtility.readRegistry(hkey, key), valueName);
    }

    public static List<String> readStringSubKeys(int hkey, String key) throws Exception {
        return WindowsUtility.findKeys(key, WindowsUtility.readRegistry(hkey, key));
    }

    private static String readRegistry(int hkey, String key) throws Exception {
        String result = null;
        try {
            int c;
            StringBuilder cmd = new StringBuilder();
            cmd.append("reg query \"");
            switch (hkey) {
                case -2147483647: {
                    cmd.append("HKCU\\");
                    break;
                }
                case -2147483646: {
                    cmd.append("HKLM\\");
                }
            }
            cmd.append(key).append('\"');
            Process process = Runtime.getRuntime().exec(cmd.toString());
            InputStream in = process.getInputStream();
            StringBuilder sb = new StringBuilder();
            while ((c = in.read()) != -1) {
                sb.append((char)c);
            }
            result = sb.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static String findValue(String raw, String valueName) {
        String value = null;
        String[] lines = WindowsUtility.toLines(raw);
        if (lines == null) {
            return null;
        }
        for (String line : lines) {
            Pattern p;
            Matcher m;
            if ((line = line.trim()).startsWith("HKEY_") || !(m = (p = Pattern.compile("(\\S*)\\s+(\\S*)\\s+(.*)")).matcher(line)).find() || !m.group(1).equals(valueName)) continue;
            value = m.group(3);
            break;
        }
        return value;
    }

    private static List<String> findKeys(String parentAbsoluteKey, String raw) {
        ArrayList<String> keys = new ArrayList<String>();
        String[] lines = WindowsUtility.toLines(raw);
        if (lines == null) {
            return null;
        }
        for (String line : lines) {
            int idx;
            if (!line.trim().startsWith("HKEY_") || line.endsWith(parentAbsoluteKey) || (idx = line.lastIndexOf("\\")) < 0) continue;
            String key = line.substring(idx + 1);
            keys.add(key);
        }
        return keys;
    }

    private static String[] toLines(String raw) {
        if (raw == null || raw.isEmpty()) {
            return null;
        }
        String[] lines = raw.split(System.getProperty("line.separator"));
        if (lines != null && lines.length > 0 && lines[0].trim().startsWith("ERROR")) {
            return null;
        }
        return lines;
    }
}

