/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.alias;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Alias;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Aliases;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Messages;
import oracle.dbtools.raptor.query.Bind;

public class AliasCommand
extends CommandListener
implements IHelp {
    private static String LIST = "list";
    private static String DROP = "drop";
    private static String ALIAS = "alias";
    private static String SAVE = "save";
    private static String LOAD = "load";
    private static String DESC = "desc";
    private static String SYSTEM = "system";
    private static String NULLDEFAULTS = "nulldefaults";
    private static String GROUP = "group";
    private static String GROUPS = "groups";

    @Override
    public String getCommand() {
        return "ALIAS";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        boolean nullskip = false;
        String group = null;
        String noNullDefaults = cmd.getSql().trim();
        String[] tokens = noNullDefaults.split("[ \t\r\n][ \t\r\n]*");
        if (tokens.length <= 0) return false;
        String query = null;
        if (!tokens[0].toLowerCase().equals(this.getCommandName())) return false;
        if (!ctx.isProductNameSQLDeveloper() && !ctx.isProductNameSQLcl()) {
            ctx.write(Messages.getString("AliasCommand.33"));
            return true;
        }
        ArrayList<String> aliases = Aliases.getInstance().getAliases();
        if (tokens.length == 1) {
            ArrayList<String> locallist = new ArrayList<String>();
            Iterator<String> it = aliases.iterator();
            while (it.hasNext()) {
                Alias current = Aliases.getInstance().get(it.next());
                if (current.isSystem()) continue;
                locallist.add(current.getName());
            }
            ArrayList depdupeCommands = new ArrayList(new LinkedHashSet(locallist));
            Collections.sort(depdupeCommands);
            try {
                ctx.write(this.printColumns(depdupeCommands, ctx) + "\n");
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        if (tokens.length <= 1) {
            ctx.write(Messages.getString("AliasCommand.32"));
            ctx.write(this.getHelp());
            return true;
        }
        String key = "";
        for (int i = 0; i < 2; ++i) {
            int start;
            if (!nullskip && tokens[1].toLowerCase().equals(NULLDEFAULTS) && tokens.length > 2) {
                nullskip = true;
                start = noNullDefaults.indexOf(tokens[1]);
                noNullDefaults = (noNullDefaults.substring(0, start) + noNullDefaults.substring(start + tokens[1].length() + 1)).trim();
                tokens = noNullDefaults.split("[ \t\r\n][ \t\r\n]*");
            }
            if (group != null || !tokens[1].toLowerCase().startsWith(GROUP + "=") || tokens[1].endsWith("=") || tokens.length <= 2) continue;
            group = tokens[1].split("=")[1];
            start = noNullDefaults.indexOf(tokens[1]);
            noNullDefaults = (noNullDefaults.substring(0, start) + noNullDefaults.substring(start + tokens[1].length() + 1)).trim();
            tokens = noNullDefaults.split("[ \t\r\n][ \t\r\n]*");
        }
        if (tokens[1].toLowerCase().equals(GROUPS) && tokens.length == 2) {
            ArrayList<String> groups = new ArrayList<String>();
            HashSet<String> dedup = new HashSet<String>();
            Iterator<String> it = aliases.iterator();
            while (it.hasNext()) {
                Alias current = Aliases.getInstance().get(it.next());
                if (current.getGroup() == null || !dedup.add(current.getGroup())) continue;
                groups.add(current.getGroup());
            }
            groups.sort(null);
            try {
                ctx.write(this.printColumns(groups, ctx) + "\n");
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        if (tokens[1].toLowerCase().equals(DROP)) {
            if (tokens.length == 3) {
                ctx.write(Aliases.getInstance().drop(tokens[2]) + "\n");
                return true;
            }
            ctx.write(Messages.getString("AliasCommand.21"));
            return true;
        }
        if (tokens[1].toLowerCase().equals(DESC)) {
            String alias = "";
            if (tokens.length > 2) {
                alias = tokens[2];
            }
            if (tokens.length < 4) {
                ctx.write(MessageFormat.format("ALIAS-22: {0} Not enough arguments", alias));
                return false;
            }
            if (!aliases.contains(alias)) return false;
            Alias a = Aliases.getInstance().get(alias);
            String newValue = "";
            int i = 0;
            while (true) {
                if (i >= 3) {
                    a.setDesc(newValue);
                    return true;
                }
                newValue = noNullDefaults.substring(noNullDefaults.indexOf(" ") + 1);
                ++i;
            }
        }
        if (tokens[1].toLowerCase().equals(SYSTEM)) {
            this.systemStyle(aliases, ctx, null);
            return false;
        }
        if (tokens[1].toLowerCase().equals(LIST)) {
            String alias = "";
            if (tokens.length > 2 && tokens[2].length() > 0) {
                alias = tokens[2];
                if (!aliases.contains(alias)) {
                    ctx.write(MessageFormat.format(Messages.getString("AliasCommand.27"), alias));
                    return true;
                }
                Alias withProperties = Aliases.getInstance().get(alias);
                String withProp = alias;
                if (withProperties.isNullDefaults()) {
                    withProp = alias + " " + NULLDEFAULTS.toUpperCase(Locale.US);
                }
                String aliasdesc = withProp;
                if (withProperties.getGroup() != null) {
                    aliasdesc = aliasdesc + " " + withProperties.getGroup();
                }
                if (withProperties.getDesc().length() > 0) {
                    aliasdesc = aliasdesc + " - " + Aliases.getInstance().get(alias).getDesc();
                }
                String line = new String(new char[aliasdesc.length()]).replace("\u0000", "-");
                ctx.write(MessageFormat.format("{0}\n{1}\n\n", aliasdesc, line));
                ctx.write(Aliases.getInstance().get(alias).getQuery() + "\n\n");
                return true;
            }
            this.searchForToken1Group(null, ctx, aliases);
            return true;
        }
        if (tokens[1].toLowerCase().equals(SAVE)) {
            if (ctx.getProperty("script.runner.jline") == null) {
                ctx.write(Messages.getString("AliasCommand.29"));
                return true;
            }
            if (tokens.length > 2 && tokens[2] != null) {
                ctx.write(Aliases.getInstance().save(tokens[2]));
                return true;
            }
            ctx.write(Aliases.getInstance().save());
            return true;
        }
        if (tokens[1].toLowerCase().equals(LOAD)) {
            if (ctx.getProperty("script.runner.jline") == null) {
                ctx.write(Messages.getString("AliasCommand.30"));
                return true;
            }
            if (tokens.length > 2 && tokens[2] != null) {
                ctx.write(Aliases.getInstance().load(tokens[2]));
                return true;
            }
            ctx.write(Aliases.getInstance().load());
            return true;
        }
        if (noNullDefaults.contains("=") && !tokens[1].startsWith("=")) {
            String[] preEqSplit = noNullDefaults.split("=")[0].split("\\s+");
            key = preEqSplit[1];
            if (preEqSplit.length > 2) {
                key = key + preEqSplit[2];
            }
            if (key.equalsIgnoreCase("alias")) {
                ctx.write(Messages.getString("AliasCommand.10"));
                return true;
            }
            String payload = noNullDefaults.substring(noNullDefaults.indexOf("=") + 1).trim();
            if (payload.startsWith(":")) {
                if (payload.length() > 1) {
                    payload = payload.substring(1);
                    Bind b = ctx.getVarMap().get(payload.toUpperCase());
                    if (b != null) {
                        query = b.getValue();
                    }
                }
                if (query == null || query.equals("")) {
                    ctx.write(Messages.getString("AliasCommand.16"));
                    return true;
                }
            } else {
                String payloadUpper = payload.toUpperCase();
                if (payload.length() > 5 && payloadUpper.startsWith("Q'") && payload.endsWith(ScriptParser.getEndQuoteString(payload.substring(2, 3)) + "'")) {
                    payload = payload.substring(3, payload.length() - 2);
                } else if (payload == null || payload.equals("")) {
                    ctx.write(Messages.getString("AliasCommand.20"));
                    return true;
                }
                query = payload;
            }
            Aliases.getInstance().add(key, query, "", nullskip, group);
            return true;
        }
        if (tokens.length > 1 && this.systemStyle(aliases, ctx, tokens[1])) {
            return true;
        }
        ctx.write(Messages.getString("AliasCommand.31"));
        return true;
    }

    private boolean systemStyle(ArrayList<String> aliases, ScriptRunnerContext ctx, String group) {
        boolean retVal = false;
        ArrayList<String> locallist = new ArrayList<String>();
        Iterator<String> it = aliases.iterator();
        while (it.hasNext()) {
            Alias current = Aliases.getInstance().get(it.next());
            if ((group != null || !current.isSystem()) && (group == null || current.getGroup() == null || !current.getGroup().equals(group))) continue;
            locallist.add(current.getName());
            retVal = true;
        }
        ArrayList depdupeCommands = new ArrayList(new LinkedHashSet(locallist));
        Collections.sort(depdupeCommands);
        if (depdupeCommands != null && !depdupeCommands.isEmpty()) {
            depdupeCommands.remove("\n");
            depdupeCommands.remove("\n\n");
            depdupeCommands.remove(" ");
        }
        try {
            ctx.write(this.printColumns(depdupeCommands, ctx) + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    private boolean searchForToken1Group(String group, ScriptRunnerContext ctx, ArrayList<String> aliases) {
        boolean found = false;
        ArrayList<String[]> interrumSort = new ArrayList<String[]>();
        Iterator<String> it = aliases.iterator();
        int i = 0;
        while (it.hasNext()) {
            String a = it.next().trim();
            if (a.length() <= i) continue;
            i = a.length();
        }
        for (String x : aliases) {
            Alias a = Aliases.getInstance().get(x);
            String[] tosort = new String[]{a.getName(), a.getGroup(), a.getDesc()};
            interrumSort.add(tosort);
        }
        interrumSort.sort(new Comparator<String[]>(){

            public int nullFirst(String o1, String o2) {
                if (o1 == null && o2 != null) {
                    return "a".compareTo("b");
                }
                if (o1 != null && o2 != null) {
                    return o1.compareTo(o2);
                }
                if (o1 != null && o2 == null) {
                    return "b".compareTo("a");
                }
                return 0;
            }

            @Override
            public int compare(String[] o1, String[] o2) {
                int compare = this.nullFirst(o1[1], o2[1]);
                if (compare == 0) {
                    return this.nullFirst(o1[0], o2[0]);
                }
                return compare;
            }
        });
        for (String[] sorted : interrumSort) {
            String x = sorted[0];
            String sortedGroup = sorted[1];
            String desc = sorted[2];
            x = i < 30 && i > 0 ? String.format("%0$-" + i + "s", x) : String.format("%0$-30s", x);
            String thisGroup = sortedGroup;
            if (group != null && (thisGroup == null || !thisGroup.equals(group))) continue;
            found = true;
            String toWrite = x;
            String padGroup = thisGroup;
            if (padGroup != null) {
                padGroup = i < 20 ? String.format("%0$-" + i + "s", padGroup) : String.format("%0$-20s", padGroup);
            }
            if (thisGroup != null) {
                toWrite = toWrite + " " + padGroup;
            }
            if (desc.length() > 0) {
                toWrite = toWrite + " - " + desc;
            }
            toWrite = toWrite + "\n";
            ctx.write(toWrite);
        }
        return found;
    }

    public String getCommandName() {
        return ALIAS;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String printColumns(Collection<? extends CharSequence> items, ScriptRunnerContext ctx) throws IOException {
        StringBuilder s = new StringBuilder();
        if (items == null || items.isEmpty()) {
            return "";
        }
        int width = 82;
        if (ctx.isCommandLine() && ctx.getSQLPlusConsoleReader().getWidth() > width) {
            width = ctx.getSQLPlusConsoleReader().getWidth();
        }
        int maxWidth = 0;
        for (CharSequence charSequence : items) {
            maxWidth = Math.max(maxWidth, charSequence.length());
        }
        StringBuilder buff = new StringBuilder();
        int n = width / (maxWidth += 3);
        int col = 0;
        for (CharSequence charSequence : items) {
            int i;
            String name = charSequence.toString();
            if (col < n) {
                buff.append(name);
                for (i = 0; i < maxWidth - charSequence.length(); ++i) {
                    buff.append(' ');
                }
                ++col;
                continue;
            }
            s.append(buff.toString() + "\n");
            buff.setLength(0);
            col = 0;
            buff.append(name);
            for (i = 0; i < maxWidth - charSequence.length(); ++i) {
                buff.append(' ');
            }
            ++col;
        }
        if (buff.length() > 0) {
            s.append(buff.toString());
        }
        return s.toString();
    }
}

