/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class SetMaxRowsSpoolTruncate
extends CommandListener
implements IShowCommand {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String lowertrim = cmd.getLoweredTrimmedNoWhitespaceSQL();
        if (lowertrim.startsWith("setmaxspoolrowstruncate")) {
            String[] parts = cmd.getLoweredTrimmedSQL().split("\\s+");
            if (parts.length == 3 && parts[2].equalsIgnoreCase("default")) {
                ctx.write(MessageFormat.format(Messages.getString("MAXROWSSPOOLTRUNCATECLEARED"), "maxspoolrowstruncate"));
                ctx.putProperty("sqlcl.script.maxrowsspooltruncate", null);
                return true;
            }
            if (parts.length == 3) {
                if (parts[2].equals("on")) {
                    ctx.putProperty("sqlcl.script.maxrowsspooltruncate", Boolean.TRUE);
                } else if (parts[2].equals("off")) {
                    ctx.putProperty("sqlcl.script.maxrowsspooltruncate", Boolean.FALSE);
                } else {
                    this.usage(ctx, cmd, conn);
                }
            } else {
                this.usage(ctx, cmd, conn);
            }
            return true;
        }
        return false;
    }

    public void usage(ScriptRunnerContext ctx, ISQLCommand cmd, Connection conn) {
        ctx.write(MessageFormat.format(Messages.getString("MAXROWSSPOOLTRUNCATEUSAGE"), "maxspoolrowstruncate"));
        ScriptUtils.doWhenever(ctx, cmd, conn, true);
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Boolean setting;
        String format = null;
        format = ctx.getProperties().containsKey("sqlcl.script.maxrowsspooltruncate") && ctx.getProperties().get("sqlcl.script.maxrowsspooltruncate") != null ? ((setting = (Boolean)ctx.getProperties().get("sqlcl.script.maxrowsspooltruncate")).booleanValue() ? "ON" : "OFF") : "Default";
        ctx.write("");
        ctx.write(MessageFormat.format(Messages.getString("MAXROWSSPOOLTRUNCATE"), "maxspoolrowstruncate", format) + "\n");
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"maxspoolrowstruncate"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

