/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetColsep
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_COLSEP;
    private static final String COLSEP_PTRN = "^'[^']+'|^\"[^\"]+\"|^[^'\"].+";

    public SetColsep() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("prop_file_string") != null) {
            String str = cmd.getSql();
            str = str.trim().replaceAll("^(?i:set\\s+colsep)\\s+", "").trim();
            if ((str = str.trim().replaceAll("^(?i:set\\s+space)\\s+", "").trim()).matches(COLSEP_PTRN)) {
                str = str.replaceAll("^\"|\"$|^'|'$", "");
                ctx.putProperty("script.runner.setcolsep", new String(str));
            } else if (str.matches("^'[^']+\"$")) {
                String squote = "'";
                String msg = MessageFormat.format(Messages.getString("SetSpool.missingquote"), str, squote) + System.getProperty("line.separator");
                ctx.write(msg);
                msg = MessageFormat.format(Messages.getString("SETUNKNOWNOPTION"), str);
                ctx.write(msg);
            } else if (str.matches("^\"[^\"]+'$")) {
                String dquote = "\"";
                String msg = MessageFormat.format(Messages.getString("SetSpool.missingquote"), str, dquote) + System.getProperty("line.separator");
                ctx.write(msg);
                msg = MessageFormat.format(Messages.getString("SETUNKNOWNOPTION"), str);
                ctx.write(msg);
            } else {
                Pattern ptrn = Pattern.compile(COLSEP_PTRN);
                Matcher m = ptrn.matcher(str);
                if (m.find()) {
                    String csstr = m.group();
                    csstr = csstr.replaceAll("^\"|\"$|^'|'$", "");
                    ctx.putProperty("script.runner.setcolsep", new String(csstr));
                }
                String errStr = str.replaceAll(COLSEP_PTRN, "");
                String msg = MessageFormat.format(Messages.getString("SETUNKNOWNOPTION"), errStr);
                ctx.write(msg);
            }
        }
        return true;
    }
}

