/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowNoRows;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

public class Column
extends CommandListener
implements IShowCommand,
IShowPrefixNameNewline,
IShowNoRows {
    private static final String m_lineSeparator = System.getProperty("line.separator");
    private static final String CMD = "\\b(?i:co(?:l\\b|lu\\b|lum\\b|lumn\\b))";
    private static final String CLEAR = "\\b(?i:cl(?:e\\b|ea\\b|ear\\b))";
    private static final String ONOROFF = "\\b(?i:on)|(?i:off)\\b";
    private static final String ON = "\\b(?i:on)\\b";
    private static final String OFF = "\\b(?i:off)\\b";
    private static final String WRAPPED = "(?i:wr(?:a|ap|app|appe|apped))";
    private static final String WORD_WRAPPED = "(?i:wo(?:r|rd|rd_|rd_w|rd_wr|rd_wra|rd_wrap|rd_wrapp|rd_wrappe|rd_wrapped))";
    private static final String TRUNCATED = "(?i:tr(?:u|un|unc|unca|uncat|uncate|uncated))";
    private static final String WRAP = "\\b(?:(?i:wr(?:a|ap|app|appe|apped))|(?i:wo(?:r|rd|rd_|rd_w|rd_wr|rd_wra|rd_wrap|rd_wrapp|rd_wrappe|rd_wrapped))|(?i:tr(?:u|un|unc|unca|uncat|uncate|uncated)))\\b";
    private static final String PRINT = "(?i:pr(?:i|in|int))";
    private static final String NPRINT = "(?i:nopr(?:i|in|int))";
    private static final String PRNT = "\\b(?:(?i:pr(?:i|in|int))|(?i:nopr(?:i|in|int)))\\b";
    private static final String FORMAT = "\\b(?i:fo(?:r|rm|rma|rmat))\\b";
    private static final String HEADING = "\\b(?i:he(?:a|ad|adi|adin|ading))\\b";
    private static final String LEFT = "(?i:l(?:|e|ef|eft))";
    private static final String CENTER = "(?i:c(?:|e|en|ent|ente|entr|enter|entre))";
    private static final String RIGHT = "(?i:r(?:|i|ig|igh|ight))";
    private static final String JUSTIFY = "\\b(?i:ju(?:s|st|sti|stif|stify))\\b";
    private static final String NULL = "\\b(?i:nu(?:l|ll))\\b";
    private static final String NEWVAL = "\\b(?i:new_(?:v|va|val|value))\\b";
    private static final String OLDVAL = "\\b(?i:old_(?:v|va|val|value))\\b";
    private static final String HEADVAL_PTRN = "\\b(?i:he(?:a|ad|adi|adin|ading))\\b\\s+('|\").+('|\")";
    private static final String FOLD_BEFORE = "\\b(?i:fold_b(?:|e|ef|efo|efor|efore))\\b";
    private static final String FOLD_AFTER = "\\b(?i:fold_a(?:|f|ft|fte|fter))\\b";
    private static final String ALIAS = "\\b(?i:ali(?:|a|as))\\b";
    private static final String NUMFORMAT = "\\$?\\b(([[09],]+(\\.[[09]Ee]+)?)|((?i:b|c|d|g|l|s|u|v)?([09]+((\\.|\\,|\\$)[09]*)?))|([09]+(((\\.|\\,|\\$)[09]*)|(?i:b|c|d|g|l|s|u|v)|(?i:pr|mi))?)|(?i:b|c|d|g|l|s|u|v)?([09]+((?i:b|c|d|g|l|s|u|v|[09])*)?)|((\\.|\\$)[09]+)|(?i:rn)|(?i:tm(9|e)?)|([09]+((\\.)[09]*)?(?i:e){4})|([09]*(?i:x)+)|((\\$)?[[09]\\,]+(\\.[09]+)?))\\b";
    private static final String FUNCTION = "([\\p{Graph}]+\\((\\'?[^\\(\\)]+\\'?,?)+\\))";
    private static final String WPLUS = "[\\w#]";
    private static final String EXPR = "\\$?\\b(([[09],]+(\\.[[09]Ee]+)?)|((?i:b|c|d|g|l|s|u|v)?([09]+((\\.|\\,|\\$)[09]*)?))|([09]+(((\\.|\\,|\\$)[09]*)|(?i:b|c|d|g|l|s|u|v)|(?i:pr|mi))?)|(?i:b|c|d|g|l|s|u|v)?([09]+((?i:b|c|d|g|l|s|u|v|[09])*)?)|((\\.|\\$)[09]+)|(?i:rn)|(?i:tm(9|e)?)|([09]+((\\.)[09]*)?(?i:e){4})|([09]*(?i:x)+)|((\\$)?[[09]\\,]+(\\.[09]+)?))\\b|(-?[\\w#]+(?:\\.[\\w#]+(?:E[\\w#]+)?)?(\\s*[-+/\\*]\\s*-?[\\w#]+(?:\\.[\\w#]+(?:E[\\w#]+)?)?)*)|(\\s+)";
    private static final String FUNC_OR_EXPR = "([\\p{Graph}]+\\((\\'?[^\\(\\)]+\\'?,?)+\\))|\\$?\\b(([[09],]+(\\.[[09]Ee]+)?)|((?i:b|c|d|g|l|s|u|v)?([09]+((\\.|\\,|\\$)[09]*)?))|([09]+(((\\.|\\,|\\$)[09]*)|(?i:b|c|d|g|l|s|u|v)|(?i:pr|mi))?)|(?i:b|c|d|g|l|s|u|v)?([09]+((?i:b|c|d|g|l|s|u|v|[09])*)?)|((\\.|\\$)[09]+)|(?i:rn)|(?i:tm(9|e)?)|([09]+((\\.)[09]*)?(?i:e){4})|([09]*(?i:x)+)|((\\$)?[[09]\\,]+(\\.[09]+)?))\\b|(-?[\\w#]+(?:\\.[\\w#]+(?:E[\\w#]+)?)?(\\s*[-+/\\*]\\s*-?[\\w#]+(?:\\.[\\w#]+(?:E[\\w#]+)?)?)*)|(\\s+)";
    private static final String[] SHOWCOLUMN = new String[]{"column"};

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sqlpcmd = cmd.getSql().trim();
        ArrayList<String> matchList = new ArrayList<String>();
        String sqlpcmd1 = sqlpcmd.replaceFirst(CMD, "");
        matchList.add("col");
        Pattern ptrn = Pattern.compile(FUNC_OR_EXPR);
        Matcher matcher = ptrn.matcher(sqlpcmd1);
        while (matcher.find()) {
            if (matcher.group().matches("\\s+|" + m_lineSeparator + "|-")) continue;
            matchList.add(matcher.group());
        }
        String[] cmds = new String[matchList.size()];
        matchList.toArray(cmds);
        if (cmds[0].matches(CMD)) {
            HashMap<String, ArrayList<String>> storedColumns = ctx.getStoredFormatCmds();
            if (ctx.is121LongIdentUsed()) {
                storedColumns = ctx.get121IdentViewColCmds();
            }
            if (cmds.length <= 2) {
                if (cmds.length == 1) {
                    this.printAllColumns(ctx, storedColumns);
                } else {
                    String str = sqlpcmd1.replaceAll(FUNC_OR_EXPR, "");
                    if (str.length() > 0) {
                        if (str.equals("-") && cmds[1] != null) {
                            ctx.write(MessageFormat.format(Messages.getString("COLUMN_NOTDEFINED"), cmds[1]) + m_lineSeparator);
                        } else {
                            ctx.write(MessageFormat.format(Messages.getString("UNKNOWN_COLOPTION"), str) + m_lineSeparator);
                        }
                        return true;
                    }
                    this.printColumn(ctx, storedColumns, cmds[1].trim());
                }
            } else {
                this.addOrRemoveColumnCommand(ctx, sqlpcmd);
            }
            return true;
        }
        return false;
    }

    private boolean checkIgnoreSetting(ScriptRunnerContext ctx) {
        Object o = ctx.getProperty("script.runner.sqlcl.ignore.settings");
        return o != null & Boolean.parseBoolean(o.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addOrRemoveColumnCommand(ScriptRunnerContext ctx, String sqlpcmd) {
        block52: {
            HashMap<String, ArrayList<String>> storedColumns = null;
            ArrayList<String> matchList = new ArrayList<String>();
            String sqlpcmd1 = sqlpcmd.replaceFirst(CMD, "");
            matchList.add("col");
            Pattern pattern = Pattern.compile("([\\p{Graph}]+\\((\\'?[^\\(\\)]+\\'?,?)+\\))|\\$?\\b(([[09],]+(\\.[[09]Ee]+)?)|((?i:b|c|d|g|l|s|u|v)?([09]+((\\.|\\,|\\$)[09]*)?))|([09]+(((\\.|\\,|\\$)[09]*)|(?i:b|c|d|g|l|s|u|v)|(?i:pr|mi))?)|(?i:b|c|d|g|l|s|u|v)?([09]+((?i:b|c|d|g|l|s|u|v|[09])*)?)|((\\.|\\$)[09]+)|(?i:rn)|(?i:tm(9|e)?)|([09]+((\\.)[09]*)?(?i:e){4})|([09]*(?i:x)+)|((\\$)?[[09]\\,]+(\\.[09]+)?))\\b|(-?[\\w#]+(?:\\.[\\w#]+(?:E[\\w#]+)?)?(\\s*[-+/\\*]\\s*-?[\\w#]+(?:\\.[\\w#]+(?:E[\\w#]+)?)?)*)|(\\s+)|[^\\s\\\"']+|\\\"[^\\\"]*\\\"|'[^']*'|'[^'\\\"]*\\\"|\\\"[^'\\\"]*'");
            Matcher matcher = pattern.matcher(sqlpcmd1);
            while (matcher.find()) {
                String grp = matcher.group();
                if (grp.matches("\\w+\\s*-\\s*\\n\\w+")) {
                    String[] grps;
                    grp = grp.replaceAll("\\n|-", "");
                    for (String x : grps = grp.split("\\s+")) {
                        matchList.add(x);
                    }
                    continue;
                }
                if (grp.matches("\\s+")) continue;
                matchList.add(grp);
            }
            String[] cmds = new String[matchList.size()];
            matchList.toArray(cmds);
            if (cmds.length < 3) break block52;
            String col = cmds[1].toLowerCase();
            storedColumns = this.checkIgnoreSetting(ctx) ? ctx.get121IdentViewColCmds() : ctx.getStoredFormatCmds();
            String colcmd = sqlpcmd.replaceFirst(CMD, "").trim();
            if (col.equals("''") || col.equals("\"\"")) {
                ctx.write(MessageFormat.format(Messages.getString("INVALID_COLNAME"), col) + m_lineSeparator);
                return;
            }
            if (col.matches("'[^']+")) {
                String subcmd = colcmd.replaceFirst("'\\s*", "");
                ctx.write(MessageFormat.format(Messages.getString("NOT_TERMINATED"), "'", subcmd, "'") + m_lineSeparator);
                return;
            }
            if (col.matches("\"[^\"]+")) {
                String subcmd = colcmd.replaceFirst("\"\\s*", "");
                ctx.write(MessageFormat.format(Messages.getString("NOT_TERMINATED"), "\"", subcmd, "\"") + m_lineSeparator);
                return;
            }
            String clmn = this.getColumnForAlias(storedColumns, cmds[1]);
            col = clmn.isEmpty() ? col : clmn;
            ArrayList<Object> optslist = null;
            optslist = storedColumns.get(col) != null ? storedColumns.get(col) : new ArrayList();
            for (int i = 2; i < cmds.length; ++i) {
                String opts;
                block51: {
                    block60: {
                        block59: {
                            block57: {
                                block58: {
                                    block56: {
                                        block55: {
                                            Map<String, String> columnMap;
                                            block54: {
                                                block53: {
                                                    opts = "";
                                                    if (!cmds[i].matches(CLEAR)) break block53;
                                                    if (storedColumns.containsKey(col)) {
                                                        storedColumns.remove(col);
                                                        optslist = null;
                                                        continue;
                                                    }
                                                    ctx.write(MessageFormat.format(Messages.getString("COLUMN_NOTDEFINED"), col) + m_lineSeparator);
                                                    break block51;
                                                }
                                                if (!cmds[i].matches(NEWVAL)) break block54;
                                                columnMap = ctx.getColumnMap();
                                                columnMap.put(col.toUpperCase(), cmds[++i]);
                                                break block51;
                                            }
                                            if (!cmds[i].matches(OLDVAL)) break block55;
                                            columnMap = ctx.getOVColumnMap();
                                            columnMap.put(col.toUpperCase(), cmds[++i]);
                                            break block51;
                                        }
                                        if (!cmds[i].matches(ONOROFF)) break block56;
                                        if (cmds[i].matches(ON)) {
                                            this.removeItem(optslist, "off");
                                            break block51;
                                        } else if (cmds[i].matches(OFF) && !((String)optslist.get(0)).equalsIgnoreCase(cmds[i])) {
                                            optslist.add(0, cmds[i]);
                                        }
                                        break block51;
                                    }
                                    if (!cmds[i].matches(WRAP)) break block57;
                                    if (optslist.contains("wrapped")) {
                                        this.removeItem(optslist, "wrapped");
                                    } else if (optslist.contains("word_wrapped")) {
                                        this.removeItem(optslist, "word_wrapped");
                                    } else if (optslist.contains("truncated")) {
                                        this.removeItem(optslist, "truncated");
                                    }
                                    if (!cmds[i].matches(WRAPPED)) break block58;
                                    opts = "wrapped";
                                    break block51;
                                }
                                if (cmds[i].matches(WORD_WRAPPED)) {
                                    opts = "word_wrapped";
                                    break block51;
                                } else if (cmds[i].matches(TRUNCATED)) {
                                    opts = "truncated";
                                }
                                break block51;
                            }
                            if (!cmds[i].matches(PRNT)) break block59;
                            if (optslist.contains("noprint")) {
                                this.removeItem(optslist, "noprint");
                            } else {
                                this.removeItem(optslist, "print");
                            }
                            if (cmds[i].matches(PRINT)) {
                                opts = "print";
                                break block51;
                            } else if (cmds[i].matches(NPRINT)) {
                                opts = "noprint";
                            }
                            break block51;
                        }
                        if (!cmds[i].matches(FORMAT) && !cmds[i].matches(HEADING) && !cmds[i].matches(JUSTIFY) && !cmds[i].matches(NULL) && !cmds[i].matches(ALIAS)) break block60;
                        if (i == cmds.length - 1) {
                            String val = "";
                            if (cmds[i].matches(JUSTIFY)) {
                                ctx.write(MessageFormat.format(Messages.getString("UNKNOWN_COLJUSTIFY"), val) + m_lineSeparator);
                                break block51;
                            } else {
                                ctx.write(MessageFormat.format(Messages.getString("SQLPLUS.ATTRIBUTE_STRING_VALUE_MISSING"), val) + m_lineSeparator);
                            }
                            break block51;
                        } else {
                            this.removeItem(optslist, cmds[i]);
                            if (cmds[i].matches(FORMAT)) {
                                String fmtstr = cmds[i + 1];
                                if (!fmtstr.matches("(?i:a)[1-9]\\d*") && !this.isValidColFormat(fmtstr)) {
                                    ctx.write(MessageFormat.format(Messages.getString("ILLEGAL_COLFORMAT"), fmtstr) + m_lineSeparator);
                                    return;
                                }
                                opts = "format ";
                            } else if (cmds[i].matches(HEADING)) {
                                opts = "heading ";
                            } else if (cmds[i].matches(JUSTIFY)) {
                                opts = "justify ";
                            } else if (cmds[i].matches(NULL)) {
                                opts = "null ";
                            } else if (cmds[i].matches(ALIAS)) {
                                opts = "alias ";
                            }
                            String str = cmds[++i];
                            if (opts.startsWith("justify")) {
                                if (str.matches(LEFT)) {
                                    str = "left";
                                } else if (str.matches(CENTER)) {
                                    str = "center";
                                } else {
                                    if (!str.matches(RIGHT)) {
                                        ctx.write(MessageFormat.format(Messages.getString("UNKNOWN_COLOPTION1"), "JUSTIFY", cmds[i]) + m_lineSeparator);
                                        return;
                                    }
                                    str = "right";
                                }
                            }
                            str = str.replaceAll("['\"]", "");
                            opts = opts + str;
                        }
                        break block51;
                    }
                    if (!cmds[i].matches(FOLD_AFTER) && !cmds[i].matches(FOLD_BEFORE)) {
                        ctx.write(MessageFormat.format(Messages.getString("UNKNOWN_COLOPTION"), cmds[i]) + m_lineSeparator);
                        return;
                    }
                    ctx.write(Messages.getString("FOLD_BEFORE_AFTER_NOTSUPPORTED") + m_lineSeparator);
                }
                if (opts.equals("")) continue;
                if (optslist == null) {
                    optslist = new ArrayList();
                }
                optslist.add(opts);
            }
            if (optslist != null) {
                if (this.checkIgnoreSetting(ctx)) {
                    if (!optslist.contains("_12.1_longident")) {
                        optslist.add("_12.1_longident");
                    }
                } else if (optslist.contains("_12.1_longident")) {
                    this.removeItem(optslist, "_12.1_longident");
                }
                storedColumns.put(col, optslist);
            }
        }
    }

    private void removeItem(ArrayList<String> optslist, String opt) {
        if (optslist != null) {
            for (int k = 0; k < optslist.size(); ++k) {
                if (!optslist.get(k).startsWith(opt.toLowerCase()) && !optslist.get(k).equalsIgnoreCase(opt)) continue;
                optslist.remove(k);
                break;
            }
        }
    }

    private void printAllColumns(ScriptRunnerContext ctx, HashMap<String, ArrayList<String>> storedColumns) {
        if (storedColumns != null) {
            for (Map.Entry<String, ArrayList<String>> entry : storedColumns.entrySet()) {
                this.print(ctx, entry);
            }
        }
    }

    private void printColumn(ScriptRunnerContext ctx, HashMap<String, ArrayList<String>> storedColumns, String column) {
        if (column.length() > 0) {
            for (Map.Entry<String, ArrayList<String>> entry : storedColumns.entrySet()) {
                String col;
                String clmn = this.getColumnForAlias(storedColumns, column);
                String string = col = clmn.isEmpty() ? column : clmn;
                if (!entry.getKey().equalsIgnoreCase(col)) continue;
                this.print(ctx, entry);
                return;
            }
            if (this.validColumnName(column)) {
                ctx.write(MessageFormat.format(Messages.getString("COLUMN_NOTDEFINED"), column) + m_lineSeparator);
            } else {
                ctx.write(MessageFormat.format(Messages.getString("Column.0"), column) + m_lineSeparator);
            }
        }
    }

    private boolean validColumnName(String column) {
        return column.matches("[A-Za-z0-9]+") || column.matches("[A-Za-z_$#0-9]+");
    }

    private void print(ScriptRunnerContext ctx, Map.Entry<String, ArrayList<String>> entry) {
        if (ctx != null && entry != null) {
            boolean bNewValFound;
            String pstr = "";
            String sstr = "";
            String col = entry.getKey();
            ArrayList<String> cmdlist = entry.getValue();
            boolean bl = bNewValFound = ctx.getColumnMap().containsKey(col.toUpperCase()) || ctx.getOVColumnMap().containsKey(col.toUpperCase());
            if (cmdlist.size() > 0 || bNewValFound) {
                String str = "";
                if (cmdlist.size() > 0) {
                    str = cmdlist.get(0);
                } else if (bNewValFound) {
                    str = "ON";
                }
                pstr = str.equalsIgnoreCase("off") ? "COLUMN  " + col + " OFF" + m_lineSeparator : "COLUMN  " + col + " ON" + m_lineSeparator;
            }
            for (int i = 0; i < cmdlist.size(); ++i) {
                String str = cmdlist.get(i);
                if (str.equalsIgnoreCase("off")) continue;
                String[] cmds = str.split("\\s+");
                if (cmds.length > 1) {
                    if (cmds[0].equalsIgnoreCase("heading")) {
                        pstr = pstr + cmds[0].toUpperCase().trim() + "  '" + str.replaceFirst("\\b(?i:he(?:a|ad|adi|adin|ading))\\b\\s{1}", "") + "'";
                        pstr = pstr + m_lineSeparator;
                        continue;
                    }
                    if (cmds[0].equalsIgnoreCase("justify")) {
                        sstr = sstr + cmds[0].toUpperCase().trim() + " " + cmds[1] + " ";
                        continue;
                    }
                    pstr = pstr + cmds[0].toUpperCase().trim() + "  " + cmds[1] + m_lineSeparator;
                    continue;
                }
                sstr = cmds[0].equalsIgnoreCase("word_wrapped") ? sstr + "word_wrap " : (cmds[0].equalsIgnoreCase("wrapped") ? sstr + "wrap " : (cmds[0].equalsIgnoreCase("truncated") ? sstr + "truncate " : (cmds[0].equalsIgnoreCase("heading") ? sstr + cmds[0].toUpperCase().trim() + "  ''" : sstr + cmds[0].toUpperCase().trim() + " ")));
            }
            if (ctx.getColumnMap().containsKey(col.toUpperCase())) {
                pstr = pstr + "NEW_VALUE  " + ctx.getColumnMap().get(col.toUpperCase()) + m_lineSeparator;
            }
            if (ctx.getOVColumnMap().containsKey(col.toUpperCase())) {
                pstr = pstr + "OLD_VALUE  " + ctx.getOVColumnMap().get(col.toUpperCase()) + m_lineSeparator;
            }
            if (!pstr.endsWith(m_lineSeparator)) {
                pstr = pstr + m_lineSeparator;
            }
            if (sstr.length() > 0) {
                if (!sstr.endsWith(m_lineSeparator)) {
                    sstr = sstr + m_lineSeparator;
                }
                pstr = pstr + sstr;
            }
            ctx.write(pstr);
        }
    }

    boolean isValidColFormat(String fmtstr) {
        boolean bValid = true;
        String fmtdNum = "";
        String numfmtRegExpr = NUMFORMAT;
        return fmtstr.matches(numfmtRegExpr);
    }

    private String getColumnForAlias(HashMap<String, ArrayList<String>> storedColumns, String alias) {
        String column = "";
        if (alias.length() > 0) {
            for (Map.Entry<String, ArrayList<String>> entry : storedColumns.entrySet()) {
                String col = entry.getKey();
                ArrayList<String> ls = storedColumns.get(col);
                for (int k = 0; k < ls.size(); ++k) {
                    String colcmd = ls.get(k);
                    String[] cmds = colcmd.split("\\s");
                    if (!cmds[0].equalsIgnoreCase("alias")) continue;
                    for (int i = 1; i < cmds.length; ++i) {
                        if (i != cmds.length - 1 || !cmds[i].equals(alias)) continue;
                        column = col;
                        return column;
                    }
                }
            }
        }
        return column;
    }

    public void beginScript(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endScript(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return SHOWCOLUMN;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if ((ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) && ctx.getStoredFormatCmds() != null && ctx.getStoredFormatCmds().size() != 0) {
            String optionalHeader = (String)ctx.getProperty("script.runner.optional_show_header");
            if (optionalHeader != null && !optionalHeader.equals("")) {
                ctx.write(optionalHeader);
            }
            SQLCommand cmdTmp = new SQLCommand(SQLCommand.StmtType.G_C_SQLPLUS, SQLCommand.StmtSubType.G_S_COLUMN, SQLCommand.StmtResultType.G_R_NONE, false, Restricted.Level.R4);
            cmdTmp.setOrigSQL("column");
            cmdTmp.setSql("column");
            return this.handleEvent(conn, ctx, cmdTmp);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

