/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.EncodeAs;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.StructureType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingJSON;
import oracle.dbtools.raptor.datatypes.strategies.preparedstatement.PrepareBindingJSON;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.jdbc.driver.json.binary.OsonConstants;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonValue;

public class JSON
extends Datum {
    protected JSON(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        Object internalValue = value.getInternalValue();
        if (internalValue instanceof OracleJsonDatum) {
            return new StringValue(this.asOracleJsonValue(internalValue).toString(), maxLen);
        }
        if (internalValue instanceof OracleJsonValue) {
            return new StringValue(internalValue.toString(), maxLen);
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        try {
            switch (valueType) {
                case DATUM: {
                    return this.asOracleJsonDatum(internalValue);
                }
                case DEFAULT: {
                    return this.asOracleJsonValue(internalValue);
                }
            }
            return super.customTypedValue(connectionProvider, value, valueType, target);
        }
        catch (IllegalArgumentException e) {
            throw new DataTypeIllegalArgumentException(this, internalValue, e);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return OracleJsonDatum.class;
            }
            case DEFAULT: {
                return OracleJsonValue.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        return this.asOracleJsonValue(value);
    }

    @Override
    public <P extends DataBinding> BindingStrategy getBind(BindContext context, P param) {
        if (CallableStatement.class.isAssignableFrom(context.getEffectiveStatementClass())) {
            return new CallableBindingJSON(context, param);
        }
        return new PrepareBindingJSON(context, param);
    }

    @Override
    public StructureType getStructureType() {
        return StructureType.OPAQUE;
    }

    @Override
    public EncodeAs getEncodeAs() {
        return EncodeAs.JSON;
    }

    private OracleJsonDatum asOracleJsonDatum(Object value) {
        try {
            return JSON.asOracleJsonDatumX(value);
        }
        catch (Exception e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
    }

    private OracleJsonValue asOracleJsonValue(Object value) {
        try {
            OracleJsonValue jsonValue = JSON.asOracleJsonValueX(value);
            if (jsonValue == null) {
                throw new DataTypeIllegalArgumentException(this, value);
            }
            return jsonValue;
        }
        catch (Exception e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
    }

    private static OracleJsonDatum asOracleJsonDatumX(Object value) {
        if (value instanceof OracleJsonDatum) {
            return (OracleJsonDatum)value;
        }
        OracleJsonFactory factory = new OracleJsonFactory();
        OracleJsonValue jsonValue = JSON.asOracleJsonValueX(value);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (OracleJsonGenerator generator = factory.createJsonBinaryGenerator((OutputStream)os);){
            generator.write(jsonValue);
            generator.close();
            OracleJsonDatum oracleJsonDatum = new OracleJsonDatum(os.toByteArray());
            return oracleJsonDatum;
        }
    }

    private static OracleJsonValue asOracleJsonValueX(Object value) {
        if (value instanceof OracleJsonValue) {
            return (OracleJsonValue)value;
        }
        if (value instanceof OracleJsonDatum) {
            return JSON.asOracleJsonValueX(((OracleJsonDatum)value).shareBytes());
        }
        if (value instanceof CharSequence) {
            try (StringReader reader = new StringReader(value.toString());){
                OracleJsonValue oracleJsonValue = JSON.asOracleJsonValueX(reader);
                return oracleJsonValue;
            }
        }
        OracleJsonFactory factory = new OracleJsonFactory();
        if (value == null) {
            return factory.createNull();
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            try (OracleJsonParser parser = JSON.isOson(bytes) ? factory.createJsonBinaryParser(ByteBuffer.wrap(bytes)) : factory.createJsonTextParser((InputStream)new ByteArrayInputStream(bytes));){
                parser.next();
                OracleJsonValue oracleJsonValue = parser.getValue();
                return oracleJsonValue;
            }
        }
        if (value instanceof ByteBuffer) {
            ByteBuffer buf = (ByteBuffer)value;
            try (OracleJsonParser parser = JSON.isOson(buf) ? factory.createJsonBinaryParser(buf) : factory.createJsonTextParser((InputStream)JSON.asByteArrayInputStream(buf));){
                parser.next();
                OracleJsonValue oracleJsonValue = parser.getValue();
                return oracleJsonValue;
            }
        }
        if (value instanceof Reader) {
            try (OracleJsonParser parser = factory.createJsonTextParser((Reader)value);){
                parser.next();
                OracleJsonValue oracleJsonValue = parser.getValue();
                return oracleJsonValue;
            }
        }
        if (value instanceof InputStream) {
            BufferedInputStream is = new BufferedInputStream((InputStream)value);
            try (OracleJsonParser parser = JSON.isOson(is) ? factory.createJsonBinaryParser((InputStream)is) : factory.createJsonTextParser((InputStream)is);){
                parser.next();
                OracleJsonValue oracleJsonValue = parser.getValue();
                return oracleJsonValue;
            }
        }
        return null;
    }

    private static ByteArrayInputStream asByteArrayInputStream(ByteBuffer buf) {
        byte[] bytes = new byte[buf.remaining()];
        buf.get(bytes);
        return new ByteArrayInputStream(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isOson(BufferedInputStream is) {
        int readLimit = OsonConstants.MAGIC_BYTES.length + 1;
        is.mark(readLimit);
        try {
            byte[] bytes = new byte[readLimit];
            int length = is.read(bytes);
            boolean bl = JSON.isOson(bytes, length);
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                is.reset();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isOson(ByteBuffer buf) {
        int readLimit = OsonConstants.MAGIC_BYTES.length + 1;
        buf.mark();
        try {
            byte[] bytes = new byte[readLimit];
            buf.get(bytes);
            boolean bl = JSON.isOson(bytes, readLimit);
            return bl;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
        }
        finally {
            buf.reset();
        }
        return false;
    }

    private static boolean isOson(byte[] bytes) {
        return JSON.isOson(bytes, bytes.length);
    }

    private static boolean isOson(byte[] bytes, int length) {
        if (length <= bytes.length && length >= OsonConstants.MAGIC_BYTES.length + 1) {
            for (int i = 0; i < OsonConstants.MAGIC_BYTES.length; ++i) {
                if (bytes[i] == OsonConstants.MAGIC_BYTES[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class StringValueRenderer
    implements oracle.dbtools.raptor.utils.StringValueRenderer {
        @Override
        public String stringValue(Object obj, Connection conn, int maxLen, boolean logOnly, int displayValue, FormatType formatType) throws SQLException, IOException {
            if (obj instanceof OracleJsonDatum || obj instanceof OracleJsonValue) {
                try {
                    String str = JSON.asOracleJsonValueX(obj).toString();
                    if (str != null && maxLen > -1 && maxLen < str.length()) {
                        str = str.substring(0, maxLen);
                    }
                    return str;
                }
                catch (Exception e) {
                    if (logOnly) {
                        Logger.getLogger(JSON.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    }
                    if (e instanceof SQLException) {
                        throw (SQLException)e;
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new IOException(e);
                }
            }
            return null;
        }
    }
}

