/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RecognizedRule;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.util.Messages;
import oracle.dbtools.util.Service;

public class SyntaxError
extends AssertionError {
    public int line;
    public int offset;
    public int end;
    public String code;
    public String marker = "^^^";
    public String detailedMessageKey = "SyntaxError_DetailedMessage";
    private Map<RecognizedRule, Integer> weightedRules;
    private Earley earley;
    public Matrix matrix;
    static String TITLE = "Syntax Error";
    static final String MESSAGE_KEY = "SyntaxError_Message";

    public static SyntaxError checkSQLQuerySyntax(String input) {
        return SyntaxError.checkSyntax(input, new String[]{"subquery", "select", "sql_statement"});
    }

    public static SyntaxError checkSQLQuerySyntax(String input, String marker, String format) {
        return SyntaxError.checkSyntax(input, new String[]{"subquery", "select", "sql_statement"}, marker, format);
    }

    public static SyntaxError checkSQLStatementSyntax(String input) {
        return SyntaxError.checkSyntax(input, new String[]{"sql_statements"});
    }

    public static SyntaxError checkSQLStatementSyntax(String input, String marker, String format) {
        return SyntaxError.checkSyntax(input, new String[]{"sql_statements"}, marker, format);
    }

    public static SyntaxError checkSingleStatement(String input) {
        return SyntaxError.checkSyntax(input, new String[]{"sql_statement", "select", "insert", "update", "delete", "merge"});
    }

    public String[] getSuggestions() {
        LinkedList<String> ret = new LinkedList<String>();
        for (Long s : this.topNsuggestions()) {
            String candidate = this.earley.allSymbols[Service.lX(s)];
            if (ret.contains(candidate) || 0 < candidate.indexOf(91)) continue;
            ret.add(candidate);
        }
        return ret.toArray(new String[0]);
    }

    public static SyntaxError checkSyntax(String input, String[] grammarSymbols) {
        return SyntaxError.checkSyntax(input, grammarSymbols, "^^^", "SyntaxError_DetailedMessage");
    }

    private static SyntaxError checkSyntax(String input, String[] grammarSymbols, String marker, String format) {
        List<LexerToken> src = Lexer.parse(input);
        SqlEarley earley = SqlEarley.partialRecognizer();
        Matrix matrix = new Matrix(earley);
        ((Earley)earley).parse(src, matrix);
        return SyntaxError.checkSyntax(input, grammarSymbols, src, earley, matrix, marker, format);
    }

    public static SyntaxError checkSyntax(String input, String[] grammarSymbols, List<LexerToken> src, Earley earley, Matrix matrix) {
        return SyntaxError.checkSyntax(input, grammarSymbols, src, earley, matrix, "^^^", "SyntaxError_DetailedMessage");
    }

    public static SyntaxError checkSyntax(String input, String[] grammarSymbols, List<LexerToken> src, Earley earley, Matrix matrix, String marker, String format) {
        Parser.EarleyCell top = matrix.get(0, src.size());
        if (top != null) {
            for (String s : grammarSymbols) {
                for (int i = 0; i < top.size(); ++i) {
                    Parser.Tuple tuple = earley.rules[top.getRule(i)];
                    String candidate = earley.allSymbols[tuple.head];
                    if (!candidate.equals(s)) continue;
                    return null;
                }
            }
        }
        int maxY = matrix.lastY();
        int end = 0;
        if (0 < maxY) {
            end = src.get((int)(maxY - 1)).end;
        }
        int line = 0;
        int beginLinePos = 0;
        int endLinePos = input.length();
        for (int i = 0; i < endLinePos; ++i) {
            if (input.charAt(i) != '\n') continue;
            if (i < end) {
                ++line;
                beginLinePos = i;
                continue;
            }
            endLinePos = i;
            break;
        }
        String code = input.substring(beginLinePos, endLinePos);
        int offset = end - beginLinePos;
        LexerToken token = null;
        if (maxY < src.size()) {
            token = src.get(maxY);
        } else if (maxY == src.size()) {
            token = src.get(maxY - 1);
        }
        TreeMap<RecognizedRule, Integer> rules = new TreeMap<RecognizedRule, Integer>();
        SyntaxError.pendingRules(earley, matrix, maxY, null, rules);
        if (token.end == input.length()) {
            SyntaxError.pendingRules(earley, matrix, maxY - 1, token, rules);
        }
        for (RecognizedRule rp : rules.keySet()) {
            long s = SyntaxError.parentChildSymbols(rp, earley);
            String ss = earley.allSymbols[Service.lX(s)];
            if (!SyntaxError.isTypo(ss, token)) continue;
            rules = new TreeMap();
            rules.put(rp, 1);
            return new SyntaxError(line, offset, token.begin, code, Service.identln(offset, marker), rules, earley, matrix, format);
        }
        return new SyntaxError(line, offset, end, code, Service.identln(offset, marker), rules, earley, matrix, format);
    }

    private static void pendingRules(Earley earley, Matrix matrix, int y, LexerToken token, Map<RecognizedRule, Integer> rules) {
        if (y < 0) {
            return;
        }
        for (int x = 0; x <= y; ++x) {
            Parser.EarleyCell cell = matrix.get(x, y);
            if (cell == null) continue;
            for (int i = 0; i < cell.size(); ++i) {
                String symbol;
                int rule = cell.getRule(i);
                int pos = cell.getPosition(i);
                Parser.Tuple t = earley.rules[rule];
                if (pos >= t.rhs.length || (symbol = earley.allSymbols[t.rhs[pos]]).startsWith("xml")) continue;
                String[] rhs = new String[t.rhs.length];
                for (int j = 0; j < rhs.length; ++j) {
                    rhs[j] = earley.allSymbols[t.rhs[j]];
                }
                if (token == null) {
                    rules.put(new RecognizedRule(earley.allSymbols[t.head], rhs, pos, x, y, 1), 1);
                    continue;
                }
                if (token.type != Token.IDENTIFIER || !earley.isTerminal(earley.rules[rule].rhs[pos]) || !symbol.substring(1).toUpperCase().startsWith(token.content.toUpperCase()) || symbol.length() == token.content.length() + 2) continue;
                rules.put(new RecognizedRule(earley.allSymbols[t.head], rhs, pos, x, y, 10), 10);
            }
        }
    }

    private static boolean isTypo(String symbol, LexerToken token) {
        if (token == null || token.begin + 1 == token.end || token.begin + 2 == token.end) {
            return false;
        }
        String candidate = "'" + token.content.toUpperCase() + "'";
        if (symbol.length() + 1 == candidate.length() || symbol.length() == candidate.length() + 1 || symbol.length() == candidate.length()) {
            int i;
            int matched = 0;
            int brokenAt = -1;
            for (i = 0; i < symbol.length() && i < candidate.length(); ++i) {
                if (symbol.charAt(i) == candidate.charAt(i)) {
                    ++matched;
                    continue;
                }
                brokenAt = i;
                break;
            }
            if (brokenAt + 1 < symbol.length() && brokenAt + 1 < candidate.length() && symbol.charAt(brokenAt + 1) == candidate.charAt(brokenAt + 1)) {
                for (i = brokenAt + 1; i < symbol.length() && i < candidate.length() && symbol.charAt(i) == candidate.charAt(i); ++i) {
                    ++matched;
                }
            } else if (brokenAt + 1 < symbol.length() && symbol.charAt(brokenAt + 1) == candidate.charAt(brokenAt)) {
                for (i = brokenAt; i + 1 < symbol.length() && i < candidate.length() && symbol.charAt(i + 1) == candidate.charAt(i); ++i) {
                    ++matched;
                }
            } else if (brokenAt + 1 < candidate.length() && symbol.charAt(brokenAt) == candidate.charAt(brokenAt + 1)) {
                for (i = brokenAt; i < symbol.length() && i + 1 < candidate.length() && symbol.charAt(i) == candidate.charAt(i + 1); ++i) {
                    ++matched;
                }
            }
            if (matched == symbol.length() - 1 || matched == candidate.length() - 1) {
                return true;
            }
        }
        return false;
    }

    private SyntaxError(int line, int offset, int end, String code, String marker, Map<RecognizedRule, Integer> rules, Earley earley, Matrix matrix, String format) {
        this.line = line;
        this.offset = offset;
        this.end = end;
        this.code = code;
        this.marker = marker;
        this.weightedRules = rules;
        this.earley = earley;
        this.detailedMessageKey = format;
        this.matrix = matrix;
    }

    public String toString() {
        return this.getDetailedMessage();
    }

    public String getDetailedMessage() {
        String pointer = Service.padln(this.marker, this.code.length());
        StringBuilder allSuggestions = new StringBuilder();
        LinkedList<String> ret = new LinkedList<String>();
        for (long s : this.topNsuggestions()) {
            String candidate = this.earley.allSymbols[Service.lX(s)];
            if (ret.contains(candidate) || 0 < candidate.indexOf(91)) continue;
            ret.add(candidate);
            allSuggestions.append(candidate + ',');
        }
        String suggestions = allSuggestions.toString();
        if (60 < suggestions.length()) {
            suggestions = suggestions.substring(0, 50);
        }
        try {
            return Messages.format(this.detailedMessageKey, this.line + 1, this.offset, suggestions, this.code, pointer);
        }
        catch (NoClassDefFoundError e) {
            return "Syntax Error at line " + (this.line + 1) + ", column " + this.offset + "\n\n" + suggestions + "\n" + this.code + "\n\nExpected: " + pointer;
        }
    }

    public String getMessage() {
        StringBuilder allSuggestions = new StringBuilder();
        LinkedList<String> ret = new LinkedList<String>();
        for (long s : this.topNsuggestions()) {
            String candidate = this.earley.allSymbols[Service.lX(s)];
            if (ret.contains(candidate) || 0 < candidate.indexOf(91)) continue;
            ret.add(candidate);
            allSuggestions.append(candidate + ',');
        }
        String suggestions = allSuggestions.toString();
        if (60 < suggestions.length()) {
            suggestions = suggestions.substring(0, 50);
        }
        return Messages.format(MESSAGE_KEY, this.line + 1, this.offset, suggestions);
    }

    public String getTitle() {
        return TITLE;
    }

    /*
     * WARNING - void declaration
     */
    public List<Long> topNsuggestions() {
        TreeMap<Long, Integer> topN = new TreeMap<Long, Integer>();
        int N = 10;
        for (RecognizedRule recognizedRule : this.weightedRules.keySet()) {
            long l = -1L;
            int minVal = Integer.MAX_VALUE;
            Iterator iterator = topN.keySet().iterator();
            while (iterator.hasNext()) {
                long s = (Long)iterator.next();
                int tmp = (Integer)topN.get(s);
                if (tmp >= minVal) continue;
                l = s;
                minVal = tmp;
            }
            long suggestedVar = SyntaxError.parentChildSymbols(recognizedRule, this.earley);
            Integer suggestedVal = HarvestDoc.getFrequencies().get(suggestedVar);
            if (suggestedVal == null) {
                suggestedVal = 0;
            }
            if (topN.size() == 10) {
                if (suggestedVal == null || minVal >= suggestedVal) continue;
                topN.remove(l);
                topN.put(suggestedVar, suggestedVal);
                continue;
            }
            topN.put(suggestedVar, suggestedVal);
        }
        ArrayList myList = new ArrayList();
        for (Map.Entry entry : topN.entrySet()) {
            myList.add(entry);
        }
        Collections.sort(myList, new Comparator<Map.Entry<Long, Integer>>(){

            @Override
            public int compare(Map.Entry a, Map.Entry b) {
                return ((Integer)b.getValue()).compareTo((Integer)a.getValue());
            }
        });
        LinkedList<Long> linkedList = new LinkedList<Long>();
        boolean bl = false;
        for (Map.Entry e : myList) {
            void var5_11;
            if (10 < var5_11) break;
            linkedList.add((Long)e.getKey());
            ++var5_11;
        }
        return linkedList;
    }

    /*
     * WARNING - void declaration
     */
    public List<RecognizedRule> topNrules(int N, boolean excludeAux) {
        TreeMap<RecognizedRule, Integer> topN = new TreeMap<RecognizedRule, Integer>();
        for (RecognizedRule recognizedRule : this.weightedRules.keySet()) {
            long l = SyntaxError.parentChildSymbols(recognizedRule, this.earley);
            Integer suggestedVal = HarvestDoc.getFrequencies().get(l);
            if (suggestedVal == null) {
                suggestedVal = 0;
            }
            suggestedVal = suggestedVal * this.weightedRules.get(recognizedRule);
            if (excludeAux && 0 < recognizedRule.head.indexOf(91)) continue;
            RecognizedRule candidate = recognizedRule;
            Integer frequency = (Integer)topN.get(candidate);
            if (frequency == null) {
                frequency = 0;
            }
            candidate.weight = frequency + suggestedVal;
            topN.put(candidate, frequency + suggestedVal);
        }
        ArrayList myList = new ArrayList();
        for (Map.Entry entry : topN.entrySet()) {
            myList.add(entry);
        }
        Collections.sort(myList, new Comparator<Map.Entry<RecognizedRule, Integer>>(){

            @Override
            public int compare(Map.Entry a, Map.Entry b) {
                return ((Integer)b.getValue()).compareTo((Integer)a.getValue());
            }
        });
        LinkedList<RecognizedRule> linkedList = new LinkedList<RecognizedRule>();
        boolean bl = false;
        for (Map.Entry e : myList) {
            void var6_11;
            if (N < var6_11) break;
            linkedList.add((RecognizedRule)e.getKey());
            ++var6_11;
        }
        return linkedList;
    }

    private static long parentChildSymbols(RecognizedRule rp, Earley earley) {
        long entry = Service.lPair((Integer)earley.symbolIndexes.get(rp.rhs[rp.pos]), (Integer)earley.symbolIndexes.get(rp.head));
        return entry;
    }

    public static void main(String[] args) throws Exception {
        String input = "select 1 from dual,";
        SyntaxError ret = SyntaxError.checkSQLStatementSyntax(input);
        System.out.println(ret.getDetailedMessage());
        System.out.println("-----------------------------");
        for (RecognizedRule rr : ret.topNrules(3, true)) {
            System.out.println(rr.toString());
        }
    }

    static {
        try {
            TITLE = Messages.getString("SyntaxError_Title");
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            // empty catch block
        }
    }
}

