/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parseable;
import oracle.dbtools.parser.plsql.EarleyRegressionTest;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.util.Service;

public class StackParser
implements Parseable {
    private static StackParser instance = null;
    private static boolean debug = false;

    public static StackParser getInstance() {
        if (instance == null) {
            instance = new StackParser();
        }
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LazyNode parse(List<LexerToken> src) {
        String token;
        LinkedList<LazyNode> stack = new LinkedList<LazyNode>();
        LazyNode pseudoRoot = new LazyNode(0, "pseudo root", src);
        pseudoRoot.to = src.size();
        stack.add(pseudoRoot);
        LexerToken prior = null;
        LexerToken prior2 = null;
        LexerToken current = null;
        int pos = -1;
        for (LexerToken lexerToken : src) {
            Iterator<LazyNode> n;
            String token2;
            if (debug) {
                System.out.print(pos + " level=" + stack.size() + "       ");
                if (current != null) {
                    current.print();
                }
            }
            if (stack.size() == 0 || current != null && ((token2 = current.content) == null || (n = StackParser.oneIter(src, stack, prior, prior2, lexerToken, pos, token2)) != null)) break;
            prior2 = prior;
            prior = current;
            current = lexerToken;
            ++pos;
        }
        if (current != null && (token = current.content) != null && stack.size() != 0) {
            LazyNode lazyNode = StackParser.oneIter(src, stack, prior, prior2, null, pos, token);
        }
        HashMap<void, LazyNode> declare2plsql = new HashMap<void, LazyNode>();
        Object var9_12 = null;
        int end = -1;
        for (LazyNode child : pseudoRoot.shallowChildren()) {
            void var9_13;
            end = child.to;
            if ("create".equalsIgnoreCase(child.startToken)) {
                LazyNode lazyNode = child;
                continue;
            }
            if (var9_13 == null || !child.isCompilationUnit()) continue;
            declare2plsql.put(var9_13, child);
            Object var9_15 = null;
        }
        for (LazyNode declair : declare2plsql.keySet()) {
            LazyNode plsql = (LazyNode)declare2plsql.get(declair);
            declair.addTopLevel(plsql);
            declair.to = plsql.to;
            pseudoRoot.topLevel.remove(plsql);
        }
        this.processStackLeftover(stack);
        if (pseudoRoot.shallowChildren().size() == 0 && pseudoRoot.from < src.size()) {
            pseudoRoot.startToken = src.get((int)pseudoRoot.from).content;
        }
        if (pseudoRoot.shallowChildren().size() == 1) {
            for (LazyNode child : pseudoRoot.shallowChildren()) {
                if (child.from == pseudoRoot.from && child.to == pseudoRoot.to) {
                    pseudoRoot = child;
                }
                if (child.to != -1) continue;
                child.to = pseudoRoot.to;
            }
        }
        if (-1 < end && end < pseudoRoot.to) {
            String label = src.get((int)end).content;
            LazyNode more = new LazyNode(end, label, src);
            more.to = src.size();
            if (more.isDML(null)) {
                pseudoRoot.addTopLevel(more);
            }
        }
        return pseudoRoot;
    }

    private void processStackLeftover(LinkedList<LazyNode> stack) {
        LazyNode above = null;
        for (LazyNode current : stack) {
            current.isWellFormed = false;
            if (above != null) {
                above.addTopLevel(current);
                if (current.to == -1) {
                    current.to = above.to;
                }
            }
            above = current;
        }
    }

    private static LazyNode oneIter(List<LexerToken> src, LinkedList<LazyNode> stack, LexerToken prior, LexerToken prior2, LexerToken next, int pos, String token) {
        LazyNode candidate = new LazyNode(pos, token, src);
        LazyNode top = stack.getLast();
        if (top == null) {
            return new LazyNode(pos, "top==null", src);
        }
        String nextStr = next == null ? null : next.content;
        String nextTop = null;
        if (candidate.isDDL(nextStr) && (prior == null || ";".equals(prior.content) || "/".equals(prior.content)) && !top.isDDL(nextTop) || candidate.isAs() && top.isCompilationUnit() && !"external".equalsIgnoreCase(nextStr) || candidate.isCompilationUnit() && !top.isDDL(nextTop) && !top.isDML(nextTop) && !"(".equals(top.startToken) && (prior == null || !".".equals(prior.content)) && (!candidate.isProcedure() || !"type".equals(top.startToken) || prior == null || !"member".equalsIgnoreCase(prior.content) && !"static".equalsIgnoreCase(prior.content)) || candidate.isDML(nextStr) && !top.isDML(nextTop) && !"(".equals(top.startToken) && !top.isDDL(nextTop) && !top.isAs() && (prior == null || !"with".equalsIgnoreCase(token) || !"time".equalsIgnoreCase(prior.content) && !"timestamp".equalsIgnoreCase(prior.content)) && (prior == null || !"update".equalsIgnoreCase(token) || !"for".equalsIgnoreCase(prior.content)) || "declare".equalsIgnoreCase(token) && !top.isDDL(nextTop) && !top.isAs() || "begin".equalsIgnoreCase(token) && !top.isAs() && !top.isDDL(nextTop) || "if".equalsIgnoreCase(token) && prior != null && !"end".equalsIgnoreCase(prior.content) && !top.isDDL(nextTop) || "case".equalsIgnoreCase(token) && prior != null && !"end".equalsIgnoreCase(prior.content) && !top.isDDL(nextTop) || "loop".equalsIgnoreCase(token) && !top.isDML(nextTop) && !top.isAs() && !"(".equals(top.startToken) && prior != null && !"end".equalsIgnoreCase(prior.content) && !top.isDDL(nextTop) || "type".equalsIgnoreCase(token) && top.isDDL(nextTop) && !"replace".equals(prior.content) && !"create".equals(prior.content) || "for".equalsIgnoreCase(token) && (prior2 == null || !"open".equalsIgnoreCase(prior2.content)) && !StackParser.isPivot(top, src) && !top.isDDL(nextTop) && !top.isAs() && !"ORDINALITY".equalsIgnoreCase(nextStr) || "while".equalsIgnoreCase(token) && !top.isDDL(nextTop) || "(".equals(token)) {
            stack.add(candidate);
        } else if ("update".equalsIgnoreCase(token) && prior != null && "for".equalsIgnoreCase(prior.content) && "for".equalsIgnoreCase(top.startToken)) {
            top.to = pos;
            if (debug) {
                System.out.println("+level=" + stack.size() + "       " + top.startToken + "..." + src.get((int)(top.to - 1)).content);
            }
            stack.removeLast();
            if (stack.size() == 0) {
                return new LazyNode(0, "error", src);
            }
        } else if ("begin".equalsIgnoreCase(token) && top.isAs() || "exception".equalsIgnoreCase(token) && top.isBlock(null) && !next.content.equals(";") || candidate.isCompilationUnit() && "create".equalsIgnoreCase(top.startToken)) {
            top.to = pos;
            if (debug) {
                System.out.println("+level=" + stack.size() + "       " + top.startToken + "..." + src.get((int)(top.to - 1)).content);
            }
            stack.removeLast();
            if (stack.size() == 0) {
                return new LazyNode(0, "error", src);
            }
            stack.getLast().addTopLevel(top);
            stack.add(candidate);
        } else if ((!"/".equals(token) || stack.size() != 1) && (";".equals(token) && top.isCompilationUnit() || ";".equals(token) && top.isDML(nextTop) || ";".equals(token) && top.isDDL(nextTop) || "/".equals(token) && top.isDDL(nextTop) || ";".equals(token) && "if".equalsIgnoreCase(top.startToken) && prior != null && "if".equalsIgnoreCase(prior.content) || ";".equals(token) && "for".equalsIgnoreCase(top.startToken) && prior != null && "loop".equalsIgnoreCase(prior.content) || ";".equals(token) && "for".equalsIgnoreCase(top.startToken) && prior2 != null && "loop".equalsIgnoreCase(prior2.content) || ";".equals(token) && "while".equalsIgnoreCase(top.startToken) && prior != null && "loop".equalsIgnoreCase(prior.content) || ";".equals(token) && "while".equalsIgnoreCase(top.startToken) && prior2 != null && "loop".equalsIgnoreCase(prior2.content) || ";".equals(token) && "declare".equalsIgnoreCase(top.startToken) && prior != null && "end".equalsIgnoreCase(prior.content) || ";".equals(token) && "declare".equalsIgnoreCase(top.startToken) && prior2 != null && "end".equalsIgnoreCase(prior2.content) || "end".equalsIgnoreCase(token) && "case".equalsIgnoreCase(top.startToken) || "end".equalsIgnoreCase(token) && "begin".equalsIgnoreCase(top.startToken) || "end".equalsIgnoreCase(token) && "exception".equalsIgnoreCase(top.startToken) || "end".equalsIgnoreCase(token) && "loop".equalsIgnoreCase(top.startToken) || "end".equalsIgnoreCase(token) && "type".equalsIgnoreCase(top.startToken) || "end".equalsIgnoreCase(token) && top.isAs() || ")".equals(token) || prior != null && "language".equalsIgnoreCase(prior.content) && "java".equalsIgnoreCase(token) && top.isAs())) {
            top.to = pos + 1;
            if ("begin".equalsIgnoreCase(top.startToken) && next != null && next.content.equalsIgnoreCase(";") || "exception".equalsIgnoreCase(top.startToken) && next != null && next.content.equalsIgnoreCase(";")) {
                top.to = pos + 2;
            }
            if (debug) {
                System.out.println("+level=" + stack.size() + "       " + top.startToken + "..." + src.get((int)(top.to - 1)).content);
            }
            stack.removeLast();
            if (stack.size() == 0) {
                return new LazyNode(pos, "error", src);
            }
            stack.getLast().addTopLevel(top);
        }
        return null;
    }

    private static boolean isPivot(LazyNode top, List<LexerToken> src) {
        boolean isXML;
        int priorPos = top.from - 1;
        if (priorPos < 0) {
            return false;
        }
        String priorToTop = src.get((int)priorPos).content;
        boolean isUPivot = priorToTop != null && priorToTop.toLowerCase().endsWith("pivot");
        boolean isNulls = "nulls".equalsIgnoreCase(priorToTop);
        if (isNulls && !isUPivot) {
            int priorPos2 = priorPos - 2;
            if (priorPos2 < 0) {
                return false;
            }
            String prior2 = src.get((int)priorPos2).content;
            boolean bl = isUPivot = prior2 != null && prior2.toLowerCase().endsWith("pivot");
        }
        if ((isXML = "xml".equalsIgnoreCase(priorToTop)) && !isUPivot) {
            int priorPos1 = priorPos - 1;
            if (priorPos1 < 0) {
                return false;
            }
            String prior1 = src.get((int)priorPos1).content;
            isUPivot = prior1 != null && prior1.toLowerCase().endsWith("pivot");
        }
        return "(".equals(top.startToken) && 0 < top.from && isUPivot;
    }

    public static void main(String[] dummy) throws Exception {
        if (!debug) {
            String testFile = "stack_parser.test";
            EarleyRegressionTest test = new EarleyRegressionTest();
            EarleyRegressionTest.parser = StackParser.getInstance();
            test.test(testFile);
            return;
        }
        String input = Service.readFile(StackParser.class, "test.sql");
        final Thread main = Thread.currentThread();
        new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(850L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                main.interrupt();
            }
        }.start();
        long h = Runtime.getRuntime().totalMemory();
        long hf = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (h - hf));
        long t1 = System.currentTimeMillis();
        List<LexerToken> src = Lexer.parse(input);
        System.gc();
        h = Runtime.getRuntime().totalMemory();
        hf = Runtime.getRuntime().freeMemory();
        System.out.println("lex mem=" + (h - hf));
        long t2 = System.currentTimeMillis();
        System.out.println("lex time = " + (t2 - t1));
        System.gc();
        ParseNode root = StackParser.getInstance().parse((List)src);
        h = Runtime.getRuntime().totalMemory();
        hf = Runtime.getRuntime().freeMemory();
        System.out.println("parse mem=" + (h - hf));
        long t3 = System.currentTimeMillis();
        System.out.println("parse time = " + (t3 - t2));
        HashSet<Long> tmp = new HashSet<Long>();
        for (ParseNode desc : root.descendants()) {
            Iterator iterator = tmp.iterator();
            while (iterator.hasNext()) {
                long t = (Long)iterator.next();
                int x = Service.lX(t);
                int y = Service.lY(t);
                if ((desc.from >= x || x >= desc.to || desc.to >= y) && (x >= desc.from || desc.from >= y || y >= desc.to)) continue;
                System.out.println("[x,y)=[" + x + "," + y + ")\n[from,to)=[" + desc.from + "," + desc.to + ")");
                t2 = System.currentTimeMillis();
                System.out.println("time = " + (t2 - t1));
                System.exit(0);
            }
            tmp.add(Service.lPair(desc.from, desc.to));
        }
        if (src.size() < 1000) {
            root.printTree();
        }
        t1 = System.currentTimeMillis();
        for (ParseNode desc : root.descendants()) {
            LazyNode node = (LazyNode)desc;
            if (!node.isProcedure()) continue;
            node.expand();
        }
        t2 = System.currentTimeMillis();
        System.out.println("expand time = " + (t2 - t1));
    }
}

