/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.insight.BasicInsightableOracleDatabase;
import oracle.dbtools.insight.SynonymsCache;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.BasicSuggestedItem;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SqlKeywords;
import oracle.dbtools.util.Pair;

public class BasicTabCol {
    public static String host = "jdbc:oracle:thin:@localhost:1521:xe";
    public static String user = "scott";
    public static String pwd = "tiger";
    private String connName;
    private boolean _noCols = false;
    public List<String> colTypesToExclude = null;
    public List<String> colNamesToExclude = null;
    public Object resultSet = null;
    public TreeSet<BasicSuggestedItem> resultSetColumns = null;
    private int optionBits = 0;
    public static final int ExcludeVirtualColumns = 1;
    public static final int BogusFlag = 2;
    public static final int NextFlag = 4;
    private SynonymsCache synonyms = null;
    static int where_clause = -1;
    static int subquery = -1;
    static int scalar_subquery_expression = -1;
    static int par_subquery = -1;
    static int query_table_expression = -1;
    static int table_reference = -1;
    static int as = -1;
    static int select_term = -1;
    static int expr = -1;
    static int identifier = -1;
    static int dot = -1;
    static int star = -1;
    static int mult_op = -1;
    static int select = -1;
    static int select_list = -1;
    static int query_block = -1;
    private String _input = null;
    private List<LexerToken> _src;
    private Set<BasicSuggestedItem> dbColumns;
    private Map<String, String> _tblAliases;
    private Map<ParseNode, String> _tables;
    private String _prefix;
    private String _suffix;
    static Integer indAll;
    static Integer indWhenever;
    public Set<BasicSuggestedItem> excludedColumns = new TreeSet<BasicSuggestedItem>();

    public BasicTabCol(String connName) {
        this.connName = connName;
        if (connName.startsWith("jdbc:oracle:thin:@")) {
            this.synonyms = SynonymsCache.fillIn(connName);
        }
    }

    public void setFlags(int option) {
        if (option < 0 || 7 < option) {
            throw new AssertionError((Object)"Unsupported option");
        }
        this.optionBits |= option;
    }

    private static List<LexerToken> lex(String input) {
        return LexerToken.parse(input);
    }

    private static ParseNode parse(List<LexerToken> src) {
        SqlEarley earley = SqlEarley.getInstance();
        Matrix matrix = new Matrix(earley);
        earley.parse(src, matrix);
        return earley.forest(src, matrix);
    }

    public Map<ParseNode, String> tblNames(ParseNode root, List<LexerToken> src) {
        TreeMap<ParseNode, String> ret = new TreeMap<ParseNode, String>();
        Iterator<ParseNode> iterator = BasicTabCol.getTableNodes(root).iterator();
        while (iterator.hasNext()) {
            ParseNode node;
            ParseNode tbl = node = iterator.next();
            String t = tbl.content(src);
            Pair<ParseNode, ParseNode> ppn = BasicTabCol.findTableAlias(tbl);
            if (ppn != null) {
                ParseNode tabRef;
                t = ppn.second().content(src);
                tbl = ppn.first();
                ParseNode ordSubq = root.descendant(tbl.from, tbl.to, scalar_subquery_expression);
                ParseNode tabSubq = root.descendant(tbl.from, tbl.to, query_table_expression);
                ParseNode withSubq = root.descendant(tbl.from, tbl.to, par_subquery);
                ParseNode iView = null;
                if (ordSubq == null && tabSubq == null && withSubq != null) {
                    iView = withSubq;
                } else if (ordSubq == null && withSubq == null && tabSubq != null) {
                    iView = tabSubq;
                } else if (ordSubq != null && tabSubq == null && withSubq == null) {
                    iView = ordSubq;
                } else if (ordSubq != null && tabSubq != null && ordSubq.from <= tabSubq.from) {
                    iView = tabSubq;
                } else if (ordSubq != null && tabSubq != null && ordSubq.from >= tabSubq.from) {
                    iView = ordSubq;
                }
                if (iView != null && (tabRef = iView.parent()).contains(table_reference)) {
                    for (ParseNode child : tabRef.children()) {
                        if (!child.contains(identifier)) continue;
                        tbl = child;
                    }
                }
            }
            if (this.synonyms != null) {
                String table;
                String prefix = null;
                String postfix = t;
                List<LexerToken> tmp = LexerToken.parse(postfix);
                if (tmp.size() == 3 && ".".equals(tmp.get((int)1).content)) {
                    prefix = tmp.get((int)0).content;
                    postfix = tmp.get((int)2).content;
                }
                if ((table = this.synonyms.getTable(prefix, postfix)) != null) {
                    t = table;
                }
            }
            ret.put(tbl, t);
        }
        return ret;
    }

    private static List<ParseNode> getTableNodes(ParseNode root) {
        LinkedList<ParseNode> ret = new LinkedList<ParseNode>();
        for (ParseNode child : root.children()) {
            if (child.contains(table_reference) && child.to - child.from < 5) {
                ret.add(child);
                continue;
            }
            if (child.contains(where_clause)) continue;
            ret.addAll(BasicTabCol.getTableNodes(child));
        }
        return ret;
    }

    public static Map<String, ParseNode> getInlineViewNodes(ParseNode root, List<LexerToken> src) {
        TreeMap<String, ParseNode> ret = new TreeMap<String, ParseNode>();
        for (ParseNode child : root.children()) {
            if (!child.contains(select_list) && (child.contains(query_table_expression) || child.contains(scalar_subquery_expression) || child.contains(par_subquery))) {
                for (ParseNode grandChild : child.children()) {
                    if (!grandChild.contains(subquery)) continue;
                    String prior = src.get((int)(child.from - 1)).content;
                    if ("as".equalsIgnoreCase(prior)) {
                        ret.put(src.get((int)(child.from - 2)).content.toLowerCase(), grandChild);
                        continue;
                    }
                    ret.put("inline subquery", grandChild);
                }
                continue;
            }
            if (child.contains(where_clause) || child.contains(select_list)) continue;
            ret.putAll(BasicTabCol.getInlineViewNodes(child, src));
        }
        return ret;
    }

    public ArrayList<Column> fetchColumns(String input) throws Exception {
        return this.fetchColumns(input, true);
    }

    public ArrayList<Column> fetchColumns(String input, boolean shortCircuit) throws Exception {
        Map<String, ParseNode> inlineViews;
        this._input = input;
        this._src = BasicTabCol.lex(input);
        ParseNode root = BasicTabCol.parse(this._src);
        this._tables = this.tblNames(root, this._src);
        ParseNode selectNode = BasicTabCol.getSelectList(BasicTabCol.getMainQueryBlock(root));
        if (selectNode == null) {
            return null;
        }
        int selBegin = this._src.get((int)selectNode.from).begin;
        int selEnd = this._src.get((int)(selectNode.to - 1)).end;
        this._prefix = input.substring(0, selBegin);
        this._suffix = input.substring(selEnd);
        ArrayList<Column> columns = BasicTabCol.extractColumns(selectNode, this._src, shortCircuit, this.excludeCondition());
        if ("*".equals(selectNode.content(this._src)) && (inlineViews = BasicTabCol.getInlineViewNodes(root, this._src)).size() > 0) {
            ParseNode candidate = inlineViews.get("inline subquery");
            if (candidate == null) {
                candidate = inlineViews.get(this._src.get((int)(selectNode.to + 1)).content.toLowerCase());
            }
            ParseNode inlineViewSelectList = BasicTabCol.getSelectList(candidate);
            ArrayList<Column> inlineViewColumns = BasicTabCol.extractColumns(inlineViewSelectList, this._src, false, this.excludeCondition());
            if ("*".equals(inlineViewSelectList.content(this._src))) {
                this.fetchDbCols();
                return columns;
            }
            this.dbColumns = new TreeSet<BasicSuggestedItem>();
            for (int i = 0; i < inlineViewColumns.size(); ++i) {
                Column c = inlineViewColumns.get(i);
                String colName = c.alias;
                if (colName == null) {
                    ParseNode cExpr = c.colExpr;
                    if (cExpr == null) {
                        throw new Exception("cExpr == null");
                    }
                    if (cExpr.to - cExpr.from == 3 || cExpr.to - cExpr.from == 1) {
                        colName = this._src.get((int)(cExpr.to - 1)).content;
                    } else {
                        throw new Exception("unexpected cExpr");
                    }
                }
                BasicSuggestedItem item = new BasicSuggestedItem("COLUMN", null, colName, i);
                this.dbColumns.add(item);
            }
            this._tblAliases = new TreeMap<String, String>();
            this._tblAliases.put("anonymous!@#$^&*", "anonymous!@#$^&*");
            return columns;
        }
        this.fetchDbCols();
        return columns;
    }

    public static ArrayList<Column> extractColumns(ParseNode selectNode, List<LexerToken> _src, boolean shortCircuit, boolean excludeCondition) {
        ArrayList<Column> columns = new ArrayList<Column>();
        if (BasicTabCol.starPosition(selectNode, _src) > 0) {
            shortCircuit = false;
        }
        HashSet<String> aliases = new HashSet<String>();
        for (ParseNode node : BasicTabCol.getColumnNodes(selectNode)) {
            Set<ParseNode> children = node.children();
            if (children.size() == 0) {
                String colName = _src.get((int)node.from).content;
                columns.add(new Column(node, colName));
                if (aliases.contains(colName)) {
                    shortCircuit = false;
                }
                aliases.add(colName);
                continue;
            }
            if (node.contains(expr)) {
                columns.add(new Column(node, null));
                shortCircuit = false;
                continue;
            }
            ParseNode column = null;
            String alias = null;
            int i = -1;
            for (ParseNode child : children) {
                if (++i == 0) {
                    if (child.contains(expr)) {
                        column = child;
                    } else if (node.contains(select_term)) {
                        column = node;
                        shortCircuit = false;
                        break;
                    }
                }
                if (i != 1) continue;
                alias = _src.get((int)(child.to - 1)).content;
                break;
            }
            if (alias == null || aliases.contains(alias)) {
                shortCircuit = false;
            }
            columns.add(new Column(column, alias));
            aliases.add(alias);
        }
        if (shortCircuit && excludeCondition) {
            return null;
        }
        return columns;
    }

    private boolean excludeCondition() {
        return !(this.colNamesToExclude != null && this.colNamesToExclude.size() != 0 || this.colTypesToExclude != null && this.colTypesToExclude.size() != 0);
    }

    private void fetchDbCols() throws SQLException, Exception, ClassNotFoundException {
        boolean dotStar = false;
        boolean dot = false;
        for (LexerToken lexerToken : this._src) {
            if (".".equals(lexerToken.content)) {
                dot = true;
                continue;
            }
            if (dot && "*".equals(lexerToken.content)) {
                dotStar = true;
                continue;
            }
            dot = false;
        }
        this._tblAliases = new TreeMap<String, String>();
        for (ParseNode parseNode : this._tables.keySet()) {
            this._tblAliases.put(parseNode.content(this._src), this._tables.get(parseNode));
        }
        this.dbColumns = null;
        if (this._tables.size() == 1 && !dotStar && this.resultSet != null) {
            this.dbColumns = this.resultSetColumns;
        } else {
            BasicInsightableOracleDatabase oracle = new BasicInsightableOracleDatabase(this.connName, false);
            if (0 < (this.optionBits & 1)) {
                oracle.excludeVirtualColumns = true;
            }
            oracle.limit = 999;
            oracle.setTableAliases(this._tblAliases);
            for (String alias : this._tblAliases.keySet()) {
                oracle.prepareColumns(this._tblAliases.get(alias), null);
            }
            oracle.adjustCase = false;
            this.dbColumns = oracle.fetch();
            if (BasicSuggestedItem.countBasicOwners(this.dbColumns) > 1) {
                TreeSet<BasicSuggestedItem> treeSet = new TreeSet<BasicSuggestedItem>();
                String schema = oracle.getConnection().getMetaData().getUserName().toUpperCase();
                for (BasicSuggestedItem si : this.dbColumns) {
                    if (!schema.equals(si.getOwner())) continue;
                    treeSet.add(si);
                }
                this.dbColumns = treeSet;
            }
        }
    }

    public int tableCount() {
        return this._tables.size();
    }

    public String disambiguate(ArrayList<Column> columns, String[] extra) throws Exception {
        if (columns == null) {
            return this._input;
        }
        return this._prefix + this.expandColumns(columns, extra, ", ", false) + this._suffix;
    }

    /*
     * WARNING - void declaration
     */
    public String expandColumns(ArrayList<Column> columns, String[] extra, String separator, boolean noAlias) throws Exception {
        String pref;
        ArrayList<Column> converted = new ArrayList<Column>();
        for (Column column : columns) {
            boolean containsStar = BasicTabCol.starPosition(column.colExpr, this._src) > 0;
            String prefixDot = "";
            String first = "";
            for (ParseNode parseNode : column.colExpr.children()) {
                if (parseNode.contains(dot)) {
                    prefixDot = first;
                    break;
                }
                first = this._src.get((int)parseNode.from).content.toUpperCase() + ".";
            }
            if (!prefixDot.startsWith("\"")) {
                prefixDot = prefixDot.toUpperCase();
            }
            if (column.colExpr.to - column.colExpr.from > 3 || column.colExpr.to - column.colExpr.from == 3 && !this._src.get((int)(column.colExpr.from + 1)).content.equals(".")) {
                converted.add(new Column(column.colExpr, column.alias == null ? "col" : column.alias));
                continue;
            }
            if (containsStar) {
                for (ParseNode parseNode : this._tables.keySet()) {
                    String talias = parseNode.content(this._src);
                    if (!talias.startsWith("\"")) {
                        talias = talias.toUpperCase();
                    }
                    if (prefixDot.length() > 0 && !prefixDot.equals(talias + ".")) continue;
                    for (BasicSuggestedItem col : this.dbColumns) {
                        Column c;
                        String colExpr = col.getName();
                        List<LexerToken> src = LexerToken.parse(colExpr);
                        boolean hasDot = false;
                        if (1 < src.size()) {
                            hasDot = ".".equals(src.get((int)1).content);
                        }
                        if (hasDot && !colExpr.startsWith(talias + ".") && !colExpr.toUpperCase().startsWith(talias + ".") || this.isExcluded(col) || converted.contains(c = new Column(null, colExpr))) continue;
                        converted.add(c);
                    }
                }
                continue;
            }
            if (column.colExpr == null) continue;
            boolean isListed = true;
            for (BasicSuggestedItem col : this.dbColumns) {
                String colExpr = column.colExpr.content(this._src);
                int dotPos = colExpr.indexOf(46);
                if (dotPos > 0 && (pref = colExpr.substring(0, dotPos)).startsWith("\"") && !pref.endsWith("\"")) {
                    dotPos = -1;
                }
                if (dotPos >= 0) {
                    colExpr = colExpr.substring(dotPos + 1);
                }
                if (colExpr.charAt(0) == '\"') {
                    colExpr = DBUtil.addDoubleQuote(colExpr.substring(1, colExpr.length() - 1));
                }
                if ((colExpr.charAt(0) == '\"' || !col.getName().endsWith(colExpr.toUpperCase()) || !this.isExcluded(col)) && (colExpr.charAt(0) != '\"' || !col.getName().endsWith(colExpr) || !this.isExcluded(col))) continue;
                isListed = false;
                break;
            }
            if (!isListed) continue;
            converted.add(new Column(column.colExpr, column.alias));
        }
        int sequence = 0;
        TreeSet<String> usedAliases = new TreeSet<String>();
        StringBuffer ret = new StringBuffer();
        for (String string : extra) {
            String comma = ret.length() == 0 ? "" : ", ";
            ret.append(comma + string + " \"" + string + "\"");
        }
        for (Column column : converted) {
            void var12_32;
            void var12_30;
            String comma = ret.length() == 0 ? "" : separator;
            String string = "";
            String alias = column.alias;
            if (column.colExpr == null) {
                String string2 = alias;
            } else {
                int start = this._src.get((int)column.colExpr.from).begin;
                int end = this._src.get((int)(column.colExpr.to - 1)).end;
                String string3 = this._input.substring(start, end);
            }
            if (alias == null) {
                alias = this._src.get((int)(column.colExpr.to - 1)).content;
            }
            if (alias.startsWith("'")) {
                alias = "col";
            }
            if ('0' <= alias.charAt(0) && alias.charAt(0) < '9') {
                alias = "\"" + alias + "\"";
            }
            List<LexerToken> src = LexerToken.parse(alias);
            int lastDotIndex = -1;
            if (1 < src.size() && ".".equals(src.get((int)1).content)) {
                lastDotIndex = src.get((int)1).begin;
            }
            if (3 < src.size() && ".".equals(src.get((int)3).content)) {
                lastDotIndex = src.get((int)3).begin;
            }
            if (0 < lastDotIndex) {
                pref = alias.substring(0, lastDotIndex);
                alias = alias.substring(lastDotIndex + 1);
            }
            if (!alias.startsWith("\"")) {
                alias = alias.toUpperCase();
            }
            for (String usedAlias : usedAliases) {
                if (!usedAlias.equals(alias)) continue;
                alias = alias + "_" + sequence++;
                break;
            }
            usedAliases.add(alias);
            if (BasicTabCol.isKeyword(alias)) {
                alias = "\"" + alias + "\"";
            }
            if (BasicTabCol.isKeyword((String)var12_30)) {
                String string4 = "\"" + (String)var12_30 + "\"";
            }
            if (noAlias) {
                alias = "";
            }
            ret.append(comma + (String)var12_32 + " " + alias);
        }
        this._noCols = ret.toString().equals("");
        return ret.toString();
    }

    public String disambiguate(ArrayList<Column> columns) throws Exception {
        return this.disambiguate(columns, new String[0]);
    }

    private static boolean isKeyword(String token) {
        int i;
        if (indAll == null) {
            for (i = 0; i < SqlKeywords.KW_words.length; ++i) {
                if ("all".equalsIgnoreCase(SqlKeywords.KW_words[i])) {
                    indAll = i;
                    continue;
                }
                if (!"whenever".equalsIgnoreCase(SqlKeywords.KW_words[i])) continue;
                indWhenever = i;
            }
        }
        for (i = indAll.intValue(); i <= indWhenever; ++i) {
            if (!SqlKeywords.KW_words[i].equalsIgnoreCase(token)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(BasicSuggestedItem col) {
        if (this.colNamesToExclude != null) {
            for (String name : this.colNamesToExclude) {
                if (!name.equals(col.getName()) && !col.getName().endsWith("." + name)) continue;
                this.excludedColumns.add(col);
                return true;
            }
        }
        if (this.colTypesToExclude != null) {
            for (String type : this.colTypesToExclude) {
                if (!type.equalsIgnoreCase(col.columnType)) continue;
                this.excludedColumns.add(col);
                return true;
            }
        }
        return false;
    }

    private static Pair<ParseNode, ParseNode> findTableAlias(ParseNode p) {
        if (!p.contains(table_reference)) {
            return null;
        }
        Pair<ParseNode, ParseNode> ppn = null;
        if (p.children().size() == 0 || p.children().size() == 3) {
            ppn = new Pair<ParseNode, ParseNode>(p, p);
        } else if (p.children().size() == 2) {
            ParseNode alias = null;
            ParseNode tbl = null;
            for (ParseNode child : p.children()) {
                if (child.contains(query_table_expression)) {
                    tbl = child;
                    continue;
                }
                if (!child.contains(identifier)) continue;
                alias = child;
            }
            if (alias != null && tbl != null) {
                ppn = new Pair<Object, Object>(alias, tbl);
            }
        }
        return ppn;
    }

    public static ParseNode getMainQueryBlock(ParseNode root) {
        if (root == null) {
            return null;
        }
        if (root.contains(query_block)) {
            return root;
        }
        for (ParseNode child : root.children()) {
            if (!child.contains(subquery) && !child.contains(query_block)) continue;
            return BasicTabCol.getMainQueryBlock(child);
        }
        return null;
    }

    public static ParseNode getSelectList(ParseNode selStmt) {
        if (selStmt == null) {
            return null;
        }
        for (ParseNode desc : selStmt.descendants()) {
            if (BasicTabCol.isInParSqubquery(desc, selStmt) || !desc.contains(select_list)) continue;
            return desc;
        }
        return null;
    }

    private static boolean isInParSqubquery(ParseNode desc, ParseNode root) {
        if (desc == root) {
            return false;
        }
        if (desc == null) {
            return false;
        }
        if (desc.contains(par_subquery)) {
            return true;
        }
        return BasicTabCol.isInParSqubquery(desc.parent(), root);
    }

    public static List<ParseNode> getColumnNodes(ParseNode node) {
        LinkedList<ParseNode> ret = new LinkedList<ParseNode>();
        if (node.contains(select_term) || node.contains(select_list) && node.contains(star)) {
            ret.add(node);
            return ret;
        }
        for (ParseNode child : node.children()) {
            ret.addAll(BasicTabCol.getColumnNodes(child));
        }
        return ret;
    }

    public boolean isEmptySelect() {
        return this._noCols;
    }

    public boolean excludedColumns() {
        return 0 < this.excludedColumns.size();
    }

    public static int starPosition(ParseNode column, List<LexerToken> src) {
        for (ParseNode d : column.descendants()) {
            if (d.from + 1 != d.to || !"*".equals(src.get((int)d.from).content) || d.contains(mult_op)) continue;
            return d.from;
        }
        return -1;
    }

    static {
        SqlEarley earley = SqlEarley.getInstance();
        where_clause = earley.getSymbol("where_clause");
        subquery = earley.getSymbol("subquery");
        scalar_subquery_expression = earley.getSymbol("scalar_subquery_expression");
        par_subquery = earley.getSymbol("par_subquery");
        query_table_expression = earley.getSymbol("query_table_expression");
        table_reference = earley.getSymbol("table_reference");
        as = earley.getSymbol("'AS'");
        select_term = earley.getSymbol("select_term");
        expr = earley.getSymbol("expr");
        identifier = earley.getSymbol("identifier");
        dot = earley.getSymbol("'.'");
        star = earley.getSymbol("'*'");
        mult_op = earley.getSymbol("mult_op");
        select = earley.getSymbol("select");
        select_list = earley.getSymbol("select_list");
        query_block = earley.getSymbol("query_block");
        indAll = null;
        indWhenever = null;
    }

    public static class Column
    implements Comparable {
        public ParseNode colExpr;
        public String alias;

        public Column(ParseNode colExpr, String alias) {
            this.colExpr = colExpr;
            this.alias = alias;
        }

        public int compareTo(Object o) {
            Column c = (Column)o;
            if (this.colExpr == null && c.colExpr != null) {
                return 1;
            }
            if (this.colExpr != null && c.colExpr == null) {
                return -1;
            }
            if (this.colExpr == null && c.colExpr == null) {
                return this.alias.compareTo(c.alias);
            }
            int firstcomp = this.colExpr.compareTo(c.colExpr);
            if (firstcomp != 0) {
                return firstcomp;
            }
            return this.alias.compareTo(c.alias);
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public String toString() {
            return this.colExpr.toString() + " As " + this.alias;
        }
    }
}

