/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.json;

import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.util.Service;

public class JsonEarley {
    static Earley instance = null;

    public static Earley jsonParser() throws IOException {
        if (instance != null) {
            return instance;
        }
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        String input = Service.readFile(JsonEarley.class, "/oracle/dbtools/parser/json/json.grammar");
        List<LexerToken> src = LexerToken.parse(input, false, 1);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        Grammar.grammar(root, src, rules);
        RuleTransforms.eliminateEmptyProductions(rules);
        instance = new Earley(rules, false){

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                LexerToken token = src.get(y);
                return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING;
            }
        };
        JsonEarley.instance.isCaseSensitive = true;
        return instance;
    }

    public static void main(String[] args) throws IOException {
        String input = Service.readFile("C:\\Users\\dim\\Documents\\JSON/slow1.txt");
        long t1 = System.nanoTime();
        List<LexerToken> src = LexerToken.parse(input);
        long t2 = System.nanoTime();
        System.out.println("Lex time = " + (t2 - t1) / 1000000L);
        Earley earley = JsonEarley.jsonParser();
        Matrix matrix = new Matrix(earley);
        long t21 = System.nanoTime();
        earley.parse(src, matrix);
        long t22 = System.nanoTime();
        System.out.println("parse time = " + (t22 - t21) / 1000000L);
        t1 = System.nanoTime();
        ParseNode root = earley.forest(src, matrix, true);
        if (src.size() < 1000) {
            root.printTree();
        }
        t2 = System.nanoTime();
        System.out.println("Reduction time = " + (t2 - t1) / 1000000L);
    }
}

