/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Service;

public class ParseNode
implements Comparable<ParseNode> {
    public int from;
    public int to;
    public ParseNode parent;
    ParseNode lft = null;
    ParseNode rgt = null;
    int[] symbols = new int[0];
    public Set<ParseNode> topLevel = null;
    Parser parser;
    public static String ignoreMarkers = null;

    public boolean contains(int symbol) {
        return this.symbols[Array.indexOf(this.symbols, symbol)] == symbol;
    }

    public boolean contains(String symbol) {
        if (this.parser == null) {
            return false;
        }
        Integer code = this.parser.symbolIndexes.get(symbol);
        if (code == null) {
            throw new AssertionError((Object)("No such symbol `" + symbol + "` in the grammar"));
        }
        return this.contains(code);
    }

    public List<ParseNode> descendants() {
        ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
        ret.add(this);
        for (ParseNode n : this.children()) {
            ret.addAll(n.descendants());
        }
        return ret;
    }

    public ParseNode parent() {
        if (this.parent == null) {
            return null;
        }
        if (!this.parent.isAuxiliary()) {
            return this.parent;
        }
        ParseNode ret = this.parent.parent();
        if (ret == null) {
            return this.parent;
        }
        return ret;
    }

    @Deprecated
    public ParseNode childAt(int head, int tail) {
        if (this.topLevel != null) {
            for (ParseNode child : this.children()) {
                if (child.from > head || tail > child.to) continue;
                return child;
            }
            return null;
        }
        if (this.lft != null && this.lft.from <= head && tail <= this.lft.to) {
            return this.lft;
        }
        if (this.rgt != null && this.rgt.from <= head && tail <= this.rgt.to) {
            return this.rgt;
        }
        return null;
    }

    @Override
    public int compareTo(ParseNode obj) {
        ParseNode src = obj;
        if (this.from != src.from) {
            return this.from - src.from;
        }
        return this.to - src.to;
    }

    public String toString() {
        return this.toString(0);
    }

    public ArrayList<Pair<ParseNode, ParseNode>> descendants(ParseNode parent) {
        ArrayList<Pair<ParseNode, ParseNode>> ret = new ArrayList<Pair<ParseNode, ParseNode>>();
        ret.add(new Pair<ParseNode, ParseNode>(this, parent));
        for (ParseNode n : this.children()) {
            ret.addAll(n.descendants(this));
        }
        return ret;
    }

    public ParseNode next() {
        Iterator<ParseNode> iterator;
        if (this.lft != null) {
            if (this.lft.isAuxiliary()) {
                return this.lft.next();
            }
            return this.lft;
        }
        ParseNode prt = this.parent;
        while (prt != null) {
            ParseNode nextSibling = prt.rgt;
            if (nextSibling == null && prt.topLevel != null) {
                for (ParseNode p : prt.topLevel) {
                    if (this.to > p.from) continue;
                    if (p.isAuxiliary()) {
                        return p.next();
                    }
                    return p;
                }
            }
            if (nextSibling != null && this.to == nextSibling.from) {
                if (nextSibling.isAuxiliary()) {
                    return nextSibling.next();
                }
                return nextSibling;
            }
            prt = prt.parent;
        }
        if (this.topLevel != null && (iterator = this.topLevel.iterator()).hasNext()) {
            ParseNode child = iterator.next();
            return child;
        }
        return null;
    }

    public int rowNo() {
        ParseNode root = null;
        ParseNode p = this;
        while (p != null) {
            root = p;
            p = p.parent;
        }
        int ret = 0;
        for (ParseNode p2 = root; p2 != null && p2 != this; p2 = p2.next()) {
            ++ret;
        }
        return ret;
    }

    public List<ParseNode> ancestors(int pos) {
        return this.intermediates(pos, pos + 1);
    }

    public List<ParseNode> intermediates(int head, int tail) {
        ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
        if (this.from <= head && tail <= this.to) {
            ret.add(this);
        }
        for (ParseNode n : this.children()) {
            if (n.from > head || tail > n.to) continue;
            ret.addAll(n.intermediates(head, tail));
        }
        return ret;
    }

    @Deprecated
    public ParseNode ancestor(int head, int tail, int content) {
        throw new AssertionError((Object)"Deprecated");
    }

    public ParseNode ancestor(int content) {
        if (this.contains(content)) {
            return this;
        }
        if (this.parent() == null) {
            return null;
        }
        return this.parent().ancestor(content);
    }

    public ParseNode descendant(int head, int tail, int content) {
        if (this.contains(content)) {
            return this;
        }
        for (ParseNode child : this.children()) {
            if (child.from > head || tail > child.to) continue;
            if (child.contains(content)) {
                return child;
            }
            return child.descendant(head, tail, content);
        }
        return null;
    }

    public ParseNode locate(int head, int tail) {
        if (this.from == head && tail == this.to) {
            return this;
        }
        for (ParseNode child : this.children()) {
            if (child.from > head || tail > child.to) continue;
            return child.locate(head, tail);
        }
        return null;
    }

    @Deprecated
    public ParseNode parent(int head, int tail) {
        ParseNode lastNotAux = null;
        ParseNode current = this;
        do {
            if (!current.isAuxiliary()) {
                lastNotAux = current;
            }
            if ((current = current.childAt(head, tail)) != null) continue;
            return null;
        } while (current.from != head || current.to != tail);
        return lastNotAux;
    }

    void print(int depth) {
        System.out.println(this.toString(depth));
    }

    public ParseNode leafAtPos(int pos) {
        if (this.children().size() == 0 && pos == this.from) {
            return this;
        }
        for (ParseNode child : this.children()) {
            if (child.from > pos || pos >= child.to) continue;
            return child.leafAtPos(pos);
        }
        return null;
    }

    private void calculateDepth(Map<Long, Integer> depthMap, int depth) {
        depthMap.put(Service.lPair(this.from, this.to), depth);
        for (ParseNode child : this.children()) {
            child.calculateDepth(depthMap, depth + 1);
        }
    }

    Map<Long, Integer> calculateDepth() {
        TreeMap<Long, Integer> depthMap = new TreeMap<Long, Integer>();
        this.calculateDepth(depthMap, 0);
        return depthMap;
    }

    public void printTree() {
        Map<Long, Integer> depthMap = this.calculateDepth();
        for (ParseNode n : this.descendants()) {
            int depth = depthMap.get(Service.lPair(n.from, n.to));
            n.print(depth);
        }
    }

    public void printBinaryTree(int depth) {
        this.print(depth);
        if (this.lft != null) {
            this.lft.printBinaryTree(depth + 1);
        }
        if (this.rgt != null) {
            this.rgt.printBinaryTree(depth + 1);
        }
        if (this.topLevel != null) {
            for (ParseNode n : this.topLevel) {
                n.printBinaryTree(depth + 1);
            }
        }
    }

    public String tree() {
        StringBuilder ret = new StringBuilder();
        Map<Long, Integer> depthMap = this.calculateDepth();
        for (ParseNode n : this.descendants()) {
            int depth = depthMap.get(Service.lPair(n.from, n.to));
            ret.append(n.toString(depth, "["));
            ret.append("\n");
        }
        return ret.toString();
    }

    public String content(List<LexerToken> src) {
        return this.content(src, null);
    }

    public String content(List<LexerToken> src, Boolean addWsDividers) {
        StringBuilder sb = new StringBuilder();
        try {
            int lastEnd = -1;
            for (int i = this.from; i < this.to; ++i) {
                LexerToken t = src.get(i);
                if (addWsDividers == null && this.from < i && lastEnd < t.begin || addWsDividers != null && addWsDividers.booleanValue()) {
                    sb.append(' ');
                }
                sb.append(t.content);
                lastEnd = t.end;
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("src out of sync with parse tree?");
            e.printStackTrace();
        }
        return sb.toString();
    }

    public int[] content() {
        return this.symbols;
    }

    public String[] contentAsStrings() {
        String[] ret = new String[this.symbols.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.parser.allSymbols[this.symbols[i]];
        }
        return ret;
    }

    public String content(int i) {
        if (this.symbols[i] < 0) {
            return "[symbols[" + i + "] = " + this.symbols[i] + "]";
        }
        return this.parser.allSymbols[this.symbols[i]];
    }

    public void addContent(int symbol) {
        this.symbols = Array.insert(this.symbols, symbol);
    }

    public void addContent(String symbol) {
        Integer s = this.parser.symbolIndexes.get(symbol);
        if (s == null) {
            System.err.println(symbol + " not found");
        }
        this.addContent(s);
    }

    public void deleteContent(int symbol) {
        this.symbols = Array.delete(this.symbols, symbol);
    }

    public void addTopLevel(ParseNode child) {
        if (this.topLevel == null) {
            this.topLevel = new TreeSet<ParseNode>();
        }
        this.topLevel.add(child);
    }

    public ParseNode coveredByOnTopLevel(int pos) {
        if (this.topLevel == null) {
            return null;
        }
        for (ParseNode node : this.topLevel) {
            if (node.from > pos || pos >= node.to) continue;
            return node;
        }
        return null;
    }

    public ParseNode(int begin, int end, int symbol, int dummy, Parser p) {
        this(begin, end, symbol, p);
    }

    public ParseNode(int begin, int end, int symbol, Parser p) {
        this.from = begin;
        this.to = end;
        this.addContent(symbol);
        this.parser = p;
    }

    protected String toString(int depth) {
        if (ignoreMarkers != null) {
            return this.toString(depth, ignoreMarkers);
        }
        return this.toString(depth, "");
    }

    protected String toString(int depth, String auxMarkers) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append(this.interval() + " ");
        int[] nArray = this.content();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            if (i2 == -1) continue;
            String symbol = this.parser == null || this.parser.allSymbols == null || i2 < 0 || i2 > this.parser.allSymbols.length ? "!" + i2 : this.parser.allSymbols[i2];
            boolean skip = false;
            for (char c : auxMarkers.toCharArray()) {
                if (0 > symbol.indexOf(c)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            sb.append("  " + symbol);
        }
        return sb.toString();
    }

    public String interval() {
        return "[" + this.from + "," + this.to + ")";
    }

    public long id() {
        return Service.lPair(this.from, this.to);
    }

    public boolean isAuxiliary() {
        return this.symbols[0] == -1;
    }

    public Set<ParseNode> children() {
        TreeSet<ParseNode> ret = new TreeSet<ParseNode>();
        if (this.topLevel != null) {
            for (ParseNode child : this.topLevel) {
                if (child.isAuxiliary()) {
                    ret.addAll(child.children());
                    continue;
                }
                ret.add(child);
            }
            return ret;
        }
        if (this.lft == null) {
            return ret;
        }
        if (this.lft.isAuxiliary()) {
            ret.addAll(this.lft.children());
        } else {
            ret.add(this.lft);
        }
        if (this.rgt == null) {
            return ret;
        }
        if (this.rgt.isAuxiliary()) {
            ret.addAll(this.rgt.children());
        } else {
            ret.add(this.rgt);
        }
        return ret;
    }

    public List<ParseNode> childList() {
        return new ArrayList<ParseNode>(this.children());
    }

    public void moveInterval(int offset) {
        this.from += offset;
        this.to += offset;
        if (this.topLevel != null) {
            for (ParseNode p : this.topLevel) {
                p.moveInterval(offset);
            }
        } else {
            if (this.lft != null) {
                this.lft.moveInterval(offset);
            }
            if (this.rgt != null) {
                this.rgt.moveInterval(offset);
            }
        }
    }

    public int treeDepth() {
        int ret = 0;
        for (ParseNode child : this.children()) {
            int tmp = child.treeDepth();
            if (ret >= tmp) continue;
            ret = tmp;
        }
        return ret + 1;
    }

    public Icon getIcon() {
        return null;
    }

    public String path() {
        ParseNode parent = this.parent();
        if (parent == null) {
            return "";
        }
        int i = -1;
        for (ParseNode child : parent.children()) {
            ++i;
            if (child != this) continue;
            return parent.path() + "." + i;
        }
        throw new AssertionError((Object)"impossible case");
    }

    public ParseNode locate(ParseNode root, String path) {
        if (path.length() == 0) {
            return root;
        }
        int sibling = Integer.parseInt(path.substring(1, 2));
        String truncated = path.substring(2);
        int i = -1;
        for (ParseNode child : this.parent.children()) {
            if (++i != sibling) continue;
            return this.locate(child, truncated);
        }
        throw new AssertionError((Object)"impossible case");
    }
}

