/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.features;

import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.lsp.Jsonable;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.json.Util;

public class DocumentSymbol
implements Jsonable {
    String name;
    Range range;
    int kind;
    List<DocumentSymbol> children = null;

    public DocumentSymbol(String name, Range range, int kind) {
        this.name = Util.sugarcoatText(name);
        this.range = range;
        this.kind = kind;
    }

    public void addChild(DocumentSymbol child) {
        if (this.children == null) {
            this.children = new LinkedList<DocumentSymbol>();
        }
        this.children.add(child);
    }

    public void addChildren(List<DocumentSymbol> symbols) {
        for (DocumentSymbol child : symbols) {
            this.addChild(child);
        }
    }

    @Override
    public String toJson() {
        StringBuilder children = new StringBuilder();
        if (this.children != null) {
            children.append(",\"children\":[");
            int pos = 0;
            for (DocumentSymbol symbol : this.children) {
                if (0 < pos++) {
                    children.append(",");
                }
                children.append(symbol.toJson());
            }
            children.append("]");
        }
        return "{ \"name\": \"" + this.name + "\", \"range\": " + this.range.toJson() + ", \"selectionRange\": " + this.range.toJson() + ", \"kind\": " + this.kind + children + " }";
    }

    public static enum SymbolKind {
        File(1),
        Module(2),
        Namespace(3),
        Package(4),
        Class(5),
        Method(6),
        Property(7),
        Field(8),
        Constructor(9),
        Enum(10),
        Interface(11),
        Function(12),
        Variable(13),
        Constant(14),
        String(15),
        Number(16),
        Boolean(17),
        Array(18),
        Object(19),
        Key(20),
        Null(21),
        EnumMember(22),
        Struct(23),
        Event(24),
        Operator(25),
        TypeParameter(26);

        private final int value;

        private SymbolKind(int newValue) {
            this.value = newValue;
        }

        public int getValue() {
            return this.value;
        }
    }
}

