/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.dictionary;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.dictionary.Item;
import oracle.dbtools.lsp.dictionary.SymbolContext;
import oracle.dbtools.parser.ParseNode;

public abstract class Registry {
    protected BackgroundParser parser;
    protected Map<Integer, SymbolContext> symbols = new HashMap<Integer, SymbolContext>();

    public Registry(BackgroundParser parser) {
        this.parser = parser;
    }

    public void recordSymbol(ParseNode symbol, String type, int declaration, BackgroundParser parser) {
        if (this.parser == null) {
            this.parser = parser;
        }
        assert (this.parser == parser);
        this.getSymbols().put(symbol.from, new SymbolContext(symbol.from, parser.src.get((int)symbol.from).content, type, declaration));
    }

    public SymbolContext getSymbol(int from) {
        return this.getSymbols().get(from);
    }

    public void cleanSymbols() {
        this.symbols = new HashMap<Integer, SymbolContext>();
    }

    public void recordSymbol(ParseNode symbol, ParseNode type, BackgroundParser parser) {
        if (this.parser == null) {
            this.parser = parser;
        }
        assert (this.parser == parser);
    }

    public void recordSymbol(ParseNode symbol, String[] types, BackgroundParser parser) {
        if (this.parser == null) {
            this.parser = parser;
        }
        assert (this.parser == parser);
    }

    public abstract String getConnString();

    public abstract Object getConnection();

    public abstract void closeConnection();

    public abstract void dissociateConnection();

    public abstract void setConnection(String var1, Object var2);

    public abstract void copyConnection(Registry var1);

    public void setConnection(Object connection) {
        this.setConnection("Not used", connection);
    }

    public Item getObject(String schema, String type, String name) throws SQLException {
        return null;
    }

    public Item getObject(SymbolContext symbol) throws SQLException {
        return null;
    }

    public Item getObject(String schema, String[] types, String oName) throws SQLException {
        return null;
    }

    public Map<Integer, SymbolContext> getSymbols() {
        return this.symbols;
    }

    public String dirName2conn(String input) {
        return input;
    }

    public boolean isEqual(String connection1, String connection2) {
        return connection1.equals(connection2);
    }
}

