/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.dictionary;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.util.Service;

public class Item
implements Comparable<Item> {
    public String name;
    public String type;
    public String owner;
    public static String LIMIT_TYPE = "LIMIT_TYPE";
    public static Item MORE = new Item("...", LIMIT_TYPE, null);
    static final Map<String, Integer> orderedTypes = new HashMap<String, Integer>();

    public Item(String name, String type, String owner) {
        this.name = LIMIT_TYPE.equals(type) ? name : Service.addDoubleQuote(name);
        this.type = type;
        this.owner = Service.addDoubleQuote(owner);
    }

    public String toString() {
        return (this.owner != null ? this.owner : "") + '.' + this.type + '.' + this.name;
    }

    public boolean secondClassCitizen() {
        if (orderedTypes.get(this.type) == 0) {
            return true;
        }
        return 6 < orderedTypes.get(this.type);
    }

    @Override
    public int compareTo(Item that) {
        Integer thatOrd;
        Integer thisOrd = orderedTypes.get(this.type);
        if (thisOrd == null) {
            thisOrd = 999;
        }
        if ((thatOrd = orderedTypes.get(that.type)) == null) {
            thatOrd = 999;
        }
        return thisOrd - thatOrd;
    }

    public String pluralType() {
        if ("INDEX".equalsIgnoreCase(this.type)) {
            return "INDEXES";
        }
        if ("DICTIONARY".equalsIgnoreCase(this.type)) {
            return "DICTIONARIES";
        }
        return this.type + "S";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static {
        orderedTypes.put("SYNONYM", 0);
        orderedTypes.put("TABLE", 1);
        orderedTypes.put("VIEW", 2);
        orderedTypes.put("PACKAGE", 3);
        orderedTypes.put("PROCEDURE", 4);
        orderedTypes.put("FUNCTION", 5);
        orderedTypes.put("TRIGGER", 6);
        orderedTypes.put("TYPE", 7);
        orderedTypes.put("INDEX", 8);
        orderedTypes.put("MATERIALIZED VIEW", 9);
        orderedTypes.put("MATERIALIZED VIEW LOG", 10);
        orderedTypes.put("OPERATOR", 11);
        orderedTypes.put("QUEUE", 12);
        orderedTypes.put("QUEUE TABLES", 13);
        orderedTypes.put("SEQUENCES", 14);
        orderedTypes.put("DATABASE LINKS", 15);
        orderedTypes.put("DIRECTORIES", 16);
        orderedTypes.put("EDITIONS", 17);
        orderedTypes.put("PUBLIC SYNONYMS", 18);
        orderedTypes.put(LIMIT_TYPE, 42);
    }
}

