/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.sql;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.dictionary.Dictionary;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public class EstablishConnection
extends CodeLens {
    String user;
    String pwd;
    String conn;

    public EstablishConnection(ParseNode node, BackgroundParser parser, String user, String pwd, String conn) {
        super(node, "Establish Connection", parser);
        this.user = user;
        this.pwd = pwd;
        this.conn = conn;
    }

    @Override
    public Object executeCommand(OutputStream send) {
        if (this.conn.startsWith("\"")) {
            this.conn = this.conn.substring(1, this.conn.length() - 1);
        }
        LanguageServer server = this.parser.languageServer;
        String cStr = Dictionary.connAlias(this.conn, this.user, this.pwd);
        try {
            Connection connection = DriverManager.getConnection(this.conn, this.user, this.pwd);
            this.parser.getRegistry().setConnection(cStr, connection);
            this.initCache(send, connection, this.user, this.pwd, this.conn);
            this.parser.resetDiagnostics();
            server.documentsBump(send);
            return "OK";
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1017) {
                this.parser.failedCommand(this.node, e);
                this.parser.documentBump(send);
                return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), this.conn);
            }
            LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
            LSP.LOG.log(Level.SEVERE, "user=" + this.user + ",pwd=" + this.pwd, e);
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), this.conn);
        }
        catch (Exception e) {
            LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
            LSP.LOG.log(Level.SEVERE, "user=" + this.user + ",pwd=" + this.pwd, e);
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), this.conn);
        }
    }

    private void initCache(OutputStream send, Connection connection, String user, String pwd, String conStr) throws IOException, SQLException {
        String content = "connect " + Dictionary.connCmdArg(conStr, user, pwd) + "\n\n" + Dictionary.dictionaryScheleton;
        LanguageServer languageServer = this.parser.languageServer;
        String folder = languageServer.dictionaryUri + '/' + Dictionary.dirName(conStr, user, pwd);
        languageServer.getLSP().createDirectory(send, folder + "/TABLES");
        languageServer.getLSP().createDirectory(send, folder + "/VIEWS");
        languageServer.getLSP().createDirectory(send, folder + "/PACKAGES");
        languageServer.getLSP().createDirectory(send, folder + "/PROCEDURES");
        languageServer.getLSP().createDirectory(send, folder + "/FUNCTIONS");
        languageServer.getLSP().createDirectory(send, folder + "/TRIGGERS");
        String uri = folder + "/" + Dictionary.fileName;
        String url = "\"" + uri + "\"";
    }
}

