/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.sql;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;

public class Autocommit
extends CodeLens {
    public Autocommit(ParseNode node, BackgroundParser parser) {
        super(node, "Switch Autocommit mode", parser);
    }

    @Override
    public Object executeCommand(OutputStream send) {
        block6: {
            String mode = this.parser.tokenAt(this.node.from);
            Connection conn = (Connection)this.parser.getRegistry().getConnection();
            if (conn == null) {
                return new ResponseError(-32099, "Not connected: ", this.parser.docUrl);
            }
            try {
                if ("ON".equalsIgnoreCase(mode)) {
                    conn.setAutoCommit(true);
                }
                if ("OFF".equalsIgnoreCase(mode)) {
                    conn.setAutoCommit(false);
                }
            }
            catch (Exception e) {
                if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                    LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
                }
                if (!(e instanceof SQLException)) break block6;
                this.parser.failedCommand(this.node, e);
            }
        }
        return "OK";
    }
}

