/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.dictionary;

import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.dictionary.Dictionary;
import oracle.dbtools.lsp.dictionary.Item;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;
import oracle.dbtools.util.Service;

public class ExpandTreeNode
extends CodeLens {
    public ExpandTreeNode(ParseNode node, BackgroundParser parser) {
        super(node, "Expand tree node", parser);
    }

    @Override
    public Object executeCommand(OutputStream send) {
        ParseNode current = null;
        for (ParseNode child : this.node.children()) {
            if (!child.contains("more")) continue;
            current = child;
        }
        LanguageServer server = this.parser.languageServer;
        boolean done = this.parser.waitForParsingFinish();
        if (!done) {
            return new ResponseError(-32603, "Parsing failed to complete", server.getLastUrl());
        }
        Range range = this.parser.nodeRange(current);
        String uri = server.getLastUrl().substring(1, server.getLastUrl().length() - 1);
        if (this.node.contains("user")) {
            String indentedDict = Dictionary.indent(Dictionary.dictionaryScheleton.replace("\n\n", "\n").replace("\n\r\n", "\n"), 2);
            server.getLSP().documentInsert(range, send, uri, indentedDict);
            return "OK";
        }
        if (this.node.contains("other_datatypes_node")) {
            String indentedDict = Dictionary.indent(Dictionary.nonessentialScheleton.replace("\n\n", "\n").replace("\n\r\n", "\n"), 2);
            server.getLSP().documentInsert(range, send, uri, indentedDict);
            LanguageServer languageServer = this.parser.languageServer;
            String folder = languageServer.dictionaryUri + '/' + ((Dictionary)this.parser.getRegistry()).dirName();
            languageServer.getLSP().createDirectory(send, folder + "/Other Datatypes/INDEXES");
            languageServer.getLSP().createDirectory(send, folder + "/Other Datatypes/MATERIALIZED VIEWS");
            languageServer.getLSP().createDirectory(send, folder + "/Other Datatypes/MATERIALIZED VIEW LOGSS");
            languageServer.getLSP().createDirectory(send, folder + "/Other Datatypes/OPERATORS");
            languageServer.getLSP().createDirectory(send, folder + "/Other Datatypes/TYPES");
            languageServer.getLSP().createDirectory(send, folder + "/Other Datatypes/QUEUES");
            languageServer.getLSP().createDirectory(send, folder + "/Other Datatypes/QUEUE TABLES");
            languageServer.getLSP().createDirectory(send, folder + "/Other Datatypes/SEQUENCES");
            languageServer.getLSP().createDirectory(send, folder + "/Other Datatypes/SYNONYMS");
            languageServer.getLSP().createDirectory(send, folder + "/Other Datatypes/PUBLIC SYNONYMS");
            languageServer.getLSP().createDirectory(send, folder + "/Other Datatypes/DATABASE LINKS");
            languageServer.getLSP().createDirectory(send, folder + "/Other Datatypes/DIRECTORIES");
            languageServer.getLSP().createDirectory(send, folder + "/Other Datatypes/EDITIONS");
            return "OK";
        }
        ParseNode grandParent = this.node.parent().parent();
        String schema = "USER";
        if (grandParent != null && !grandParent.contains("other_datatypes_node")) {
            schema = "'" + this.parser.src.get((int)grandParent.from).content.toUpperCase() + "'";
        }
        String symbol = this.parser.earley.allSymbols[this.node.content()[0]].toUpperCase();
        int chop = symbol.indexOf("_NODE");
        String objType = symbol.substring(0, chop);
        Object conn = server.getLastConnection();
        if (conn == null) {
            return new ResponseError(-32603, "Not connected", server.getLastUrl());
        }
        try {
            List<Item> items = Dictionary.queryItems(this.node, this.parser.src, schema, objType, conn);
            StringBuilder aggr = new StringBuilder();
            int level = grandParent != null ? 3 : 1;
            int cnt = -1;
            for (Item item : items) {
                ++cnt;
                String name = item.name;
                if (objType.equals("OTHER_USERS")) {
                    LanguageServer languageServer = this.parser.languageServer;
                    String folder = languageServer.dictionaryUri + '/' + ((Dictionary)this.parser.getRegistry()).dirName();
                    languageServer.getLSP().createDirectory(send, folder + "/Other Users/" + name);
                    if (item != Item.MORE) {
                        name = name + "...";
                    }
                }
                if (cnt < items.size() - 1) {
                    name = name + ",\n";
                }
                aggr.append(Dictionary.indent(name, level));
            }
            String ins = "\n" + Service.padln("", 4 * level) + aggr.toString();
            if (cnt == 0) {
                ins = "\n";
            }
            server.getLSP().documentInsert(range, send, uri, ins);
            return "OK";
        }
        catch (SQLException e) {
            LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), conn);
        }
    }
}

