/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.arbori;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.commands.arbori.Query;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public class RunScript
extends CodeLens {
    static final String normalTitle = "Run Script";

    public RunScript(BackgroundParser parser) {
        this(parser, normalTitle);
    }

    public RunScript(BackgroundParser parser, String title) {
        super(new ParseNode(0, 0, -1, null), title, parser);
    }

    @Override
    public Object executeCommand(OutputStream send) {
        LanguageServer server = this.parser.languageServer;
        try {
            SqlProgram r = new SqlProgram(this.parser.text){

                @Override
                public Boolean getBoolBindVar(String name) {
                    return true;
                }
            };
            r.setStruct(server);
            String conn = this.parser.getRegistry().getConnString();
            if (conn.charAt(0) == '\"') {
                conn = conn.substring(1, conn.length() - 1);
            }
            r.setTargetFileName(conn);
            Map<String, MaterializedPredicate> output = r.eval();
            StringBuilder ret = new StringBuilder();
            for (String t : output.keySet()) {
                if (t.startsWith("anonymous JS Block")) continue;
                ret.append(t + ":\n");
                ret.append("===============\n");
                MaterializedPredicate p = output.get(t);
                ret.append(Query.render(p, (BackgroundParser)this.parser.getRegistry().getConnection()));
                ret.append("\n");
            }
            String fileExt = ".output.csv";
            String uri = server.getLastUrl().substring(1, server.getLastUrl().length() - 1) + fileExt;
            server.getLSP().createFile(send, uri, ret.toString());
            this.parser.languageServer.getLSP().notifyClient(send, "telemetry/event", "\"Script finished\"");
        }
        catch (AssertionError e) {
            return new ResponseError(-32603, Util.sugarcoatText(((Throwable)((Object)e)).getMessage()), e);
        }
        catch (IOException e) {
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), e);
        }
        return "OK";
    }
}

