/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.arbori;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public class Query
extends CodeLens {
    static final String normalTitle = "Query:";

    public Query(ParseNode node, BackgroundParser parser) {
        this(node, parser, normalTitle);
    }

    public Query(ParseNode node, BackgroundParser parser, String title) {
        super(node, title, parser);
    }

    @Override
    public Object executeCommand(OutputStream send) {
        String statement = this.parser.text.substring(this.parser.src.get((int)this.node.from).begin, this.parser.src.get((int)(this.node.to - 1)).end);
        LanguageServer server = this.parser.languageServer;
        try {
            SqlProgram r = new SqlProgram(this.parser.text){

                @Override
                public Boolean getBoolBindVar(String name) {
                    return true;
                }
            };
            r.setStruct(server);
            String conn = this.parser.getRegistry().getConnString();
            if (conn.charAt(0) == '\"') {
                conn = conn.substring(1, conn.length() - 1);
            }
            r.setTargetFileName(conn);
            Map<String, MaterializedPredicate> output = r.eval();
            if (this.node.contains("rule")) {
                String content = this.parser.src.get((int)this.node.from).content;
                MaterializedPredicate p = output.get(content);
                String fileExt = ".output.csv";
                String uri = server.getLastUrl().substring(1, server.getLastUrl().length() - 1) + fileExt;
                server.getLSP().createFile(send, uri, Query.render(p, (BackgroundParser)this.parser.getRegistry().getConnection()));
            }
            this.parser.languageServer.getLSP().notifyClient(send, "telemetry/event", "\"Query finished\"");
        }
        catch (AssertionError e) {
            return new ResponseError(-32603, Util.sugarcoatText(((Throwable)((Object)e)).getMessage()), statement);
        }
        catch (IOException e) {
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), statement);
        }
        return "OK";
    }

    static String render(MaterializedPredicate rs, BackgroundParser p) {
        StringBuilder ret = new StringBuilder();
        int cols = rs.arity();
        for (int i = 0; i < cols; ++i) {
            if (0 < i) {
                ret.append(",");
            }
            ret.append(rs.getAttribute(i));
        }
        ret.append("\n");
        String conn = p.docUrl;
        if (conn.charAt(0) == '\"') {
            conn = conn.substring(1, conn.length() - 1);
        }
        for (Tuple tu : rs.getTuples()) {
            for (int i = 0; i < cols; ++i) {
                String attr = rs.getAttribute(i);
                ParseNode pn = rs.getAttribute(tu, attr);
                if (0 < i) {
                    ret.append(",");
                }
                int line = pn.rowNo() + p.src.size() + 3;
                ret.append('\"' + pn.interval() + "  " + conn + ".tree#L" + line + '\"');
            }
            ret.append("\n");
        }
        return ret.toString();
    }
}

