/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.arbori;

import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.dictionary.Registry;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public class EstablishConnection
extends CodeLens {
    public EstablishConnection(ParseNode node, BackgroundParser parser) {
        super(node, "Establish Connection", parser);
    }

    @Override
    public Object executeCommand(OutputStream send) {
        String cmd = this.parser.text.substring(this.parser.src.get((int)this.node.from).begin, this.parser.src.get((int)(this.node.to - 1)).end);
        List<LexerToken> src = LexerToken.parse(cmd);
        String filename = src.get((int)1).content;
        LanguageServer server = this.parser.languageServer;
        this.parser.resetDiagnostics();
        try {
            Registry registry = this.parser.getRegistry();
            BackgroundParser p = server.getParser(filename);
            if (p == null) {
                String msg = "Please open associated sql file first";
                this.parser.failedCommand(this.node, new Exception("Please open associated sql file first"));
                this.parser.documentBump(send);
                return new ResponseError(-32603, Util.sugarcoatText("Please open associated sql file first"), "");
            }
            registry.setConnection(p);
            if (p.root == null || p.src == null) {
                return new ResponseError(-32603, Util.sugarcoatText("p.root == null || p.src == null"), "");
            }
            StringBuilder out = new StringBuilder("*** Lexical Analysis:\n");
            int j = 0;
            for (LexerToken t : p.src) {
                out.append("  " + j + "    ");
                out.append(t.toString());
                out.append("\n");
                ++j;
            }
            out.append("*** ParseTree:\n");
            out.append(p.root.tree());
            String baseFileName = p.docUrl.substring(1, p.docUrl.length() - 1);
            String uri = baseFileName + ".tree";
            server.getLSP().createFile(send, uri, out.toString(), true);
            server.documentsBump(send);
            return "OK";
        }
        catch (Exception e) {
            LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), filename);
        }
    }
}

