/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import oracle.dbtools.lsp.GridRenderer;
import oracle.dbtools.raptor.utils.DataTypesUtil;

class JsonRenderer
extends GridRenderer {
    JsonRenderer() {
    }

    @Override
    public String render(ResultSet rs, Connection conn) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        StringBuilder ret = new StringBuilder("{\"results\":[{\"columns\":[{");
        int cols = rsmd.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            if (1 < i) {
                ret.append(",");
            }
            ret.append('\"' + rsmd.getColumnName(i) + '\"' + ':');
            ret.append('\"' + rsmd.getColumnTypeName(i) + '\"');
        }
        ret.append("}],\"items\":\n[\n");
        int line = 0;
        while (rs.next() && line++ < 10000) {
            if (this.isSilent) continue;
            if (1 < line) {
                ret.append(",");
            }
            ret.append("{");
            for (int i = 1; i <= cols; ++i) {
                if (1 < i) {
                    ret.append(",");
                }
                Object o = rs.getObject(i);
                String s = DataTypesUtil.stringValueChecked(o, conn);
                ret.append('\"' + rsmd.getColumnName(i) + '\"' + ':');
                char qt = ' ';
                if ("VARCHAR2".equals(rsmd.getColumnTypeName(i))) {
                    qt = '\"';
                }
                if ("CHAR".equals(rsmd.getColumnTypeName(i))) {
                    qt = '\"';
                }
                if ("DATE".equals(rsmd.getColumnTypeName(i))) {
                    qt = '\"';
                }
                ret.append(qt + s + qt);
            }
            ret.append("}\n");
        }
        ret.append("]}]}\n");
        if (this.isSilent) {
            return "{\"json\": \"silent mode\"}\n";
        }
        return ret.toString();
    }
}

