/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.sql.Connection;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.dictionary.Dictionary;
import oracle.dbtools.lsp.dictionary.Registry;
import oracle.dbtools.lsp.features.Diagnostics;
import oracle.dbtools.lsp.features.DocumentSymbol;
import oracle.dbtools.lsp.features.Position;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.jdbc.OracleDatabaseException;

class BackgroundSqlParser
extends BackgroundParser {
    public BackgroundSqlParser(String input, String url, LanguageServer languageServer) {
        super(input, SqlEarley.partialRecognizer(), "sql_statements", url, languageServer);
        this.initRegistry(new Dictionary(this));
        this.lateInit();
    }

    @Override
    public String label(ParseNode node) {
        String label = ((LexerToken)this.src.get((int)node.from)).content;
        if (node.contains("sql_statement") && !node.contains("sqlplus_command")) {
            return label;
        }
        if (node.contains("sqlplus_command")) {
            return label;
        }
        if (node.contains("subprg_body")) {
            return this.text.substring(((LexerToken)this.src.get((int)node.from)).begin, ((LexerToken)this.src.get((int)(node.from + 1))).end);
        }
        if (node.contains("basic_d")) {
            return this.text.substring(((LexerToken)this.src.get((int)node.from)).begin, ((LexerToken)this.src.get((int)(node.from + 1))).end);
        }
        if (node.contains("prm_spec")) {
            return this.text.substring(((LexerToken)this.src.get((int)node.from)).begin, ((LexerToken)this.src.get((int)(node.from + 1))).end);
        }
        return null;
    }

    @Override
    int kind(ParseNode node) {
        if (node.contains("sql_statement")) {
            return DocumentSymbol.SymbolKind.Function.getValue();
        }
        if (node.contains("subprg_body")) {
            return DocumentSymbol.SymbolKind.Module.getValue();
        }
        if (node.contains("basic_d")) {
            return DocumentSymbol.SymbolKind.Property.getValue();
        }
        if (node.contains("prm_spec")) {
            return DocumentSymbol.SymbolKind.Variable.getValue();
        }
        return super.kind(node);
    }

    @Override
    public String semanticActionsFile() {
        return "sqlCodeLens.arbori";
    }

    @Override
    public void failedCommand(ParseNode command, Exception exception) {
        int commandOffset;
        int errorOffset = commandOffset = ((LexerToken)this.src.get((int)command.from)).begin;
        if (exception.getCause() instanceof OracleDatabaseException) {
            OracleDatabaseException exc = (OracleDatabaseException)exception.getCause();
            errorOffset += exc.getErrorPosition();
        }
        int line = this.charPos2LineNo0(errorOffset);
        int offset = errorOffset - this.lineNo2CharPos0(line);
        Position start = new Position(line, offset);
        Position end = new Position(line, offset + 3);
        Range range = new Range(start, end);
        this.diagnostics = new Diagnostics(range, exception.getMessage());
    }

    @Override
    public Set<String> getOpenConnections() {
        HashSet<String> ret = new HashSet<String>();
        for (BackgroundParser parser : this.languageServer.parsers.values()) {
            String candidate;
            Registry registry = parser.getRegistry();
            if (!(registry.getConnection() instanceof Connection) || (candidate = registry.getConnString()) == null || ret.contains(candidate)) continue;
            ret.add(candidate);
        }
        return ret;
    }

    @Override
    public void associateUnambiguousConnection() {
        Registry reg = this.languageServer.getUnambiguousConnectedRegistry();
        if (reg != null) {
            this.getRegistry().copyConnection(reg);
        }
    }
}

