/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.lsp.BackgroundArboriParser;
import oracle.dbtools.lsp.BackgroundDictParser;
import oracle.dbtools.lsp.BackgroundSqlParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.PublishDiagnosticsParams;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.dictionary.Dictionary;
import oracle.dbtools.lsp.dictionary.Item;
import oracle.dbtools.lsp.dictionary.Registry;
import oracle.dbtools.lsp.dictionary.SymbolContext;
import oracle.dbtools.lsp.features.Diagnostics;
import oracle.dbtools.lsp.features.DocumentSymbol;
import oracle.dbtools.lsp.features.FoldingRange;
import oracle.dbtools.lsp.features.Location;
import oracle.dbtools.lsp.features.Position;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Yelrae;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public abstract class BackgroundParser {
    private static Logger logger = Logger.getLogger(BackgroundParser.class.getName());
    private int objRef;
    private static int objCnt = 0;
    public Earley earley;
    String topSymbol;
    public String text = null;
    public List<LexerToken> src = null;
    public List<LexerToken> allSrc = null;
    public Matrix matrix = null;
    public ParseNode root = null;
    private int[] lineMap = null;
    public Program program = null;
    public CodeLens[] codeLens = null;
    public Diagnostics diagnostics = null;
    public String docUrl;
    public LanguageServer languageServer;
    private Registry registry = null;
    Set<FoldingRange> foldingRanges = new HashSet<FoldingRange>();
    boolean quit = false;
    static int cnt = 0;
    int instance;

    public BackgroundParser(String input, Earley earley, String topSymbol, String url, LanguageServer languageServer) {
        this.text = input;
        this.earley = earley;
        this.topSymbol = topSymbol;
        this.docUrl = url;
        this.languageServer = languageServer;
        this.objRef = objCnt++;
    }

    public void resetDiagnostics() {
        this.diagnostics = null;
    }

    public void initCodeLens(int len) {
        this.codeLens = new CodeLens[len];
    }

    public void setCodeLens(int index, CodeLens value) {
        this.codeLens[index] = value;
    }

    public void sortCodeLens() {
        Arrays.sort(this.codeLens);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void initRegistry(Registry value) {
        this.registry = value;
    }

    public String getAssociatedConnstr() {
        return this.getRegistry().getConnString();
    }

    public int lineNo2CharPos0(int line) {
        int ret = Service.lineNo2CharPos0(this.lineMap, line);
        try {
            if (this.text.charAt(ret) == '\r') {
                return ret + 1;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return ret;
    }

    public int lineNo2CharPos1(int line) {
        return this.lineNo2CharPos0(line - 1);
    }

    public int charPos2LineNo0(int pos) {
        return Service.charPos2LineNo0(this.lineMap, pos);
    }

    public int charPos2LineNo1(int pos) {
        return Service.charPos2LineNo1(this.lineMap, pos);
    }

    public void addFoldingRange(ParseNode p) {
        int lineEnd;
        if (this.src == null) {
            return;
        }
        int lineBegin = this.charPos2LineNo1(this.src.get((int)p.from).begin);
        if (lineBegin < (lineEnd = this.charPos2LineNo1(this.src.get((int)(p.to - 1)).end))) {
            this.foldingRanges.add(new FoldingRange(lineBegin - 1, lineEnd - 1));
        }
    }

    public void clearFoldingRanges() {
        this.foldingRanges = new HashSet<FoldingRange>();
    }

    public void updateText(String newText) {
        this.src = null;
        this.allSrc = null;
        this.matrix = null;
        this.root = null;
        this.text = newText;
    }

    protected void lateInit() {
        this.src = null;
        try {
            this.parse();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.instance = cnt++;
            Thread parsingThread = new Thread("Background Parser#" + this.instance){

                @Override
                public void run() {
                    BackgroundParser.this.quit = false;
                    while (!BackgroundParser.this.quit) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (BackgroundParser.this.src != null) continue;
                        try {
                            BackgroundParser.this.parse();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            parsingThread.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public boolean isLexing() {
        return this.allSrc == null;
    }

    public boolean isParsing() {
        return this.allSrc == null || this.matrix == null || this.root == null;
    }

    public boolean waitForLexingFinish() {
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isLexing()) continue;
            return true;
        }
        return false;
    }

    public boolean waitForParsingFinish() {
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isParsing()) continue;
            return true;
        }
        return false;
    }

    public boolean waitForArboriFinish() {
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.codeLens == null) continue;
            return true;
        }
        return false;
    }

    public void parse() {
        if (this.text == null) {
            this.lineMap = null;
            this.src = null;
            this.allSrc = null;
            this.matrix = null;
            this.root = null;
            this.codeLens = null;
            return;
        }
        long t1 = System.currentTimeMillis();
        this.lineMap = Service.lineMap(this.text);
        this.allSrc = LexerToken.parse(this.text, true);
        this.src = LexerToken.parse(this.text);
        this.matrix = new Matrix(this.earley);
        this.earley.parse(this.src, this.matrix);
        this.root = Yelrae.duplexParse(this.earley, this.src, this.matrix);
        this.clearFoldingRanges();
        Parsed target = new Parsed(this.text, this.src, this.root);
        if (this.program == null) {
            this.program = new Program(this.earley, this){};
            try {
                String prg = null;
                String filename = this.semanticActionsFile();
                Properties pr = System.getProperties();
                String m = (String)pr.get("dbtools.lsp.codeLensDir");
                if (m != null) {
                    if (!m.endsWith("/") || !m.endsWith("\\")) {
                        m = m + '/';
                    }
                    filename = m + filename;
                } else {
                    m = (String)pr.get("dbtools.lsp." + this.semanticActionsFile());
                    if (m != null) {
                        filename = m;
                    }
                }
                try {
                    prg = m == null ? Service.readFile(LSP.class, filename) : Service.readFile(filename);
                }
                catch (IOException e2) {
                    throw new AssertionError((Object)(filename + " not found"));
                }
                this.program.compile(prg, null, true);
            }
            catch (AssertionError e) {
                LSP.LOG.log(Level.SEVERE, ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
            }
            catch (Exception e) {
                e.printStackTrace();
                LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.program.eval(target, this);
        if (this.codeLens == null) {
            this.codeLens = new CodeLens[0];
        }
        System.out.println("***** Background parser parser timing = " + (System.currentTimeMillis() - t1));
    }

    public Range nodeRange(ParseNode node) {
        if (node == null) {
            boolean bl = true;
        }
        if (node.from == 0 && node.to == 0) {
            Position start = new Position(0, 0);
            return new Range(start, start);
        }
        int pos = -1;
        try {
            pos = this.src.get((int)node.from).begin;
        }
        catch (IndexOutOfBoundsException e) {
            pos = -1;
        }
        int line = Service.charPos2LineNo1(this.lineMap, pos);
        int lineStart = Service.lineNo2CharPos1(this.lineMap, line);
        Position start = new Position(line - 1, pos - lineStart);
        Position end = null;
        if (node.to == 0) {
            end = start;
        } else {
            pos = this.src.get((int)(node.to - 1)).end;
            line = Service.charPos2LineNo1(this.lineMap, pos);
            lineStart = Service.lineNo2CharPos1(this.lineMap, line);
            end = new Position(line - 1, pos - lineStart);
        }
        return new Range(start, end);
    }

    public String tokenAt(int pos) {
        return this.src.get((int)pos).content;
    }

    public static BackgroundParser factory(String input, String url, LanguageServer languageServer) throws IOException {
        if (url.indexOf("\"") != 0) {
            url = '\"' + url + '\"';
        }
        if (url.endsWith(".dict\"")) {
            return new BackgroundDictParser(input, url, languageServer);
        }
        if (url.endsWith(".arbori\"")) {
            return new BackgroundArboriParser(input, url, languageServer);
        }
        return new BackgroundSqlParser(input, url, languageServer);
    }

    List<DocumentSymbol> filter(ParseNode node) {
        int pos = this.src.get((int)node.from).begin;
        int line = Service.charPos2LineNo1(this.lineMap, pos);
        int lineStart = Service.lineNo2CharPos1(this.lineMap, line);
        Position start = new Position(line - 1, pos - lineStart);
        Position end = new Position(line - 1, this.src.get((int)node.from).end - lineStart);
        Range range = new Range(start, end);
        LinkedList<DocumentSymbol> ret = new LinkedList<DocumentSymbol>();
        String label = this.label(node);
        if (label != null) {
            DocumentSymbol ds = new DocumentSymbol(label, range, this.kind(node));
            for (ParseNode child : node.children()) {
                ds.addChildren(this.filter(child));
            }
            ret.add(ds);
        } else {
            for (ParseNode child : node.children()) {
                ret.addAll(this.filter(child));
            }
        }
        return ret;
    }

    int kind(ParseNode node) {
        return DocumentSymbol.SymbolKind.Namespace.getValue();
    }

    public void documentBump(OutputStream send) {
        this.languageServer.getLSP().documentBump(send, this.docUrl, this);
    }

    public void failedCommand(ParseNode command, Exception exception) {
        int commandOffset;
        int errorOffset = commandOffset = this.src.get((int)command.from).begin;
        int line = this.charPos2LineNo0(errorOffset);
        int offset = errorOffset - this.lineNo2CharPos0(line);
        Position start = new Position(line, offset);
        Position end = new Position(line, offset + 3);
        Range range = new Range(start, end);
        this.diagnostics = new Diagnostics(range, exception.getMessage());
    }

    public PublishDiagnosticsParams publishDiagnostics() {
        SyntaxError err = SyntaxError.checkSyntax(this.text, new String[]{this.topSymbol}, this.src, this.earley, this.matrix);
        if (err != null) {
            Position start = new Position(err.line, err.offset);
            Position end = new Position(err.line, err.offset + 3);
            return new PublishDiagnosticsParams(this.docUrl, new Diagnostics(new Range(start, end), err.getDetailedMessage()));
        }
        if (this.diagnostics != null) {
            return new PublishDiagnosticsParams(this.docUrl, this.diagnostics);
        }
        return new PublishDiagnosticsParams(this.docUrl, new Diagnostics[0]);
    }

    public boolean isAlive(String connStr) {
        List<LexerToken> src = LexerToken.parse(connStr);
        try {
            Connection connection;
            String user = src.get((int)1).content;
            String pwd = src.get((int)3).content;
            String conn = src.get((int)5).content.trim();
            if (conn.startsWith("\"")) {
                conn = conn.substring(1, conn.length() - 1);
            }
            if ((connection = (Connection)this.languageServer.getConnection(Dictionary.connAlias(conn, user, pwd))) == null) {
                return false;
            }
            return connection.isValid(1);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object locate(OutputStream send, SymbolContext symbol) {
        if (symbol.declaration == -1) {
            try {
                Registry catalog = this.getRegistry();
                Item object = catalog.getObject(symbol);
                if (object == null) {
                    return new ResponseError(-32601, Util.sugarcoatText("Object " + symbol.name + " not found"), "");
                }
                return this.locate(send, object, (Dictionary)catalog, true);
            }
            catch (SQLWarning e) {
                return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), e);
            }
            catch (SQLException e) {
                LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
                return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), e);
            }
        }
        int offset = this.src.get((int)symbol.declaration).begin;
        int line = this.charPos2LineNo1(offset);
        int character = offset - this.lineNo2CharPos1(line);
        Range range = new Range(new Position(line - 1, character), new Position(line - 1, character + this.src.get((int)symbol.declaration).content.length()));
        return new Location(Util.cleanText(this.languageServer.getLastUrl()), range);
    }

    public Object locate(OutputStream send, Item object, Dictionary catalog, boolean initParser) {
        try {
            String content = "connect " + catalog.dirName2conn(catalog.getConnString()) + "\n\n" + catalog.queryObjectDefinition(object).trim();
            if (content.length() == 0) {
                return null;
            }
            if (!(content.endsWith(";") || content.endsWith(";\n") || content.endsWith(";\n\r") || content.endsWith(";\r\n") || content.endsWith("/") || content.endsWith("/\n") || content.endsWith("/\n\r") || content.endsWith("/\r\n"))) {
                content = content + ";";
            }
            String typeFolder = (object.secondClassCitizen() ? "Other Datatypes/" : "") + object.pluralType();
            String otherUsers = "";
            if (object.owner != null && !object.owner.equals(catalog.getSchema())) {
                otherUsers = "/Other Users/" + object.owner;
            }
            String url = this.languageServer.dictionaryUri + '/' + catalog.dirName() + otherUsers + '/' + typeFolder + '/' + object.name + ".sql";
            String uri = "\"" + url + "\"";
            if (initParser) {
                BackgroundParser parser = BackgroundParser.factory(content.toString(), uri, this.languageServer);
                this.languageServer.parsers.put(uri, parser);
                this.languageServer.associateConnection(parser, catalog.getConnString());
            }
            this.languageServer.getLSP().createFile(send, url, content.toString());
            Range zero = new Range(new Position(0, 0), new Position(0, 0));
            return new Location(url, zero);
        }
        catch (Exception e) {
            LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), object.toString());
        }
    }

    public void recordSymbol(ParseNode symbol, ParseNode type) {
        this.getRegistry().recordSymbol(symbol, type, this);
    }

    public void recordSymbol(ParseNode symbol, String[] types) {
        this.getRegistry().recordSymbol(symbol, types, this);
    }

    public void recordSymbol(ParseNode symbol, String type, int declaration) {
        this.getRegistry().recordSymbol(symbol, type, declaration, this);
    }

    public abstract String label(ParseNode var1);

    public abstract String semanticActionsFile();

    public abstract Set<String> getOpenConnections();

    public String toString() {
        return this.getClass().getName() + "@" + this.objRef;
    }

    public void associateUnambiguousConnection() {
    }
}

