/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.loadservice;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.common.TranslatableMessage;
import oracle.dbtools.data.formattors.DataTypeFormatterRegistry;
import oracle.dbtools.data.formattors.ITypeFormattor;
import oracle.dbtools.data.loadservice.ColumnDefinitionDetective;
import oracle.dbtools.data.loadservice.DataLoadException;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.loadservice.LoadParmsAPI;
import oracle.dbtools.data.loadservice.LoadResources;
import oracle.dbtools.data.loadservice.LoadSql;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.data.model.Table;
import oracle.dbtools.data.readservice.ReadParmsAPI;
import oracle.dbtools.data.readservice.ReadParmsDelimitedAPI;
import oracle.dbtools.data.readservice.ReadService;
import oracle.dbtools.data.readservice.ReadServiceDelimited;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public abstract class LoadService {
    protected final String ENCODING = "UTF-8";
    protected final String LINE_TERM = "\n";
    protected final String SPACE = " ";
    private final String INFO_PREFIX_SQL = "--";
    private final String ERROR_PREFIX_SQL = "--";
    private String INFO_PREFIX_RAW;
    private String ERROR_PREFIX_RAW;
    private Connection _conn;
    private DBUtil _dbUtil;
    private String _schemaName;
    private String _tableName;
    private OutputStreamWriter _responseWriter;
    private LoadParmsAPI _loadParms;
    private ReadParmsAPI _readerParms;
    private Logger LOGGER = Logger.getLogger(this.getClass().getName());
    private boolean CANCELLED;
    private boolean _connLocked = false;
    private boolean _isConnAutoCommit;
    private boolean _isDoCommit;
    private ReadService _reader;
    private InputStream _input;
    private Table _table;
    private int _errorRowsCount;
    private int _processedRowsCount;
    private long _lastCommittedRow;
    private List<Object[]> _scanRowsList;
    private boolean _useScannedModel;
    private boolean _isScanned;
    private String _dateFormat;
    private String _timestampFormat;
    private String _timestampTZFormat;
    private String[] _columnNames;
    private ExitCode _exitCode = ExitCode.EXIT_SUCCESS;
    private static final long START_TIME = System.nanoTime();
    private boolean _isFinished = false;

    private static String formatInterval(long l) {
        long hr = TimeUnit.NANOSECONDS.toHours(l);
        long min = TimeUnit.NANOSECONDS.toMinutes(l - TimeUnit.HOURS.toNanos(hr));
        long sec = TimeUnit.NANOSECONDS.toSeconds(l - TimeUnit.HOURS.toNanos(hr) - TimeUnit.MINUTES.toNanos(min));
        long ms = TimeUnit.NANOSECONDS.toMillis(l - TimeUnit.HOURS.toNanos(hr) - TimeUnit.MINUTES.toNanos(min) - TimeUnit.SECONDS.toNanos(sec));
        return String.format("%02d:%02d:%02d.%03d", hr, min, sec, ms);
    }

    ExitCode start(Connection conn, String schemaName, String tableName, InputStream input, OutputStream response, LoadParmsAPI loadParms, ReadParmsAPI readerParms, Logger logger) {
        this._conn = conn;
        this._schemaName = schemaName;
        this._tableName = tableName;
        this._loadParms = loadParms;
        this._readerParms = readerParms;
        this._input = input;
        this.LOGGER = logger;
        this.INFO_PREFIX_RAW = "#" + this.translate("INFO") + " ";
        this.ERROR_PREFIX_RAW = "#" + this.translate("ERROR") + " ";
        this.LOGGER.log(Level.INFO, LoadResources.getString("LOAD_START"));
        this._isDoCommit = this.getLoadParms().isDoCommit();
        try {
            this._responseWriter = new OutputStreamWriter(response, this._loadParms.getResponseEncoding());
            if (readerParms == null || !(readerParms instanceof ReadParmsDelimitedAPI)) {
                String msg = this.translate("READER_START_ERR", new Object[]{readerParms.getServiceType().toString()});
                throw new DataLoadException(msg, ExitCode.EXIT_SEVERE);
            }
            this._reader = new ReadServiceDelimited(input, (ReadParmsDelimitedAPI)readerParms, loadParms.getResponseLocales());
            this.initConnection();
            GenericTable genericTable = new GenericTable(this.getConnection(), this.getSchemaName(), this.getTableName());
            this._table = genericTable.getTable();
            if (this._table == null && this._loadParms.getProcess() == LoadParmsAPI.PROCESS.LOAD && this._loadParms.getDdlOption() == LoadParmsAPI.DDL_OPTION.NONE) {
                String t = this._schemaName == null || this._schemaName.length() == 0 ? this._tableName : this._schemaName + "." + this._tableName;
                String msg = this.translate("TABLE_NOT_EXIST", new Object[]{t});
                throw new DataLoadException(msg, ExitCode.EXIT_SEVERE);
            }
            if (this._table != null && this._loadParms.getProcess() == LoadParmsAPI.PROCESS.LOAD && this._loadParms.getDdlOption() == LoadParmsAPI.DDL_OPTION.CREATE) {
                String t = this._schemaName == null || this._schemaName.length() == 0 ? this._tableName : this._schemaName + "." + this._tableName;
                String msg = this.translate("TABLE_EXIST", new Object[]{t});
                throw new DataLoadException(msg, ExitCode.EXIT_SEVERE);
            }
        }
        catch (UnsupportedEncodingException e) {
            String msg = this.translate("RESPONSE_START_ERR");
            this.responseErrorMsg(new String[]{msg, e.getMessage()});
            this.LOGGER.log(Level.SEVERE, LoadResources.getString("RESPONSE_START_ERR") + " " + e.getMessage());
            this._exitCode = ExitCode.EXIT_SEVERE;
        }
        catch (SQLException e) {
            String msg = this.translate("CONNECTION_ERR");
            this.responseErrorMsg(new String[]{msg, e.getMessage()});
            this.LOGGER.log(Level.SEVERE, msg + " " + e.getMessage());
            this._exitCode = ExitCode.EXIT_SEVERE;
        }
        catch (DataLoadException e) {
            this.responseErrorMsg(new String[]{e.getMessage()});
            this.LOGGER.log(Level.SEVERE, e.getMessage());
            this._exitCode = e.getExitCode();
        }
        if (this._exitCode.equals((Object)ExitCode.EXIT_SEVERE)) {
            this.signalCancel();
            this.finish();
        }
        return this._exitCode;
    }

    abstract String getType();

    /*
     * Unable to fully structure code
     */
    ExitCode scan() {
        this._exitCode = ExitCode.EXIT_SUCCESS;
        this._dateFormat = null;
        this._timestampFormat = null;
        this._timestampTZFormat = null;
        if (this._loadParms.getDdlOption() != LoadParmsAPI.DDL_OPTION.NONE) {
            scanned = false;
            try {
                scanned = this.doScan();
            }
            catch (Exception e) {
                msg = this.translate("SCAN_ERR");
                this.responseErrorMsg(new String[]{msg, e.getMessage()});
                this.getLogger().log(Level.WARNING, e.getMessage());
                this.setExitCodeHighest(ExitCode.EXIT_SEVERE);
                return this._exitCode;
            }
            if (scanned) {
                try {
                    ddl = this.doDdl();
                    this.responseWrite(ddl + ";" + "\n");
                    if (this._loadParms.getDdlOption() != LoadParmsAPI.DDL_OPTION.CREATE) ** GOTO lbl34
                    this.doDdlExec(ddl);
                    this.responseInfoMsg(new String[]{"Table created"});
                }
                catch (Exception e) {
                    msg = this.translate("CREATE_TABLE_ERR");
                    this.responseErrorMsg(new String[]{msg, e.getMessage()});
                    this.getLogger().log(Level.WARNING, e.getMessage());
                    this.setExitCodeHighest(ExitCode.EXIT_SEVERE);
                    return this._exitCode;
                }
            }
        } else {
            this.setTemporalFormats();
        }
lbl34:
        // 4 sources

        this._scanRowsList = null;
        return this._exitCode;
    }

    boolean checkScanned() {
        return this._isScanned;
    }

    ExitCode load(InputStream inputStream, boolean useScannedModel) {
        this._input = inputStream;
        this._useScannedModel = useScannedModel;
        return this.load();
    }

    ExitCode load() {
        this._exitCode = ExitCode.EXIT_SUCCESS;
        if (this._loadParms.getProcess() == LoadParmsAPI.PROCESS.LOAD) {
            if (this._table == null) {
                GenericTable genericTable = new GenericTable(this.getConnection(), this.getSchemaName(), this.getTableName());
                this._table = genericTable.getTable();
            }
            this._reader = new ReadServiceDelimited(this._input, (ReadParmsDelimitedAPI)this._readerParms, this._loadParms.getResponseLocales());
            this.doLoad();
            String[] lines = new String[]{this.translate("STAT_ROWS_PROCESSED", new Object[]{this._processedRowsCount}), this.translate("STAT_ROWS_ERROR", new Object[]{this._errorRowsCount}), this._isDoCommit && this._lastCommittedRow > 0L ? this.translate("STAT_LAST_COMMITTED", new Object[]{this._lastCommittedRow}) : this.translate("STAT_NONE_COMMITTED")};
            this.responseInfoMsg(lines);
        }
        this.finish();
        return this._exitCode;
    }

    protected abstract void doLoad();

    protected final Connection getConnection() {
        return this._conn;
    }

    protected final String translate(String messageId, Object[] args) {
        if (this._loadParms.getResponseLocales() == null) {
            return LoadResources.format(messageId, args);
        }
        return new TranslatableMessage(LoadResources.class, messageId, LoadResources.format(messageId, args), args).toString(this._loadParms.getResponseLocales());
    }

    protected final String translate(String messageId) {
        if (this._loadParms.getResponseLocales() == null) {
            return LoadResources.getString(messageId);
        }
        return new TranslatableMessage(LoadResources.class, messageId, LoadResources.getString(messageId), new Object[0]).toString(this._loadParms.getResponseLocales());
    }

    protected final Logger getLogger() {
        return this.LOGGER;
    }

    protected final String getSchemaName() {
        return this._schemaName;
    }

    protected final String getTableName() {
        return this._tableName;
    }

    protected final Table getTable() {
        return this._table;
    }

    protected final ReadService getReader() {
        return this._reader;
    }

    protected final ReadParmsAPI getReaderParms() {
        return this._readerParms;
    }

    protected final LoadParmsAPI getLoadParms() {
        return this._loadParms;
    }

    protected String getColumnName(String aliasOrColumnName) {
        if (this._loadParms.getAliasToColumnMap() == null || this._loadParms.getAliasToColumnMap().size() == 0) {
            return aliasOrColumnName;
        }
        String name = this._loadParms.getAliasToColumnMap().get(aliasOrColumnName);
        return name == null || name.length() == 0 ? aliasOrColumnName : name;
    }

    protected long getElapsedTime() {
        return (System.nanoTime() - START_TIME) / 1000000L;
    }

    protected final void responseWrite(String content) {
        try {
            if (this._responseWriter != null) {
                this._responseWriter.write(content + "\n");
            }
        }
        catch (IOException e) {
            this.LOGGER.log(Level.SEVERE, e.getMessage());
        }
    }

    protected final void addRowsProcessed() {
        ++this._processedRowsCount;
    }

    protected final void addRowsError() {
        ++this._errorRowsCount;
    }

    protected final void lastCommittedRow(long row) {
        if (this._connLocked && this._isDoCommit) {
            this._lastCommittedRow = row;
        }
    }

    protected void responseInfoMsg(String[] lines) {
        String prefix = this.getLoadParms().isResponseFormatRaw() ? this.INFO_PREFIX_RAW : "--";
        for (int i = 0; i < lines.length; ++i) {
            this.responseWrite(prefix + lines[i]);
        }
    }

    protected void responseErrorMsg(String[] lines) {
        String prefix = this.getLoadParms().isResponseFormatRaw() ? this.ERROR_PREFIX_RAW : "--";
        for (int i = 0; i < lines.length; ++i) {
            this.responseWrite(prefix + lines[i]);
        }
    }

    protected final boolean checkCanProceed() {
        if (this._loadParms.isErrorsLimited() && this._errorRowsCount > this._loadParms.getErrorsLimit()) {
            this.CANCELLED = true;
            this._exitCode = ExitCode.EXIT_ERROR;
        }
        return !this.CANCELLED;
    }

    protected final void setExitCodeHighest(ExitCode exitCode) {
        if (exitCode.getSeverity() > this._exitCode.getSeverity()) {
            this._exitCode = exitCode;
        }
    }

    protected final boolean isCancelled() {
        return this.CANCELLED;
    }

    public void signalCancel() {
        this.CANCELLED = true;
    }

    private void initConnection() throws SQLException {
        this._isConnAutoCommit = this._conn.getAutoCommit();
        this._connLocked = LockManager.lock(this._conn);
        if (!this._connLocked) {
            this._exitCode = ExitCode.EXIT_SEVERE;
            this.signalCancel();
        } else if (this._isConnAutoCommit) {
            this._conn.setAutoCommit(false);
        }
    }

    public ExitCode finish() {
        if (!this._isFinished) {
            this._isFinished = true;
            if (this.CANCELLED) {
                this.rollbackConn();
            } else {
                this.commitConn();
            }
            this.responseWrite(this._exitCode.toStringTranslated(this._loadParms.getResponseLocales()));
            this.resetConn();
            try {
                if (this._responseWriter != null) {
                    this._responseWriter.close();
                }
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setMessage(e.getMessage());
                return exitCode;
            }
        }
        return ExitCode.EXIT_SUCCESS;
    }

    private void rollbackConn() {
        try {
            if (!this._conn.isClosed() && this._connLocked) {
                this._conn.rollback();
            }
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            this._exitCode = ExitCode.EXIT_SEVERE;
        }
        this.signalCancel();
    }

    protected void commitConn() {
        try {
            if (this._connLocked && this._isDoCommit) {
                this._conn.commit();
            }
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            this._exitCode = ExitCode.EXIT_SEVERE;
            this.signalCancel();
        }
    }

    private void resetConn() {
        try {
            if (this._isConnAutoCommit && this._connLocked) {
                this._conn.setAutoCommit(this._isConnAutoCommit);
                this._connLocked = false;
                LockManager.unlock(this._conn);
            } else if (this._connLocked) {
                LockManager.unlock(this._conn);
            }
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            this._exitCode = ExitCode.EXIT_SEVERE;
            this.signalCancel();
        }
    }

    protected boolean doScan() throws Exception {
        int scanRowsLimit = this.getLoadParms().getScanRows();
        if (scanRowsLimit > 0) {
            this._isScanned = true;
            this.getLogger().log(Level.INFO, "doScan");
            this._scanRowsList = new ArrayList<Object[]>(scanRowsLimit);
            LoadSql loadSql = new LoadSql(this.getSchemaName(), this.getTableName(), this.getLoadParms().getLocale());
            loadSql.useQuotedNames(true);
            this.getReader().start();
            int columnCount = 0;
            if (this.getReaderParms().isHeader()) {
                this._columnNames = this.getReader().getColumnNames();
                while (this.getReader().hasMoreRows(scanRowsLimit)) {
                    this._scanRowsList.add(this.getReader().readline());
                }
            } else {
                while (this.getReader().hasMoreRows(scanRowsLimit)) {
                    String[] scanRow = (String[])this.getReader().readline();
                    this._scanRowsList.add(this.getReader().readline());
                    if (columnCount >= scanRow.length) continue;
                    columnCount = scanRow.length;
                }
                this._columnNames = this.getReader().getDefaultColumnNames(columnCount);
            }
        } else {
            String msg = this.translate("SCAN_SKIPPED");
            this.responseInfoMsg(new String[]{msg});
            return false;
        }
        return true;
    }

    protected String doDdl() {
        String[] stringArray;
        String[] timestampMasks;
        String[] stringArray2;
        String[] dateMasks;
        String[] stringArray3;
        this.getLogger().log(Level.INFO, "doDdl");
        String ddl = "";
        LoadFile loadFile = new LoadFile();
        ArrayList<String> uniqueIds = new ArrayList<String>();
        for (int i = 0; i < this._columnNames.length; ++i) {
            Column column = new Column();
            String name = this.getColumnName(this.getCleanName(this._columnNames[i], uniqueIds));
            if (!name.equals(this._columnNames[i])) {
                String msg = this.translate("COLUMN_NAME", new Object[]{i + 1, this._columnNames[i], name});
                this.responseInfoMsg(new String[]{msg});
            }
            column.setName(name);
            column.setSourceColID(i);
            column.setEditable(true);
            column.setNullable(true);
            LoadField loadField = new LoadField();
            loadField.setColumn(column);
            loadFile.addField(loadField);
        }
        String dm = this._loadParms.getDataFormat();
        String tm = this._loadParms.getTimestampFormat();
        String ttzm = this._loadParms.getTimestampTZFormat();
        if (dm != null && !dm.isEmpty()) {
            String[] stringArray4 = new String[1];
            stringArray3 = stringArray4;
            stringArray4[0] = dm;
        } else {
            stringArray3 = dateMasks = ColumnDefinitionDetective.DATE_MASKS;
        }
        if (tm != null && !tm.isEmpty()) {
            String[] stringArray5 = new String[1];
            stringArray2 = stringArray5;
            stringArray5[0] = tm;
        } else {
            stringArray2 = timestampMasks = ColumnDefinitionDetective.TIMESTAMP_MASKS;
        }
        if (ttzm != null && !ttzm.isEmpty()) {
            String[] stringArray6 = new String[1];
            stringArray = stringArray6;
            stringArray6[0] = ttzm;
        } else {
            stringArray = ColumnDefinitionDetective.TIMESTAMPTZ_MASKS;
        }
        String[] timestampTZMasks = stringArray;
        boolean isDate = false;
        boolean isTimestamp = false;
        boolean isTimestampTZ = false;
        Character decimalSeparator = new Character(((OracleNLSProvider)NLSProvider.getProvider(this._conn)).getDecimalSeparator());
        ColumnDefinitionDetective detective = new ColumnDefinitionDetective(this._loadParms.getLocale(), decimalSeparator);
        for (LoadField field : loadFile.getFields()) {
            String msg;
            detective.detect(this._scanRowsList, field, false);
            Column col = field.getColumn();
            String type = col.getType();
            String format = col.getFormat();
            if (format == null) {
                if (this._loadParms.getDdlColSize() == LoadParmsAPI.DDL_COL_SIZE.ROUNDED) {
                    col.setPrecision(ColumnDefinitionDetective.getRoundedPrecision(col.getPrecision(), type));
                    continue;
                }
                if (this._loadParms.getDdlColSize() != LoadParmsAPI.DDL_COL_SIZE.MAX) continue;
                if (type.equals("VARCHAR2")) {
                    col.setPrecision(this.getDbUtil().getMaxStringSize().equals("STANDARD") ? 4000 : Short.MAX_VALUE);
                    continue;
                }
                col.setPrecision(ColumnDefinitionDetective.getMaxPrecision(col.getPrecision(), type));
                continue;
            }
            if (type.equals("DATE") && !isDate) {
                isDate = true;
                this._dateFormat = format;
                dateMasks = new String[]{format};
                detective.setMasks(dateMasks, timestampMasks, timestampTZMasks);
                msg = this.translate("DATE_FORMAT_DET", new Object[]{format}) + "\n";
                this.responseInfoMsg(new String[]{msg});
                continue;
            }
            if (type.equals("TIMESTAMP") && !isTimestamp) {
                isTimestamp = true;
                this._timestampFormat = format;
                timestampMasks = new String[]{format};
                detective.setMasks(dateMasks, timestampMasks, timestampTZMasks);
                msg = this.translate("TIMESTAMP_FORMAT_DET", new Object[]{format}) + "\n";
                this.responseInfoMsg(new String[]{msg});
                continue;
            }
            if (!type.equals("TIMESTAMP WITH TIME ZONE") || isTimestampTZ) continue;
            isTimestampTZ = true;
            this._timestampTZFormat = format;
            timestampTZMasks = new String[]{format};
            detective.setMasks(dateMasks, timestampMasks, timestampTZMasks);
            msg = this.translate("TIMESTAMPTZ_FORMAT_DET", new Object[]{format}) + "\n";
            this.responseInfoMsg(new String[]{msg});
        }
        ddl = this.getCreateTable(loadFile);
        return ddl;
    }

    protected boolean setTemporalFormats() {
        this._useScannedModel = false;
        if (this._table == null) {
            GenericTable genericTable = new GenericTable(this.getConnection(), this.getSchemaName(), this.getTableName());
            this._table = genericTable.getTable();
        }
        boolean isScanDateNeeded = false;
        boolean isScanTimestampNeeded = false;
        boolean isScanTimestampTZNeeded = false;
        for (Column col : this.getTable().getColumns()) {
            if (col.getType().equals("DATE")) {
                if (this.getLoadParms().getDataFormat() != null && !this.getLoadParms().getDataFormat().isEmpty()) continue;
                isScanDateNeeded = true;
                continue;
            }
            if (col.getType().equals("TIMESTAMP") || col.getType().equals("TIMESTAMP WITH LOCAL TIME ZONE")) {
                if (this.getLoadParms().getTimestampFormat() != null && !this.getLoadParms().getTimestampFormat().isEmpty()) continue;
                isScanTimestampNeeded = true;
                continue;
            }
            if (!col.getType().equals("TIMESTAMP WITH TIME ZONE") || this.getLoadParms().getTimestampTZFormat() != null && !this.getLoadParms().getTimestampTZFormat().isEmpty()) continue;
            isScanTimestampTZNeeded = true;
        }
        if (isScanDateNeeded || isScanTimestampNeeded || isScanTimestampTZNeeded) {
            this._useScannedModel = true;
            this._dateFormat = this._loadParms.getDataFormat();
            this._timestampFormat = this._loadParms.getTimestampFormat();
            this._timestampTZFormat = this._loadParms.getTimestampTZFormat();
            Character decimalSeparator = Character.valueOf('.');
            ColumnDefinitionDetective detective = new ColumnDefinitionDetective(this._loadParms.getLocale(), decimalSeparator);
            if (this._loadParms.getDdlOption() == LoadParmsAPI.DDL_OPTION.NONE) {
                try {
                    if (this.doScan()) {
                        String[] cleanNames = this.getCleanColumnNames();
                        for (Column col : this.getTable().getColumns()) {
                            if ((this._dateFormat == null || this._dateFormat.isEmpty()) && col.getType().equals("DATE")) {
                                col.setSourceColID(this.getSourceColID(col.getName(), cleanNames));
                                detective.detectFormat(this._scanRowsList, col, this.getReaderParms().isHeader());
                                if (col.getFormat() == null) continue;
                                this._dateFormat = col.getFormat();
                                continue;
                            }
                            if ((this._timestampFormat == null || this._timestampFormat.isEmpty()) && (col.getType().equals("TIMESTAMP") || col.getType().equals("TIMESTAMP WITH LOCAL TIME ZONE"))) {
                                col.setSourceColID(this.getSourceColID(col.getName(), cleanNames));
                                detective.detectFormat(this._scanRowsList, col, this.getReaderParms().isHeader());
                                if (col.getFormat() == null) continue;
                                this._timestampFormat = col.getFormat();
                                continue;
                            }
                            if (this._timestampTZFormat != null && !this._timestampTZFormat.isEmpty() || !col.getType().equals("TIMESTAMP WITH TIME ZONE")) continue;
                            col.setSourceColID(this.getSourceColID(col.getName(), cleanNames));
                            detective.detectFormat(this._scanRowsList, col, this.getReaderParms().isHeader());
                            if (col.getFormat() == null) continue;
                            this._timestampTZFormat = col.getFormat();
                        }
                    }
                }
                catch (Exception e) {
                    String msg = this.translate("SCAN_ERR");
                    this.responseErrorMsg(new String[]{msg, e.getMessage()});
                    this.getLogger().log(Level.WARNING, e.getMessage());
                }
            }
            this._scanRowsList = null;
        }
        return !this._useScannedModel;
    }

    private String[] getCleanColumnNames() {
        ArrayList<String> uniqueIds = new ArrayList<String>();
        String[] cleanNames = new String[this._columnNames.length];
        for (int i = 0; i < this._columnNames.length; ++i) {
            cleanNames[i] = this.getCleanName(this._columnNames[i], uniqueIds);
        }
        return cleanNames;
    }

    private int getSourceColID(String name, String[] cleanNames) {
        for (int i = 0; i < cleanNames.length; ++i) {
            if (!name.equals(cleanNames[i])) continue;
            return i;
        }
        return -1;
    }

    protected String getCreateTable(LoadFile loadFile) {
        String ddl = "\n";
        String t = this._schemaName == null || this._schemaName.length() == 0 ? this._tableName : this._schemaName + "." + this._tableName;
        ddl = ddl + "CREATE TABLE " + t + "\n" + " (" + "\n";
        ITypeFormattor fmtor = null;
        String separator = "  ";
        for (LoadField field : loadFile.getFields()) {
            Column col = field.getColumn();
            fmtor = DataTypeFormatterRegistry.getInstance().getFormattor(col.getType());
            if (fmtor == null) {
                fmtor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
            }
            ddl = ddl + separator + fmtor.formatColumn(col);
            separator = ",\n  ";
        }
        ddl = ddl + "\n )\n";
        return ddl;
    }

    protected DBUtil getDbUtil() {
        return this._dbUtil != null ? this._dbUtil : DBUtil.getInstance(this._conn);
    }

    protected String getCleanName(String name, List<String> uniqueIds) {
        String clType = this._loadParms.getCleanNames() == null ? LoadParmsAPI.CLEAN_NAMES.UNIQUE.toString() : this._loadParms.getCleanNames().toString();
        char doubleq = '\"';
        return this.getDbUtil().cleanIdentifier(name, uniqueIds, clType, doubleq, this._loadParms.getLocale());
    }

    protected boolean useScannedModel() {
        return this._useScannedModel;
    }

    protected String getScannedDateFormat() {
        return this._dateFormat;
    }

    protected String getScannedTimestampFormat() {
        return this._timestampFormat;
    }

    protected String getScannedTimestampTZFormat() {
        return this._timestampTZFormat;
    }

    protected boolean doDdlExec(String ddl) throws SQLException {
        this.getLogger().log(Level.INFO, "doDdlExec");
        boolean isCreated = this.pstmtExec(ddl);
        if (!isCreated) {
            this._exitCode.setShortMessage(LoadResources.getString("CONNECTION_ERR") + " ");
            this._exitCode.setMessage(LoadResources.getString("CONNECTION_ERR") + " ");
            return false;
        }
        return true;
    }

    public boolean pstmtExec(String sql) throws SQLException {
        if (this._connLocked) {
            PreparedStatement pstmt = this._conn.prepareStatement(sql);
            pstmt.execute();
            return true;
        }
        return false;
    }
}

