/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.db;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.connections.db.PasswordPrompter;
import oracle.dbtools.connections.security.ReferenceWorker;

public final class DatabaseProviderHelper {
    private static Logger DEFAULT_LOGGER = Logger.getLogger("oracle.dbtools.connections.db");
    private static Class<? extends DatabaseProviderHelperImpl> sImplementationClass;

    private static DatabaseProviderHelperImpl getImplemenation() {
        return Holder.INSTANCE;
    }

    public static synchronized void setImplementationClass(Class<? extends DatabaseProviderHelperImpl> cls) {
        if (sImplementationClass != null) {
            DEFAULT_LOGGER.warning("Replacing DatabaseProviderHelper implementation " + sImplementationClass + " with " + cls);
        }
        sImplementationClass = cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DatabaseProviderHelperImpl createHelper() {
        Class<DatabaseProviderHelper> clazz = DatabaseProviderHelper.class;
        synchronized (DatabaseProviderHelper.class) {
            Class<? extends DatabaseProviderHelperImpl> cls = sImplementationClass;
            // ** MonitorExit[var1] (shouldn't be in output)
            DatabaseProviderHelperImpl instance = null;
            if (cls != null) {
                try {
                    instance = cls.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    DEFAULT_LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
            if (instance == null) {
                instance = new DatabaseProviderHelperImpl(){
                    ReferenceWorker mWorker = ReferenceWorker.createNullWorker();

                    @Override
                    public String getProgramName() {
                        return "unknown";
                    }

                    @Override
                    public PasswordPrompter getPasswordPrompter() {
                        return null;
                    }

                    @Override
                    public ReferenceWorker<?> getDefaultWorker() {
                        return this.mWorker;
                    }
                };
            }
            return instance;
        }
    }

    public static String getProgramName() {
        return DatabaseProviderHelper.getImplemenation().getProgramName();
    }

    public static PasswordPrompter getPasswordPrompter() {
        return DatabaseProviderHelper.getImplemenation().getPasswordPrompter();
    }

    public static ReferenceWorker getDefaultWorker() {
        return DatabaseProviderHelper.getImplemenation().getDefaultWorker();
    }

    public static Logger getLogger() {
        return DatabaseProviderHelper.getImplemenation().getLogger();
    }

    private DatabaseProviderHelper() {
    }

    static /* synthetic */ DatabaseProviderHelperImpl access$100() {
        return DatabaseProviderHelper.createHelper();
    }

    private static class Holder {
        private static DatabaseProviderHelperImpl INSTANCE = DatabaseProviderHelper.access$100();

        private Holder() {
        }
    }

    public static interface DatabaseProviderHelperImpl {
        public static Logger getDefaultLogger() {
            return DEFAULT_LOGGER;
        }

        public String getProgramName();

        public PasswordPrompter getPasswordPrompter();

        public ReferenceWorker<?> getDefaultWorker();

        default public Logger getLogger() {
            return DatabaseProviderHelperImpl.getDefaultLogger();
        }
    }
}

