/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.dbtools.connections.Location;

public final class FileLocation
implements Location {
    private final File mFile;

    public static Location createFileLocation(File f) {
        return new FileLocation(f);
    }

    private FileLocation(File f) {
        this.mFile = f;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.mFile.exists()) {
            this.mFile.createNewFile();
        }
        return new FileInputStream(this.mFile);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.mFile);
    }

    @Override
    public boolean exists() {
        return this.mFile.exists();
    }
}

