/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.dbtools.common.utils.ModelUtil;

public class DBURLUtil {
    public static final String DB_PROTOCOL = "sqldev.nav";
    private static final Map<URL, ParsedURL> s_parsedURLs = new WeakHashMap<URL, ParsedURL>();

    public static synchronized ParsedURL getParsedURL(URL url) {
        ParsedURL parsedURL = s_parsedURLs.get(url);
        if (parsedURL == null) {
            String path = url.getPath();
            int size = 5;
            String[] parts = new String[size];
            int count = 0;
            ParsedURL parent = null;
            int prevIndex = -1;
            while (true) {
                String part;
                if (count >= size) {
                    URL baseURL = null;
                    try {
                        baseURL = new URL(url.getProtocol(), null, path.substring(0, prevIndex));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                    parent = parent == null ? new ParsedURLImpl(baseURL, parts) : new EnclosedURL(baseURL, parent, parts);
                    count = 0;
                    size = 2;
                    parts = new String[size];
                }
                int idx = path.indexOf(47, prevIndex + 1);
                if (count == 0 && path.startsWith("\"") && path.length() > 1 && path.substring(1).contains("\"/")) {
                    idx = path.substring(1).indexOf("\"/") + 1;
                    part = path.substring(prevIndex + 1, ++idx);
                    parts[count++] = DBURLUtil.decode(part);
                    prevIndex = idx;
                    continue;
                }
                if (idx < 0) break;
                part = path.substring(prevIndex + 1, idx);
                parts[count++] = DBURLUtil.decode(part);
                prevIndex = idx;
            }
            parts[count++] = DBURLUtil.decode(path.substring(prevIndex + 1));
            if (count < size) {
                String[] tmp = parts;
                parts = new String[count];
                System.arraycopy(tmp, 0, parts, 0, count);
            } else {
                String ref = url.getRef();
                if (ModelUtil.hasLength(ref)) {
                    int idx = ref.indexOf(47);
                    if (idx < 0) {
                        String[] tmp = parts;
                        parts = new String[count + 1];
                        System.arraycopy(tmp, 0, parts, 0, count);
                        parts[count++] = DBURLUtil.decode(ref);
                    } else {
                        String[] tmp = parts;
                        parts = new String[count + 2];
                        System.arraycopy(tmp, 0, parts, 0, count);
                        parts[count++] = DBURLUtil.decode(ref.substring(0, idx));
                        parts[count++] = DBURLUtil.decode(ref.substring(idx + 1));
                    }
                }
            }
            parsedURL = parent == null ? new ParsedURLImpl(url, parts) : new EnclosedURL(url, parent, parts);
            if (parsedURL != null) {
                s_parsedURLs.put(url, parsedURL);
            }
        }
        return parsedURL;
    }

    public static URL getURL(String protocol, String cName, String catalog, String schema, String type, String name) {
        URL url = DBURLUtil.getURL(protocol, cName, catalog, schema, type);
        if (url != null) {
            url = DBURLUtil.getURL(url, name);
        }
        return url;
    }

    public static URL getURL(String protocol, String cName, String catalog, String schema, String type) {
        URL url = null;
        String path = DBURLUtil.encode(cName) + "/" + DBURLUtil.encode(catalog) + "/" + DBURLUtil.encode(schema);
        path = "PACKAGE+BODY".equals(type) ? path + "/" + type : path + "/" + DBURLUtil.encode(type);
        try {
            url = new URL(protocol, null, path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return url;
    }

    public static URL getURL(URL base, String name) {
        URL url = null;
        String protocol = base.getProtocol();
        String path = base.getPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + DBURLUtil.encode(name);
        try {
            url = new URL(protocol, null, path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return url;
    }

    private static String encode(String s) {
        if (s == null) {
            return "";
        }
        String encoded = s;
        try {
            encoded = URLEncoder.encode(s, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encoded;
    }

    private static String decode(String s) {
        if (s == null) {
            return "";
        }
        String decoded = s;
        try {
            decoded = URLDecoder.decode(s, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decoded;
    }

    private DBURLUtil() {
    }

    public static void main(String[] args) {
    }

    private static final class EnclosedURL
    implements ParsedURL {
        private static int BASETYPE_PART = 0;
        private static int NAME_PART = BASETYPE_PART + 1;
        private static int CHILDTYPE_PART = NAME_PART + 1;
        private static int CHILDNAME_PART = CHILDTYPE_PART + 1;
        private final ParsedURL m_enclosingURL;
        private final URL m_url;
        private final String[] m_parts = new String[CHILDNAME_PART + 1];

        EnclosedURL(URL url, ParsedURL parentURL, String ... parts) {
            this.m_url = url;
            this.m_enclosingURL = parentURL;
            System.arraycopy(parts, 0, this.m_parts, 0, Math.min(parts.length, this.m_parts.length));
        }

        @Override
        public String getConnectionName() {
            return this.m_enclosingURL.getConnectionName();
        }

        @Override
        public String getCatalog() {
            return this.m_enclosingURL.getCatalog();
        }

        @Override
        public String getSchema() {
            return this.m_enclosingURL.getSchema();
        }

        @Override
        public String getObjectType() {
            return this.m_parts[BASETYPE_PART];
        }

        @Override
        public String getObjectName() {
            return this.m_parts[NAME_PART];
        }

        @Override
        public ParsedURL getEnclosingURL() {
            return this.m_enclosingURL;
        }

        @Override
        public URL getURL() {
            return this.m_url;
        }

        @Override
        public String getChildType() {
            return this.m_parts[CHILDTYPE_PART];
        }

        @Override
        public String getChildName() {
            return this.m_parts[CHILDNAME_PART];
        }

        @Override
        public URL getTypeURL() {
            return DBURLUtil.getURL(this.m_enclosingURL.getURL(), this.m_parts[BASETYPE_PART]);
        }
    }

    private static final class ParsedURLImpl
    implements ParsedURL {
        private static int CNAME_PART = 0;
        private static int CATALOG_PART = CNAME_PART + 1;
        private static int SCHEMA_PART = CATALOG_PART + 1;
        private static int BASETYPE_PART = SCHEMA_PART + 1;
        private static int NAME_PART = BASETYPE_PART + 1;
        private static int CHILDTYPE_PART = NAME_PART + 1;
        private static int CHILDNAME_PART = CHILDTYPE_PART + 1;
        private final String[] m_parts = new String[CHILDNAME_PART + 1];
        private final URL m_url;

        ParsedURLImpl(URL url, String ... parts) {
            this.m_url = url;
            System.arraycopy(parts, 0, this.m_parts, 0, Math.min(parts.length, this.m_parts.length));
        }

        @Override
        public String getConnectionName() {
            return this.m_parts[CNAME_PART];
        }

        @Override
        public String getCatalog() {
            return this.m_parts[CATALOG_PART];
        }

        @Override
        public String getSchema() {
            return this.m_parts[SCHEMA_PART];
        }

        @Override
        public String getObjectType() {
            return this.m_parts[BASETYPE_PART];
        }

        @Override
        public String getObjectName() {
            return this.m_parts[NAME_PART];
        }

        @Override
        public ParsedURL getEnclosingURL() {
            return null;
        }

        @Override
        public URL getURL() {
            return this.m_url;
        }

        @Override
        public String getChildType() {
            return this.m_parts[CHILDTYPE_PART];
        }

        @Override
        public String getChildName() {
            return this.m_parts[CHILDNAME_PART];
        }

        @Override
        public URL getTypeURL() {
            if (this.m_parts[BASETYPE_PART] != null) {
                if (this.m_parts[NAME_PART] == null) {
                    return this.m_url;
                }
                return DBURLUtil.getURL(this.m_url.getProtocol(), this.m_parts[CNAME_PART], this.m_parts[CATALOG_PART], this.m_parts[SCHEMA_PART], this.m_parts[BASETYPE_PART]);
            }
            return null;
        }
    }

    public static interface ParsedURL {
        public String getConnectionName();

        public String getCatalog();

        public String getSchema();

        public String getObjectType();

        public String getObjectName();

        public ParsedURL getEnclosingURL();

        public URL getURL();

        public String getChildType();

        public String getChildName();

        public URL getTypeURL();
    }
}

