/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Invocable;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.False;
import oracle.dbtools.arbori.GlobalMap;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.True;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

class JSFunc
implements Predicate {
    String name;
    Program program;
    List<String> args;

    public JSFunc(String name, Program program, List<String> args) {
        this.name = name;
        this.program = program;
        this.args = args;
    }

    @Override
    public boolean eval(Map<String, Integer> attributePositions, ParseNode[] t, List<LexerToken> src, Map<String, Attribute> varDefs) {
        try {
            Invocable invocable = (Invocable)((Object)this.program.getEngine());
            if (invocable == null) {
                return true;
            }
            HashMap<String, ParseNode> tuple = new HashMap<String, ParseNode>();
            for (String colName : attributePositions.keySet()) {
                ParseNode node = t[attributePositions.get(colName)];
                tuple.put(colName, node);
            }
            GlobalMap globals = this.program.getGlobals();
            if (globals == null) {
                return false;
            }
            globals.put("tuple", (Object)tuple);
            if (this.args.size() == 0) {
                return (Boolean)invocable.invokeFunction(this.name, new Object[0]);
            }
            if (this.args.size() == 1) {
                return (Boolean)invocable.invokeFunction(this.name, this.args.get(0));
            }
            if (this.args.size() == 2) {
                return (Boolean)invocable.invokeFunction(this.name, this.args.get(0), this.args.get(1));
            }
            throw new AssertionError((Object)("Wrong number of arguments (=" + this.args.size() + ")"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String toString(int depth) {
        return "." + this.name;
    }

    @Override
    public void variables(Set<String> ret, boolean optimizeEqs) {
    }

    @Override
    public void signature(Set<String> ret) {
    }

    @Override
    public Predicate isRelated(String var1, String var2, Map<String, Attribute> varDefs) {
        return null;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        return ret;
    }

    @Override
    public Predicate copy(Program prg) {
        return new JSFunc(this.name, prg, this.args);
    }

    @Override
    public void adjustIsFunFlag(Set<String> independentAttributes) {
    }

    @Override
    public MaterializedPredicate eval(Parsed target) {
        try {
            Invocable invocable = (Invocable)((Object)this.program.getEngine());
            if (invocable == null) {
                return new False().eval(target);
            }
            if (((Boolean)invocable.invokeFunction(this.name, new Object[0])).booleanValue()) {
                new True().eval(target);
            } else {
                new False().eval(target);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new False().eval(target);
    }
}

