/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import oracle.dbtools.app.injection.Dotted;
import oracle.dbtools.app.injection.FuncFormal;
import oracle.dbtools.app.injection.ParmSpec;
import oracle.dbtools.app.injection.PlsqlException;
import oracle.dbtools.app.injection.PlsqlType;
import oracle.dbtools.app.injection.SqlInjectionAnalysisFailure;
import oracle.dbtools.app.injection.SqlInjectionGraph;
import oracle.dbtools.app.injection.Symbol;
import oracle.dbtools.app.injection.SymbolTable;
import oracle.dbtools.app.injection.TypeConversion;
import oracle.dbtools.app.injection.Usage;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;

class ValueNode {
    ParseNode pos;

    private ValueNode(ParseNode pos) {
        this.pos = pos;
    }

    ParseNode getPos() {
        return this.pos;
    }

    void setPos(ParseNode pos) {
        this.pos = pos;
    }

    ValueType getValueType() {
        throw new IllegalStateException("Raw ValueNode");
    }

    ExprNode asExprNode(SymbolTable symbols) {
        if (this instanceof ExprNode) {
            return (ExprNode)this;
        }
        if (this instanceof DottedNode) {
            DottedNode name = (DottedNode)this;
            Symbol sym = symbols.resolveDotted((Dotted)name.getDotted()).symbol;
            Usage u = sym.read();
            if (u == null) {
                if (Debug.DUMP_NOTFOUND.debug) {
                    symbols.dump((Boolean)Debug.DUMP_NOTFOUND.parms[0]);
                }
                throw new SqlInjectionAnalysisFailure("No usage for symbol " + name.getName());
            }
            List<Usage> usages = Collections.singletonList(u);
            return new ExprNode(this.pos, u.getType(), usages);
        }
        return (ExprNode)this;
    }

    FunctionNodeDeclaration asFunctionNodeDeclaration() {
        return (FunctionNodeDeclaration)this;
    }

    IdentifierNode asIdentifierNode() {
        return (IdentifierNode)this;
    }

    IdentifierNode asIdentifierNode(SymbolTable symbols) {
        return (IdentifierNode)this;
    }

    IdentifierNodeDeclaration asIdentiferNodeDeclared() {
        return (IdentifierNodeDeclaration)this;
    }

    ArgNode asArgNode() {
        return (ArgNode)this;
    }

    DottedNode asDottedNode() {
        return (DottedNode)this;
    }

    public ModeNode asModeNode() {
        return (ModeNode)this;
    }

    public MultiExprNode asMultiExprNode() {
        return (MultiExprNode)this;
    }

    public MultiArgNode asMultiArgNode() {
        return (MultiArgNode)this;
    }

    public MultiIdentifierNodeDeclaration asMultiIdentifierNodeDeclaration() {
        return (MultiIdentifierNodeDeclaration)this;
    }

    TokenNode asTokenNode() {
        return (TokenNode)this;
    }

    TypeNode asTypeNode() {
        return (TypeNode)this;
    }

    public String posToString() {
        return "[" + this.pos.from + "," + this.pos.to + ")";
    }

    public String valueNodeToString() {
        return "[" + this.pos.toString() + "]";
    }

    public String toString() {
        return this.valueNodeToString();
    }

    static class TokenNode
    extends ValueNode {
        Token lextype;
        private String name;

        TokenNode(ParseNode pos, LexerToken lextok) {
            super(pos);
            this.lextype = lextok.type;
            this.name = lextok.content;
        }

        public Token getLextype() {
            return this.lextype;
        }

        String getName() {
            return this.name;
        }

        @Override
        ValueType getValueType() {
            return ValueType.TOKENNODE;
        }

        @Override
        public String toString() {
            return "[token " + this.posToString() + " " + this.name + " <" + (Object)((Object)this.lextype) + ">]";
        }
    }

    static class TypeNode
    extends ValueNode {
        PlsqlType type;

        TypeNode(ParseNode pos, PlsqlType type) {
            super(pos);
            this.type = type;
        }

        PlsqlType getType() {
            return this.type;
        }

        @Override
        ValueType getValueType() {
            return ValueType.TYPENODE;
        }

        @Override
        public String toString() {
            return "[type " + this.type + "]";
        }
    }

    static class FunctionNodeDeclaration
    extends IdentifierNodeDeclaration {
        Symbol.FunctionSym func;
        FuncFormal formal;

        FunctionNodeDeclaration(ParseNode pos, Dotted dotted, Symbol.FunctionSym func, FuncFormal formal) {
            super(pos, dotted, func.getType(), null);
            this.func = func;
            this.formal = formal;
        }
    }

    static class IdentifierNodeDeclaration
    extends IdentifierNode {
        SymbolTable symtab;
        Usage declaration;
        SqlInjectionGraph.ParameterMode mode;
        boolean noCopy;

        IdentifierNodeDeclaration(ParseNode pos, Dotted name, PlsqlType type, SqlInjectionGraph.ParameterMode mode, boolean noCopy) {
            super(pos, name, type);
            this.mode = mode;
            this.noCopy = noCopy;
        }

        IdentifierNodeDeclaration(ParseNode pos, Dotted name, PlsqlType type, ModeNode mode) {
            super(pos, name, type);
            if (mode != null) {
                this.mode = mode.mode;
                this.noCopy = mode.noCopy;
            }
        }

        SqlInjectionGraph.ParameterMode getMode() {
            return this.mode;
        }

        @Override
        ValueType getValueType() {
            return ValueType.IDENTIFIERNODEDECLARATION;
        }

        @Override
        public MultiIdentifierNodeDeclaration asMultiIdentifierNodeDeclaration() {
            MultiIdentifierNodeDeclaration multi = new MultiIdentifierNodeDeclaration(this.pos);
            multi.add(this);
            return multi;
        }

        @Override
        public String toString() {
            return "[identifierdeclared " + super.toString() + " " + (Object)((Object)this.mode) + (this.noCopy ? " NOCOPY" : "") + "]";
        }
    }

    static class MultiIdentifierNodeDeclaration
    extends MultiNode<IdentifierNodeDeclaration> {
        MultiIdentifierNodeDeclaration(ParseNode pos) {
            super(pos);
        }

        List<ParmSpec> getAsParms() {
            ArrayList<ParmSpec> parms = new ArrayList<ParmSpec>();
            for (int i = 0; i < this.getValues().size(); ++i) {
                IdentifierNodeDeclaration decl = (IdentifierNodeDeclaration)this.getValues().get(i);
                parms.add(new ParmSpec(i, decl.getName(), decl.getType(), decl.getMode()));
            }
            return parms;
        }

        @Override
        ValueType getValueType() {
            return ValueType.MULTIIDENTIFIERNODEDECLARATION;
        }

        @Override
        public String toString() {
            return "[MultiIdentifierNodeDeclaration " + this.valToString() + "]";
        }
    }

    static class MultiExprNode
    extends MultiNode<ExprNode> {
        MultiExprNode(ParseNode pos) {
            super(pos);
        }

        @Override
        ValueType getValueType() {
            return ValueType.MULTIEXPRNODE;
        }

        @Override
        public String toString() {
            return "[multiexpr " + this.valToString() + "]";
        }
    }

    static class MultiArgNode
    extends MultiNode<ArgNode> {
        MultiArgNode(ParseNode pos) {
            super(pos);
        }

        @Override
        ValueType getValueType() {
            return ValueType.MULTIARGNODE;
        }

        @Override
        ExprNode asExprNode(SymbolTable symbols) {
            PlsqlType type = null;
            ArrayList<Usage> usages = new ArrayList<Usage>();
            for (ExprNode expr : this.getValues()) {
                if (type == null || type.isConvertibleFrom(expr.getType())) {
                    type = expr.getType();
                }
                usages.addAll(expr.usages);
            }
            return new ExprNode(this.pos, type, usages);
        }

        @Override
        public String toString() {
            return "[multiarg " + this.valToString() + "]";
        }
    }

    static class ModeNode
    extends ValueNode {
        SqlInjectionGraph.ParameterMode mode;
        boolean noCopy;

        ModeNode(ParseNode pos, SqlInjectionGraph.ParameterMode mode, boolean noCopy) {
            super(pos);
            this.mode = mode;
            this.noCopy = noCopy;
        }

        @Override
        ValueType getValueType() {
            return ValueType.MODENODE;
        }

        @Override
        public String toString() {
            return "[mode " + (Object)((Object)this.mode) + (this.noCopy ? "" : " NOCOPY") + "]";
        }
    }

    static abstract class MultiNode<T>
    extends ValueNode {
        private ArrayList<T> values = new ArrayList();

        private MultiNode(ParseNode pos) {
            super(pos);
        }

        void add(T value) {
            this.values.add(value);
        }

        void addAll(List<T> values) {
            this.values.addAll(values);
        }

        List<T> getValues() {
            return this.values;
        }

        public String valToString() {
            StringBuffer sb = new StringBuffer("{");
            String sep = "";
            for (T value : this.values) {
                sb.append(sep + (value == null ? "null" : value.toString()));
                sep = "+";
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        abstract ValueType getValueType();

        @Override
        public String toString() {
            return "[multi " + this.valToString() + "]";
        }
    }

    static class IdentifierNode
    extends DottedNode {
        private PlsqlType type;

        IdentifierNode(ParseNode pos, Dotted dotted, PlsqlType type) {
            super(pos, dotted);
            this.type = type;
        }

        IdentifierNode(ParseNode pos, String simpleName, PlsqlType type) {
            this(pos, new Dotted(simpleName), type);
        }

        @Override
        public String getName() {
            return super.getName();
        }

        public PlsqlType getType() {
            return this.type;
        }

        @Override
        ValueType getValueType() {
            return ValueType.IDENTIFIERNODE;
        }

        @Override
        public String toString() {
            return "[identifier " + super.getName() + "/" + this.type + "]";
        }
    }

    static class DottedNode
    extends ValueNode {
        final Dotted dotted;

        DottedNode(ParseNode pos, String decl_id) {
            super(pos);
            this.dotted = new Dotted(decl_id);
        }

        DottedNode(ParseNode pos, Dotted dotted) {
            super(pos);
            this.dotted = dotted;
        }

        Dotted getDotted() {
            return this.dotted;
        }

        @Override
        IdentifierNode asIdentifierNode(SymbolTable symbols) {
            Symbol sym = symbols.resolveDotted((Dotted)this.getDotted()).symbol;
            return new IdentifierNode(this.pos, this.getDotted(), sym.getType());
        }

        public String getName() {
            return this.dotted.toString();
        }

        @Override
        ValueType getValueType() {
            return ValueType.DOTTEDNODE;
        }

        @Override
        public String toString() {
            return "[dotted " + this.getName() + "]";
        }
    }

    static class LiteralNode
    extends ExprNode {
        String val;

        LiteralNode(ParseNode pos, PlsqlType type, String val) {
            super(pos, type, Collections.emptyList());
            this.val = val;
        }

        String getVal() {
            return this.val;
        }

        @Override
        ValueType getValueType() {
            return ValueType.LITERALNODE;
        }

        @Override
        public String toString() {
            return "[literal " + this.posToString() + "=" + this.val + "]";
        }
    }

    static class ArgNode
    extends ExprNode {
        DottedNode namedArg = null;
        String literal;

        ArgNode(ParseNode pos, PlsqlType type, List<Usage> usages) {
            super(pos, type, usages);
            this.literal = null;
        }

        ArgNode(ExprNode expr) {
            super(expr.pos, expr.type, expr.usages);
            this.literal = expr instanceof LiteralNode ? ((LiteralNode)expr).val : null;
        }

        public DottedNode getNamedArg() {
            return this.namedArg;
        }

        public void setNamedArg(DottedNode namedArg) {
            this.namedArg = namedArg;
        }

        @Override
        ValueType getValueType() {
            return ValueType.ARGNODE;
        }

        @Override
        public String toString() {
            String exprString = super.toString();
            return exprString.substring(0, exprString.length() - 1) + (this.namedArg == null ? "" : "=>" + this.namedArg.getName()) + (this.literal == null ? "" : " \"" + this.literal + "\"") + "]";
        }
    }

    static class ExprNode
    extends TypeNode {
        private List<Usage> usages;

        ExprNode(ParseNode pos, PlsqlType type, List<Usage> usages) {
            super(pos, type);
            this.usages = usages != null ? usages : new ArrayList<Usage>(2);
        }

        @Override
        PlsqlType getType() {
            return this.type;
        }

        void setType(PlsqlType type) {
            this.type = type;
        }

        void addUsage(Usage u) {
            this.usages.add(u);
        }

        List<Usage> getUsages() {
            return this.usages;
        }

        void setUsages(List<Usage> newUsages) {
            this.usages = newUsages;
        }

        EnumSet<PlsqlException> merge(ExprNode en) {
            this.usages.addAll(en.usages);
            if (this.type == null) {
                this.type = en.getType();
            }
            return TypeConversion.exceptionsFromMerge(this.type, en.getType());
        }

        @Override
        ValueType getValueType() {
            return ValueType.EXPRNODE;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer("[expr " + this.posToString() + " " + this.type);
            if (this.usages.size() > 0) {
                sb.append(" <-");
            }
            for (Usage u : this.usages) {
                sb.append(" " + u);
            }
            sb.append("]");
            return sb.toString();
        }
    }

    public static enum ValueType {
        MULTIEXPRNODE(1, true),
        TYPENODE(1),
        EXPRNODE(1),
        LITERALNODE(1),
        MULTIIDENTIFIERNODEDECLARATION(2, true),
        IDENTIFIERNODEDECLARATION(2),
        FUNCTIONNODEDECLARATION(2),
        DOTTEDNODE(3),
        IDENTIFIERNODE(3),
        MULTIARGNODE(-1, true),
        ARGNODE(1),
        MODENODE,
        TOKENNODE(2),
        NULLNODE,
        CONFLICTED,
        BOGUS_SYMBOL;

        final int group;
        final boolean multi;

        private ValueType(int group, boolean multi) {
            this.group = group;
            this.multi = multi;
        }

        private ValueType(int group) {
            this(group, false);
        }

        private ValueType() {
            this(-1, false);
        }

        boolean isExpression() {
            return this.group == 1;
        }

        boolean isMulti() {
            return this.multi;
        }

        ValueType asMulti() {
            if (this.group == 1 && this != TYPENODE) {
                return MULTIEXPRNODE;
            }
            if (this.group == 2) {
                return MULTIIDENTIFIERNODEDECLARATION;
            }
            return CONFLICTED;
        }

        /*
         * Unable to fully structure code
         */
        static ValueType inferCompatibleType(boolean multiRule, ValueType ... type) throws IllegalArgumentException {
            for (i = 0; i < type.length && type[i] == null; ++i) {
            }
            if (i >= type.length) {
                return null;
            }
            ret = type[i];
            group = type[i].group;
            ++i;
            while (i < type.length) {
                block11: {
                    block13: {
                        block12: {
                            typei = type[i];
                            if (typei == null) break block11;
                            if (ret != ValueType.BOGUS_SYMBOL) break block12;
                            ret = typei;
                            group = type[i].group;
                            ** GOTO lbl-1000
                        }
                        if (ret != ValueType.TOKENNODE || typei == ValueType.BOGUS_SYMBOL) break block13;
                        ret = typei;
                        group = type[i].group;
                        ** GOTO lbl-1000
                    }
                    if (typei != ValueType.TOKENNODE) {
                        if (typei != ret || !multiRule && !typei.isMulti()) {
                            if (group == -1 || typei.group == -1) {
                                return ValueType.CONFLICTED;
                            }
                            if (group != typei.group) {
                                return ValueType.CONFLICTED;
                            } else {
                                ** GOTO lbl-1000
                            }
                        }
                    } else if (multiRule) {
                        if (typei.ordinal() < ret.ordinal()) {
                            ret = typei;
                        }
                    } else {
                        ret = ret.asMulti();
                    }
                }
                ++i;
            }
            return ret;
        }
    }

    static enum Debug {
        DUMP_NOTFOUND(true, true);

        boolean debug = false;
        Object[] parms;

        private Debug(boolean debug, Object ... parms) {
            this.parms = parms;
        }
    }
}

