/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.EnumSet;
import oracle.dbtools.app.injection.PlsqlException;
import oracle.dbtools.app.injection.PlsqlType;

public class TypeConversion {
    static EnumSet<PlsqlException> exceptionsFromMerge(PlsqlType a, PlsqlType b) {
        EnumSet<PlsqlException> exceptions = TypeConversion.conversionExceptions(a, b);
        exceptions.addAll(TypeConversion.conversionExceptions(b, a));
        return exceptions;
    }

    static EnumSet<PlsqlException> conversionExceptions(PlsqlType from, PlsqlType to) {
        if (from.getTypeClass() == PlsqlType.TYPECLASS.SCALAR && to.getTypeClass() == PlsqlType.TYPECLASS.SCALAR) {
            PlsqlType.Scalar tos = (PlsqlType.Scalar)to;
            PlsqlType.Scalar froms = (PlsqlType.Scalar)from;
            switch (tos.getScalarClass()) {
                case BOOLEAN: {
                    if (froms.getScalarClass() == PlsqlType.ScalarClass.BOOLEAN) {
                        return EnumSet.noneOf(PlsqlException.class);
                    }
                    return EnumSet.of(PlsqlException.VALUE_ERROR);
                }
                case NUMERIC: {
                    return TypeConversion.toNumericExceptions(froms, tos);
                }
                case CHAR: {
                    return TypeConversion.toCharacterExceptions(froms, tos);
                }
                case DATE: {
                    return TypeConversion.toDateTimeExceptions(froms, tos);
                }
                case BLOB: 
                case CLOB: {
                    return TypeConversion.toLobExceptions(froms, tos);
                }
                case LONG: {
                    break;
                }
                case RAW: {
                    break;
                }
            }
        }
        throw new IllegalArgumentException("Unable to convert from " + from + " to " + to);
    }

    private static EnumSet<PlsqlException> toNumericExceptions(PlsqlType.Scalar from, PlsqlType.Scalar to) {
        assert (to.getScalarClass() == PlsqlType.ScalarClass.NUMERIC);
        switch (from.getScalarClass()) {
            case NUMERIC: {
                if (from.getScalarType() == to.getScalarType()) {
                    if (from.getScalarType() == PlsqlType.ScalarType.NUMBER) {
                        if (!TypeConversion.scalarSizeSafe(from, to)) {
                            return EnumSet.of(PlsqlException.VALUE_ERROR);
                        }
                        return EnumSet.noneOf(PlsqlException.class);
                    }
                    if (!TypeConversion.scalarSizeSafe(from, to)) {
                        return EnumSet.of(PlsqlException.VALUE_ERROR);
                    }
                    return EnumSet.noneOf(PlsqlException.class);
                }
                if (from.getScalarType() == PlsqlType.ScalarType.BINARY_FLOAT && to.getScalarType() == PlsqlType.ScalarType.BINARY_DOUBLE) {
                    return EnumSet.noneOf(PlsqlException.class);
                }
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
            case BOOLEAN: {
                return EnumSet.of(PlsqlException.INVALID_NUMBER, PlsqlException.VALUE_ERROR);
            }
            case CHAR: {
                return EnumSet.of(PlsqlException.INVALID_NUMBER, PlsqlException.VALUE_ERROR);
            }
            case DATE: 
            case BLOB: 
            case CLOB: {
                return EnumSet.of(PlsqlException.INVALID_NUMBER);
            }
        }
        throw new NullPointerException("Unexpected ScalarClass " + (Object)((Object)from.getScalarClass()));
    }

    private static EnumSet<PlsqlException> toCharacterExceptions(PlsqlType.Scalar from, PlsqlType.Scalar to) {
        assert (to.getScalarClass() == PlsqlType.ScalarClass.CHAR);
        switch (from.getScalarClass()) {
            case CHAR: {
                if (from.getScalarType() == to.getScalarType() && TypeConversion.scalarSizeSafe(from, to)) {
                    return EnumSet.noneOf(PlsqlException.class);
                }
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
            case BOOLEAN: 
            case NUMERIC: 
            case DATE: {
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
            case BLOB: 
            case CLOB: {
                switch (from.getScalarType()) {
                    case BLOB: 
                    case CLOB: 
                    case NCLOB: {
                        return EnumSet.of(PlsqlException.VALUE_ERROR);
                    }
                }
            }
        }
        throw new NullPointerException("Unexpected ScalarClass " + (Object)((Object)from.getScalarClass()));
    }

    private static EnumSet<PlsqlException> toDateTimeExceptions(PlsqlType.Scalar from, PlsqlType.Scalar to) {
        assert (to.getScalarClass() == PlsqlType.ScalarClass.DATE);
        switch (from.getScalarClass()) {
            case DATE: {
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
            case CHAR: {
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
            case BOOLEAN: 
            case NUMERIC: 
            case BLOB: 
            case CLOB: {
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
        }
        throw new NullPointerException("Unexpected ScalarClass " + (Object)((Object)from.getScalarClass()));
    }

    private static boolean scalarSizeSafe(int fromSize, int toSize) {
        if (toSize == -1 || fromSize == -1) {
            return false;
        }
        return toSize >= fromSize;
    }

    private static boolean scalarSizeSafe(PlsqlType.Scalar from, PlsqlType.Scalar to) {
        return TypeConversion.scalarSizeSafe(from.getScalarSize(), to.getScalarSize());
    }

    private static EnumSet<PlsqlException> toLobExceptions(PlsqlType.Scalar from, PlsqlType.Scalar to) {
        switch (from.getScalarClass()) {
            case BOOLEAN: 
            case NUMERIC: 
            case CHAR: 
            case DATE: {
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
            case BLOB: 
            case CLOB: {
                if (from.getScalarType() == to.getScalarType() && TypeConversion.scalarSizeSafe(from, to)) {
                    return EnumSet.noneOf(PlsqlException.class);
                }
                return EnumSet.of(PlsqlException.VALUE_ERROR);
            }
        }
        throw new NullPointerException("Unexpected ScalarClass " + (Object)((Object)from.getScalarClass()));
    }
}

